/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlqt;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.cumulate.calculate.model.result.QTPool;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.ScalableExtObj;

public class QTPoolHolder
extends ScalableExtObj {
    private Map<Long, List<QTPool>> qtPoolMap = new HashMap<Long, List<QTPool>>();
    private Map<DetailLogicKey, Set<Long>> dbDetailIdRecorder = new HashMap<DetailLogicKey, Set<Long>>(16);

    public Set<Long> getOldDBLineDetailId(DetailLogicKey key) {
        return this.dbDetailIdRecorder.getOrDefault(key, WTCCollections.modifiableEmptySet());
    }

    public static QTPoolHolder of(List<QTPool> qtPools) {
        QTPoolHolder qtPoolHolder = new QTPoolHolder();
        if (WTCCollections.isEmpty(qtPools)) {
            return qtPoolHolder;
        }
        qtPoolHolder.qtPoolMap = qtPools.stream().collect(Collectors.groupingBy(QTPool::getAttFileBoId));
        for (QTPool qtPool : qtPools) {
            for (QTLineDetail lineDetail : qtPool.getLineDetailList()) {
                qtPoolHolder.dbDetailIdRecorder.computeIfAbsent(new DetailLogicKey(lineDetail), key -> WTCCollections.modifiableEmptySet()).add(lineDetail.getBid());
            }
        }
        return qtPoolHolder;
    }

    public List<QTPool> getQtPoolByFileBoId(Long attFileBoId) {
        return this.qtPoolMap.get(attFileBoId);
    }

    public List<QTLineDetail> getQtPoolByFileBoId(Long attFileBoId, Long qtTypeId) {
        List<QTPool> qtPools = this.qtPoolMap.get(attFileBoId);
        if (WTCCollections.isEmpty(qtPools)) {
            return Collections.emptyList();
        }
        List<QTLineDetail> collect = qtPools.stream().flatMap(pool -> pool.getLineDetailList().stream().filter(detail -> qtTypeId.longValue() == detail.getQtTypeId())).collect(Collectors.toList());
        if (WTCCollections.isEmpty(collect)) {
            return Collections.emptyList();
        }
        return collect;
    }

    public List<QTLineDetail> getQtPoolByFileBoId(Long attFileBoId, int periodNum, Long qtTypeId) {
        List<QTPool> qtPools = this.qtPoolMap.get(attFileBoId);
        if (WTCCollections.isEmpty(qtPools)) {
            return Collections.emptyList();
        }
        List<QTLineDetail> collect = qtPools.stream().flatMap(pool -> pool.getLineDetailList().stream().filter(detail -> periodNum == detail.getPeriodNum() && qtTypeId.longValue() == detail.getQtTypeId())).collect(Collectors.toList());
        if (WTCCollections.isEmpty(collect)) {
            return Collections.emptyList();
        }
        return collect;
    }

    public List<QTLineDetail> getBeforeCurPeriodNumQtPool(Long attFileBoId, int periodNum, Long qtTypeId) {
        List<QTPool> qtPools = this.qtPoolMap.get(attFileBoId);
        if (WTCCollections.isEmpty(qtPools)) {
            return Collections.emptyList();
        }
        List<QTLineDetail> collect = qtPools.stream().flatMap(pool -> pool.getLineDetailList().stream().filter(detail -> detail.getPeriodNum() < periodNum && qtTypeId.longValue() == detail.getQtTypeId())).collect(Collectors.toList());
        if (WTCCollections.isEmpty(collect)) {
            return Collections.emptyList();
        }
        return collect;
    }
}

