/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigEntity;
import kd.wtc.wtes.business.model.rlra.TimeBucketLabelEnum;

public class AttItemLabelConfigData {
    private static final String DEFAULT_RELATION = OverworkAttendanceEnum.OTHER.getNumber() + "|" + TimeBucketLabelEnum.OTHER.getNumber();
    private final Map<Long, TimeSeqBo<AttItemLabelConfigEntity>> bid2SpecBo;

    public Map<Long, TimeSeqBo<AttItemLabelConfigEntity>> getBid2SpecBo() {
        return this.bid2SpecBo;
    }

    public AttItemLabelConfigData(Map<Long, TimeSeqBo<AttItemLabelConfigEntity>> bid2SpecBo) {
        this.bid2SpecBo = bid2SpecBo;
    }

    public static AttItemLabelConfigData of(List<TimeSeqBo<AttItemLabelConfigEntity>> attItemLabelConfigEntityList) {
        HashMap<Long, TimeSeqBo<AttItemLabelConfigEntity>> bid2SpecBo = new HashMap<Long, TimeSeqBo<AttItemLabelConfigEntity>>(attItemLabelConfigEntityList.size());
        attItemLabelConfigEntityList.forEach(bo -> bid2SpecBo.put(bo.getBid(), (TimeSeqBo<AttItemLabelConfigEntity>)bo));
        return new AttItemLabelConfigData(bid2SpecBo);
    }

    public TimeSeqBo<AttItemLabelConfigEntity> getByBid(Long bid) {
        return this.bid2SpecBo.getOrDefault(bid, (TimeSeqBo<AttItemLabelConfigEntity>)TimeSeqBo.empty());
    }

    public AttItemLabelConfigEntity getDate(Long bid, LocalDate inDate) {
        return (AttItemLabelConfigEntity)this.getByBid(bid).getVersionByDate(inDate);
    }

    public AttItemLabelConfigEntity getAttItemLabelConfigEntity(Long bid, LocalDate inDate) {
        return (AttItemLabelConfigEntity)this.getByBid(bid).getVersionByDate(inDate);
    }

    public List<String> getAttItemLabelListByParam(Long bid, LocalDate inDate, List<String> attStatusList, String shiftTimeBucketProperty, String dateType) {
        AttItemLabelConfigEntity entity = this.getAttItemLabelConfigEntity(bid, inDate);
        HashSet<String> resultList = new HashSet<String>(16);
        if (null != entity && null != entity.getAttItemLabelRelationMap()) {
            for (String attStatus : attStatusList) {
                resultList.addAll(entity.getRelationByParam(attStatus, shiftTimeBucketProperty, dateType));
            }
        }
        if (resultList.isEmpty()) {
            resultList.add(DEFAULT_RELATION);
        }
        return new ArrayList<String>(resultList);
    }
}

