/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigEntity;
import kd.wtc.wtes.business.model.rlra.AttStatusEnum;

public class AttStatusConfigData {
    private final Map<Long, TimeSeqBo<AttStatusConfigEntity>> bid2SpecBo;

    public Map<Long, TimeSeqBo<AttStatusConfigEntity>> getBid2SpecBo() {
        return this.bid2SpecBo;
    }

    public AttStatusConfigData(Map<Long, TimeSeqBo<AttStatusConfigEntity>> bid2SpecBo) {
        this.bid2SpecBo = bid2SpecBo;
    }

    public static AttStatusConfigData of(List<TimeSeqBo<AttStatusConfigEntity>> attStatusConfigEntityList) {
        HashMap<Long, TimeSeqBo<AttStatusConfigEntity>> bid2SpecBo = new HashMap<Long, TimeSeqBo<AttStatusConfigEntity>>(attStatusConfigEntityList.size());
        attStatusConfigEntityList.forEach(bo -> bid2SpecBo.put(bo.getBid(), (TimeSeqBo<AttStatusConfigEntity>)bo));
        return new AttStatusConfigData(bid2SpecBo);
    }

    public TimeSeqBo<AttStatusConfigEntity> getByBid(Long bid) {
        return this.bid2SpecBo.getOrDefault(bid, (TimeSeqBo<AttStatusConfigEntity>)TimeSeqBo.empty());
    }

    public AttStatusConfigEntity getDate(Long bid, LocalDate inDate) {
        return (AttStatusConfigEntity)this.getByBid(bid).getVersionByDate(inDate);
    }

    public AttStatusConfigEntity getAttStatusConfigEntity(Long bid, LocalDate inDate) {
        return (AttStatusConfigEntity)this.getByBid(bid).getVersionByDate(inDate);
    }

    public List<String> getAttStatusListByTags(Long bid, LocalDate inDate, String punchCardTag, List<String> attendanceBillTagList) {
        AttStatusConfigEntity entity = this.getAttStatusConfigEntity(bid, inDate);
        HashSet<String> resultList = new HashSet<String>(16);
        if (null != entity && null != entity.getAttStatusRelationMap()) {
            resultList.addAll(entity.getRelationByParam(punchCardTag, attendanceBillTagList));
        }
        if (resultList.isEmpty()) {
            resultList.add(AttStatusEnum.OTHER.getCode());
        }
        return new ArrayList<String>(resultList);
    }
}

