/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;

public class AttendanceBillTag
implements Cloneable {
    private static final int NO_STATUS = 0;
    public static final int ON_BUSINESS = 1;
    public static final int VACATION = 2;
    public static final int OVERTIME = 4;
    private static final int BUSINESS_VACATION = 3;
    private static final int BUSINESS_OVERTIME = 5;
    private static final int VACATION_OVERTIME = 6;
    private static final int BUSINESS_VACATION_OVERTIME = 7;
    private static final String TL_NUMBER = "1030_S";
    private static final String VA_NUMBER = "1020_S";
    private static final String OT_NUMBER = "1010_S";
    private static final Map<Integer, String> NUMBER_MAP = new HashMap<Integer, String>(5);
    public static final AttendanceBillTag NOSTATUSTAG;
    private int status;
    private long tlBillId;
    private long tlBillEntryId;
    private long otBillId;
    private long otBillEntryId;
    private long vaBillId;
    private long vaBillEntryId;
    private long tlBillTypeId;
    private long otBillTypeId;
    private long vaBillTypeId;

    private AttendanceBillTag(int status) {
        this.status = status;
    }

    public boolean isOnBusiness() {
        return this.hasStatus(1);
    }

    public boolean isOnVacation() {
        return this.hasStatus(2);
    }

    public boolean isOverTime() {
        return this.hasStatus(4);
    }

    boolean hasStatus(int status) {
        return (status & this.status) == status;
    }

    public AttendanceBillTag of(int code) {
        AttendanceBillTag clone = null;
        try {
            clone = (AttendanceBillTag)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        clone.status = code;
        return clone;
    }

    private AttendanceBillTag addStatus(int status) {
        return this.of(this.status | status);
    }

    private AttendanceBillTag clearStatus(int status) {
        return this.of(this.status ^ status);
    }

    public AttendanceBillTag addBusinessStatus(AbstractCardPoint cardPoint) {
        AttendanceBillTag attendanceBillTag = this.addStatus(1);
        attendanceBillTag.tlBillId = cardPoint.getBillId();
        attendanceBillTag.tlBillTypeId = cardPoint.getBillType();
        attendanceBillTag.tlBillEntryId = cardPoint.getBillEntryId();
        return attendanceBillTag;
    }

    public AttendanceBillTag addVacationStatus(AbstractCardPoint cardPoint) {
        AttendanceBillTag attendanceBillTag = this.addStatus(2);
        attendanceBillTag.vaBillId = cardPoint.getBillId();
        attendanceBillTag.vaBillTypeId = cardPoint.getBillType();
        attendanceBillTag.vaBillEntryId = cardPoint.getBillEntryId();
        return attendanceBillTag;
    }

    public AttendanceBillTag addOverTimeStatus(AbstractCardPoint cardPoint) {
        AttendanceBillTag attendanceBillTag = this.addStatus(4);
        attendanceBillTag.otBillId = cardPoint.getBillId();
        attendanceBillTag.otBillTypeId = cardPoint.getBillType();
        attendanceBillTag.otBillEntryId = cardPoint.getBillEntryId();
        return attendanceBillTag;
    }

    AttendanceBillTag clearBusinessStatus() {
        AttendanceBillTag attendanceBillTag = this.clearStatus(1);
        attendanceBillTag.tlBillId = 0L;
        attendanceBillTag.tlBillTypeId = 0L;
        return attendanceBillTag;
    }

    AttendanceBillTag clearVacationStatus() {
        AttendanceBillTag attendanceBillTag = this.clearStatus(2);
        attendanceBillTag.vaBillId = 0L;
        attendanceBillTag.vaBillTypeId = 0L;
        return attendanceBillTag;
    }

    AttendanceBillTag clearOverTimeStatus() {
        AttendanceBillTag attendanceBillTag = this.clearStatus(4);
        attendanceBillTag.otBillId = 0L;
        attendanceBillTag.otBillTypeId = 0L;
        return attendanceBillTag;
    }

    public List<String> toNumberList() {
        ArrayList<String> numberList = new ArrayList<String>();
        for (Map.Entry<Integer, String> entry : NUMBER_MAP.entrySet()) {
            if (!this.hasStatus(entry.getKey())) continue;
            numberList.add(entry.getValue());
        }
        return numberList;
    }

    public String toString() {
        return "AttendanceBillTag [status=" + this.status + ", tlBillId=" + this.tlBillId + ", otBillId=" + this.otBillId + ", vaBillId=" + this.vaBillId + ", tlBillTypeId=" + this.tlBillTypeId + ", otBillTypeId=" + this.otBillTypeId + ", vaBillTypeId=" + this.vaBillTypeId + "]";
    }

    public AttendanceBillTag switchAttendanceBillTag(AbstractCardPoint cardPoint) {
        AttendanceBillTag billTag;
        int pointType = cardPoint.getPointType();
        switch (pointType) {
            case 27: {
                billTag = this.addOverTimeStatus(cardPoint);
                break;
            }
            case 28: {
                billTag = this.clearOverTimeStatus();
                break;
            }
            case 31: {
                billTag = this.addVacationStatus(cardPoint);
                break;
            }
            case 32: {
                billTag = this.clearVacationStatus();
                break;
            }
            case 33: {
                billTag = this.addBusinessStatus(cardPoint);
                break;
            }
            case 34: {
                billTag = this.clearBusinessStatus();
                break;
            }
            default: {
                billTag = this;
            }
        }
        return billTag;
    }

    public int getStatus() {
        return this.status;
    }

    public long getTlBillId() {
        return this.tlBillId;
    }

    public long getOtBillId() {
        return this.otBillId;
    }

    public long getVaBillId() {
        return this.vaBillId;
    }

    public long getVaBillEntryId() {
        return this.vaBillEntryId;
    }

    public long getTlBillTypeId() {
        return this.tlBillTypeId;
    }

    public long getOtBillTypeId() {
        return this.otBillTypeId;
    }

    public long getTlBillEntryId() {
        return this.tlBillEntryId;
    }

    public long getOtBillEntryId() {
        return this.otBillEntryId;
    }

    public long getVaBillTypeId() {
        return this.vaBillTypeId;
    }

    static {
        NUMBER_MAP.put(1, TL_NUMBER);
        NUMBER_MAP.put(2, VA_NUMBER);
        NUMBER_MAP.put(4, OT_NUMBER);
        NOSTATUSTAG = new AttendanceBillTag(0);
    }
}

