/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;

public enum BillTagEnum {
    NO_STATUS(new MultiLangEnumBridge("\u65e0\u5355\u636e", "BillTagEnum_0", "wtc-wtes-business"), 0),
    ON_BUSINESS(new MultiLangEnumBridge("{0}", "BillTagEnum_1", "wtc-wtes-business", new Object[]{BillTypeEnum.EVECTIONBILL}), 1),
    VACATION(new MultiLangEnumBridge("\u4f11\u5047", "BillTagEnum_2", "wtc-wtes-business"), 2),
    OVERTIME(new MultiLangEnumBridge("\u52a0\u73ed", "BillTagEnum_3", "wtc-wtes-business"), 4),
    BUSINESS_VACATION(new MultiLangEnumBridge("{0}+\u4f11\u5047", "BillTagEnum_4", "wtc-wtes-business", new Object[]{BillTypeEnum.EVECTIONBILL}), BillTagEnum.ON_BUSINESS.code | BillTagEnum.VACATION.code),
    BUSINESS_OVERTIME(new MultiLangEnumBridge("{0}+\u52a0\u73ed", "BillTagEnum_5", "wtc-wtes-business", new Object[]{BillTypeEnum.EVECTIONBILL}), BillTagEnum.ON_BUSINESS.code | BillTagEnum.OVERTIME.code),
    VACATION_OVERTIME(new MultiLangEnumBridge("\u4f11\u5047+\u52a0\u73ed", "BillTagEnum_6", "wtc-wtes-business"), BillTagEnum.VACATION.code | BillTagEnum.OVERTIME.code),
    BUSINESS_VACATION_OVERTIME(new MultiLangEnumBridge("\u4f11\u5047+{0}+\u52a0\u73ed", "BillTagEnum_7", "wtc-wtes-business", new Object[]{BillTypeEnum.EVECTIONBILL}), BillTagEnum.ON_BUSINESS.code | BillTagEnum.VACATION.code | BillTagEnum.OVERTIME.code);

    public MultiLangEnumBridge name;
    public final int code;

    private BillTagEnum(MultiLangEnumBridge name, int code) {
        this.name = name;
        this.code = code;
    }

    boolean isOnBusiness() {
        return this.hasStatus(ON_BUSINESS);
    }

    boolean isOnVacation() {
        return this.hasStatus(VACATION);
    }

    boolean isOverTime() {
        return this.hasStatus(OVERTIME);
    }

    boolean hasStatus(BillTagEnum billTag) {
        return (billTag.code & this.code) == billTag.code;
    }

    BillTagEnum of(int code) {
        BillTagEnum[] billTagEnums;
        for (BillTagEnum billTagEnum : billTagEnums = BillTagEnum.values()) {
            if (billTagEnum.code != code) continue;
            return billTagEnum;
        }
        return NO_STATUS;
    }

    BillTagEnum addStatus(BillTagEnum status) {
        return this.of(this.code | status.code);
    }

    BillTagEnum clearStatus(BillTagEnum status) {
        return this.of(this.code ^ status.code);
    }

    BillTagEnum addBusinessStatus() {
        return this.addStatus(ON_BUSINESS);
    }

    BillTagEnum addVacationStatus() {
        return this.addStatus(VACATION);
    }

    BillTagEnum addOverTimeStatus() {
        return this.addStatus(OVERTIME);
    }

    BillTagEnum clearBusinessStatus() {
        return this.clearStatus(ON_BUSINESS);
    }

    BillTagEnum clearVacationStatus() {
        return this.clearStatus(VACATION);
    }

    BillTagEnum clearOverTimeStatus() {
        return this.clearStatus(OVERTIME);
    }

    public BillTagEnum switchAttendanceBillTag(AbstractCardPoint cardPoint) {
        BillTagEnum billTag;
        int pointType = cardPoint.getPointType();
        switch (pointType) {
            case 27: {
                billTag = this.addOverTimeStatus();
                break;
            }
            case 28: {
                billTag = this.clearOverTimeStatus();
                break;
            }
            case 31: {
                billTag = this.addVacationStatus();
                break;
            }
            case 32: {
                billTag = this.clearVacationStatus();
                break;
            }
            case 33: {
                billTag = this.addBusinessStatus();
                break;
            }
            case 34: {
                billTag = this.clearBusinessStatus();
                break;
            }
            default: {
                billTag = this;
            }
        }
        return billTag;
    }

    public static BillTagEnum getByCode(int code) {
        for (BillTagEnum billTagEnum : BillTagEnum.values()) {
            if (billTagEnum.code != code) continue;
            return billTagEnum;
        }
        return null;
    }
}

