/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEntity;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;

public class PunchCardTagData {
    private static final Log logger = LogFactory.getLog(PunchCardTagData.class);
    private final Map<Long, TimeSeqBo<PunchCardTagEntity>> bid2SpecBo;

    public PunchCardTagData(Map<Long, TimeSeqBo<PunchCardTagEntity>> bid2SpecBo) {
        this.bid2SpecBo = bid2SpecBo;
    }

    public static PunchCardTagData of(List<TimeSeqBo<PunchCardTagEntity>> punchCardTagList) {
        HashMap<Long, TimeSeqBo<PunchCardTagEntity>> bid2SpecBo = new HashMap<Long, TimeSeqBo<PunchCardTagEntity>>(punchCardTagList.size());
        punchCardTagList.forEach(bo -> bid2SpecBo.put(bo.getBid(), (TimeSeqBo<PunchCardTagEntity>)bo));
        return new PunchCardTagData(bid2SpecBo);
    }

    public TimeSeqBo<PunchCardTagEntity> getByBide(Long bid) {
        return this.bid2SpecBo.getOrDefault(bid, (TimeSeqBo<PunchCardTagEntity>)TimeSeqBo.empty());
    }

    public PunchCardTagEntity getByBideAndDate(Long bid, LocalDate inDate) {
        return (PunchCardTagEntity)this.getByBide(bid).getVersionByDate(inDate);
    }

    public PunchCardTagEntity getDate(Long bid, LocalDate inDate) {
        return (PunchCardTagEntity)this.getByBide(bid).getVersionByDate(inDate);
    }

    public PunchCardTagEntity getPunchCardTagEntity(Long bid, LocalDate inDate) {
        return (PunchCardTagEntity)this.getByBide(bid).getVersionByDate(inDate);
    }

    public String getPunchCardTagByParam(Long bid, LocalDate inDate, String timeCardRelation, String shiftTimeBucketProperty, String exceptionType) {
        PunchCardTagEntity entity = this.getPunchCardTagEntity(bid, inDate);
        String result = PunchCardTagEnum.OTHER.code;
        if (null != entity && null != entity.getTimeCardRelationMap()) {
            result = entity.getRelationByParam(timeCardRelation, shiftTimeBucketProperty, exceptionType);
        } else {
            logger.debug("\u672a\u83b7\u53d6\u5230\u6253\u5361\u6620\u5c04\u5217\u8868\u5b9e\u4f53,\u5165\u53c2id{},localDate{}", (Object)bid, (Object)inDate);
        }
        if (result == PunchCardTagEnum.OTHER.code) {
            logger.debug("\u672a\u83b7\u53d6\u5230\u6253\u5361\u6620\u5c04\u5217\u8868,\u5165\u53c2id{},localDate{},timeCardRelation{}, shiftTimeBucketProperty{}, exceptionType{}", new Object[]{bid, inDate, timeCardRelation, shiftTimeBucketProperty, exceptionType});
        }
        return result;
    }

    public Map<Long, TimeSeqBo<PunchCardTagEntity>> getBid2SpecBo() {
        return this.bid2SpecBo;
    }
}

