/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;

public enum ShiftTimeBucketPropertyEnum {
    ATTENDANCE(new MultiLangEnumBridge("\u666e\u901a\u51fa\u52e4\u65f6\u6bb5", "ShiftTimeBucketPropertyEnum_0", "wtc-wtes-business"), "1020_01_S", 102001L),
    CORE_ATT(new MultiLangEnumBridge("\u6838\u5fc3\u51fa\u52e4\u65f6\u6bb5", "ShiftTimeBucketPropertyEnum_1", "wtc-wtes-business"), "1020_02_S", 102002L),
    ATT_OT(new MultiLangEnumBridge("\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5", "ShiftTimeBucketPropertyEnum_2", "wtc-wtes-business"), "1020_03_S", 102003L),
    REST(new MultiLangEnumBridge("\u4f11\u606f\u65f6\u6bb5", "ShiftTimeBucketPropertyEnum_3", "wtc-wtes-business"), "1030_01_S", 103001L),
    BEFORE_SHIFT(new MultiLangEnumBridge("(\u73ed\u6b21\u5916)\u73ed\u6b21\u524d", "ShiftTimeBucketPropertyEnum_4", "wtc-wtes-business"), "1010_01_S", 101001L),
    AFTER_SHIFT(new MultiLangEnumBridge("(\u73ed\u6b21\u5916)\u73ed\u6b21\u540e", "ShiftTimeBucketPropertyEnum_5", "wtc-wtes-business"), "1040_01_S", 104001L),
    NON_PLAN_TIME(new MultiLangEnumBridge("\u65e0\u8ba1\u5212\u65f6\u6bb5", "ShiftTimeBucketPropertyEnum_6", "wtc-wtes-business"), "1050_01_S", 105001L),
    TEMP(new MultiLangEnumBridge("\u4e2d\u95f4(\u4e34\u65f6)\u72b6\u6001", "ShiftTimeBucketPropertyEnum_7", "wtc-wtes-business"), "6", 6L),
    UNKNOWN(new MultiLangEnumBridge("\u672a\u77e5\u72b6\u6001", "ShiftTimeBucketPropertyEnum_8", "wtc-wtes-business"), "7", 7L);

    private static final Log LOGGER;
    public MultiLangEnumBridge name;
    public final String code;
    public final long id;

    private ShiftTimeBucketPropertyEnum(MultiLangEnumBridge name, String code, long id) {
        this.name = name;
        this.code = code;
        this.id = id;
    }

    public ShiftTimeBucketPropertyEnum switchShiftTimeBucketPropertyStatus(AbstractCardPoint cardPoint, boolean offNonPlan) {
        ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum;
        if (offNonPlan) {
            return NON_PLAN_TIME;
        }
        int pointType = cardPoint.getPointType();
        switch (pointType) {
            case 2: 
            case 3: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 49: {
                shiftTimeBucketPropertyEnum = ATTENDANCE;
                break;
            }
            case 17: {
                shiftTimeBucketPropertyEnum = CORE_ATT;
                break;
            }
            case 43: {
                shiftTimeBucketPropertyEnum = ATT_OT;
                break;
            }
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 44: {
                shiftTimeBucketPropertyEnum = AFTER_SHIFT;
                break;
            }
            case 14: {
                shiftTimeBucketPropertyEnum = REST;
                break;
            }
            case 29: 
            case 48: {
                shiftTimeBucketPropertyEnum = NON_PLAN_TIME;
                break;
            }
            default: {
                shiftTimeBucketPropertyEnum = this;
            }
        }
        return shiftTimeBucketPropertyEnum;
    }

    public TimeBucketPositionEnum genTimeBucketPosition() {
        TimeBucketPositionEnum timeBucketPositionEnum;
        switch (this) {
            case ATTENDANCE: 
            case CORE_ATT: 
            case ATT_OT: {
                timeBucketPositionEnum = TimeBucketPositionEnum.IN_SHIFT;
                break;
            }
            case BEFORE_SHIFT: {
                timeBucketPositionEnum = TimeBucketPositionEnum.BEFORE_SHIFT;
                break;
            }
            case AFTER_SHIFT: {
                timeBucketPositionEnum = TimeBucketPositionEnum.AFTER_SHIFT;
                break;
            }
            case REST: {
                timeBucketPositionEnum = TimeBucketPositionEnum.IN_REST;
                break;
            }
            case NON_PLAN_TIME: {
                timeBucketPositionEnum = TimeBucketPositionEnum.NON_PLAN_TIME;
                break;
            }
            default: {
                timeBucketPositionEnum = TimeBucketPositionEnum.UNKNOWN;
            }
        }
        return timeBucketPositionEnum;
    }

    static {
        LOGGER = LogFactory.getLog(ShiftTimeBucketPropertyEnum.class);
    }
}

