/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rltl;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.rltl.TravelType;
import kd.wtc.wtes.common.lang.WtesException;

public class TravelEntry
extends Entity {
    private static final long serialVersionUID = 2909131175066045568L;
    private static final Log LOG = LogFactory.getLog(TravelEntry.class);
    private long oriAtt;
    private long roundWrapper;
    private long roundAtt;
    private long resultAtt;
    private String condition;
    private TravelType travelType;
    private Long timeSource;
    private String limitScope;
    private transient AccessDto dateConditionAccessDto;
    private transient AccessDto limitConditionAccessDto;

    public TravelEntry(long id, String number) {
        super(id, number);
    }

    public static TravelEntry of(long id, String number) {
        return new TravelEntry(id, number);
    }

    public String getCondition() {
        return this.condition;
    }

    public TravelEntry setCondition(String condition) {
        this.condition = condition;
        if (HRStringUtils.isNotEmpty((String)condition)) {
            try {
                this.dateConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this;
    }

    public long getOriAtt() {
        return this.oriAtt;
    }

    public TravelEntry setOriAtt(long oriAtt) {
        this.oriAtt = oriAtt;
        return this;
    }

    public long getRoundWrapper() {
        return this.roundWrapper;
    }

    public TravelEntry setRoundWrapper(long roundWrapper) {
        this.roundWrapper = roundWrapper;
        return this;
    }

    public long getRoundAtt() {
        return this.roundAtt;
    }

    public TravelEntry setRoundAtt(long roundAtt) {
        this.roundAtt = roundAtt;
        return this;
    }

    public long getResultAtt() {
        return this.resultAtt;
    }

    public TravelEntry setResultAtt(long resultAtt) {
        this.resultAtt = resultAtt;
        return this;
    }

    public TravelType getTravelType() {
        return this.travelType;
    }

    public Long getTimeSource() {
        return this.timeSource;
    }

    public String getLimitScope() {
        return this.limitScope;
    }

    public AccessDto getDateConditionAccessDto() {
        return this.dateConditionAccessDto;
    }

    public AccessDto getLimitConditionAccessDto() {
        return this.limitConditionAccessDto;
    }

    public TravelEntry setTravelType(TravelType travelType) {
        this.travelType = travelType;
        return this;
    }

    public TravelEntry setTimeSource(Long timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    public TravelEntry setLimitScope(String limitScope) {
        this.limitScope = limitScope;
        if (HRStringUtils.isNotEmpty((String)limitScope)) {
            try {
                this.limitConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)limitScope, AccessDto.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this;
    }
}

