/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.rlad.AdCalcData;
import kd.wtc.wtes.business.model.rlad.AdCalcDataModel;
import kd.wtc.wtes.business.model.rlad.AdConfigDetailPackage;
import kd.wtc.wtes.business.model.rlad.AdConfigPackage;
import kd.wtc.wtes.business.model.rlad.AdPlanPackage;
import kd.wtc.wtes.business.model.rlad.AdRulePackage;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AdEntityUtils {
    private static final Log LOG = LogFactory.getLog(AdEntityUtils.class);
    private static final List<String> TIMESCOPE_LIST = Lists.newArrayList((Object[])new String[]{"A", "B", "C"});

    public static AdConfigPackage getAdConfigPackage(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        AdPlanPackage adPlanPackage = attFileModel.getAdPlanPackage(chainDate);
        if (adPlanPackage != null) {
            AdRulePackage adRulePackage = null;
            if (adPlanPackage.isDirectRule()) {
                TimeSeqAvailableBo<AdRulePackage> rule = adPlanPackage.getRule();
                if (rule != null) {
                    adRulePackage = (AdRulePackage)rule.getVersionByDate(chainDate);
                }
            } else {
                adRulePackage = AdEntityUtils.getRuleEngineConfig(context, chainDate, adPlanPackage);
            }
            if (adRulePackage != null) {
                AdConfigPackage adConfigPackage = adRulePackage.getAdConfigPackage();
                return adConfigPackage;
            }
        }
        return null;
    }

    public static TimeSeqAvailableBo<AdRulePackage> getRule(Long ruleBoId, Map<Long, List<DynamicObject>> ruleHisMap) {
        List<DynamicObject> ruleHisList = ruleHisMap.get(ruleBoId);
        if (CollectionUtils.isEmpty(ruleHisList)) {
            LOG.debug("AdEntityUtils.getRule ruleHisList is empty,ruleBoId:{}", (Object)ruleBoId);
            return new TimeSeqAvailableBo();
        }
        ArrayList<AdRulePackage> adRulePackageList = new ArrayList<AdRulePackage>(ruleHisList.size());
        for (DynamicObject ruleDy : ruleHisList) {
            DynamicObject countSet = ruleDy.getDynamicObject("countset");
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(ruleDy);
            AdConfigPackage adConfigPackage = null;
            if (countSet != null) {
                adConfigPackage = AdEntityUtils.buildAdConfigPackage(countSet);
            }
            AdRulePackage adRulePackage = new AdRulePackage((TimeSeqInfo)timeSeqEntity, adConfigPackage);
            adRulePackageList.add(adRulePackage);
        }
        return new TimeSeqAvailableBo(adRulePackageList);
    }

    private static AdConfigPackage buildAdConfigPackage(DynamicObject countSet) {
        AdConfigPackage adConfigPackage = new AdConfigPackage();
        long id = countSet.getLong("id");
        String number = countSet.getString("number");
        adConfigPackage.setId(id);
        adConfigPackage.setNumber(number);
        String limitType = countSet.getString("limittype");
        adConfigPackage.setLimitType(limitType);
        if ("A".equals(limitType)) {
            AdConfigDetailPackage adConfigDetailPackage = new AdConfigDetailPackage();
            adConfigDetailPackage.setCount(countSet.getInt("count"));
            adConfigDetailPackage.setAttItemId(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)countSet, (String)"attitem"));
            adConfigDetailPackage.setAllowAbove("1".equals(countSet.getString("allowabove")));
            adConfigDetailPackage.setAboveCount(countSet.getInt("abovecount"));
            adConfigDetailPackage.setAboveAttItemId(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)countSet, (String)"aboveattitem"));
            String timeScope = countSet.getString("countsco");
            adConfigDetailPackage.setTimeScope(timeScope);
            adConfigPackage.setAdConfigByCardPackage(adConfigDetailPackage);
        } else {
            DynamicObjectCollection byReasonColl = countSet.getDynamicObjectCollection("entryentity");
            ArrayList<AdConfigDetailPackage> adConfigDetailPackages = new ArrayList<AdConfigDetailPackage>(byReasonColl.size());
            for (DynamicObject byReason : byReasonColl) {
                AdConfigDetailPackage adConfigDetailPackage = new AdConfigDetailPackage();
                adConfigDetailPackage.setReasonId(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)byReason, (String)"reason"));
                adConfigDetailPackage.setCount(byReason.getInt("enticount"));
                adConfigDetailPackage.setAttItemId(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)byReason, (String)"entiattitem"));
                adConfigDetailPackage.setAllowAbove("1".equals(byReason.getString("entiallowabove")));
                adConfigDetailPackage.setAboveCount(byReason.getInt("entiabovecount"));
                adConfigDetailPackage.setAboveAttItemId(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)byReason, (String)"entiaboveattitem"));
                String timeScope = byReason.getString("enticountsco");
                adConfigDetailPackage.setTimeScope(timeScope);
                adConfigDetailPackages.add(adConfigDetailPackage);
            }
            adConfigPackage.setAdConfigByReasonPackageList(adConfigDetailPackages);
        }
        return adConfigPackage;
    }

    public static Tuple<LocalDate, LocalDate> getTimeScopeRange(String timeScope, long attPersonId, LocalDate inDate, AttPeriodTable attPeriodTable) {
        LocalDate begin = null;
        LocalDate end = null;
        switch (timeScope) {
            case "A": {
                begin = inDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                end = inDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY));
                break;
            }
            case "B": {
                begin = inDate.with(TemporalAdjusters.firstDayOfMonth());
                end = inDate.with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case "C": {
                Optional<PerAttPeriod> perAttPeriodByAttPersonIdAndDate = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate(attPersonId, inDate);
                if (!perAttPeriodByAttPersonIdAndDate.isPresent()) break;
                PerAttPeriod perAttPeriod = perAttPeriodByAttPersonIdAndDate.get();
                begin = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttBeginDate());
                end = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
                break;
            }
        }
        return new Tuple((Object)begin, end);
    }

    public static Tuple<LocalDate, LocalDate> getDefaultMaxTimeScopeRange(InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        HashSet timeScopeRangeDateSet = Sets.newHashSetWithExpectedSize((int)attPersonIds.size());
        for (Long attPersonId : attPersonIds) {
            for (String timeScope : TIMESCOPE_LIST) {
                Tuple<LocalDate, LocalDate> timeScopeRangeStart = AdEntityUtils.getTimeScopeRange(timeScope, attPersonId, startDate, attPeriodTable);
                LocalDate beginScopeRangeStart = (LocalDate)timeScopeRangeStart.getKey();
                LocalDate endScopeRangeStart = (LocalDate)timeScopeRangeStart.getValue();
                if (beginScopeRangeStart != null && endScopeRangeStart != null) {
                    timeScopeRangeDateSet.add(beginScopeRangeStart);
                    timeScopeRangeDateSet.add(endScopeRangeStart);
                }
                Tuple<LocalDate, LocalDate> timeScopeRangeEnd = AdEntityUtils.getTimeScopeRange(timeScope, attPersonId, endDate, attPeriodTable);
                LocalDate beginTimeScopeRangeEnd = (LocalDate)timeScopeRangeEnd.getKey();
                LocalDate endTimeScopeRangeEnd = (LocalDate)timeScopeRangeEnd.getValue();
                if (beginTimeScopeRangeEnd == null || endTimeScopeRangeEnd == null) continue;
                timeScopeRangeDateSet.add(beginTimeScopeRangeEnd);
                timeScopeRangeDateSet.add(endTimeScopeRangeEnd);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)timeScopeRangeDateSet)) {
            List collect = timeScopeRangeDateSet.stream().sorted().collect(Collectors.toList());
            LocalDate begin = (LocalDate)collect.get(0);
            LocalDate end = (LocalDate)collect.get(collect.size() - 1);
            return new Tuple((Object)begin, (Object)end);
        }
        return null;
    }

    private static AdRulePackage getRuleEngineConfig(TieContextStd context, LocalDate localDate, AdPlanPackage adPlanPackage) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.ad.getSceneNumber(), RuleEngineEnum.ad.getBizApp(), adPlanPackage.getId());
        ruleParam.setScenePlanName(RuleEngineEnum.ad.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        LOG.debug("\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}", policyResults);
        String rule = "rule";
        Set<Long> ids = RuleEngineService.getRuleIdsByTag(policyResults, rule);
        RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
        if (CollectionUtils.isEmpty(ids)) {
            LOG.warn("adrule is empty");
            return null;
        }
        List adRulePackageList = ids.stream().map(id -> (AdRulePackage)((TimeSeqBo)ruleEngineMetaData.getBizRuleById((Long)id)).getVersionByDate(localDate)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(adRulePackageList)) {
            LOG.debug("adrulepackage is empty");
            return null;
        }
        if (adRulePackageList.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8865\u7b7e\u65b9\u6848\u91cc\u7684\u89c4\u5219\u5f15\u64ce\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u89c4\u5219\u8fd4\u56de\u3002", (String)"AdEntityUtils_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        return (AdRulePackage)((Object)adRulePackageList.get(0));
    }

    public static boolean isCountByOriginalCard() {
        String supCountCalType = SystemParamQueryUtil.getBillSystemParam().getSupCountCalType();
        return "2".equals(supCountCalType);
    }

    public static Map<LocalDate, List<AdCalcData>> getCardDataOfPerson(TieContextStd context, long attPersonId) {
        Map<Long, Map<LocalDate, List<AdCalcData>>> adCalcDataMap;
        Map<LocalDate, List<AdCalcData>> byDataCardMap = new HashMap<LocalDate, List<AdCalcData>>(0);
        AdCalcDataModel adCalcDataModel = (AdCalcDataModel)context.getInitParam("PUNCHCARD_DATA");
        if (adCalcDataModel != null && CollectionUtils.isNotEmpty(adCalcDataMap = adCalcDataModel.getAdCalcDataMap())) {
            byDataCardMap = adCalcDataMap.get(attPersonId);
        }
        return byDataCardMap;
    }
}

