/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.model.rlfm.FormulaConfigPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaRulePackage;

public class FormulaEntityUtils {
    public static List<Long> getConfigIdListFromPlanSeqBoMap(Map<Long, TimeSeqBo<FormulaPlanPackage>> planSeqBoMap) {
        ArrayList<TimeSeqBo<FormulaPlanPackage>> planPackages = new ArrayList<TimeSeqBo<FormulaPlanPackage>>(10);
        planPackages.addAll(planSeqBoMap.values());
        return FormulaEntityUtils.doGetConfigIdList(planPackages);
    }

    public static List<Long> getConfigIdListFromPlanSeqBoMap(List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFileModelList) {
        ArrayList<TimeSeqBo<FormulaPlanPackage>> planPackages = new ArrayList<TimeSeqBo<FormulaPlanPackage>>(10);
        for (AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>> entity : attFileModelList) {
            if (entity.getEntity() == null) continue;
            planPackages.add((TimeSeqBo<FormulaPlanPackage>)entity.getEntity());
        }
        return FormulaEntityUtils.doGetConfigIdList(planPackages);
    }

    public static boolean hasExistAnyFormulaPlan(List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFileModelList) {
        ArrayList<Object> planPackages = new ArrayList<Object>(10);
        for (AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>> entity : attFileModelList) {
            if (entity.getEntity() == null) continue;
            planPackages.add(entity.getEntity());
        }
        return planPackages.size() > 0;
    }

    private static List<Long> doGetConfigIdList(List<TimeSeqBo<FormulaPlanPackage>> fpBos) {
        ArrayList rulePackages = new ArrayList(10);
        for (TimeSeqBo<FormulaPlanPackage> fpBo : fpBos) {
            for (FormulaPlanPackage planPack : fpBo.getVersions()) {
                if (null == planPack.getRule()) continue;
                rulePackages.addAll(planPack.getRule().getVersions());
            }
        }
        ArrayList configPackages = new ArrayList(10);
        for (FormulaRulePackage rulePack : rulePackages) {
            for (TimeSeqBo<FormulaConfigPackage> configPack : rulePack.getConfigs()) {
                configPackages.addAll(configPack.getVersions());
            }
        }
        return configPackages.stream().map(IEntity::getId).collect(Collectors.toList());
    }
}

