/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.model.TbAttPackage;
import kd.wtc.wtes.business.model.rltl.TravelEntry;
import kd.wtc.wtes.business.model.rltl.TravelRule;
import kd.wtc.wtes.business.model.rltl.TravelType;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TravelEntityUtils {
    private static final String ORIGINALATT = "originalatt";
    private static final String ROUNDRULE = "roundrule";
    private static final String ROUNDATT = "roundatt";
    private static final String DATERANGECONDITION = "daterangecondition";
    private static final String TRIPSOURCE_PROPERTY = "tripsource.id";

    public static Map<Long, TimeSeqBo<TbAttPackage>> getTravelPlanTimeSeqBo(Set<Long> planIds, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqBo<TbAttPackage>> result = new HashMap<Long, TimeSeqBo<TbAttPackage>>(planIds.size());
        HRBaseServiceHelper planHisServiceHelper = new HRBaseServiceHelper("wtp_taplan");
        DynamicObject[] hisPlanArray = planHisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(planIds, startDate, endDate));
        HashSet<Long> ruleIds = new HashSet<Long>();
        HashMap<Long, List> hisPlanCluster = new HashMap<Long, List>(planIds.size());
        for (DynamicObject hisPlan2 : hisPlanArray) {
            long fid = hisPlan2.getLong("boid");
            List list = hisPlanCluster.getOrDefault(fid, new LinkedList());
            list.add(hisPlan2);
            hisPlanCluster.put(fid, list);
            TravelEntityUtils.collectRuleIds(hisPlan2, ruleIds);
        }
        Map<Long, TimeSeqBo<TravelRule>> ruleBoMap = TravelEntityUtils.getTravelRuleTimeSeqBo(ruleIds, startDate, endDate);
        for (Map.Entry entry : hisPlanCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(hisPlan -> TravelEntityUtils.generateTravelPlan(hisPlan, ruleBoMap, true)).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqBo<TbAttPackage>)TimeSeqBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    private static void collectRuleIds(DynamicObject plan, Set<Long> ruleIds) {
        ruleIds.add(plan.getLong("triprule.id"));
    }

    private static TbAttPackage generateTravelPlan(DynamicObject plan, Map<Long, TimeSeqBo<TravelRule>> ruleBoMap, boolean isTimeSeq) {
        TbAttPackage.Builder builder;
        long id = plan.getLong("id");
        String number = plan.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(plan);
        TbAttPackage.Builder builder2 = builder = isTimeSeq ? TbAttPackage.withTimeSeq(id, number, timeSeqEntity) : TbAttPackage.withUnTimeSeq(id, number);
        if (!PolicyResultHelp.isRuleEngineByPlanID(id)) {
            Long ruleId = plan.getLong("triprule.id");
            TimeSeqBo<TravelRule> travelRuleBo = ruleBoMap.get(ruleId);
            if (travelRuleBo != null) {
                builder.addTravelRuleBo(travelRuleBo);
            }
        } else {
            builder.addTravelRuleBo((TimeSeqBo<TravelRule>)new TimeSeqAvailableBo());
        }
        return builder.build();
    }

    public static Map<Long, TimeSeqBo<TravelRule>> getTravelRuleTimeSeqBo(Set<Long> ruleIds, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqBo<TravelRule>> result = new HashMap<Long, TimeSeqBo<TravelRule>>(ruleIds.size());
        HRBaseServiceHelper rulesHisServiceHelper = new HRBaseServiceHelper("wtp_tarvelrule");
        DynamicObject[] hisRuleArray = rulesHisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(ruleIds, startDate, endDate));
        HashSet<Long> travelEntrieIds = new HashSet<Long>();
        TravelEntityUtils.collectTravelEntrieIds(hisRuleArray, travelEntrieIds);
        HashMap<Long, List> hisRuleCluster = new HashMap<Long, List>(ruleIds.size());
        for (DynamicObject hisRule2 : hisRuleArray) {
            long fid = hisRule2.getLong("boid");
            List list = hisRuleCluster.getOrDefault(fid, new LinkedList());
            list.add(hisRule2);
            hisRuleCluster.put(fid, list);
        }
        for (Map.Entry entry : hisRuleCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(hisRule -> TravelEntityUtils.generateTravelRule(hisRule, true)).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqBo<TravelRule>)TimeSeqBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    private static void collectTravelType(DynamicObject rule, Map<Long, TravelType> travelTypeMap) {
        for (DynamicObject entryDy : rule.getDynamicObjectCollection("entryentity")) {
            long typeId = entryDy.getLong("traveltype.id");
            String number = entryDy.getString("traveltype.number");
            travelTypeMap.put(typeId, TravelType.of(typeId, number));
        }
    }

    private static void collectTravelEntrieIds(DynamicObject[] hisRuleArray, Set<Long> travelEntrieIds) {
        for (DynamicObject hisRule : hisRuleArray) {
            hisRule.getDynamicObjectCollection("entryentity").forEach(entry -> travelEntrieIds.add(entry.getLong("id")));
        }
    }

    private static TravelRule generateTravelRule(DynamicObject rule, boolean isTimeSeq) {
        long id = rule.getLong("id");
        String number = rule.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(rule);
        TravelRule travelRule = isTimeSeq ? new TravelRule(id, number, timeSeqEntity) : new TravelRule(id, number, null);
        travelRule.setTravelEntries(TravelEntityUtils.getTravelEntry(rule));
        return travelRule;
    }

    private static List<TravelEntry> getTravelEntry(DynamicObject rule) {
        DynamicObjectCollection entryEntity = rule.getDynamicObjectCollection("entryentity");
        ArrayList resultList = Lists.newArrayListWithCapacity((int)entryEntity.size());
        for (DynamicObject entryDy : rule.getDynamicObjectCollection("entryentity")) {
            long typeId = entryDy.getLong("traveltype.id");
            String number = entryDy.getString("traveltype.number");
            TravelEntry travelEntry = TravelEntry.of(entryDy.getLong("id"), entryDy.getString("id")).setOriAtt(entryDy.getDynamicObject(ORIGINALATT) != null ? entryDy.getDynamicObject(ORIGINALATT).getLong("id") : 0L).setRoundAtt(entryDy.getDynamicObject(ROUNDATT) != null ? entryDy.getDynamicObject(ROUNDATT).getLong("id") : 0L).setRoundWrapper(entryDy.getDynamicObject(ROUNDRULE) != null ? entryDy.getDynamicObject(ROUNDRULE).getLong("id") : 0L).setCondition(entryDy.getString(DATERANGECONDITION)).setTimeSource(entryDy.getLong(TRIPSOURCE_PROPERTY)).setLimitScope(entryDy.getString("limitscope")).setTravelType(TravelType.of(typeId, number));
            resultList.add(travelEntry);
        }
        return resultList;
    }

    private static String getConditionNum(List<Entity> entrys) {
        if (CollectionUtils.isEmpty(entrys)) {
            return "";
        }
        return entrys.get(0).getNumber();
    }
}

