/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota;

import java.util.concurrent.CancellationException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtes.business.quota.QuotaException;
import kd.wtc.wtes.business.quota.QuotaInterruptingException;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.service.QuotaAlarm;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.service.QuotaStateful;
import kd.wtc.wtes.business.quota.service.QuotaTerminable;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;

public abstract class AbstractQuotaRunner
implements QuotaStateful,
QuotaTerminable,
Runnable,
QuotaAlarm {
    private static final int MAX_EXPORT_SIZE = 150;
    private static final int MAX_EXPORT_LINE = 20;
    private volatile QuotaState state = QuotaState.NEW;
    private final Object stateChangeMonitor = new Object();
    protected final Log log = LogFactory.getLog(AbstractQuotaRunner.class);
    protected String exceptionStr;
    private RequestContext requestContext;

    public abstract QuotaRequest getQuotaRequest();

    @Override
    public void run() {
        if (this.requestContext != null) {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
        }
        this.caughtException();
        try {
            this.beforeRun();
            this.checkAndSetState(QuotaState.INIT);
            this.init();
            this.validate();
            this.checkAndSetState(QuotaState.RUNNING);
            this.beforeDoRun();
            this.doRun();
            this.doRunAfter();
            this.checkAndSetState(QuotaState.SUCCESS);
        }
        catch (QuotaInterruptingException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e3b\u52a8\u68c0\u6d4b\u5230\u7ec8\u6b62:", (String)"AbstractQuotaRunner_0", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true);
            this.stateChanged(QuotaState.TERMINATED);
        }
        catch (InterruptedException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u7ebf\u7a0b\u68c0\u67e5\u4e2d\u65ad\u88ab\u7ec8\u6b62:", (String)"AbstractQuotaRunner_1", (String)"wtc-wtes-business", (Object[])new Object[0]), e, false);
            this.stateChanged(QuotaState.TERMINATING);
            this.stateChanged(QuotaState.TERMINATED);
        }
        catch (CancellationException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u68c0\u67e5\u4e2d\u65ad\u88ab\u53d6\u6d88:", (String)"AbstractQuotaRunner_2", (String)"wtc-wtes-business", (Object[])new Object[0]), e, false);
            this.stateChanged(QuotaState.TERMINATED);
        }
        catch (WtesBizException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u4efb\u52a1\u53d1\u751f\u9519\u8bef\u7ec8\u6b62:", (String)"AbstractQuotaRunner_5", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true);
            this.stateChanged(QuotaState.ERROR);
        }
        catch (QuotaException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u3002", (String)"AbstractQuotaRunner_3", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, true);
            this.stateChanged(QuotaState.ERROR);
        }
        catch (KDException e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"", (String)"AbstractQuotaRunner_3", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, true);
            this.stateChanged(QuotaState.ERROR);
        }
        catch (Exception e) {
            this.log.warn("QuotaEngine_error", (Throwable)e);
            this.setReportExceptionStr(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u3002", (String)"AbstractQuotaRunner_3", (String)"wtc-wtes-business", (Object[])new Object[0]), e, true, true);
            this.stateChanged(QuotaState.ERROR);
        }
        finally {
            try {
                this.afterRun();
            }
            catch (Exception e) {
                this.log.warn("QuotaEngine after run error", (Throwable)e);
            }
        }
    }

    private void checkAndSetState(QuotaState state) throws QuotaInterruptingException, InterruptedException {
        this.checkInterrupt();
        this.stateChanged(state);
    }

    protected void beforeRun() throws QuotaException, InterruptedException {
    }

    protected void init() throws QuotaException, InterruptedException {
    }

    protected abstract void doRun() throws QuotaException, InterruptedException;

    protected void afterRun() {
    }

    protected void validate() throws WtesException {
    }

    protected abstract void stateChanged(QuotaState var1, QuotaState var2);

    @Override
    public QuotaState getState() {
        return this.state;
    }

    @Override
    public void terminate() {
        this.stateChanged(QuotaState.TERMINATING);
    }

    private void stateChanged(QuotaState state) {
        QuotaState oldState = this.syncChange(state);
        if (oldState != null) {
            this.stateChanged(oldState, state);
        }
    }

    protected abstract String getRunnerTag();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuotaState syncChange(QuotaState state) {
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (state.isAfter(this.state)) {
                QuotaState oldState = this.state;
                this.state = state;
                return oldState;
            }
            return null;
        }
    }

    protected final void checkInterrupt() throws QuotaInterruptingException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (QuotaState.TERMINATING == this.state) {
            throw new QuotaInterruptingException();
        }
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    private String getStackTraceMessage(Throwable exception) {
        if (exception == null) {
            return "";
        }
        this.log.warn("AbstractQuotaRunner.run error message:", exception);
        StackTraceElement[] traceArray = exception.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(exception.getMessage());
        sb.append(':');
        if (null != traceArray) {
            for (int i = 0; i < traceArray.length; ++i) {
                sb.append(traceArray[i]);
                if (i > 20) break;
            }
        }
        return sb.toString();
    }

    private void setReportExceptionStr(String preMark, Throwable exception, boolean stackFlag) {
        this.setReportExceptionStr(preMark, exception, stackFlag, true);
    }

    private void setReportExceptionStr(String preMark, Throwable exception, boolean stackFlag, boolean alarmException) {
        this.log.warn(preMark, exception);
        String exceptionRemark = stackFlag ? this.getStackTraceMessage(exception) : exception.getMessage();
        this.exceptionStr = preMark + exceptionRemark;
        if (alarmException) {
            this.alarm(QuotaMsgLevel.ERROR, this.getAlarmMessage(preMark, exception));
        } else {
            this.alarm(QuotaMsgLevel.ERROR, preMark);
        }
    }

    private String getAlarmMessage(String preMark, Throwable exception) {
        if (exception == null) {
            return preMark;
        }
        return preMark + (null != exception.getMessage() ? exception.getMessage().substring(0, Math.min(150, exception.getMessage().length())) : "");
    }

    private void caughtException() {
        Thread.currentThread().setUncaughtExceptionHandler((t, throwable) -> {
            this.log.warn("[QUOTA] InstanceId: %s, QuotaEngineTag: %s error", new Object[]{Instance.getInstanceId(), this.getRunnerTag(), throwable});
            try {
                this.stateChanged(QuotaState.ERROR);
            }
            catch (Exception e) {
                this.log.warn("[QUOTA] InstanceId: %s, QuotaEngineTag: %s, state could not changed to error", new Object[]{Instance.getInstanceId(), this.getRunnerTag(), e});
            }
        });
    }

    protected abstract void doRunAfter();

    protected abstract void beforeDoRun();
}

