/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.chain.TieStatusDecision;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.chain.AbstractQuotaExecutorsExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaChainExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaExecutionException;
import kd.wtc.wtes.business.quota.chain.QuotaExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaPhaseExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactory;
import kd.wtc.wtes.business.quota.chain.QuotaWrappedDataPackage;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeWrapper;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.service.IQuotaLineExporter;
import kd.wtc.wtes.business.quota.service.QuotaAlarm;
import kd.wtc.wtes.business.quota.service.QuotaIdService;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.std.QuotaPhaseExecutorStd;
import kd.wtc.wtes.common.util.Assert;

public class QuotaChainExecutorDefault<T extends IQuotaDataNode<T>>
extends AbstractQuotaExecutorsExecutor<T>
implements QuotaChainExecutor<T> {
    private LocalDate chainDate;
    private TieScheme tieScheme;
    private QuotaRequest tieRequest;
    private Map<String, Object> engineVariable;
    private Map<String, Object> lineVariable;
    private IQuotaLineExporter lineExporter;
    private QuotaDataNodeWrapper<T> dataNodeWrapper;
    private QuotaIdService idService;
    private QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private Map<String, Object> initParams;
    private TieSchemeIdentity schemeIdentity;
    private AttPersonRange attSubjectEntry;
    private Long quotaTypeId;
    private CircleRestVo circleRestVo;

    @Override
    protected void init() throws QuotaExecutionException {
        super.init();
        Assert.nonNull((Object)((Object)this.tieScheme), (String)"tieScheme");
        Assert.nonNull(this.lineVariable, (String)"lineVariable");
        Assert.nonNull((Object)this.chainDate, (String)"chainDate");
        Assert.nonNull((Object)this.tieRequest, (String)"tieRequest");
        Assert.nonNull(this.engineVariable, (String)"engineVariable");
        Assert.nonNull((Object)this.lineExporter, (String)"lineExporter");
        Assert.nonNull(this.dataNodeWrapper, (String)"dataNodeWrapper");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
        Assert.nonNull(this.initParams, (String)"initParams");
        Assert.nonNull((Object)this.attSubjectEntry, (String)"attSubjectEntry");
        this.schemeIdentity = new TieSchemeIdentity(this.tieScheme.getId(), this.tieScheme.getNumber(), 0L, null);
    }

    @Override
    public QuotaDataPackage<T> makeDataPackage() {
        return new QuotaWrappedDataPackage(this);
    }

    @Override
    protected int getExecutorSize() {
        return this.tieScheme.getPhaseProperties().size();
    }

    @Override
    protected QuotaExecutor<T> makeExecutor(int executorIndex) {
        TiePhaseConfig phaseConfig = this.tieScheme.getPhaseProperties().get(executorIndex);
        QuotaPhaseExecutor phase = (QuotaPhaseExecutor)WTCAppContextHelper.getBean(QuotaPhaseExecutorStd.class);
        phase.setChainExecutor(this);
        phase.setPhaseConfig(phaseConfig);
        CalReportParaHolder reportPara = this.getReportPara();
        phase.setReportPara(reportPara);
        phase.setPhaseIdentity(new TiePhaseIdentity(phaseConfig.getNumber(), this.getSchemeIdentity(), phaseConfig.getIndex(), phaseConfig.getSaveFlag(), phaseConfig.getResult(), phaseConfig.getId()));
        return phase;
    }

    @Override
    protected TieStatusDecision makeDecision() {
        TieStatusDecision tieStatusDecision = (TieStatusDecision)WTCAppContextHelper.getBean(TieStatusDecision.class);
        tieStatusDecision.mackDecisionMap(this.tieScheme.getPhaseDecisions());
        return tieStatusDecision;
    }

    @Override
    public String getExecutorTag() {
        return this.attSubjectEntry.getPersonId() + EXECUTOR_TAG_DELIMITER + this.chainDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    @Override
    public String getExecutorName() {
        return null;
    }

    @Override
    public QuotaAlarm getAlarm() {
        return this.lineExporter;
    }

    @Override
    public Map<String, Object> getEngineVariable() {
        return this.engineVariable;
    }

    @Override
    public Map<String, Object> getLineVariable() {
        return this.lineVariable;
    }

    @Override
    public QuotaRequest getQuotaRequest() {
        return this.tieRequest;
    }

    @Override
    public LocalDate getChainDate() {
        return this.chainDate;
    }

    @Override
    public TieScheme getQuotaScheme() {
        return this.tieScheme;
    }

    @Override
    public void setQuotaScheme(TieScheme tieScheme) {
        this.tieScheme = tieScheme;
    }

    @Override
    public void setDataNodeWrapper(QuotaDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public QuotaDataNodeWrapper<T> getDataNodeWrapper() {
        return this.dataNodeWrapper;
    }

    @Override
    public void setLineVariable(Map<String, Object> lineVariable) {
        this.lineVariable = lineVariable;
    }

    @Override
    public void setChainDate(LocalDate chainDate) {
        this.chainDate = chainDate;
    }

    @Override
    public void setQuotaRequest(QuotaRequest tieRequest) {
        this.tieRequest = tieRequest;
    }

    @Override
    public AttPersonRange getAttSubjectEntry() {
        return this.attSubjectEntry;
    }

    @Override
    public void setAttSubjectEntry(AttPersonRange attSubjectEntry) {
        this.attSubjectEntry = attSubjectEntry;
    }

    @Override
    public void setEngineVariable(Map<String, Object> engineVariable) {
        this.engineVariable = engineVariable;
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    @Override
    public void setLineExporter(IQuotaLineExporter lineExporter) {
        this.lineExporter = lineExporter;
    }

    @Override
    public List<QuotaPhaseExecutor<T>> getExecutedExecutors() {
        return super.getExecutedExecutors();
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.lineExporter.alarm(msgLevel, msg);
    }

    @Override
    public void setStepExecutorUnitFactory(QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public QuotaStepExecutorUnitFactory<T> getStepExecutorUnitFactory() {
        return this.stepExecutorUnitFactory;
    }

    @Override
    public void setIdService(QuotaIdService idService) {
        this.idService = idService;
    }

    @Override
    public QuotaIdService getIdService() {
        return this.idService;
    }

    @Override
    public TieSchemeIdentity getSchemeIdentity() {
        return this.schemeIdentity;
    }

    @Override
    public List<QuotaPhaseDataResult<T>> getPhaseDataResults() {
        return this.getExecutedExecutors().stream().map(QuotaPhaseExecutor::getPhaseDataResult).collect(Collectors.toList());
    }

    @Override
    public Long getQoutaTypeId() {
        return this.quotaTypeId;
    }

    @Override
    public void setQoutaTypeId(Long quotaTypeId) {
        this.quotaTypeId = quotaTypeId;
    }

    @Override
    public CircleRestVo getCircleRestVo() {
        return this.circleRestVo;
    }

    @Override
    public void setCircleRestVo(CircleRestVo circleRestVo) {
        this.circleRestVo = circleRestVo;
    }
}

