/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.chain.QuotaVariable;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;

public interface QuotaContext<T extends IQuotaDataNode<T>> {
    public AttPersonRange getAttSubjectEntry();

    public QuotaRequest getRequest();

    public QuotaDataPackage<T> getDataPackage();

    default public List<T> getAllDataNodes() {
        return this.getDataPackage().getAllDataNodes();
    }

    default public List<T> getDataNodesByPhaseNumber(String phaseNumber) {
        return this.getDataPackage().getDataNodesByPhaseNumber(phaseNumber);
    }

    default public List<T> getDataNodesByStepNumber(String phaseNumber, String stepNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Assert.nonNull((Object)stepNumber, (String)"stepNumber");
        return this.getDataNodesByPhaseNumber(phaseNumber).stream().filter(dataNode -> dataNode.getStepIdentity().getNumber().equals(stepNumber)).collect(Collectors.toList());
    }

    @Nullable
    default public T getDataNodeById(long id) {
        return (T)((IQuotaDataNode)this.getAllDataNodes().stream().filter(dataNode -> dataNode.getId() == id).findFirst().orElse(null));
    }

    default public List<T> getDataNodesOfPrevStepExecutor() {
        Optional<QuotaStepDataResult<QuotaStepDataResult>> lastExecutedStepResult = this.getDataPackage().getLastExecutedStepResult();
        return lastExecutedStepResult.map(stepDataResult -> CollectionUtils.unmodifiableList(stepDataResult.getDataNodes())).orElseGet(() -> Collections.emptyList());
    }

    default public List<T> getDataNodesInCurPhase() {
        Optional<QuotaPhaseDataResult<QuotaPhaseDataResult>> lastExecutedPhaseResult = this.getDataPackage().getLastPhaseResult();
        return lastExecutedPhaseResult.map(phaseResult -> {
            List dataNodesInStepResults = QuotaDataPackage.getDataNodesInStepResults(phaseResult.getStepDataResults());
            return CollectionUtils.unmodifiableList(dataNodesInStepResults);
        }).orElseGet(() -> Collections.emptyList());
    }

    public QuotaVariable getQuotaVariable();

    @Nullable
    default public Object setVariable(String key, Object value, VScope vScope) {
        return this.getQuotaVariable().getVariableMap(vScope).put(key, value);
    }

    @Nullable
    default public <V> V getVariable(String key, VScope vScope) {
        return (V)this.getQuotaVariable().getVariableMap(vScope).get(key);
    }

    default public boolean containsVariable(String key, VScope vScope) {
        return this.getQuotaVariable().getVariableMap(vScope).containsKey(key);
    }

    public Map<String, Object> getInitParams();

    @Nullable
    default public <V> V getInitParam(String key) {
        return (V)this.getInitParams().get(key);
    }

    default public <V> V getInitParamMust(String key, Class<V> paramType) {
        Object value = this.getInitParams().get(key);
        if (value == null) {
            throw new WtesBizException("Could not find [" + key + "] in init params");
        }
        if (!paramType.isInstance(value)) {
            throw new WtesBizException("Param type mismatch, expected: " + paramType.getName() + ",actual:" + value.getClass().getName() + ",the param key is: " + key);
        }
        return paramType.cast(value);
    }

    default public <V> Optional<V> getInitParamOptional(String key, Class<V> paramType) {
        Object value = this.getInitParams().get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!paramType.isInstance(value)) {
            throw new WtesBizException("Param type mismatch, expected: " + paramType.getName() + ",actual:" + value.getClass().getName() + ",the param key is: " + key);
        }
        return Optional.of(paramType.cast(value));
    }

    @NotNull
    public TieStepIdentity getQuotaStepIdentity();

    public Long getQuotaTypeId();

    public CircleRestVo getCircleRestVo();
}

