/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.Map;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.chain.QuotaChainExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaContext;
import kd.wtc.wtes.business.quota.chain.QuotaPhaseExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaVariable;
import kd.wtc.wtes.business.quota.chain.QuotaWrappedDataPackage;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.common.util.Assert;

public class QuotaContextDefault<T extends IQuotaDataNode<T>>
implements QuotaContext<T> {
    private final TieStepIdentity tieStepIdentity;
    private final QuotaRequest tieRequest;
    private final QuotaDataPackage<T> dataPackage;
    private final QuotaVariable tieVariable;
    private final Map<String, Object> initParams;
    private final AttPersonRange attSubjectEntry;
    private final Long quotaTypeId;
    private final CircleRestVo circleRestVo;

    public QuotaContextDefault(QuotaStepExecutor<T> stepExecutor) {
        QuotaPhaseExecutor<T> phaseExecutor = stepExecutor.getPhaseExecutor();
        Assert.nonNull(phaseExecutor, (String)"phaseExecutor");
        QuotaChainExecutor<T> chainExecutor = phaseExecutor.getChainExecutor();
        Assert.nonNull(chainExecutor, (String)"chainExecutor");
        QuotaWrappedDataPackage<T> dataPackage = new QuotaWrappedDataPackage<T>(chainExecutor);
        QuotaVariable tieVariable = new QuotaVariable(chainExecutor.getEngineVariable(), chainExecutor.getLineVariable(), chainExecutor.getExecutorVariable(), phaseExecutor.getExecutorVariable(), stepExecutor.getExecutorVariable());
        this.tieStepIdentity = stepExecutor.getStepIdentity();
        this.attSubjectEntry = chainExecutor.getAttSubjectEntry();
        this.tieRequest = chainExecutor.getQuotaRequest();
        this.dataPackage = dataPackage;
        this.tieVariable = tieVariable;
        this.initParams = chainExecutor.getInitParams();
        this.circleRestVo = chainExecutor.getCircleRestVo();
        this.quotaTypeId = chainExecutor.getQoutaTypeId();
    }

    @Override
    public AttPersonRange getAttSubjectEntry() {
        return this.attSubjectEntry;
    }

    @Override
    public QuotaRequest getRequest() {
        return this.tieRequest;
    }

    @Override
    public QuotaDataPackage<T> getDataPackage() {
        return this.dataPackage;
    }

    @Override
    public QuotaVariable getQuotaVariable() {
        return this.tieVariable;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    @Override
    public TieStepIdentity getQuotaStepIdentity() {
        return this.tieStepIdentity;
    }

    @Override
    public Long getQuotaTypeId() {
        return this.quotaTypeId;
    }

    @Override
    public CircleRestVo getCircleRestVo() {
        return this.circleRestVo;
    }

    public String toString() {
        return "QuotaContextDefault{tieStepIdentity=" + this.tieStepIdentity + ", attPersonQuotaRange=" + this.attSubjectEntry + ", tieRequest=" + this.tieRequest + ", dataPackage=" + this.dataPackage + ", tieVariable=" + this.tieVariable + ", quotaTypeId=" + this.quotaTypeId + ", initParams=" + this.initParams + '}';
    }
}

