/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.Map;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.common.util.Assert;

public class QuotaVariable {
    private final Map<String, Object> engineVariable;
    private final Map<String, Object> lineVariable;
    private final Map<String, Object> chainVariable;
    private final Map<String, Object> phaseVariable;
    private final Map<String, Object> stepVariable;

    public QuotaVariable(Map<String, Object> engineVariable, Map<String, Object> lineVariable, Map<String, Object> chainVariable, Map<String, Object> phaseVariable, Map<String, Object> stepVariable) {
        Assert.nonNull(engineVariable, (String)"chainExecutor");
        Assert.nonNull(lineVariable, (String)"lineVariable");
        Assert.nonNull(chainVariable, (String)"chainVariable");
        Assert.nonNull(phaseVariable, (String)"phaseVariable");
        Assert.nonNull(stepVariable, (String)"stepVariable");
        this.engineVariable = engineVariable;
        this.lineVariable = lineVariable;
        this.chainVariable = chainVariable;
        this.phaseVariable = phaseVariable;
        this.stepVariable = stepVariable;
    }

    public <V> V get(String key, VScope vScope) {
        Map<String, Object> variable = this.getVariableMap(vScope);
        Object value = variable.get(key);
        return (V)value;
    }

    public <V> V put(String key, Object value, VScope vScope) {
        Map<String, Object> variable = this.getVariableMap(vScope);
        Object oldValue = variable.put(key, value);
        return (V)oldValue;
    }

    public boolean contains(String key, VScope vScope) {
        Map<String, Object> variable = this.getVariableMap(vScope);
        return variable.containsKey(key);
    }

    public Map<String, Object> getVariableMap(VScope vScope) {
        switch (vScope) {
            case PHASE: {
                return this.phaseVariable;
            }
            case CHAIN: {
                return this.chainVariable;
            }
            case LINE: {
                return this.lineVariable;
            }
            case ENGINE: {
                return this.engineVariable;
            }
            case STEP: {
                return this.stepVariable;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "TieVariable{engineVariable=" + this.engineVariable + ", lineVariable=" + this.lineVariable + ", chainVariable=" + this.chainVariable + ", phaseVariable=" + this.phaseVariable + ", stepVariable=" + this.stepVariable + '}';
    }
}

