/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.datanode;

import java.util.Collection;
import java.util.List;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.IQuotaTraceable;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public interface IQuotaDataNodeExt<T extends IQuotaDataNode<T>>
extends IQuotaTraceable<T> {
    public List<EvaluationRuleModel> getEvaluationRule();

    public List<QuotaAttItemInstance> getAttItemInstances();

    public String getDataNodeCategory();

    public LabelSet<ILabel> getLabelSet();

    public IEntity getMatchedRule();

    default public <R extends IEntity> R getMatchedRule(Class<R> matchedRuleClazz) {
        return (R)((IEntity)matchedRuleClazz.cast(this.getMatchedRule()));
    }

    default public long[] getParentIds() {
        return this.parentDataNodes().stream().mapToLong(IQuotaDataNode::getId).toArray();
    }

    default public boolean containsAttItem(AttItemSpec attItemSpec) {
        if (attItemSpec == null) {
            return false;
        }
        return this.getAttItemInstances().stream().anyMatch(attItemInstance -> ((Object)((Object)attItemInstance.getAttItemSpec())).equals((Object)attItemSpec));
    }

    default public boolean containsAnyAttItem(Collection<? extends AttItemSpec> attItemSpecs) {
        for (AttItemSpec attItemSpec : attItemSpecs) {
            if (!this.containsAttItem(attItemSpec)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAllAttItems(Collection<? extends AttItemSpec> attItemSpecs) {
        for (AttItemSpec attItemSpec : attItemSpecs) {
            if (this.containsAttItem(attItemSpec)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAttItemNumber(String attItemNumber) {
        if (attItemNumber == null) {
            return false;
        }
        return this.getAttItemInstances().stream().anyMatch(attItemInstance -> attItemInstance.getAttItemSpec().getNumber().equals(attItemNumber));
    }

    default public boolean containsAnyAttItemNumber(Collection<String> attItemNumbers) {
        for (String attItemNumber : attItemNumbers) {
            if (!this.containsAttItemNumber(attItemNumber)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAllAttItemNumbers(Collection<String> attItemNumbers) {
        for (String attItemNumber : attItemNumbers) {
            if (this.containsAttItemNumber(attItemNumber)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsLabel(ILabel label) {
        return this.getLabelSet().stream().anyMatch(lb -> lb.equals(label));
    }

    default public boolean containsAllLabels(Collection<? extends ILabel> labels) {
        return this.getLabelSet().containsAll(labels);
    }

    default public boolean containsAnyLabel(Collection<? extends ILabel> labels) {
        return this.getLabelSet().containsAny(labels);
    }
}

