/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.datanode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNodeExt;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.common.lang.TypeCloneable;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public abstract class QuotaDataNode
implements IQuotaDataNodeExt<QuotaDataNodeStd>,
TypeCloneable<QuotaDataNode> {
    private List<QuotaDataNodeStd> parentDataNodes = new LinkedList<QuotaDataNodeStd>();
    private List<EvaluationRuleModel> evaluationRules = new ArrayList<EvaluationRuleModel>(16);
    private LabelSet<ILabel> labelSet = new LabelSet();
    private IEntity matchedRule;

    protected QuotaDataNode() {
    }

    @Override
    public List<EvaluationRuleModel> getEvaluationRule() {
        return this.evaluationRules;
    }

    public void setEvaluationRule(EvaluationRuleModel evaluationRule) {
        this.evaluationRules.add(evaluationRule);
    }

    @Override
    public List<QuotaDataNodeStd> parentDataNodes() {
        return this.parentDataNodes;
    }

    public void setParentDataNodes(List<QuotaDataNodeStd> parentDataNodes) {
        this.parentDataNodes = parentDataNodes;
    }

    @Override
    public LabelSet<ILabel> getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSet<ILabel> labelSet) {
        this.labelSet = labelSet;
    }

    @Override
    public IEntity getMatchedRule() {
        return this.matchedRule;
    }

    public void setMatchedRule(IEntity matchedRule) {
        this.matchedRule = matchedRule;
    }

    public String toString() {
        return "QuotaDataNode{parentDataNodeIds=" + Arrays.toString(this.getParentIds()) + ", evaluationRules=" + this.evaluationRules + ", labelSet=" + this.labelSet + '}';
    }

    public QuotaDataNode clone() {
        try {
            return (QuotaDataNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WtesException((Throwable)e);
        }
    }

    protected static <T> List<T> copy(Collection<T> tCollection) {
        if (tCollection == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(tCollection);
    }

    protected static abstract class Builder<E extends QuotaDataNode, B extends Builder<E, B>>
    extends CleanableBuilder<E, B> {
        protected QuotaDataNode dataNode;

        protected Builder(E dataNode) {
            Assert.nonNull(dataNode, (String)"dataNode");
            this.dataNode = dataNode;
        }

        public B appendParentDataNode(QuotaDataNodeStd parentDataNode) {
            this.dataNode.parentDataNodes.add(parentDataNode);
            return (B)((Builder)this.self());
        }

        public B appendAllParentDataNodes(Collection<QuotaDataNodeStd> parentDataNodes) {
            this.dataNode.parentDataNodes.addAll(parentDataNodes);
            return (B)((Builder)this.self());
        }

        public B parentDataNodes(Collection<QuotaDataNodeStd> parentDataNodes) {
            this.dataNode.parentDataNodes = new ArrayList<QuotaDataNodeStd>(parentDataNodes);
            return (B)((Builder)this.self());
        }

        public B clearParentDataNodes() {
            this.dataNode.parentDataNodes.clear();
            return (B)((Builder)this.self());
        }

        public B evaluationRule(EvaluationRuleModel evaluationRule) {
            this.dataNode.evaluationRules.add(evaluationRule);
            return (B)((Builder)this.self());
        }

        public B addLabel(ILabel label) {
            this.dataNode.labelSet.add(label);
            return (B)((Builder)this.self());
        }

        public B addAllLabels(Collection<? extends ILabel> labels) {
            this.dataNode.labelSet.addAll(labels);
            return (B)((Builder)this.self());
        }

        public B matchedRule(IEntity matchedRule) {
            this.dataNode.matchedRule = matchedRule;
            return (B)((Builder)this.self());
        }

        @Override
        protected void clear() {
            this.dataNode = null;
        }
    }
}

