/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.datanode;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtbs.common.model.Extendable;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.datanode.QuotaPoisonPillObj;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtes.common.util.Assert;

public interface QuotaDataPackage<T extends IQuotaDataNode<T>>
extends QuotaPoisonPillObj,
Extendable {
    public static final int mask_line_bo_run_end = 1;
    public static final int mask_line_run_end = 2;
    public static final String ext_key_qt_runtime_cache = "ext_key_qt_runtime_cache";
    public static final String ext_key_line_all_bo = "ext_key_line_all_bo";
    public static final String ext_key_line_one_bo = "ext_key_line_one_bo";

    public boolean isEmptyDataPackage();

    public void setEmptyDataPackage(boolean var1);

    public List<T> getAllDataNodes();

    public List<QuotaPhaseDataResult<T>> getPhaseDataResults();

    public String getVersion();

    public long getAttPersonId();

    public LocalDate getChainDate();

    public TieStatus getResultStatus();

    public TieSchemeIdentity getQuotaSchemeIdentity();

    default public Optional<QuotaPhaseDataResult<T>> getFirstPhaseResult() {
        List<QuotaPhaseDataResult<T>> quotaPhaseDataResults = this.getPhaseDataResults();
        if (quotaPhaseDataResults.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(quotaPhaseDataResults.get(0));
    }

    default public Optional<QuotaStepDataResult<T>> getFirstStepResult() {
        return this.getFirstPhaseResult().map(quotaPhaseDataResult -> {
            List quotaStepDataResults = quotaPhaseDataResult.getStepDataResults();
            if (quotaStepDataResults.isEmpty()) {
                return null;
            }
            return quotaStepDataResults.get(0);
        });
    }

    default public Optional<QuotaPhaseDataResult<T>> getLastPhaseResult() {
        List<QuotaPhaseDataResult<T>> quotaPhaseDataResults = this.getPhaseDataResults();
        if (quotaPhaseDataResults.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(quotaPhaseDataResults.get(quotaPhaseDataResults.size() - 1));
    }

    default public Optional<QuotaStepDataResult<T>> getLastStepResult() {
        return this.getLastPhaseResult().map(quotaPhaseDataResult -> {
            List quotaStepDataResults = quotaPhaseDataResult.getStepDataResults();
            if (quotaStepDataResults.isEmpty()) {
                return null;
            }
            return quotaStepDataResults.get(quotaStepDataResults.size() - 1);
        });
    }

    default public Optional<QuotaStepDataResult<T>> getLastExecutedStepResult() {
        return this.getLastPhaseResult().map(quotaPhaseDataResult -> {
            List quotaStepDataResults = quotaPhaseDataResult.getStepDataResults();
            if (quotaStepDataResults.isEmpty()) {
                return null;
            }
            for (int i = quotaStepDataResults.size() - 1; i >= 0; --i) {
                QuotaStepDataResult quotaStepDataResult = quotaStepDataResults.get(i);
                if (quotaStepDataResult.getResultStatus() == TieStatus.UNKNOWN) continue;
                return quotaStepDataResult;
            }
            return null;
        });
    }

    default public List<QuotaPhaseDataResult<T>> getPhaseResultsBeforePhase(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        LinkedList<QuotaPhaseDataResult<T>> results = new LinkedList<QuotaPhaseDataResult<T>>();
        for (QuotaPhaseDataResult<T> quotaPhaseDataResult : this.getPhaseDataResults()) {
            if (!quotaPhaseDataResult.getNumber().equals(phaseNumber)) {
                results.add(quotaPhaseDataResult);
                continue;
            }
            return results;
        }
        return Collections.emptyList();
    }

    default public List<T> getDataNodesBeforePhase(String phaseNumber) {
        List<QuotaPhaseDataResult<T>> results = this.getPhaseResultsBeforePhase(phaseNumber);
        return QuotaDataPackage.getDataNodesInPhaseResults(results);
    }

    default public Optional<QuotaPhaseDataResult<T>> getPhaseResultByPhaseNumber(String phaseNumber) {
        return this.getPhaseDataResults().stream().filter(quotaPhaseDataResult -> quotaPhaseDataResult.getNumber().equals(phaseNumber)).findFirst();
    }

    default public List<T> getDataNodesByPhaseNumber(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Optional<QuotaPhaseDataResult<QuotaPhaseDataResult>> phaseResult = this.getPhaseResultByPhaseNumber(phaseNumber);
        LinkedList dataNodes = new LinkedList();
        phaseResult.ifPresent(result -> dataNodes.addAll(QuotaDataPackage.getDataNodesInStepResults(result.getStepDataResults())));
        return dataNodes;
    }

    default public List<QuotaPhaseDataResult<T>> getPhaseResultsAfterPhase(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        LinkedList<QuotaPhaseDataResult<T>> results = new LinkedList<QuotaPhaseDataResult<T>>();
        List<QuotaPhaseDataResult<T>> quotaPhaseDataResultList = this.getPhaseDataResults();
        if (!quotaPhaseDataResultList.isEmpty()) {
            ListIterator<QuotaPhaseDataResult<T>> iterator = quotaPhaseDataResultList.listIterator(quotaPhaseDataResultList.size() - 1);
            while (iterator.hasPrevious()) {
                QuotaPhaseDataResult<T> quotaPhaseDataResult = iterator.previous();
                if (!quotaPhaseDataResult.getNumber().equals(phaseNumber)) {
                    results.add(quotaPhaseDataResult);
                    continue;
                }
                return results;
            }
        }
        return Collections.emptyList();
    }

    default public List<T> getDataNodesAfterPhase(String phaseNumber) {
        List<QuotaPhaseDataResult<T>> results = this.getPhaseResultsAfterPhase(phaseNumber);
        return QuotaDataPackage.getDataNodesInPhaseResults(results);
    }

    public static <T extends IQuotaDataNode<T>> List<T> getDataNodesInPhaseResults(List<QuotaPhaseDataResult<T>> quotaPhaseDataResults) {
        if (quotaPhaseDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> dataNodes = new LinkedList<T>();
        for (QuotaPhaseDataResult<T> result : quotaPhaseDataResults) {
            dataNodes.addAll(QuotaDataPackage.getDataNodesInStepResults(result.getStepDataResults()));
        }
        return dataNodes;
    }

    public static <T extends IQuotaDataNode<T>> List<T> getDataNodesInStepResults(List<QuotaStepDataResult<T>> quotaStepDataResults) {
        if (quotaStepDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> dataNodes = new LinkedList<T>();
        for (QuotaStepDataResult<T> result : quotaStepDataResults) {
            dataNodes.addAll(result.getDataNodes());
        }
        return dataNodes;
    }

    default public List<T> getDataNodesByStepNumber(String phaseNumber, String stepNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Assert.nonNull((Object)stepNumber, (String)"stepNumber");
        return this.getDataNodesByPhaseNumber(phaseNumber).stream().filter(dataNode -> dataNode.getStepIdentity().getNumber().equals(stepNumber)).collect(Collectors.toList());
    }
}

