/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.drouter;

import java.util.HashMap;
import java.util.Map;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataPackageRouterStd;
import kd.wtc.wtes.business.quota.std.QuotaDataPackageStd;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;

public abstract class AbstractQuotaDataPackageRouterStd
implements QuotaDataPackageRouterStd {
    private QuotaRequestStd quotaRequestStd;
    private Map<String, Object> initParams;
    private AttPersonRange attSubject;
    private long elapsedInNano;
    private int committedNum;
    private long firstStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(QuotaDataPackage<QuotaDataNodeStd> dataPackage) {
        long startTime = System.nanoTime();
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        try {
            this.commitStd((QuotaDataPackageStd)dataPackage);
        }
        finally {
            this.elapsedInNano += System.nanoTime() - startTime;
            ++this.committedNum;
        }
    }

    @Override
    public void setQuotaRequestStd(QuotaRequestStd quotaRequestStd) {
        this.quotaRequestStd = quotaRequestStd;
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    public QuotaRequestStd getQuotaRequestStd() {
        return this.quotaRequestStd;
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public <T> T getInitParam(String key) {
        return (T)this.getInitParams().get(key);
    }

    @Override
    public void setAttSubject(AttPersonRange attSubject) {
        this.attSubject = attSubject;
    }

    public AttPersonRange getAttSubject() {
        return this.attSubject;
    }

    @Override
    public Map<String, Object> getSpanData() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("spanName", TieReportKDStrings.DATA_PACKAGE_ROUTER.loadKDString());
        if (this.firstStartTime == 0L) {
            map.put("startTime", System.currentTimeMillis());
            map.put("duration", 1L);
        } else {
            map.put("startTime", this.firstStartTime);
            map.put("duration", WTCDateUtils.nano2millis((long)this.elapsedInNano));
        }
        map.put("committedNum", this.committedNum);
        return map;
    }
}

