/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.threads.ThreadPools;
import kd.sdk.wtc.wtes.business.qte.QteRequest;
import kd.sdk.wtc.wtes.business.qte.init.AfterQteAllParamInitEvent;
import kd.sdk.wtc.wtes.business.qte.init.QteParamInitExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.quota.AbstractQuotaRunner;
import kd.wtc.wtes.business.quota.QuotaException;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactory;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeWrapper;
import kd.wtc.wtes.business.quota.drouter.QuotaDataPackageRouter;
import kd.wtc.wtes.business.quota.drouter.QuotaDataPackageRouterFactory;
import kd.wtc.wtes.business.quota.engine.QuotaEngine;
import kd.wtc.wtes.business.quota.engine.QuotaEngineCallbackEvent;
import kd.wtc.wtes.business.quota.engine.QuotaEngineCompletedCallback;
import kd.wtc.wtes.business.quota.engine.QuotaLine;
import kd.wtc.wtes.business.quota.engine.QuotaLineDefault;
import kd.wtc.wtes.business.quota.engine.QuotaRangeChecker;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.DeductEnv;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.service.IQuotaExporter;
import kd.wtc.wtes.business.quota.service.IQuotaLineExporter;
import kd.wtc.wtes.business.quota.service.QuotaIdService;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.service.QuotaTerminable;
import kd.wtc.wtes.business.quota.storage.QuotaDataPackageStoreManager;
import kd.wtc.wtes.business.quota.storage.QuotaVersionDataPackageStore;
import kd.wtc.wtes.business.quota.validator.QuotaValidatorExecutor;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.business.storage.DataPackageStoreResult;
import kd.wtc.wtes.business.storage.VersionDataPackageStore;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.LogUtils;

public abstract class AbstractQuotaEngine<T extends IQuotaDataNode<T>>
extends AbstractQuotaRunner
implements QuotaEngine<T> {
    private QuotaRequest request;
    protected QuotaDataPackageRouterFactory<T> dataPackageRouterFactory;
    protected IQuotaExporter exporter;
    private QuotaEngineCompletedCallback engineCompletedCallback;
    private final Map<String, Object> engineVariable = new ConcurrentHashMap<String, Object>(8);
    private final Map<String, Object> initParams = new HashMap<String, Object>(16);
    private List<AttPersonRange> attSubjects;
    private List<List<QuotaParamInitializer>> initialises;
    private QuotaRangeChecker rangeChecker;
    private QuotaDataNodeWrapper<T> dataNodeWrapper;
    private QuotaIdService idService;
    private QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private QuotaValidatorExecutor validatorExecutor;
    private ITieSchemeService tieSchemeService;
    static final int DEFAULT_INIT_POOL_SIZE = 2;
    static final int INIT_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("quota.engine.pool.size", 2);
    static final String DEFAULT_INIT_POOL_NAME = "WTC_WTES_Qouta_TieInitPool";
    static final String INIT_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("quota.engine.pool.name", "WTC_WTES_Qouta_TieInitPool");
    protected static final ExecutorService INIT_EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)INIT_POOL_NAME, (int)INIT_POOL_SIZE);

    @Override
    protected void beforeRun() throws QuotaException, InterruptedException {
        super.beforeRun();
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        DataPackageStoreManager instance = DataPackageStoreManager.getInstance();
        QuotaRequest request = this.getRequest();
        String version = request.getVersion();
        int shardingIndex = request.getShardingIndex();
        VersionDataPackageStore versionDataPackageStore = instance.getVersionDataPackageStore(version, shardingIndex);
        try (Span storeBatchSpan = TaskTracer.newSpan((String)CalcReportConstants.STORE_BATCH_TIME);){
            Map<String, Object> costData = versionDataPackageStore.getCostData();
            Date startDate = new Date((Long)costData.get("startTime"));
            storeBatchSpan.startTime(WTCDateUtils.toLocalDateTime((Date)startDate));
            storeBatchSpan.durationInMills(System.currentTimeMillis() - startDate.getTime());
            storeBatchSpan.info(TieReportKDStrings.STORE_BATCH_NUM.loadKDString(), () -> String.valueOf(costData.get("storeBatchNum")));
            storeBatchSpan.info(TieReportKDStrings.STORE_TOTAL_COUNT.loadKDString(), () -> String.valueOf(costData.get("storeTotalCount")));
        }
        instance.clearVersionStoreInstance(version, shardingIndex);
    }

    @Override
    protected void init() throws QuotaException, InterruptedException {
        super.init();
        this.checkArgs();
        try (Span initSpan = TaskTracer.newSpan((String)CalcReportConstants.PARAM_INIT);){
            this.rangeChecker.setQuotaRequest(this.request);
            this.rangeChecker.check();
            this.attSubjects = this.rangeChecker.getAttSubjects();
            initSpan.info(TieReportKDStrings.ATT_SUBJECTS_NUM.loadKDString(), () -> String.valueOf(this.attSubjects.size()));
            initSpan.info(TieReportKDStrings.EXCLUDE_ATT_SUBJECTS_NUM.loadKDString(), () -> String.valueOf(this.rangeChecker.getAttExcludeSubject().size()));
            initSpan.info(CalcReportConstants.EXCLUDE_MESSAGE, () -> this.rangeChecker.getExcludeMessage());
            this.exporter.setQuotaRequest(this.request);
            this.exporter.setAttPersonRanges(this.attSubjects);
            this.exporter.setAttExcludeSubjects(this.rangeChecker.getAttExcludeSubject());
            if (CollectionUtils.isEmpty(this.attSubjects)) {
                this.alarm(QuotaMsgLevel.INFO, TieEngineErrorCodes.getNonPersonNeedToTie(), new Object[0]);
                String cancelMessage = TieEngineErrorCodes.getNonPersonNeedToTie().getMessage();
                if (null != this.rangeChecker.getExcludeMessage()) {
                    cancelMessage = cancelMessage + ":" + this.rangeChecker.getExcludeMessage();
                }
                throw new CancellationException(cancelMessage);
            }
            for (List<QuotaParamInitializer> list : this.initialises) {
                Map<String, Object> initParamsTemp = this.loadInitParams(list);
                this.initParams.putAll(initParamsTemp);
            }
            this.afterAllParamInit();
            this.exporter.setInitParams(this.initParams);
        }
    }

    private void afterAllParamInit() {
        AfterQteAllParamInitEvent qtInitExpParam = new AfterQteAllParamInitEvent((QteRequest)this.request, Collections.unmodifiableMap(this.initParams));
        List<AttPersonRange> attPersonRanges = this.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        this.initParams.put("calculateBoIds", attFileBoIds);
        QuotaExtPluginHolder extPluginHolder = (QuotaExtPluginHolder)this.initParams.get("QT_EXT_PLUGIN");
        WTCPluginProxy extPlugin = (WTCPluginProxy)extPluginHolder.getPlugin(QteParamInitExtPlugin.class.getName());
        extPlugin.invokeReplace(instance -> instance.afterAllParamInit(qtInitExpParam));
        Object initDataExt = qtInitExpParam.getInitDataExt();
        if (initDataExt != null) {
            this.initParams.put("QT_EXT_PARAM", initDataExt);
        }
    }

    protected Map<String, Object> loadInitParams(List<QuotaParamInitializer> initialises) throws QuotaException, InterruptedException {
        if (CollectionUtils.isEmpty(initialises)) {
            LogUtils.warning((Log)this.log, (ErrorCode)TieEngineErrorCodes.getNonParamInitializer(), (Object[])new Object[0]);
            this.alarm(QuotaMsgLevel.WARNING, TieEngineErrorCodes.getNonParamInitializer(), new Object[0]);
            return Collections.emptyMap();
        }
        QuotaRequest tieRequest = this.getRequest();
        LocalDate initStartDate = tieRequest.getStartDate();
        LocalDate initEndDate = tieRequest.getEndDate();
        List<AttPersonRange> attSubjects = this.rangeChecker.getAttSubjects();
        if (QTAccountModeHelper.isDeductChain((String)this.request.getAccountMode())) {
            HashSet<Long> requestFileBos = new HashSet<Long>(this.request.getAttFileBoids());
            Iterator<AttPersonRange> subjectIterator = attSubjects.iterator();
            List removeBoList = WTCCollections.modifiableEmptyList();
            while (subjectIterator.hasNext()) {
                AttPersonRange subject = subjectIterator.next();
                Iterator<AttFileInfo> fileBoIterator = subject.getAttFileInfoList().iterator();
                while (fileBoIterator.hasNext()) {
                    AttFileInfo fileBo = fileBoIterator.next();
                    if (requestFileBos.contains(fileBo.getAttFileBaseBoId())) continue;
                    removeBoList.add(fileBo.getAttFileBaseBoId());
                    fileBoIterator.remove();
                }
                if (!subject.getAttFileInfoList().isEmpty()) continue;
                subjectIterator.remove();
            }
            if (WTCCollections.isNotEmpty((Collection)removeBoList)) {
                this.log.info("deduct chain remove extra fileBo:{}", (Object)removeBoList);
            }
        }
        Date minStartDate = attSubjects.stream().map(item -> item.getAttFileInfoList().stream().map(AttFileInfo::getStartDate).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).sorted(Comparator.comparing(Date::getTime)).findFirst().get();
        Date maxEndDate = attSubjects.stream().map(item -> item.getAttFileInfoList().stream().map(AttFileInfo::getEndDate).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().get();
        initStartDate = initStartDate == null ? WTCDateUtils.toLocalDate((Date)minStartDate) : WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinDate((Date)WTCDateUtils.toDate((LocalDate)initStartDate), (Date)minStartDate));
        initEndDate = initEndDate == null ? WTCDateUtils.toLocalDate((Date)maxEndDate) : WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxDate((Date)WTCDateUtils.toDate((LocalDate)initEndDate), (Date)maxEndDate));
        WTCAssert.nonNull((Object)initStartDate, (String)"initStartDate");
        WTCAssert.nonNull((Object)initEndDate, (String)"initEndDate");
        Tuple<LocalDate, LocalDate> initDateRange = this.judgeInitRange(initStartDate.plusDays(-2L), initEndDate.plusDays(2L));
        initStartDate = (LocalDate)initDateRange.getKey();
        initEndDate = (LocalDate)initDateRange.getValue();
        QuotaInitParamRequest initRequest = new QuotaInitParamRequest(tieRequest.getAttPersonIds(), initStartDate, initEndDate, tieRequest, attSubjects);
        initRequest.putInitParams(this.initParams);
        String initializerTags = initialises.stream().map(initializer -> initializer.category() + "->" + initializer.getClass().getName()).collect(Collectors.joining(","));
        this.log.debug("Trying to load params between [{},{}] with those initialises: {}", new Object[]{initStartDate, initEndDate, initializerTags});
        return this.loadInitParams(initialises, initRequest);
    }

    private Tuple<LocalDate, LocalDate> judgeInitRange(LocalDate initStartDate, LocalDate initEndDate) {
        if (!QTAccountModeHelper.isDeductChain((String)this.getRequest().getAccountMode())) {
            return new Tuple((Object)initStartDate, (Object)initEndDate);
        }
        DeductEnv deductEnv = (DeductEnv)this.initParams.get("QT_DEDUCT_CHAIN_EVN");
        if (deductEnv == null) {
            return new Tuple((Object)initStartDate, (Object)initEndDate);
        }
        LocalDate minLineStartDate = WTCDateUtils.toLocalDate((Date)deductEnv.getMinLineStartDate());
        LocalDate maxLineEndDate = WTCDateUtils.toLocalDate((Date)deductEnv.getMaxLineEndDate());
        if (minLineStartDate != null && minLineStartDate.isBefore(initStartDate)) {
            initStartDate = minLineStartDate;
        }
        if (maxLineEndDate != null && maxLineEndDate.isAfter(initEndDate)) {
            initEndDate = maxLineEndDate;
        }
        this.log.info("AbstractQuotaEngine expand initRange for QTDeductChain, initRange:[{}, {}]", (Object)initStartDate, (Object)initEndDate);
        return new Tuple((Object)initStartDate, (Object)initEndDate);
    }

    protected abstract Map<String, Object> loadInitParams(List<QuotaParamInitializer> var1, QuotaInitParamRequest var2) throws InterruptedException, QuotaException;

    protected void checkArgs() {
        Assert.nonNull((Object)this.request, (String)"tieRequest");
        Assert.nonNull((Object)this.rangeChecker, (String)"rangeChecker");
        Assert.nonNull(this.dataPackageRouterFactory, (String)"dataPackageRouterFactory");
        Assert.nonNull((Object)this.exporter, (String)"tieExporter");
        Assert.nonNull(this.dataNodeWrapper, (String)"dataNodeWrapper");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
    }

    protected QuotaLine<T> makeLine(AttPersonRange attSubject) {
        IQuotaLineExporter alarm = this.exporter.newLineExporter(attSubject);
        QuotaDataPackageRouter<T> dataPackageRouter = this.dataPackageRouterFactory.create();
        dataPackageRouter.setInitParams(this.initParams);
        dataPackageRouter.setQuotaRequest(this.request);
        dataPackageRouter.setAttSubject(attSubject);
        QuotaLine line = (QuotaLine)WTCAppContextHelper.getBean(QuotaLineDefault.class);
        line.setDataPackageRouter(dataPackageRouter);
        line.setEngineVariable(this.engineVariable);
        line.setLineExporter(alarm);
        line.setQuotaRequest(this.request);
        line.setDataNodeWrapper(this.dataNodeWrapper);
        line.setIdService(this.idService);
        line.setStepExecutorUnitFactory(this.stepExecutorUnitFactory);
        line.setInitParams(Collections.unmodifiableMap(this.initParams));
        line.setValidatorExecutor(this.validatorExecutor);
        line.setQuotaSchemeService(this.tieSchemeService);
        this.dealAttSubjectNew(attSubject);
        line.setAttSubject(attSubject);
        line.setRequestContext(this.getRequestContext());
        return line;
    }

    protected void dealAttSubject(AttPersonRange attSubject) {
        AttRecordDetailHolder holder = (AttRecordDetailHolder)this.initParams.get("QT_ATT_RECORD_DETAIL");
        Map<String, QuotaCycInfo> holderMap = holder.getCycSetMap();
        if (holderMap != null && !holderMap.isEmpty()) {
            HashMap typeHolderMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Long dyQuotaId : this.request.getDyQtTypeIds()) {
                if (null == holderMap.get(attSubject.getPersonId() + "_" + dyQuotaId)) continue;
                typeHolderMap.put(dyQuotaId, holderMap.get(attSubject.getPersonId() + "_" + dyQuotaId));
            }
            for (Long reqQTtypeId : this.request.getRegQtTypeIds()) {
                if (null == holderMap.get(attSubject.getPersonId() + "_" + reqQTtypeId)) continue;
                typeHolderMap.put(reqQTtypeId, holderMap.get(attSubject.getPersonId() + "_" + reqQTtypeId));
            }
            attSubject.setTypeCircleMap(typeHolderMap);
        }
    }

    protected void dealAttSubjectNew(AttPersonRange attSubject) {
        AttRecordDetailHolder holder = (AttRecordDetailHolder)this.initParams.get("QT_ATT_RECORD_DETAIL");
        Map<String, QuotaCycInfo> holderMap = holder.getCycSetMap();
        if (holderMap != null && !holderMap.isEmpty()) {
            for (AttFileInfo attFileInfo : attSubject.getAttFileInfoList()) {
                this.setTypeCircleMap(attFileInfo, holderMap);
            }
            if (attSubject.getPreAttFileInfo() != null) {
                this.setTypeCircleMap(attSubject.getPreAttFileInfo(), holderMap);
            }
            if (attSubject.getNextAttFileInfo() != null) {
                this.setTypeCircleMap(attSubject.getNextAttFileInfo(), holderMap);
            }
        }
        this.dealPreOrNextIndexForFileBo(attSubject);
    }

    private void setTypeCircleMap(AttFileInfo attFileInfo, Map<String, QuotaCycInfo> holderMap) {
        HashMap typeHolderMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Long dyQuotaId : this.request.getDyQtTypeIds()) {
            if (null == holderMap.get(attFileInfo.getAttFileBaseBoId() + "_" + dyQuotaId)) continue;
            typeHolderMap.put(dyQuotaId, holderMap.get(attFileInfo.getAttFileBaseBoId() + "_" + dyQuotaId));
        }
        for (Long reqQTtypeId : this.request.getRegQtTypeIds()) {
            if (null == holderMap.get(attFileInfo.getAttFileBaseBoId() + "_" + reqQTtypeId)) continue;
            typeHolderMap.put(reqQTtypeId, holderMap.get(attFileInfo.getAttFileBaseBoId() + "_" + reqQTtypeId));
        }
        attFileInfo.setTypeCircleMap(typeHolderMap);
    }

    private void processCircleForFileBo(AttFileInfo attFileInfo, Map<Long, Map<Long, Tuple<CircleRestVo, CircleRestVo>>> map) {
        Map<Long, QuotaCycInfo> typeCircleMap = attFileInfo.getTypeCircleMap();
        if (CollectionUtils.isEmpty(typeCircleMap)) {
            return;
        }
        for (Map.Entry<Long, QuotaCycInfo> quotaCycInfoEntry : typeCircleMap.entrySet()) {
            List filteredRestVos;
            Long quotaTypeId = quotaCycInfoEntry.getKey();
            QuotaCycInfo quotaCycInfo = quotaCycInfoEntry.getValue();
            List<CircleRestVo> restVos = quotaCycInfo.getRestVos();
            if (CollectionUtils.isEmpty(restVos) || CollectionUtils.isEmpty(filteredRestVos = restVos.stream().filter(circleRestVo -> WTCDateUtils.hasIntersectionLCRC((Date)attFileInfo.getStartDate(), (Date)attFileInfo.getEndDate(), (Date)circleRestVo.getStartDate(), (Date)circleRestVo.getEndDate())).collect(Collectors.toList()))) continue;
            CircleRestVo firstCircleRestVo = (CircleRestVo)filteredRestVos.get(0);
            CircleRestVo lastCircleRestVo = (CircleRestVo)filteredRestVos.get(filteredRestVos.size() - 1);
            Tuple tuple = new Tuple((Object)firstCircleRestVo, (Object)lastCircleRestVo);
            Map<Long, Tuple<CircleRestVo, CircleRestVo>> longTupleMap = map.get(quotaTypeId);
            if (longTupleMap == null) {
                longTupleMap = new HashMap<Long, Tuple<CircleRestVo, CircleRestVo>>();
            }
            longTupleMap.put(attFileInfo.getAttFileBaseBoId(), (Tuple<CircleRestVo, CircleRestVo>)tuple);
            map.put(quotaTypeId, longTupleMap);
        }
    }

    protected void dealPreOrNextIndexForFileBo(AttPersonRange attPersonRange) {
        List<AttFileInfo> attFileInfoList = attPersonRange.getAttFileInfoList();
        AttFileInfo preAttFileInfo = attPersonRange.getPreAttFileInfo();
        AttFileInfo nextAttFileInfo = attPersonRange.getNextAttFileInfo();
        HashMap nextFileBoMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<AttFileInfo> attFileInfoListAll = new ArrayList<AttFileInfo>();
        attFileInfoListAll.addAll(attFileInfoList);
        if (preAttFileInfo != null) {
            attFileInfoListAll.add(0, preAttFileInfo);
        }
        if (nextAttFileInfo != null) {
            attFileInfoListAll.add(nextAttFileInfo);
        }
        Map<Long, List<AttFileInfo>> empFileMap = attFileInfoListAll.stream().collect(Collectors.groupingBy(file -> file.getEmployeeId()));
        HashMap preFileBoMap = Maps.newHashMapWithExpectedSize((int)16);
        this.setPreNextFileBo(nextFileBoMap, preFileBoMap, empFileMap);
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (AttFileInfo attFileInfo : attFileInfoList) {
            this.processCircleForFileBo(attFileInfo, map);
        }
        if (preAttFileInfo != null) {
            this.processCircleForFileBo(preAttFileInfo, map);
        }
        for (AttFileInfo attFileInfo : attFileInfoList) {
            Long attFileBaseBoId = attFileInfo.getAttFileBaseBoId();
            Long nextAttFileBoId = (Long)nextFileBoMap.get(attFileBaseBoId);
            Long preAttFileBoId = (Long)preFileBoMap.get(attFileBaseBoId);
            if (CollectionUtils.isEmpty(attFileInfo.getTypeCircleMap())) continue;
            for (Map.Entry<Long, QuotaCycInfo> entry : attFileInfo.getTypeCircleMap().entrySet()) {
                List filteredRestVoList;
                QuotaCycInfo quotaCycInfo;
                List<CircleRestVo> restVos;
                Long quotaTypeId = entry.getKey();
                Map longTupleMap = (Map)map.get(quotaTypeId);
                if (longTupleMap == null || longTupleMap.size() == 0 || CollectionUtils.isEmpty(restVos = (quotaCycInfo = entry.getValue()).getRestVos()) || CollectionUtils.isEmpty(filteredRestVoList = restVos.stream().filter(vo -> WTCDateUtils.hasIntersectionLCRC((Date)attFileInfo.getStartDate(), (Date)attFileInfo.getEndDate(), (Date)vo.getStartDate(), (Date)vo.getEndDate())).collect(Collectors.toList()))) continue;
                CircleRestVo lastCircleRestVo = (CircleRestVo)filteredRestVoList.get(filteredRestVoList.size() - 1);
                if (nextAttFileBoId != null && nextAttFileBoId != 0L) {
                    Tuple nextTuple = (Tuple)longTupleMap.get(nextAttFileBoId);
                    if (nextTuple != null) {
                        lastCircleRestVo.setNextCycSetId(((CircleRestVo)nextTuple.getKey()).getCycSetId());
                        lastCircleRestVo.setNextIndex(((CircleRestVo)nextTuple.getKey()).getIndex());
                    }
                    lastCircleRestVo.setNextAttFileBoId(nextAttFileBoId);
                }
                CircleRestVo firstCircleRestVo = (CircleRestVo)filteredRestVoList.get(0);
                if (preAttFileBoId == null || preAttFileBoId == 0L) continue;
                Tuple preTuple = (Tuple)longTupleMap.get(preAttFileBoId);
                if (preTuple != null) {
                    firstCircleRestVo.setPreCycSetId(((CircleRestVo)preTuple.getValue()).getCycSetId());
                    firstCircleRestVo.setPreIndex(((CircleRestVo)preTuple.getValue()).getIndex());
                }
                firstCircleRestVo.setPreAttFileBoId(preAttFileBoId);
            }
        }
    }

    private void setPreNextFileBo(Map<Long, Long> nextFileBoMap, Map<Long, Long> preFileBoMap, Map<Long, List<AttFileInfo>> empFileMap) {
        if (WTCCollections.isEmpty(empFileMap)) {
            return;
        }
        for (Map.Entry<Long, List<AttFileInfo>> entry : empFileMap.entrySet()) {
            int i;
            List<AttFileInfo> fileInfos = entry.getValue();
            if (WTCCollections.isEmpty(fileInfos)) continue;
            List fileBoIdList = fileInfos.stream().map(AttFileInfo::getAttFileBaseBoId).distinct().collect(Collectors.toList());
            for (i = 0; i < fileBoIdList.size(); ++i) {
                nextFileBoMap.put((Long)fileBoIdList.get(i), i >= fileBoIdList.size() - 1 ? null : (Long)fileBoIdList.get(i + 1));
            }
            for (i = fileBoIdList.size() - 1; i >= 0; --i) {
                preFileBoMap.put((Long)fileBoIdList.get(i), i <= 0 ? null : (Long)fileBoIdList.get(i - 1));
            }
        }
    }

    @Override
    protected void stateChanged(QuotaState oldState, QuotaState newState) {
        this.exporter.stateChanged(oldState, newState);
        if (newState.isTerminating()) {
            if (this.exporter instanceof QuotaTerminable) {
                ((QuotaTerminable)((Object)this.exporter)).terminate();
            }
            this.terminateRunningLines();
            this.terminateRunningInitializer();
        } else if (newState.isDone() && this.engineCompletedCallback != null) {
            this.engineCompletedCallback.completedCallback(new QuotaEngineCallbackEvent(null, this));
        }
    }

    protected abstract void terminateRunningLines();

    protected abstract void terminateRunningInitializer();

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.exporter.alarm(msgLevel, msg);
    }

    @Override
    public void setRequest(QuotaRequest request) {
        this.request = request;
    }

    @Override
    public void setDataPackageRouterFactory(QuotaDataPackageRouterFactory<T> dataPackageRouterFactory) {
        this.dataPackageRouterFactory = dataPackageRouterFactory;
    }

    @Override
    public void setExporter(IQuotaExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public void setCompletedCallback(QuotaEngineCompletedCallback terminatedCallback) {
        this.engineCompletedCallback = terminatedCallback;
    }

    public QuotaRequest getRequest() {
        return this.request;
    }

    @Override
    public IQuotaExporter getExporter() {
        return this.exporter;
    }

    public Map<String, Object> getEngineVariable() {
        return this.engineVariable;
    }

    @Override
    public void setInitialises(List<List<QuotaParamInitializer>> initialises) {
        this.initialises = initialises;
    }

    @Override
    public void setRangeChecker(QuotaRangeChecker rangeChecker) {
        this.rangeChecker = rangeChecker;
    }

    @Override
    protected String getRunnerTag() {
        return this.request.getVersion() + ".T." + this.request.getTaskId();
    }

    @Override
    public void setDataNodeWrapper(QuotaDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public void setIdService(QuotaIdService idService) {
        this.idService = idService;
    }

    @Override
    public void setStepExecutorUnitFactory(QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public QuotaValidatorExecutor getValidatorExecutor() {
        return this.validatorExecutor;
    }

    @Override
    public void setValidatorExecutor(QuotaValidatorExecutor validatorExecutor) {
        this.validatorExecutor = validatorExecutor;
    }

    @Override
    protected void validate() throws WtesException {
        super.validate();
        this.validatorExecutor.validateParams(this.request, this.engineVariable, this.initParams);
    }

    @Override
    public QuotaRequest getQuotaRequest() {
        return this.request;
    }

    @Override
    public void setQuotaSchemeService(ITieSchemeService tieSchemeService) {
        this.tieSchemeService = tieSchemeService;
    }

    @Override
    public List<AttPersonRange> getAttSubjects() {
        return WTCCollections.unmodifiableList(this.attSubjects);
    }

    @Override
    public Map<Long, LocalDate> getLastQuotaDateMap() {
        return this.exporter.getLastQuotaDateMap();
    }

    @Override
    public Map<Long, LocalDate> getErrorDateMap() {
        return this.exporter.getErrorDateMap();
    }

    protected void addDataPackageReportNode(QuotaLine<T> currentLine) {
        QuotaDataPackageRouter<T> dataPackageRouter = currentLine.getDataPackageRouter();
        if (dataPackageRouter != null) {
            Map<String, Object> spanData = dataPackageRouter.getSpanData();
            try (Span dataPackageSpan = TaskTracer.newSpan((String)((String)spanData.get("spanName")));){
                dataPackageSpan.startTime(WTCDateUtils.toLocalDateTime((Date)new Date((Long)spanData.get("startTime"))));
                dataPackageSpan.durationInMills(((Long)spanData.get("duration")).longValue());
                dataPackageSpan.info(TieReportKDStrings.DATA_PACKAGE_COMMITTED.loadKDString(), () -> String.valueOf(spanData.get("committedNum")));
            }
        }
    }

    protected void reportProcess(int total, int finishedLine) {
        try {
            int processLimit;
            if (total == finishedLine) {
                WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)this.request.getSubTaskId(), (int)100);
            }
            if ((processLimit = total / 16) < 5) {
                processLimit = 5;
            }
            if (finishedLine % processLimit == 0) {
                WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)this.request.getSubTaskId(), (int)(finishedLine / total));
            }
        }
        catch (Exception e) {
            this.log.warn("[QUOTA] reportProgress error,total={},finishedLine={}", new Object[]{total, finishedLine, e});
        }
    }

    protected void waitStoreFinished() {
        QuotaRequest request = this.getRequest();
        String version = request.getVersion();
        int shardingIndex = request.getShardingIndex();
        QuotaDataPackageStoreManager instance = QuotaDataPackageStoreManager.getInstance();
        QuotaVersionDataPackageStore versionDataPackageStore = instance.getVersionDataPackageStore(version, shardingIndex);
        List<Future<DataPackageStoreResult>> storeResult = versionDataPackageStore.getStoreResult();
        String key = RequestContext.get().getAccountId() + '_' + version + '_' + shardingIndex;
        this.log.debug("waitStoreFinished storeResult key {} num {}", (Object)key, (Object)storeResult.size());
        try {
            int failSize = 0;
            StringBuilder failMsg = new StringBuilder();
            for (Future<DataPackageStoreResult> future : storeResult) {
                DataPackageStoreResult dataPackageStoreResult = future.get();
                if (dataPackageStoreResult.isSuccess()) continue;
                this.exporter.updateSubErrorResult(dataPackageStoreResult.getAttPersonIds(), ResManager.loadKDString((String)"\u6838\u7b97\u8f6c\u50a8\u8282\u70b9\u5f02\u5e38\u3002", (String)"AbstractQuotaEngine_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
                ++failSize;
                failMsg.append(dataPackageStoreResult.getFailMsg());
            }
            if (failSize != 0) {
                throw new KDBizException(new ErrorCode("500", failMsg.toString()), new Object[0]);
            }
        }
        catch (Exception ex) {
            this.log.warn("store fail", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", "to store is fail"), new Object[0]);
        }
    }

    protected void storeLastDataPackage() {
        QuotaDataPackageStoreManager dataPackageStoreManager = QuotaDataPackageStoreManager.getInstance();
        QuotaRequest tieRequest = this.getQuotaRequest();
        dataPackageStoreManager.storeImmediately(tieRequest.getVersion(), tieRequest.getShardingIndex());
    }
}

