/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactory;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactoryDefault;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeWrapper;
import kd.wtc.wtes.business.quota.drouter.QuotaDataPackageRouterFactory;
import kd.wtc.wtes.business.quota.drouter.QuotaDataPackageRouterFactoryStd;
import kd.wtc.wtes.business.quota.engine.IQuotaEngineConfig;
import kd.wtc.wtes.business.quota.engine.QuotaEngineCompletedCallback;
import kd.wtc.wtes.business.quota.engine.QuotaRangeChecker;
import kd.wtc.wtes.business.quota.exporter.QuotaExporterStdImpl;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.service.IQuotaExporter;
import kd.wtc.wtes.business.quota.service.QuotaIdService;
import kd.wtc.wtes.business.quota.service.QuotaIdServiceMemory;
import kd.wtc.wtes.business.quota.service.QuotaRangerBuilder;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeWrapperStd;
import kd.wtc.wtes.business.service.impl.TiePlanServiceImpl;

public class QuotaEngineConfigImpl {
    public static final IQuotaEngineConfig DEFAULT = new QuotaEngineConfigInner();

    private static class QuotaEngineConfigInner
    implements IQuotaEngineConfig {
        private QuotaEngineConfigInner() {
        }

        @Override
        public IQuotaExporter getExporter() {
            return (IQuotaExporter)WTCAppContextHelper.getBean(QuotaExporterStdImpl.class);
        }

        @Override
        public ITieSchemeService getQuotaSchemeService() {
            return (ITieSchemeService)WTCAppContextHelper.getBean(TiePlanServiceImpl.class);
        }

        @Override
        public QuotaDataPackageRouterFactory<QuotaDataNodeStd> getDataPackageRouterFactory() {
            return (QuotaDataPackageRouterFactory)WTCAppContextHelper.getBean(QuotaDataPackageRouterFactoryStd.class);
        }

        @Override
        public QuotaRangeChecker getRangeChecker() {
            return (QuotaRangeChecker)WTCAppContextHelper.getBean(QuotaRangerBuilder.class);
        }

        @Override
        public List<QuotaEngineCompletedCallback> getCompletedCallbackList() {
            Object initialises = WTCAppContextHelper.getProjectParams().get("quota.init.callBackList");
            if (initialises == null) {
                return Collections.emptyList();
            }
            List initializerList = (List)initialises;
            return initializerList.stream().map(initializerBeanName -> (QuotaEngineCompletedCallback)WTCAppContextHelper.getBean((String)initializerBeanName, QuotaEngineCompletedCallback.class)).collect(Collectors.toList());
        }

        @Override
        public List<List<QuotaParamInitializer>> getInitialises() {
            Object initialises = WTCAppContextHelper.getProjectParams().get("quota.init.initialises");
            if (initialises == null) {
                return Collections.emptyList();
            }
            List initializerList = (List)initialises;
            ArrayList<List<QuotaParamInitializer>> initialisesLists = new ArrayList<List<QuotaParamInitializer>>(16);
            initializerList.forEach(list -> initialisesLists.add(list.stream().map(initializerBeanName -> (QuotaParamInitializer)WTCAppContextHelper.getBean((String)initializerBeanName, QuotaParamInitializer.class)).collect(Collectors.toList())));
            return initialisesLists;
        }

        @Override
        public QuotaDataNodeWrapper<QuotaDataNodeStd> getDataNodeWrapper() {
            return (QuotaDataNodeWrapper)WTCAppContextHelper.getBean(QuotaDataNodeWrapperStd.class);
        }

        @Override
        public QuotaIdService getIdService() {
            return (QuotaIdService)WTCAppContextHelper.getBean(QuotaIdServiceMemory.class);
        }

        @Override
        public QuotaStepExecutorUnitFactory<QuotaDataNodeStd> getStepExecutorUnitFactory() {
            return (QuotaStepExecutorUnitFactory)WTCAppContextHelper.getBean(QuotaStepExecutorUnitFactoryDefault.class);
        }
    }
}

