/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.sdk.wtc.wtbs.common.model.Extendable;
import kd.sdk.wtc.wtes.business.qte.QteRequest;
import kd.sdk.wtc.wtes.business.qte.init.AfterQteParamInitEvent;
import kd.sdk.wtc.wtes.business.qte.init.QteParamInitExtPlugin;
import kd.sdk.wtc.wtes.business.qte.init.QteParamInitRequest;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.common.enums.InitVariableEnum;

class QuotaParamInitExecutor
implements Callable<Tuple<String, QuotaInitParamResult>> {
    private final QuotaParamInitializer initializer;
    private final QuotaInitParamRequest initRequest;
    private static final Log log = WTCLogFactory.getLog(QuotaParamInitExecutor.class);

    public QuotaParamInitExecutor(QuotaParamInitializer initializer, QuotaInitParamRequest initRequest) {
        this.initializer = initializer;
        this.initRequest = initRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Tuple<String, QuotaInitParamResult> call() {
        Throwable throwable = null;
        try (Span initSpan = TaskTracer.newSpan((String)InitVariableEnum.getNamefromCode((String)this.initializer.category()));){
            QuotaInitParamResult finalInitResult;
            QuotaExtPluginHolder extPluginHolder;
            initSpan.info(CalcReportConstants.PARAM_CODE, this.initializer::category);
            Date start = new Date();
            QuotaInitParamResult initResult = null;
            try {
                initResult = this.initializer.init(this.initRequest);
                if (initResult.getInitData() instanceof Extendable && (extPluginHolder = (QuotaExtPluginHolder)this.initRequest.getInitParams().get("QT_EXT_PLUGIN")) != null) {
                    WTCPluginProxy extProxy = (WTCPluginProxy)extPluginHolder.getPlugin(QteParamInitExtPlugin.class.getName());
                    this.afterInit((WTCPluginProxy<QteParamInitExtPlugin>)extProxy, this.initRequest, (Extendable)initResult.getInitData(), this.initializer.category());
                }
                extPluginHolder = new Tuple((Object)this.initializer.category(), (Object)initResult);
                finalInitResult = initResult;
            }
            catch (QuotaParamInitException e) {
                Tuple tuple;
                block21: {
                    block22: {
                        tuple = new Tuple((Object)this.initializer.category(), (Object)QuotaInitParamResult.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, e.getMessage())));
                        QuotaInitParamResult finalInitResult2 = initResult;
                        initSpan.debug(CalcReportConstants.INIT_RESULT, () -> null != finalInitResult2 ? JSON.toJSONString((Object)finalInitResult2.getInitData()) : ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"QuotaParamInitExecutor_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                        long elapsed = System.currentTimeMillis() - start.getTime();
                        log.debug("#Quota# [Initializer {}] [Tag {}] [Elapsed {}] #Quota#", new Object[]{this.initializer.getClass().getName(), this.initializer.category(), elapsed});
                        if (initSpan == null) break block21;
                        if (throwable == null) break block22;
                        try {
                            initSpan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block21;
                    }
                    initSpan.close();
                }
                return tuple;
                {
                    catch (Throwable throwable3) {
                        try {
                            QuotaInitParamResult finalInitResult3 = initResult;
                            initSpan.debug(CalcReportConstants.INIT_RESULT, () -> null != finalInitResult2 ? JSON.toJSONString((Object)finalInitResult2.getInitData()) : ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"QuotaParamInitExecutor_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                            long elapsed = System.currentTimeMillis() - start.getTime();
                            log.debug("#Quota# [Initializer {}] [Tag {}] [Elapsed {}] #Quota#", new Object[]{this.initializer.getClass().getName(), this.initializer.category(), elapsed});
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                }
            }
            initSpan.debug(CalcReportConstants.INIT_RESULT, () -> null != finalInitResult2 ? JSON.toJSONString((Object)finalInitResult2.getInitData()) : ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"QuotaParamInitExecutor_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            long elapsed = System.currentTimeMillis() - start.getTime();
            log.debug("#Quota# [Initializer {}] [Tag {}] [Elapsed {}] #Quota#", new Object[]{this.initializer.getClass().getName(), this.initializer.category(), elapsed});
            return extPluginHolder;
        }
    }

    private void afterInit(WTCPluginProxy<QteParamInitExtPlugin> extProxy, QuotaInitParamRequest initRequest, Extendable currentInitData, String category) {
        QteParamInitRequest initParamReq = new QteParamInitRequest(initRequest.getAttPersonIds(), initRequest.getStartDate(), initRequest.getEndDate(), (QteRequest)initRequest.getRequest());
        AfterQteParamInitEvent extParam = new AfterQteParamInitEvent(category, (Object)currentInitData, initParamReq, Collections.unmodifiableMap(initRequest.getInitParams()));
        extProxy.invokeReplace(instance -> instance.afterParamInit(extParam));
    }
}

