/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryAdjustTable;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCarryDownTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOverDrawTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTVestDayEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailAdjustUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTCarryOverAdjustEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTCarryOverAdjustEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverAdjustEvaluator not found dataNodes"));
        }
        LinkedList<QuotaDataNode> quotaDataNodeList = new LinkedList<QuotaDataNode>();
        List<QuotaAttItemValueStd> quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        ArrayList<QuotaAttItemValueStd> availableStds = new ArrayList<QuotaAttItemValueStd>(4);
        ArrayList<QuotaAttItemValueStd> overdStds = new ArrayList<QuotaAttItemValueStd>(4);
        HashMap<Long, List<QuotaAttItemValueStd>> overdStdsMap = new HashMap(4);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        for (QuotaAttItemValueStd node : quotaAttStds) {
            QuotaAttItemInstance instance = node.getAttItemInstance();
            QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == instance.getQtDetailId().longValue()).findFirst().orElse(null);
            if (this.isNeedAvailableStds(node, qtLineDetail)) {
                availableStds.add(node);
            }
            if (null == instance || null == instance.getQuotaAttItemType() || instance.getQuotaAttItemType() != QuotaAttItemType.OVERDRAWN || !node.isLeaf() || qtLineDetail == null || QuotaAttItemStatus.of(qtLineDetail.getBusstatus()) != QuotaAttItemStatus.EFFECT) continue;
            overdStds.add(node);
        }
        if (!CollectionUtils.isEmpty(overdStds)) {
            overdStdsMap = overdStds.stream().collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
        }
        Map<Long, List<QuotaAttItemValueStd>> canBeOdStdMap = quotaAttStds.stream().filter(std -> std.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.OVERDRAW_AVAILABLE && std.isLeaf()).collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
        if (CollectionUtils.isEmpty(availableStds)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverAdjustEvaluator not found available AttItemInstance");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverAdjustEvaluator not found available AttItemInstance"));
        }
        Date departDate = QuotaContextUtil.getDepartDate(context);
        Date sysDate = WTCDateUtils.getDayBegin();
        if (departDate != null && departDate.before(sysDate)) {
            sysDate = departDate;
        }
        HashMap<Long, List<QTDetailCarryAdjust>> matchQTDetailAdjusts = new HashMap<Long, List<QTDetailCarryAdjust>>();
        this.matchQtDetailAdjust(context, matchQTDetailAdjusts, availableStds, quotaAttStds);
        if (WTCCollections.isEmpty(matchQTDetailAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverAdjustEvaluator not match QTDetailCarryAdjust");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverAdjustEvaluator not match QTDetailCarryAdjust"));
        }
        for (QuotaAttItemValueStd attItemValueStd : availableStds) {
            QTDetailCarryAdjust qtDetailCarryAdjust;
            String message;
            List qtDetailCarryAdjusts;
            QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
            Date expireDate = WTCDateUtils.addDays((Date)instance.getUseEndDate(), (int)1);
            if (this.misCondition(expireDate, sysDate, instance)) continue;
            QuotaAttItemValueStd canBeOdStd = null;
            if (canBeOdStdMap != null && !CollectionUtils.isEmpty((Collection)canBeOdStdMap.get(instance.getQtDetailId()))) {
                canBeOdStd = canBeOdStdMap.get(instance.getQtDetailId()).get(0);
            }
            if (CollectionUtils.isEmpty((Collection)(qtDetailCarryAdjusts = (List)matchQTDetailAdjusts.get(instance.getQtDetailId()))) || !HRStringUtils.isNotEmpty((String)(message = this.processCarryOver(attItemValueStd, canBeOdStd, quotaDataNodeList, context, overdStdsMap, qtDetailCarryAdjust = (QTDetailCarryAdjust)qtDetailCarryAdjusts.get(0))))) continue;
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.ERROR, message));
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private boolean isNeedAvailableStds(QuotaAttItemValueStd node, QTLineDetail qtLineDetail) {
        QuotaAttItemInstance instance = node.getAttItemInstance();
        if (null == instance || qtLineDetail == null) {
            return false;
        }
        if (instance.getQuotaAttItemType() != QuotaAttItemType.AVAILABLE || !node.isLeaf()) {
            return false;
        }
        if (instance.getSource() != QuotaDetailType.CUR_PERIOD_GEN && instance.getSource() != QuotaDetailType.MANUAL_GIVE && instance.getSource() != QuotaDetailType.BO_SETTLEMENT) {
            return false;
        }
        return QuotaAttItemStatus.of(qtLineDetail.getBusstatus()) == QuotaAttItemStatus.EFFECT;
    }

    private boolean misCondition(Date expireDate, Date sysDate, QuotaAttItemInstance instance) {
        if (expireDate == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverAdjustEvaluator not found expireDate:[{}],instanceId:[{}]", (Object)instance.getUseEndDate(), (Object)instance.getQtDetailId());
            }
            return true;
        }
        expireDate = WTCDateUtils.getZeroDate((Date)expireDate);
        if (sysDate.getTime() < expireDate.getTime()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverAdjustEvaluator not expireDate");
            }
            return true;
        }
        return false;
    }

    private void matchQtDetailAdjust(QuotaContextStd context, Map<Long, List<QTDetailCarryAdjust>> matchQTDetailAdjusts, List<QuotaAttItemValueStd> availableStds, List<QuotaAttItemValueStd> quotaAttStds) {
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        QTDetailCarryAdjustTable qtDetailCarryAdjustTable = context.getInitParamMust("QT_DETAIL_CARRY_AJ", QTDetailCarryAdjustTable.class);
        List<QTDetailCarryAdjust> qtDetailCarryAdjusts = qtDetailCarryAdjustTable.getQtDetailCarryAdjustByBid(attFileModel.getBid());
        if (WTCCollections.isEmpty(qtDetailCarryAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDetailAdjustEvaluator not found QTDetailCarryAdjust");
            }
            return;
        }
        List<QuotaAttItemValueStd> starAttStds = quotaAttStds.stream().filter(dt -> QuotaAttItemType.STANDARD == dt.getAttItemInstance().getQuotaAttItemType() && dt.isLeaf()).collect(Collectors.toList());
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        QuotaDetailAdjustUtils.matchQtDetailAdjust(matchQTDetailAdjusts, qtDetailCarryAdjusts, availableStds, starAttStds, qtDetails);
    }

    private String processCarryOver(QuotaAttItemValueStd attItemValueStd, QuotaAttItemValueStd canBeOdStd, List<QuotaDataNode> quotaDataNodeList, QuotaContextStd contextStd, Map<Long, List<QuotaAttItemValueStd>> overdStdsMap, QTDetailCarryAdjust carryDownAdjust) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        QTCalRule qtCalRule = (QTCalRule)attItemValueStd.getMatchedRule();
        QTDetailCarryDown carryDown = carryDownAdjust.getQtDetailCarryDown();
        if (carryDown == null) {
            LOG.warn("QTDetailAdjustEvaluator not found carryDown version");
            return ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u5b9a\u989d\u660e\u7ec6\u7ed3\u8f6c\u8c03\u6574\u3002", (String)"QTCarryOverEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("QTDetailAdjustEvaluator availableInstance type[{}],value[{}],detailId[{}]", new Object[]{instance.getSource(), instance.getItemValue(), instance.getQtDetailId()});
        }
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)instance.getQttypeId(), (long)instance.getPeriodcircleId(), (long)instance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        QuotaAttItemInstance expireInstance = null;
        QuotaAttItemInstance carryInstance = null;
        long qtDetailId = instance.getQtDetailId();
        if (QTCarryDownTypeEnum.QT_INVALID == carryDown.getCarryDownMethod() || instance.getSource() == QuotaDetailType.PRE_PERIOD_CARRY_DOWN) {
            AttItemSpec expireAttItemSpec;
            long expireAttItemId;
            long l = expireAttItemId = QTCarryDownTypeEnum.QT_INVALID == carryDown.getCarryDownMethod() ? carryDown.getPassDurationAttItem() : carryDown.getCarryDownAttItem();
            if (instance.getSource() == QuotaDetailType.PRE_PERIOD_CARRY_DOWN && expireAttItemId == 0L) {
                QTUnitEnum qtUnitEnum = AttitemUnitEnum.DAY == instance.getUntil() ? QTUnitEnum.DAY : QTUnitEnum.HOUR;
                expireAttItemId = QuotaContextUtil.getQTDefaultItem(qtUnitEnum);
            }
            if (null == (expireAttItemSpec = attItemSpecData.getByBidAndDate(expireAttItemId, contextStd.getChainDate()))) {
                LOG.warn("QTDetailAdjustEvaluator not found expireAttItemSpec");
                return ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5b9a\u989d\u7c7b\u578b\u7684\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]);
            }
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, instance.getItemValue(), AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        } else if (QTCarryDownTypeEnum.QT_TO_NEXT == carryDown.getCarryDownMethod()) {
            QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == qtDetailId).findFirst().get();
            if (qtLineDetail == null || BigDecimal.ZERO.compareTo(qtLineDetail.getUsableValue()) > 0) {
                return null;
            }
            CircleRestVo circleRestVo = contextStd.getCircleRestVo();
            List list = (List)contextStd.getVariable("circleRestVoList", VScope.LINE);
            int index = list.indexOf(circleRestVo);
            if (Objects.equals(index, list.size() - 1)) {
                LOG.info("QTDetailAdjustEvaluator not found next CircleRestVo");
                return null;
            }
            CircleRestVo nextCircle = (CircleRestVo)list.get(index + 1);
            Map<String, Date> dateMap = this.getUseDate(carryDown, instance);
            Date useStartDate = dateMap.get("start");
            Date useEndDate = dateMap.get("end");
            if (useEndDate.before(useStartDate)) {
                return String.format(ResManager.loadKDString((String)"%1$s\u5b9a\u989d\u660e\u7ec6\u7ed3\u8f6c\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u660e\u7ec6\u7ed3\u8f6c\u201d\u3002", (String)"QTCarryOverAdjustEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]), attFileModel.getNumber());
            }
            AttItemSpec expireAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCarryDownAttItem(), contextStd.getChainDate());
            AttItemSpec carryAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCdDuration(), contextStd.getChainDate());
            if (QTOverDrawTypeEnum.OVER_FIX == carryDown.getCarryType()) {
                Map<String, QuotaAttItemInstance> fixMap = this.overDrawByFix(carryDown, instance, qtDetailId, expireAttItemSpec, carryAttItemSpec, nextCircle);
                expireInstance = fixMap.get("expireInstance");
                carryInstance = fixMap.get("carryInstance");
            } else {
                long roundRuleId = 0L;
                if (qtCalRule != null) {
                    QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(instance.getOrgEndDay());
                    roundRuleId = null != qtGenConfig.getQtGenCfEntryByDetail(qtDetailId) ? qtGenConfig.getQtGenCfEntryByDetail(qtDetailId).getRoundRule() : 0L;
                }
                BigDecimal carryAmount = instance.getItemValue().multiply(carryDown.getPercentValue()).multiply(BigDecimal.valueOf(0.01));
                BigDecimal carryRoundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, carryAmount);
                carryRoundResult = carryRoundResult.setScale(6, RoundingMode.HALF_UP);
                carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryRoundResult, AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
                BigDecimal expirePercent = BigDecimal.ONE.subtract(carryDown.getPercentValue().multiply(BigDecimal.valueOf(0.01)));
                BigDecimal expireAmount = instance.getItemValue().multiply(expirePercent);
                BigDecimal expireRoundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, expireAmount);
                expireRoundResult = expireRoundResult.setScale(6, RoundingMode.HALF_UP);
                expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, expireRoundResult, AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            }
            QuotaAttItemValue carryAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(carryInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDownAdjust.getId(), "wtte_qtdetailcarryaj"))).build();
            carryAttItemValue.getAttItemInstance().setGenStartDate(instance.getGenStartDate());
            carryAttItemValue.getAttItemInstance().setGenEndDate(instance.getGenEndDate());
            carryAttItemValue.getAttItemInstance().setUseStartDate(useStartDate);
            carryAttItemValue.getAttItemInstance().setUseEndDate(useEndDate);
            carryAttItemValue.getAttItemInstance().setOrgEndDay(instance.getOrgEndDay());
            carryAttItemValue.getAttItemInstance().setAttFileBoId(instance.getAttFileBoId());
            carryAttItemValue.getAttItemInstance().setAttFileVId(instance.getAttFileVId());
            quotaDataNodeList.add(carryAttItemValue);
        } else if (QTCarryDownTypeEnum.QT_TO_BUSINESS == carryDown.getCarryDownMethod()) {
            this.carryToBusiness(carryDown, contextStd, attItemValueStd, attItemSpecData, overdStdsMap, quotaDataNodeList, carryDownAdjust.getId());
        }
        if (expireInstance != null) {
            QuotaAttItemValue expireAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(expireInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDownAdjust.getId(), "wtte_qtdetailcarryaj"))).build();
            expireAttItemValue.getAttItemInstance().setGenStartDate(instance.getGenStartDate());
            expireAttItemValue.getAttItemInstance().setGenEndDate(instance.getGenEndDate());
            expireAttItemValue.getAttItemInstance().setUseStartDate(instance.getUseStartDate());
            expireAttItemValue.getAttItemInstance().setUseEndDate(instance.getUseEndDate());
            expireAttItemValue.getAttItemInstance().setOrgEndDay(instance.getOrgEndDay());
            expireAttItemValue.getAttItemInstance().setAttFileVId(instance.getAttFileVId());
            expireAttItemValue.getAttItemInstance().setAttFileBoId(instance.getAttFileBoId());
            quotaDataNodeList.add(expireAttItemValue);
        }
        QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, instance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)instance.getAttItemSpec().getUnit()), QuotaAttItemType.AVAILABLE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        stdInstance.setGenStartDate(instance.getGenStartDate());
        stdInstance.setGenEndDate(instance.getGenEndDate());
        stdInstance.setUseStartDate(instance.getUseStartDate());
        stdInstance.setUseEndDate(instance.getUseEndDate());
        stdInstance.setOrgEndDay(instance.getOrgEndDay());
        stdInstance.setAttFileBoId(instance.getAttFileBoId());
        stdInstance.setAttFileVId(instance.getAttFileVId());
        QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(attItemValueStd.getMatchedRule())).parentDataNodes(Collections.singletonList(attItemValueStd))).evaluationRule(EvaluationRuleModel.of(carryDownAdjust.getId(), "wtte_qtdetailcarryaj"))).build();
        this.fillQtDetails(qtDetails, carryInstance, expireInstance, qtDetailId);
        quotaDataNodeList.add(quotaSdtAttItemValue);
        this.setCanBeOdValueIsZero(canBeOdStd, quotaDataNodeList, qtDetails, carryDownAdjust.getId());
        return null;
    }

    private void setCanBeOdValueIsZero(QuotaAttItemValueStd canBeOdStd, List<QuotaDataNode> quotaDataNodeList, List<QTLineDetail> qtDetails, Long id) {
        if (canBeOdStd != null && canBeOdStd.getAttItemInstance() != null) {
            QuotaAttItemInstance canBeOdInstance = canBeOdStd.getAttItemInstance();
            QuotaAttItemInstance canBeOdstdInstance = new QuotaAttItemInstance(canBeOdInstance.getQtDetailId(), canBeOdInstance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)canBeOdInstance.getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, canBeOdInstance.getSource(), canBeOdInstance.getQttypeId(), canBeOdInstance.getPeriodcircleId(), canBeOdInstance.getPeriodNum(), canBeOdInstance.getPeriodAttribtion());
            canBeOdstdInstance.setGenStartDate(canBeOdInstance.getGenStartDate());
            canBeOdstdInstance.setGenEndDate(canBeOdInstance.getGenEndDate());
            canBeOdstdInstance.setUseStartDate(canBeOdInstance.getUseStartDate());
            canBeOdstdInstance.setUseEndDate(canBeOdInstance.getUseEndDate());
            canBeOdstdInstance.setAttFileVId(canBeOdInstance.getAttFileVId());
            canBeOdstdInstance.setAttFileBoId(canBeOdInstance.getAttFileBoId());
            QuotaAttItemValue canBeOdSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(canBeOdstdInstance)).matchedRule(canBeOdStd.getMatchedRule())).parentDataNodes(Collections.singletonList(canBeOdStd))).evaluationRule(EvaluationRuleModel.of(id, "wtte_qtdetailcarryaj"))).build();
            quotaDataNodeList.add(canBeOdSdtAttItemValue);
            if (!CollectionUtils.isEmpty(qtDetails)) {
                qtDetails.forEach(qtLineDetail -> {
                    if (qtLineDetail.getBid() == canBeOdInstance.getQtDetailId().longValue()) {
                        qtLineDetail.setCdCanBeOdValue(qtLineDetail.getCanBeOdValue());
                        qtLineDetail.setCanBeOdValue(BigDecimal.ZERO);
                    }
                });
            }
        }
    }

    private Map<String, QuotaAttItemInstance> overDrawByFix(QTDetailCarryDown carryDown, QuotaAttItemInstance instance, long qtDetailId, AttItemSpec expireAttItemSpec, AttItemSpec carryAttItemSpec, CircleRestVo nextCircle) {
        QuotaAttItemInstance carryInstance;
        QuotaAttItemInstance expireInstance;
        if (carryDown.getFixValue().compareTo(instance.getItemValue()) > 0) {
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, BigDecimal.ZERO, AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, instance.getItemValue(), AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
        } else {
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, instance.getItemValue().subtract(carryDown.getFixValue()), AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryDown.getFixValue(), AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
        }
        HashMap<String, QuotaAttItemInstance> map = new HashMap<String, QuotaAttItemInstance>(4);
        map.put("expireInstance", expireInstance);
        map.put("carryInstance", carryInstance);
        return map;
    }

    private void fillQtDetails(List<QTLineDetail> qtDetails, QuotaAttItemInstance carryInstance, QuotaAttItemInstance expireInstance, long qtDetailId) {
        if (!CollectionUtils.isEmpty(qtDetails)) {
            QuotaAttItemInstance finalCarryInstance = carryInstance;
            QuotaAttItemInstance finalExpireInstance = expireInstance;
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId) {
                    if (finalCarryInstance != null) {
                        qtLineDetail.setCarryDownedValue(finalCarryInstance.getItemValue());
                        qtLineDetail.setCarryDownedStart(finalCarryInstance.getUseStartDate());
                        qtLineDetail.setCarryDownedend(finalCarryInstance.getUseEndDate());
                        qtLineDetail.setVestType(finalCarryInstance.getVestType());
                    }
                    if (finalExpireInstance != null) {
                        qtLineDetail.setPastValue(finalExpireInstance.getItemValue());
                    }
                    qtLineDetail.setUsableValue(BigDecimal.ZERO);
                }
            });
        }
    }

    private Map<String, Date> getUseDate(QTDetailCarryDown carryDown, QuotaAttItemInstance instance) {
        Date useEndDate;
        Date useStartDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryStartDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        Date date = useEndDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryEndDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        if (Boolean.TRUE.equals(carryDown.getStartDelay())) {
            useStartDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getStartFloatUnit() ? WTCDateUtils.addDays((Date)useStartDate, (int)carryDown.getsDelay()) : WTCDateUtils.add((Date)useStartDate, (int)2, (int)carryDown.getsDelay());
        }
        if (Boolean.TRUE.equals(carryDown.getEndDelay())) {
            useEndDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getEndFloatUnit() ? WTCDateUtils.addDays((Date)useEndDate, (int)carryDown.geteDelay()) : WTCDateUtils.add((Date)useEndDate, (int)2, (int)carryDown.geteDelay());
        }
        HashMap<String, Date> map = new HashMap<String, Date>(4);
        map.put("start", useStartDate);
        map.put("end", useEndDate);
        return map;
    }

    private void carryToBusiness(QTDetailCarryDown carryDown, QuotaContextStd contextStd, QuotaAttItemValueStd attItemValueStd, AttItemSpecData attItemSpecData, Map<Long, List<QuotaAttItemValueStd>> overdStdsMap, List<QuotaDataNode> quotaDataNodeList, Long id) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        if (instance == null) {
            return;
        }
        long qtDetailId = instance.getQtDetailId();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)instance.getQttypeId(), (long)instance.getPeriodcircleId(), (long)instance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        AttItemSpec carryAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCdDuration(), contextStd.getChainDate());
        if (QTVestDayEnum.QT_NEXT_GENG_STARTDAY == carryDown.getVestDay()) {
            CircleRestVo circleRestVo = contextStd.getCircleRestVo();
            Date startDate = instance.getUseEndDate();
            if (Boolean.TRUE.equals(carryDown.getVDDelay())) {
                startDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getVestDayFloatUnit() ? WTCDateUtils.addDays((Date)startDate, (int)carryDown.getVestDayDelay()) : WTCDateUtils.add((Date)startDate, (int)2, (int)carryDown.getVestDayDelay());
            }
            BigDecimal carryResult = instance.getItemValue() == null ? BigDecimal.ZERO : instance.getItemValue();
            List<QuotaAttItemValueStd> overds = overdStdsMap.get(qtDetailId);
            ArrayList<QuotaDataNodeStd> parentDataNodes = new ArrayList<QuotaDataNodeStd>();
            parentDataNodes.add(attItemValueStd);
            BigDecimal overValue = this.getOverValueAndGenAttiem(overds, qtDetailId, parentDataNodes, id, quotaDataNodeList);
            carryResult = carryResult.add(overValue);
            QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryResult, AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), circleRestVo.getIndex(), circleRestVo.getAssignDate());
            quotaAttItemInstance.setGenStartDate(instance.getGenStartDate());
            quotaAttItemInstance.setGenEndDate(instance.getGenEndDate());
            quotaAttItemInstance.setUseStartDate(instance.getUseEndDate());
            quotaAttItemInstance.setUseEndDate(startDate);
            quotaAttItemInstance.setVestDay(WTCDateUtils.getZeroDate((Date)startDate));
            quotaAttItemInstance.setVestType(VestTypeEnum.BUSINESS_AREA.getCode());
            quotaAttItemInstance.setOrgEndDay(instance.getOrgEndDay());
            quotaAttItemInstance.setAttFileBoId(instance.getAttFileBoId());
            quotaAttItemInstance.setAttFileVId(instance.getAttFileVId());
            QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).matchedRule(attItemValueStd.getMatchedRule())).parentDataNodes(parentDataNodes)).evaluationRule(EvaluationRuleModel.of(id, "wtte_qtdetailcarryaj"))).build();
            quotaDataNodeList.add(quotaSdtAttItemValue);
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId) {
                    qtLineDetail.setCarryDownedValue(quotaAttItemInstance.getItemValue());
                    qtLineDetail.setCarryDownedStart(quotaAttItemInstance.getUseStartDate());
                    qtLineDetail.setCarryDownedend(quotaAttItemInstance.getUseEndDate());
                    qtLineDetail.setVestType(quotaAttItemInstance.getVestType());
                    qtLineDetail.setUseOdValue(BigDecimal.ZERO);
                }
            });
        }
    }

    private BigDecimal getOverValueAndGenAttiem(List<QuotaAttItemValueStd> overds, Long qtDetailId, List<QuotaDataNodeStd> parentDataNodes, Long id, List<QuotaDataNode> quotaDataNodeList) {
        BigDecimal carryResult = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(overds)) {
            for (QuotaAttItemValueStd over : overds) {
                QuotaAttItemInstance overInstance = over.getAttItemInstance();
                BigDecimal overValue = overInstance.getItemValue();
                carryResult = carryResult.add(overValue.negate());
                QuotaAttItemInstance quotaOverInstance = new QuotaAttItemInstance(qtDetailId, overInstance.getAttItemSpec(), BigDecimal.ZERO, overInstance.getUntil(), overInstance.getQuotaAttItemType(), overInstance.getSource(), overInstance.getQttypeId(), overInstance.getPeriodcircleId(), overInstance.getPeriodNum(), overInstance.getPeriodAttribtion());
                quotaOverInstance.setAttFileVId(overInstance.getAttFileVId());
                quotaOverInstance.setAttFileBoId(overInstance.getAttFileBoId());
                quotaOverInstance.setGenStartDate(overInstance.getGenStartDate());
                quotaOverInstance.setGenEndDate(overInstance.getGenEndDate());
                quotaOverInstance.setUseEndDate(overInstance.getUseEndDate());
                quotaOverInstance.setUseStartDate(overInstance.getUseStartDate());
                QuotaAttItemValue quotaOverSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaOverInstance)).matchedRule(over.getMatchedRule())).parentDataNodes(Collections.singletonList(over))).evaluationRule(EvaluationRuleModel.of(id, "wtte_qtdetailcarryaj"))).build();
                quotaDataNodeList.add(quotaOverSdtAttItemValue);
                parentDataNodes.add(over);
            }
        }
        return carryResult;
    }
}

