/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtes.business.qte.executor.CarryDwonType;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailCarryDwon;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCarryDownTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCrossMangOrgEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOverDrawTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTVestDayEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTCaryyOverUtils;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaCrossManageOrgUtils;
import kd.wtc.wtes.business.quota.util.QuotaRuleConfigUtils;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTCarryOverEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTCarryOverEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd) {
        return this.doEvaluate(contextStd, contextStd.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd, List<QuotaDataNodeStd> dataNodes) {
        LinkedList<QuotaAttItemValue> quotaDataNodeList = new LinkedList<QuotaAttItemValue>();
        AttFileInfo attFileInfo = contextStd.getAttSubjectEntry().getCurrentChainAttFileInfo();
        if (attFileInfo == null) {
            LOG.warn("QTCarryOverEvaluator not found attFileInfo ");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverEvaluator not found attFileInfo"));
        }
        Long attFileBid = attFileInfo.getAttFileBaseBoId();
        QTPoolHolder qtPoolHolder = contextStd.getInitParamMust("QT_POOL", QTPoolHolder.class);
        QuotaRunTimeCache quotaRunTimeCache = (QuotaRunTimeCache)contextStd.getInitParam("QT_RUN_TIME_CACHE");
        QTRuntime qtRuntime = quotaRunTimeCache.getRunTimeByAttFileBoId(attFileBid);
        this.flushCrossCarryDownDetails(contextStd, attFileBid, qtRuntime);
        ArrayList<QuotaAttItemValueStd> quotaAttStds = CollectionUtils.isEmpty(dataNodes) ? new ArrayList<QuotaAttItemValueStd>() : dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        this.beforePeriodNumDetailSettlement(contextStd, quotaDataNodeList, quotaAttStds, attFileBid, qtPoolHolder, qtRuntime);
        if (CollectionUtils.isEmpty(dataNodes) && CollectionUtils.isNotEmpty(quotaDataNodeList)) {
            return QuotaDataResultStd.success(quotaDataNodeList);
        }
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverEvaluator not found dataNodes"));
        }
        List<Object> availableStds = new ArrayList<QuotaAttItemValueStd>(4);
        ArrayList<QuotaAttItemValueStd> overdStds = new ArrayList<QuotaAttItemValueStd>(4);
        HashMap<Long, List<QuotaAttItemValueStd>> overdStdsMap = new HashMap(4);
        QuotaAttItemValueStd firstInstance = quotaAttStds.stream().findFirst().orElse(null);
        if (firstInstance == null) {
            LOG.warn("QTCarryOverEvaluator not found dataNodes");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverEvaluator not found dataNodes"));
        }
        List<QTLineDetail> preDetails = qtPoolHolder.getQtPoolByFileBoId(attFileBid, contextStd.getCircleRestVo().getIndex(), contextStd.getQuotaTypeId());
        List settleMentList = preDetails.stream().filter(qtLineDetail -> qtLineDetail.getBusstatus().equals("0")).filter(qtLineDetail -> qtLineDetail.isSettlement()).collect(Collectors.toList());
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        List<QTLineDetail> qtDetails = QuotaContextUtil.getLineDetail(contextStd);
        HashSet<Long> carryOverAj = new HashSet<Long>();
        for (QuotaAttItemValueStd node : quotaAttStds) {
            QuotaAttItemInstance instance = node.getAttItemInstance();
            QTLineDetail qtLineDetail2 = qtDetails.stream().filter(qt -> qt.getBid() == instance.getQtDetailId().longValue()).findFirst().orElse(null);
            if (this.isNeedAvailableStds(node, qtLineDetail2)) {
                availableStds.add(node);
            }
            if (null != instance && null != instance.getQuotaAttItemType() && instance.getQuotaAttItemType() == QuotaAttItemType.OVERDRAWN && node.isLeaf() && qtLineDetail2 != null && QuotaAttItemStatus.of(qtLineDetail2.getBusstatus()) == QuotaAttItemStatus.EFFECT) {
                overdStds.add(node);
            }
            if (!this.carryHasOccured(node, qtLineDetail2)) continue;
            carryOverAj.add(instance.getQtDetailId());
        }
        if (!CollectionUtils.isEmpty(overdStds)) {
            overdStdsMap = overdStds.stream().collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
        }
        Map<Long, List<QuotaAttItemValueStd>> canBeOdStdMap = quotaAttStds.stream().filter(std -> std.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.OVERDRAW_AVAILABLE && std.isLeaf()).collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
        if (CollectionUtils.isEmpty(availableStds)) {
            LOG.warn("QTCarryOverEvaluator not found available AttItemInstance");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverEvaluator not found available AttItemInstance"));
        }
        Date departDate = QuotaContextUtil.getDepartDate(contextStd);
        availableStds = availableStds.stream().sorted(Comparator.comparing(dt -> dt.getAttItemInstance().getUseEndDate())).collect(Collectors.toList());
        boolean isCrossBo = this.isCrossBo(contextStd);
        boolean isCurNumSettlement = this.isSettlemetBo(contextStd);
        for (QuotaAttItemValueStd quotaAttItemValueStd : availableStds) {
            boolean isDepart = false;
            Date sysDate = WTCDateUtils.getDayBegin();
            if (departDate != null && departDate.before(sysDate)) {
                sysDate = departDate;
                isDepart = true;
            }
            QuotaAttItemInstance instance = quotaAttItemValueStd.getAttItemInstance();
            QTLineDetail qtLineDetail3 = preDetails.stream().filter(qt -> qt.getBid() == instance.getQtDetailId().longValue()).findFirst().orElse(null);
            QTLineDetail cacheLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == instance.getQtDetailId().longValue()).findFirst().orElse(null);
            QTCalRule qtCalRule = (QTCalRule)quotaAttItemValueStd.getMatchedRule();
            if (qtCalRule == null || qtCalRule.getCarryDown() == null) {
                LOG.warn("QTCarryOverEvaluator not found qtCalRule");
                String message = ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u7ed3\u8f6c\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
                return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.ERROR, message));
            }
            boolean isPreNumSettlement = false;
            if (isCurNumSettlement) {
                sysDate = WTCDateUtils.toDate((LocalDate)contextStd.getChainDate());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Settlement is true");
                }
            } else if (!isCrossBo && qtLineDetail3 != null && !isDepart) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("old qtLineDetail {}", (Object)JSON.toJSONString((Object)qtLineDetail3));
                }
                isPreNumSettlement = qtLineDetail3.isSettlement();
            } else if (!isCrossBo && instance.isCross() && !CollectionUtils.isEmpty(settleMentList) && !isDepart) {
                isPreNumSettlement = true;
            }
            if (cacheLineDetail != null) {
                cacheLineDetail.setSettlement(Boolean.FALSE.booleanValue());
            }
            if (isPreNumSettlement && !isDepart) {
                sysDate = attFileModel.getEndDateTime();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("sysDate {}", (Object)WTCDateUtils.date2Str((Date)departDate, (String)"yyyy.MM.dd"));
            }
            Date expireDate = WTCDateUtils.addDays((Date)instance.getUseEndDate(), (int)1);
            QuotaAttItemValueStd canBeOdStd = null;
            if (canBeOdStdMap != null && !CollectionUtils.isEmpty((Collection)canBeOdStdMap.get(instance.getQtDetailId()))) {
                canBeOdStd = canBeOdStdMap.get(instance.getQtDetailId()).get(0);
            }
            if (this.misCondition(expireDate, sysDate, instance, carryOverAj)) {
                if (!isCurNumSettlement && !isPreNumSettlement || instance.getSource() == QuotaDetailType.INIT_PRE_PERIOD_CARRY_DOWN) continue;
                QuotaCrossManageOrgUtils.genSettlement(quotaAttItemValueStd, quotaDataNodeList, contextStd, canBeOdStd);
                continue;
            }
            if (WTCDateUtils.getDayBegin().getTime() < expireDate.getTime()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(" transfer occurred before the transfer date  qtLineDetail {}", (Object)JSON.toJSONString((Object)qtLineDetail3));
                continue;
            }
            String message = this.processCarryOver(quotaAttItemValueStd, canBeOdStd, quotaDataNodeList, contextStd, overdStdsMap, availableStds);
            if (!HRStringUtils.isNotEmpty((String)message)) continue;
            throw new KDBizException(message);
        }
        QteGenExtPluginUtils.afterDoEvalua(contextStd, quotaDataNodeList, "carrydown", QTCarryOverEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private boolean isCrossBo(QuotaContextStd contextStd) {
        Long nextAttFileBoId = contextStd.getCircleRestVo().getNextAttFileBoId();
        return nextAttFileBoId != null && nextAttFileBoId != 0L;
    }

    private boolean isSettlemetBo(QuotaContextStd contextStd) {
        if (this.isCrossBo(contextStd)) {
            Date departDate = QuotaContextUtil.getDepartDate(contextStd);
            QTGenConfig nextGenConfig = this.getNextBoQtGenConfig(contextStd, departDate);
            return this.isSettlementnextBo(nextGenConfig, contextStd.getQuotaTypeId());
        }
        return false;
    }

    private void beforePeriodNumDetailSettlement(QuotaContextStd contextStd, List<QuotaAttItemValue> quotaDataNodeList, List<QuotaAttItemValueStd> dataNodes, Long attFileBid, QTPoolHolder qtPoolHolder, QTRuntime qtRuntime) {
        Long nextAttFileBoId = contextStd.getCircleRestVo().getNextAttFileBoId();
        if (nextAttFileBoId == null || nextAttFileBoId == 0L) {
            return;
        }
        List<QTLineDetail> berforPeriodNumDetails = QuotaContextUtil.getBeforeCurPeriodNum(contextStd, attFileBid, contextStd.getCircleRestVo().getIndex(), contextStd.getQuotaTypeId(), contextStd.getCircleRestVo().getCycSetId());
        List berforPeriodNumsettleMentList = berforPeriodNumDetails.stream().filter(qtLineDetail -> qtLineDetail.getBusstatus().equals("0")).filter(qtLineDetail -> qtLineDetail.isSettlement()).collect(Collectors.toList());
        if (this.isSettlemetBo(contextStd)) {
            QTCalRule matchCalRule = null;
            QTGenConfigEntry qtGenConfigEntry = null;
            if (!CollectionUtils.isEmpty(dataNodes)) {
                matchCalRule = (QTCalRule)dataNodes.get(0).getMatchedRule();
                QTGenConfig qtGenConfig = (QTGenConfig)matchCalRule.getGenConfig().getVersionByDate(dataNodes.get(0).getAttItemInstance().getOrgEndDay());
                qtGenConfigEntry = qtGenConfig.getQtGenCfEntryByDetail(dataNodes.get(0).getAttItemInstance().getQtDetailId());
            } else {
                int periodNum = contextStd.getCircleRestVo().getIndex();
                long cycSet = contextStd.getCircleRestVo().getCycSetId();
                String key = DetailLogicKey.getIndexKey((long)attFileBid, (long)contextStd.getQuotaTypeId(), (long)cycSet, (long)periodNum);
                String rule = "rule" + key;
                String configEntry = "configEntry" + key;
                matchCalRule = (QTCalRule)contextStd.getVariable(rule, VScope.LINE);
                qtGenConfigEntry = (QTGenConfigEntry)contextStd.getVariable(configEntry, VScope.LINE);
            }
            ArrayList needUpdateDetails = Lists.newArrayListWithCapacity((int)berforPeriodNumsettleMentList.size());
            for (QTLineDetail qtLineDetail2 : berforPeriodNumDetails) {
                Date expireDate = WTCDateUtils.getZeroDate((Date)qtLineDetail2.getUseEndDate());
                Date calculateDate = WTCDateUtils.toDate((LocalDate)contextStd.getChainDate());
                if (calculateDate.compareTo(expireDate) > 0 || QuotaDetailType.of(qtLineDetail2.getSource()) == QuotaDetailType.INIT_PRE_PERIOD_CARRY_DOWN) continue;
                QuotaCrossManageOrgUtils.genSettlement(qtLineDetail2, quotaDataNodeList, contextStd, matchCalRule, needUpdateDetails, qtGenConfigEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("need update details {}", (Object)JSON.toJSONString((Object)needUpdateDetails));
            }
            qtRuntime.plusPoolAndMarkDirty((Collection)needUpdateDetails);
            String settlementKey = QuotaContextUtil.getSettlementKey(attFileBid, contextStd.getQuotaTypeId());
            contextStd.setVariable(settlementKey, needUpdateDetails, VScope.LINE);
        } else {
            berforPeriodNumsettleMentList.stream().forEach(qt -> qt.setSettlement(Boolean.FALSE.booleanValue()));
            qtRuntime.plusPoolAndMarkDirty(berforPeriodNumsettleMentList);
        }
    }

    private void flushCrossCarryDownDetails(QuotaContextStd contextStd, Long attFileBid, QTRuntime qtRuntime) {
        String corssCarryDownKey = QuotaContextUtil.getCrossCarryDwon(attFileBid, contextStd.getQuotaTypeId(), contextStd.getCircleRestVo().getIndex());
        List corssCarryDowns = (List)contextStd.getVariable(corssCarryDownKey, VScope.LINE);
        if (CollectionUtils.isNotEmpty((Collection)corssCarryDowns)) {
            qtRuntime.plusPoolAndMarkDirty((Collection)corssCarryDowns);
        }
    }

    private QTGenConfig getNextBoQtGenConfig(QuotaContextStd contextStd, Date departDate) {
        AttFileModel attFileModel;
        AttFileCabinet attFileCabinet = contextStd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        List<AttFileInfo> attFileInfos = contextStd.getAttSubjectEntry().getAttFileInfoList();
        Long nextAttFileBoId = contextStd.getCircleRestVo().getNextAttFileBoId();
        Date endDate = null;
        for (AttFileInfo attFileInfo : attFileInfos) {
            if (nextAttFileBoId == null || !nextAttFileBoId.equals(attFileInfo.getAttFileBaseBoId())) continue;
            endDate = attFileInfo.getEndDate();
            break;
        }
        if (endDate == null) {
            return null;
        }
        LocalDate endLocalDate = WTCDateUtils.toLocalDate(endDate);
        WTCDateUtils.toDate((LocalDate)endLocalDate);
        if (departDate != null && departDate.before(endDate)) {
            endLocalDate = WTCDateUtils.toLocalDate((Date)departDate);
        }
        if ((attFileModel = attFileCabinet.getByAttPersonIdAndDate(contextStd.getAttPersonId(), endLocalDate, nextAttFileBoId)) == null) {
            return null;
        }
        QTScheme qtScheme = attFileModel.getAttQtPackage(endLocalDate);
        if (qtScheme == null) {
            return null;
        }
        QTRule qtRule = QuotaRuleConfigUtils.getRuleConfig(contextStd, qtScheme, endLocalDate);
        if (qtRule == null) {
            return null;
        }
        List<QTCalRule> qtCalRules = qtRule.getQtRules();
        if (WTCCollections.isEmpty(qtCalRules)) {
            return null;
        }
        QTCalRule qtCalRule = this.getQTCalRule(qtCalRules, contextStd, endLocalDate);
        if (qtCalRule == null) {
            return null;
        }
        return (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(endLocalDate);
    }

    private QTCalRule getQTCalRule(List<QTCalRule> qtCalRules, QuotaContextStd contextstd, LocalDate endDate) {
        if (CollectionUtils.isEmpty(qtCalRules)) {
            return null;
        }
        for (QTCalRule qtCalRule : qtCalRules) {
            QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(endDate);
            if (!contextstd.getQuotaTypeId().equals(genConfig.getQtType().getId())) continue;
            return qtCalRule;
        }
        return null;
    }

    private boolean isSettlementnextBo(QTGenConfig genConfig, long curQtTypleId) {
        if (genConfig == null) {
            return false;
        }
        return QTCrossMangOrgEnum.CROSS_CARYY_DOWN.type.equals(genConfig.getCrossMangOrg());
    }

    private boolean isNeedAvailableStds(QuotaAttItemValueStd node, QTLineDetail qtLineDetail) {
        QuotaAttItemInstance instance = node.getAttItemInstance();
        if (null == instance || qtLineDetail == null) {
            return false;
        }
        if (instance.getQuotaAttItemType() != QuotaAttItemType.AVAILABLE || !node.isLeaf()) {
            return false;
        }
        return QuotaAttItemStatus.of(qtLineDetail.getBusstatus()) == QuotaAttItemStatus.EFFECT;
    }

    private boolean misCondition(Date expireDate, Date sysDate, QuotaAttItemInstance instance, Set<Long> carryOverAj) {
        if (expireDate == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverEvaluator not found expireDate:[{}],instanceId:[{}]", (Object)instance.getUseEndDate(), (Object)instance.getQtDetailId());
            }
            return true;
        }
        expireDate = WTCDateUtils.getZeroDate((Date)expireDate);
        if (sysDate.getTime() < expireDate.getTime()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverEvaluator not expireDate");
            }
            return true;
        }
        return carryOverAj.contains(instance.getQtDetailId());
    }

    private boolean carryHasOccured(QuotaAttItemValueStd node, QTLineDetail qtLineDetail) {
        QuotaAttItemInstance instance = node.getAttItemInstance();
        if (null == instance || qtLineDetail == null) {
            return false;
        }
        if (instance.getQuotaAttItemType() != QuotaAttItemType.CARRYDOWN_DURATION && instance.getQuotaAttItemType() != QuotaAttItemType.CARRYDOWN_EXPIRE) {
            return false;
        }
        if (!node.isLeaf()) {
            return false;
        }
        return QuotaAttItemStatus.of(qtLineDetail.getBusstatus()) == QuotaAttItemStatus.EFFECT;
    }

    private String processCarryOver(QuotaAttItemValueStd attItemValueStd, QuotaAttItemValueStd canBeOdStd, List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd contextStd, Map<Long, List<QuotaAttItemValueStd>> overdStdsMap, List<QuotaAttItemValueStd> availableStds) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        QTCalRule qtCalRule = (QTCalRule)attItemValueStd.getMatchedRule();
        if (qtCalRule == null || qtCalRule.getCarryDown() == null) {
            LOG.warn("QTCarryOverEvaluator not found qtCalRule");
            return ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u7ed3\u8f6c\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
        }
        QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(instance.getOrgEndDay());
        if (carryDown == null) {
            LOG.warn("QTCarryOverEvaluator not found carryDown version");
            return ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u7ed3\u8f6c\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("QTCarryOverEvaluator availableInstance type[{}],value[{}],detailId[{}]", new Object[]{instance.getSource(), instance.getItemValue(), instance.getQtDetailId()});
        }
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)instance.getQttypeId(), (long)instance.getPeriodcircleId(), (long)instance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        QuotaAttItemInstance expireInstance = null;
        QuotaAttItemInstance carryInstance = null;
        long qtDetailId = instance.getQtDetailId();
        if (this.isLoseEff(carryDown, instance)) {
            AttItemSpec expireAttItemSpec;
            long expireAttItemId;
            long l = expireAttItemId = QTCarryDownTypeEnum.QT_INVALID == carryDown.getCarryDownMethod() ? carryDown.getPassDurationAttItem() : carryDown.getCarryDownAttItem();
            if (instance.getSource() == QuotaDetailType.PRE_PERIOD_CARRY_DOWN && expireAttItemId == 0L) {
                QTUnitEnum qtUnitEnum = AttitemUnitEnum.DAY == instance.getUntil() ? QTUnitEnum.DAY : QTUnitEnum.HOUR;
                expireAttItemId = QuotaContextUtil.getQTDefaultItem(qtUnitEnum);
            }
            if (null == (expireAttItemSpec = attItemSpecData.getByBidAndDate(expireAttItemId, contextStd.getChainDate()))) {
                LOG.error("QTCarryOverEvaluator not found expireAttItemSpec");
                return ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5b9a\u989d\u7c7b\u578b\u7684\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]);
            }
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, instance.getItemValue(), AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        } else if (QTCarryDownTypeEnum.QT_TO_NEXT == carryDown.getCarryDownMethod()) {
            QTCaryyOverUtils.carryToNextOffset(carryDown, qtDetails, attItemValueStd, quotaDataNodeList, availableStds);
            QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == qtDetailId).findFirst().get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverEvaluator value {}", (Object)qtLineDetail.getUsableValue());
            }
            if (qtLineDetail == null || BigDecimal.ZERO.compareTo(qtLineDetail.getUsableValue()) > 0) {
                return null;
            }
            CircleRestVo circleRestVo = contextStd.getCircleRestVo();
            List list = (List)contextStd.getVariable("circleRestVoList", VScope.LINE);
            int index = list.indexOf(circleRestVo);
            if (Objects.equals(index, list.size() - 1)) {
                LOG.info("QTCarryOverEvaluator not found next CircleRestVo");
                return null;
            }
            CircleRestVo nextCircle = (CircleRestVo)list.get(index + 1);
            Map<String, Date> dateMap = this.getUseDate(carryDown, instance);
            Date useStartDate = dateMap.get("start");
            Date useEndDate = dateMap.get("end");
            if (useEndDate.before(useStartDate)) {
                return String.format(ResManager.loadKDString((String)"%1$s\u5b9a\u989d\u7ed3\u8f6c\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u7ed3\u8f6c\u914d\u7f6e\u201d\u3002", (String)"QTCarryOverEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]), attFileModel.getNumber());
            }
            AttItemSpec expireAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCarryDownAttItem(), contextStd.getChainDate());
            AttItemSpec carryAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCdDuration(), contextStd.getChainDate());
            if (QTOverDrawTypeEnum.OVER_FIX == carryDown.getCarryType()) {
                Map<String, QuotaAttItemInstance> fixMap = this.overDrawByFix(carryDown, instance, qtDetailId, expireAttItemSpec, carryAttItemSpec, nextCircle);
                expireInstance = fixMap.get("expireInstance");
                carryInstance = fixMap.get("carryInstance");
            } else {
                QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(contextStd.getChainDate());
                long roundRuleId = null != qtGenConfig.getQtGenCfEntryByDetail(qtDetailId) ? qtGenConfig.getQtGenCfEntryByDetail(qtDetailId).getRoundRule() : 0L;
                BigDecimal carryAmount = instance.getItemValue().multiply(carryDown.getPercentValue()).multiply(BigDecimal.valueOf(0.01));
                BigDecimal carryRoundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, carryAmount);
                carryRoundResult = carryRoundResult.setScale(6, RoundingMode.HALF_UP);
                carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryRoundResult, AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
                BigDecimal expirePercent = BigDecimal.ONE.subtract(carryDown.getPercentValue().multiply(BigDecimal.valueOf(0.01)));
                BigDecimal expireAmount = instance.getItemValue().multiply(expirePercent);
                BigDecimal expireRoundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, expireAmount);
                expireRoundResult = expireRoundResult.setScale(6, RoundingMode.HALF_UP);
                expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, expireRoundResult, AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            }
            QuotaAttItemValue carryAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(carryInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            carryAttItemValue.getAttItemInstance().setGenStartDate(instance.getGenStartDate());
            carryAttItemValue.getAttItemInstance().setGenEndDate(instance.getGenEndDate());
            carryAttItemValue.getAttItemInstance().setUseStartDate(useStartDate);
            carryAttItemValue.getAttItemInstance().setUseEndDate(useEndDate);
            carryAttItemValue.getAttItemInstance().setOrgEndDay(instance.getOrgEndDay());
            carryAttItemValue.getAttItemInstance().setAttFileVId(instance.getAttFileVId());
            carryAttItemValue.getAttItemInstance().setAttFileBoId(instance.getAttFileBoId());
            quotaDataNodeList.add(carryAttItemValue);
        } else if (QTCarryDownTypeEnum.QT_TO_BUSINESS == carryDown.getCarryDownMethod()) {
            this.carryToBusiness(carryDown, contextStd, attItemValueStd, attItemSpecData, overdStdsMap, quotaDataNodeList);
        }
        if (expireInstance != null) {
            QuotaAttItemValue expireAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(expireInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            expireAttItemValue.getAttItemInstance().setGenStartDate(instance.getGenStartDate());
            expireAttItemValue.getAttItemInstance().setGenEndDate(instance.getGenEndDate());
            expireAttItemValue.getAttItemInstance().setUseStartDate(instance.getUseStartDate());
            expireAttItemValue.getAttItemInstance().setUseEndDate(instance.getUseEndDate());
            expireAttItemValue.getAttItemInstance().setOrgEndDay(instance.getOrgEndDay());
            expireAttItemValue.getAttItemInstance().setAttFileBoId(instance.getAttFileBoId());
            expireAttItemValue.getAttItemInstance().setAttFileVId(instance.getAttFileVId());
            quotaDataNodeList.add(expireAttItemValue);
        }
        QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, instance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)instance.getAttItemSpec().getUnit()), QuotaAttItemType.AVAILABLE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        stdInstance.setGenStartDate(instance.getGenStartDate());
        stdInstance.setGenEndDate(instance.getGenEndDate());
        stdInstance.setUseStartDate(instance.getUseStartDate());
        stdInstance.setUseEndDate(instance.getUseEndDate());
        stdInstance.setOrgEndDay(instance.getOrgEndDay());
        stdInstance.setAttFileVId(instance.getAttFileVId());
        stdInstance.setAttFileBoId(instance.getAttFileBoId());
        QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(attItemValueStd.getMatchedRule())).parentDataNodes(Collections.singletonList(attItemValueStd))).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
        this.fillQtDetails(qtDetails, carryInstance, expireInstance, qtDetailId);
        quotaDataNodeList.add(quotaSdtAttItemValue);
        this.setCanBeOdValueIsZero(canBeOdStd, quotaDataNodeList, carryDown, qtDetails);
        return null;
    }

    private boolean isLoseEff(QTCarryDown carryDown, QuotaAttItemInstance instance) {
        if (QTCarryDownTypeEnum.QT_INVALID == carryDown.getCarryDownMethod()) {
            return true;
        }
        if (instance.getSource() == QuotaDetailType.PRE_PERIOD_CARRY_DOWN) {
            return true;
        }
        return instance.getSource() == QuotaDetailType.INIT_PRE_PERIOD_CARRY_DOWN && QTCarryDownTypeEnum.QT_TO_BUSINESS != carryDown.getCarryDownMethod();
    }

    private void setCanBeOdValueIsZero(QuotaAttItemValueStd canBeOdStd, List<QuotaAttItemValue> quotaDataNodeList, QTCarryDown carryDown, List<QTLineDetail> qtDetails) {
        if (canBeOdStd != null && canBeOdStd.getAttItemInstance() != null) {
            QuotaAttItemInstance canBeOdInstance = canBeOdStd.getAttItemInstance();
            QuotaAttItemInstance canBeOdstdInstance = new QuotaAttItemInstance(canBeOdInstance.getQtDetailId(), canBeOdInstance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)canBeOdInstance.getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, canBeOdInstance.getSource(), canBeOdInstance.getQttypeId(), canBeOdInstance.getPeriodcircleId(), canBeOdInstance.getPeriodNum(), canBeOdInstance.getPeriodAttribtion());
            canBeOdstdInstance.setGenStartDate(canBeOdInstance.getGenStartDate());
            canBeOdstdInstance.setGenEndDate(canBeOdInstance.getGenEndDate());
            canBeOdstdInstance.setUseStartDate(canBeOdInstance.getUseStartDate());
            canBeOdstdInstance.setUseEndDate(canBeOdInstance.getUseEndDate());
            canBeOdstdInstance.setAttFileBoId(canBeOdInstance.getAttFileBoId());
            canBeOdstdInstance.setAttFileVId(canBeOdInstance.getAttFileVId());
            QuotaAttItemValue canBeOdSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(canBeOdstdInstance)).matchedRule(canBeOdStd.getMatchedRule())).parentDataNodes(Collections.singletonList(canBeOdStd))).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            quotaDataNodeList.add(canBeOdSdtAttItemValue);
            if (!CollectionUtils.isEmpty(qtDetails)) {
                qtDetails.forEach(qtLineDetail -> {
                    if (qtLineDetail.getBid() == canBeOdInstance.getQtDetailId().longValue()) {
                        qtLineDetail.setCdCanBeOdValue(qtLineDetail.getCanBeOdValue());
                        qtLineDetail.setCanBeOdValue(BigDecimal.ZERO);
                    }
                });
            }
        }
    }

    private Map<String, QuotaAttItemInstance> overDrawByFix(QTCarryDown carryDown, QuotaAttItemInstance instance, long qtDetailId, AttItemSpec expireAttItemSpec, AttItemSpec carryAttItemSpec, CircleRestVo nextCircle) {
        QuotaAttItemInstance carryInstance;
        QuotaAttItemInstance expireInstance;
        if (carryDown.getFixValue().compareTo(instance.getItemValue()) > 0) {
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, BigDecimal.ZERO, AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, instance.getItemValue(), AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
        } else {
            expireInstance = new QuotaAttItemInstance(qtDetailId, expireAttItemSpec, instance.getItemValue().subtract(carryDown.getFixValue()), AttitemUnitEnum.of((String)expireAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_EXPIRE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
            carryInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryDown.getFixValue(), AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), nextCircle.getIndex(), nextCircle.getAssignDate());
        }
        HashMap<String, QuotaAttItemInstance> map = new HashMap<String, QuotaAttItemInstance>(4);
        map.put("expireInstance", expireInstance);
        map.put("carryInstance", carryInstance);
        return map;
    }

    private void fillQtDetails(List<QTLineDetail> qtDetails, QuotaAttItemInstance carryInstance, QuotaAttItemInstance expireInstance, long qtDetailId) {
        if (!CollectionUtils.isEmpty(qtDetails)) {
            QuotaAttItemInstance finalCarryInstance = carryInstance;
            QuotaAttItemInstance finalExpireInstance = expireInstance;
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId) {
                    if (finalCarryInstance != null) {
                        qtLineDetail.setCarryDownedValue(finalCarryInstance.getItemValue());
                    }
                    if (finalExpireInstance != null) {
                        qtLineDetail.setPastValue(finalExpireInstance.getItemValue());
                    }
                    qtLineDetail.setUsableValue(BigDecimal.ZERO);
                }
            });
        }
    }

    private Map<String, Date> getUseDate(QTCarryDown carryDown, QuotaAttItemInstance instance) {
        Date useEndDate;
        Date useStartDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryStartDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        Date date = useEndDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryEndDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        if (Boolean.TRUE.equals(carryDown.getStartDelay())) {
            useStartDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getStartFloatUnit() ? WTCDateUtils.addDays((Date)useStartDate, (int)carryDown.getsDelay()) : WTCDateUtils.add((Date)useStartDate, (int)2, (int)carryDown.getsDelay());
        }
        if (Boolean.TRUE.equals(carryDown.getEndDelay())) {
            useEndDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getEndFloatUnit() ? WTCDateUtils.addDays((Date)useEndDate, (int)carryDown.geteDelay()) : WTCDateUtils.add((Date)useEndDate, (int)2, (int)carryDown.geteDelay());
        }
        HashMap<String, Date> map = new HashMap<String, Date>(4);
        map.put("start", useStartDate);
        map.put("end", useEndDate);
        return map;
    }

    private void carryToBusiness(QTCarryDown carryDown, QuotaContextStd contextStd, QuotaAttItemValueStd attItemValueStd, AttItemSpecData attItemSpecData, Map<Long, List<QuotaAttItemValueStd>> overdStdsMap, List<QuotaAttItemValue> quotaDataNodeList) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        if (instance == null) {
            return;
        }
        long qtDetailId = instance.getQtDetailId();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)instance.getQttypeId(), (long)instance.getPeriodcircleId(), (long)instance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        AttItemSpec carryAttItemSpec = attItemSpecData.getByBidAndDate(carryDown.getCdDuration(), contextStd.getChainDate());
        if (QTVestDayEnum.QT_NEXT_GENG_STARTDAY == carryDown.getVestDay()) {
            CircleRestVo circleRestVo = contextStd.getCircleRestVo();
            Date startDate = instance.getUseEndDate();
            if (Boolean.TRUE.equals(carryDown.getVDDelay())) {
                startDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getVestDayFloatUnit() ? WTCDateUtils.addDays((Date)startDate, (int)carryDown.getVestDayDelay()) : WTCDateUtils.add((Date)startDate, (int)2, (int)carryDown.getVestDayDelay());
            }
            BigDecimal carryResult = instance.getItemValue();
            List<QuotaAttItemValueStd> overds = overdStdsMap.get(qtDetailId);
            ArrayList<QuotaDataNodeStd> parentDataNodes = new ArrayList<QuotaDataNodeStd>();
            parentDataNodes.add(attItemValueStd);
            BigDecimal overValue = this.getOverValueAndGenAttiem(overds, qtDetailId, parentDataNodes, carryDown.getId(), quotaDataNodeList);
            carryResult = carryResult.add(overValue);
            QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtDetailId, carryAttItemSpec, carryResult, AttitemUnitEnum.of((String)carryAttItemSpec.getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), circleRestVo.getIndex(), circleRestVo.getAssignDate());
            quotaAttItemInstance.setGenStartDate(instance.getGenStartDate());
            quotaAttItemInstance.setGenEndDate(instance.getGenEndDate());
            quotaAttItemInstance.setUseStartDate(instance.getUseEndDate());
            quotaAttItemInstance.setUseEndDate(startDate);
            quotaAttItemInstance.setVestDay(WTCDateUtils.getZeroDate((Date)startDate));
            quotaAttItemInstance.setVestType(VestTypeEnum.BUSINESS_AREA.getCode());
            quotaAttItemInstance.setOrgEndDay(instance.getOrgEndDay());
            quotaAttItemInstance.setAttFileBoId(instance.getAttFileBoId());
            quotaAttItemInstance.setAttFileVId(instance.getAttFileVId());
            QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).matchedRule(attItemValueStd.getMatchedRule())).parentDataNodes(parentDataNodes)).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            quotaDataNodeList.add(quotaSdtAttItemValue);
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId) {
                    qtLineDetail.setCarryDownedValue(quotaAttItemInstance.getItemValue());
                    qtLineDetail.setCarryDownedStart(quotaAttItemInstance.getUseStartDate());
                    qtLineDetail.setCarryDownedend(quotaAttItemInstance.getUseEndDate());
                    qtLineDetail.setVestType(quotaAttItemInstance.getVestType());
                    qtLineDetail.setUseOdValue(BigDecimal.ZERO);
                }
            });
        }
    }

    private BigDecimal getOverValueAndGenAttiem(List<QuotaAttItemValueStd> overds, Long qtDetailId, List<QuotaDataNodeStd> parentDataNodes, Long id, List<QuotaAttItemValue> quotaDataNodeList) {
        BigDecimal carryResult = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(overds)) {
            for (QuotaAttItemValueStd over : overds) {
                QuotaAttItemInstance overInstance = over.getAttItemInstance();
                BigDecimal overValue = overInstance.getItemValue();
                carryResult = carryResult.add(overValue.negate());
                QuotaAttItemInstance quotaOverInstance = new QuotaAttItemInstance(qtDetailId, overInstance.getAttItemSpec(), BigDecimal.ZERO, overInstance.getUntil(), overInstance.getQuotaAttItemType(), overInstance.getSource(), overInstance.getQttypeId(), overInstance.getPeriodcircleId(), overInstance.getPeriodNum(), overInstance.getPeriodAttribtion());
                quotaOverInstance.setGenStartDate(overInstance.getGenStartDate());
                quotaOverInstance.setGenEndDate(overInstance.getGenEndDate());
                quotaOverInstance.setUseEndDate(overInstance.getUseEndDate());
                quotaOverInstance.setUseStartDate(overInstance.getUseStartDate());
                QuotaAttItemValue quotaOverSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaOverInstance)).matchedRule(over.getMatchedRule())).parentDataNodes(Collections.singletonList(over))).evaluationRule(EvaluationRuleModel.of(id, "wtte_qtdetailcarryaj"))).build();
                quotaDataNodeList.add(quotaOverSdtAttItemValue);
                parentDataNodes.add(over);
            }
        }
        return carryResult;
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailCarryDwon quotaDetailCarryDwon = new QuotaDetailCarryDwon(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate, qtLineDetail.getInvalidValue(), qtLineDetail.getSettlementValue());
        if (VestTypeEnum.BUSINESS_AREA.getCode().equals(qtLineDetail.getVestType())) {
            quotaDetailCarryDwon.setCarryValue(qtLineDetail.getCarryDownedValue(), CarryDwonType.CARRY_TO_BUSINESS, Boolean.FALSE.booleanValue());
        } else {
            quotaDetailCarryDwon.setCarryValue(qtLineDetail.getCarryDownedValue(), null, Boolean.FALSE.booleanValue());
        }
        return quotaDetailCarryDwon;
    }
}

