/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover.detailadjust;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.executor.carryover.detailadjust.QTDetailAdjustEvaluator;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailAddData;
import kd.wtc.wtes.business.quota.model.QuotaDetailAddModel;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTUseDateGenUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailClearUtils;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTAddManualDetailEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTDetailAdjustEvaluator.class);
    private static final List<String> filterList = Lists.newArrayList((Object[])new String[]{QuotaDetailType.MANUAL_GIVE.getCode(), QuotaDetailType.INIT_PERIOD_GEN.getCode(), QuotaDetailType.INIT_PRE_PERIOD_CARRY_DOWN.getCode()});

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        List<QTLineDetail> curManualDetails;
        QTGenConfigEntry qtGenConfigEntry;
        QTCalRule qtCalRule;
        AttFileCabinet attFileCabinet;
        List<Object> quotaAttStds = new ArrayList(16);
        if (!CollectionUtils.isEmpty(dataNodes)) {
            quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
            quotaAttStds = quotaAttStds.stream().filter(dataNode -> dataNode.isLeaf() && QuotaAttItemType.DURATION_ENJOYMENT == dataNode.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        }
        if ((attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6863\u6848\u4fe1\u606f\u3002", (String)"QTAddManualDetailEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        CircleRestVo circleRestVo = context.getCircleRestVo();
        if (circleRestVo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u671f\u95f4\u5faa\u73af\u914d\u3002", (String)"QTPrePeriodDetailsEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        int periodNum = circleRestVo.getIndex();
        long cycSet = circleRestVo.getCycSetId();
        Long qtTypeId = context.getQuotaTypeId();
        LocalDate localDate = context.getChainDate();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)qtTypeId, (long)cycSet, (long)periodNum);
        QTGenConfig qtGenConfig = null;
        if (!CollectionUtils.isEmpty(dataNodes)) {
            QuotaAttItemValueStd std = (QuotaAttItemValueStd)dataNodes.get(0);
            qtCalRule = (QTCalRule)std.getMatchedRule();
            localDate = std.getAttItemInstance().getOrgEndDay();
            qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(std.getAttItemInstance().getOrgEndDay());
            qtGenConfigEntry = qtGenConfig.getQtGenCfEntryByDetail(std.getAttItemInstance().getQtDetailId());
        } else {
            String rule = "rule" + key;
            String configEntry = "configEntry" + key;
            qtCalRule = (QTCalRule)context.getVariable(rule, VScope.LINE);
            if (qtCalRule != null) {
                qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(context.getChainDate());
            }
            qtGenConfigEntry = (QTGenConfigEntry)context.getVariable(configEntry, VScope.LINE);
        }
        if (qtCalRule == null || qtGenConfig == null || qtGenConfigEntry == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTPrePeriodDetailsEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
        if (circleRestVo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u671f\u95f4\u5faa\u73af\u914d\u3002", (String)"QTDurationDeductionEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        List<QTLineDetail> qtLineDetailList = qtPoolHolder.getQtPoolByFileBoId(attFileModel.getBid(), periodNum, qtTypeId);
        List<QTLineDetail> manualDetails = qtLineDetailList.stream().filter(detail -> QuotaDetailType.MANUAL_GIVE.getCode().equals(detail.getSource())).collect(Collectors.toList());
        List initDetails = qtLineDetailList.stream().filter(detail -> QuotaDetailType.INIT_PERIOD_GEN.getCode().equals(detail.getSource()) || QuotaDetailType.INIT_PRE_PERIOD_CARRY_DOWN.getCode().equals(detail.getSource())).collect(Collectors.toList());
        List<Object> quotaDetailAddModels = new ArrayList();
        QuotaDetailAddData quotaDetailAddData = context.getInitParamMust("QT_ADD", QuotaDetailAddData.class);
        if (quotaDetailAddData != null) {
            quotaDetailAddModels = quotaDetailAddData.getModelByBoidAndQuotaTypeId(attFileModel.getBid(), qtTypeId);
        }
        ArrayList<QTLineDetail> qtLineDetails = (ArrayList<QTLineDetail>)context.getVariable(key, VScope.LINE);
        if (manualDetails == null) {
            manualDetails = new ArrayList();
        }
        if (initDetails == null) {
            initDetails = new ArrayList();
        }
        if (qtLineDetails == null) {
            qtLineDetails = new ArrayList<QTLineDetail>();
            context.setVariable(key, qtLineDetails, VScope.LINE);
        }
        ArrayList<QuotaDataNode> quotaDataNodeList = new ArrayList<QuotaDataNode>();
        if (WTCCollections.isNotEmpty(quotaDetailAddModels)) {
            long[] ids = IDService.get().genLongIds(quotaDetailAddModels.size());
            for (int index = 0; index < quotaDetailAddModels.size(); ++index) {
                this.doAddManualDetailByRule((QuotaDetailAddModel)quotaDetailAddModels.get(index), ids[index], manualDetails, qtLineDetails, context, qtCalRule);
            }
        }
        List<QTLineDetail> noAddByRules = manualDetails.stream().filter(qt -> qt.getQtDetailAddId() == 0L).collect(Collectors.toList());
        noAddByRules.addAll(initDetails);
        if (!WTCCollections.isEmpty(noAddByRules)) {
            this.doAddManualDetail(noAddByRules, qtLineDetails, context);
        }
        if (!WTCCollections.isEmpty(curManualDetails = qtLineDetails.stream().filter(detail -> filterList.contains(detail.getSource())).collect(Collectors.toList()))) {
            this.buildItem(quotaDataNodeList, curManualDetails, qtGenConfig, qtGenConfigEntry, context, qtCalRule, localDate);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void doAddManualDetailByRule(QuotaDetailAddModel quotaDetailAddModel, Long id, List<QTLineDetail> qtLineDetailList, List<QTLineDetail> newQtLineDetails, QuotaContextStd context, QTCalRule qtCalRule) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        Date genEndDate = context.getCircleRestVo().getEndDate();
        Date startDate = context.getCircleRestVo().getStartDate();
        QTDetailAdjustTable qtDetailAdjustTable = (QTDetailAdjustTable)context.getInitParam("QT_DETAIL_ADJUST");
        long addManualDetailId = quotaDetailAddModel.getId();
        Date geneStartDate = quotaDetailAddModel.getGeneStartDate();
        Date useEndDate = quotaDetailAddModel.getUseEndDate();
        Date useStartDate = quotaDetailAddModel.getUseStartDate();
        if (geneStartDate.compareTo(startDate) < 0 || geneStartDate.compareTo(genEndDate) > 0) {
            return;
        }
        BigDecimal value = quotaDetailAddModel.getValue();
        Map<String, Date> map = QTUseDateGenUtils.getUseDate(geneStartDate, genEndDate, context, qtCalRule);
        useStartDate = useStartDate != null ? useStartDate : map.get("startDate");
        Date date = useEndDate = useEndDate != null ? useEndDate : map.get("endDate");
        if (useStartDate.after(useEndDate)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u201d\u3002", (String)"QTAvailableTimeEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]), attFileModel.getNumber()));
        }
        for (QTLineDetail qtLineDetail : qtLineDetailList) {
            if (qtLineDetail.getQtDetailAddId() != addManualDetailId) continue;
            qtLineDetail.rememberOriginalId();
            QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtLineDetail);
            qtLineDetail.setGenValue(value);
            qtLineDetail.setOwnValue(value);
            qtLineDetail.setUsableValue(value);
            qtLineDetail.setGenStartDate(geneStartDate);
            qtLineDetail.setGenEndDate(genEndDate);
            qtLineDetail.setUseStartDate(useStartDate);
            qtLineDetail.setUseEndDate(useEndDate);
            qtLineDetail.setQtDetailAddId(addManualDetailId);
            this.setDpConvert(qtDetailAdjustTable, qtLineDetail, quotaDetailAddModel.isDpConvert());
            newQtLineDetails.add(qtLineDetail);
            qtLineDetail.setId(id.longValue());
            return;
        }
        CircleRestVo circleRestVo = context.getCircleRestVo();
        QTLineDetail newQtLineDetail = new QTLineDetail();
        newQtLineDetail.setCreateTime(new Date());
        newQtLineDetail.setGenValue(value);
        newQtLineDetail.setOwnValue(value);
        newQtLineDetail.setUsableValue(value);
        newQtLineDetail.setUseStartDate(useStartDate);
        newQtLineDetail.setUseEndDate(useEndDate);
        newQtLineDetail.setAttFileBoId(attFileModel.getBid());
        newQtLineDetail.setAttFileVid(attFileModel.getId());
        newQtLineDetail.setQtTypeId(context.getQuotaTypeId().longValue());
        newQtLineDetail.setpCycleId(circleRestVo.getCycSetId().longValue());
        newQtLineDetail.setPeriodNum(circleRestVo.getIndex().intValue());
        newQtLineDetail.setQtTypeId(quotaDetailAddModel.getQtTypeId().longValue());
        newQtLineDetail.setGenStartDate(geneStartDate);
        newQtLineDetail.setGenEndDate(genEndDate);
        newQtLineDetail.setQtDetailAddId(addManualDetailId);
        newQtLineDetail.setSource(QuotaDetailType.MANUAL_GIVE.code);
        newQtLineDetail.setOrgId(attFileModel.getOrgId().longValue());
        newQtLineDetail.setDpConvert(quotaDetailAddModel.isDpConvert());
        newQtLineDetail.setId(id.longValue());
        newQtLineDetails.add(newQtLineDetail);
    }

    private void doAddManualDetail(List<QTLineDetail> qtLineDetailList, List<QTLineDetail> newQtLineDetails, QuotaContextStd context) {
        QTDetailAdjustTable qtDetailAdjustTable = (QTDetailAdjustTable)context.getInitParam("QT_DETAIL_ADJUST");
        long[] ids = IDService.get().genLongIds(qtLineDetailList.size());
        for (int index = 0; index < qtLineDetailList.size(); ++index) {
            QTLineDetail qtLineDetail = qtLineDetailList.get(index);
            qtLineDetail.setOwnValue(qtLineDetail.getGenValue());
            qtLineDetail.rememberOriginalId();
            QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtLineDetail);
            this.setDpConvert(qtDetailAdjustTable, qtLineDetail, qtLineDetail.isDpConvert());
            if (qtLineDetail.getOrignUseStartDate() != null) {
                qtLineDetail.setUseStartDate(qtLineDetail.getOrignUseStartDate());
            }
            if (qtLineDetail.getOrignEndStartDate() != null) {
                qtLineDetail.setUseEndDate(qtLineDetail.getOrignEndStartDate());
            }
            qtLineDetail.setId(ids[index]);
            newQtLineDetails.add(qtLineDetail);
        }
    }

    private void buildItem(List<QuotaDataNode> quotaDataNodeList, List<QTLineDetail> currManualLineDetails, QTGenConfig qtGenConfig, QTGenConfigEntry qtGenConfigEntry, QuotaContextStd context, QTCalRule qtCalRule, LocalDate localDate) {
        if (qtGenConfig != null) {
            AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getEnjoyAttItem(), context.getChainDate());
            AttItemSpec standardAttItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getResultAttItem(), context.getChainDate());
            CircleRestVo circleRestVo = context.getCircleRestVo();
            for (int index = 0; index < currManualLineDetails.size(); ++index) {
                QTLineDetail qtLineDetail = currManualLineDetails.get(index);
                if (qtLineDetail == null) continue;
                QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtLineDetail.getBid(), attItemSpec, qtLineDetail.getOwnValue(), AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.DURATION_ENJOYMENT, QuotaDetailType.of(qtLineDetail.getSource()), qtLineDetail.getQtTypeId(), qtGenConfig.getCycSet(), circleRestVo.getIndex(), circleRestVo.getAssignDate(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getCrossStartdate(), qtLineDetail.getCrossEnddate());
                quotaAttItemInstance.setStatus(QuotaAttItemStatus.of(qtLineDetail.getBusstatus()));
                quotaAttItemInstance.setOrgEndDay(localDate);
                quotaAttItemInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
                quotaAttItemInstance.setAttFileVId(qtLineDetail.getAttFileVid());
                qtGenConfig.putQtGenCfEntryByDetail(qtLineDetail.getBid(), qtGenConfigEntry);
                QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).build();
                attItemValue.setMatchedRule(qtCalRule);
                if (qtLineDetail.getQtDetailAddId() != 0L) {
                    attItemValue.setEvaluationRule(EvaluationRuleModel.of(qtLineDetail.getQtDetailAddId(), "wtte_quotadetailadd"));
                }
                QuotaAttItemInstance standardAttItemInstance = new QuotaAttItemInstance(qtLineDetail.getBid(), standardAttItemSpec, qtLineDetail.getOwnValue(), AttitemUnitEnum.of((String)standardAttItemSpec.getUnit()), QuotaAttItemType.STANDARD, QuotaDetailType.of(qtLineDetail.getSource()), qtLineDetail.getQtTypeId(), qtGenConfig.getCycSet(), circleRestVo.getIndex(), circleRestVo.getAssignDate(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getCrossStartdate(), qtLineDetail.getCrossEnddate());
                standardAttItemInstance.setStatus(QuotaAttItemStatus.of(qtLineDetail.getBusstatus()));
                standardAttItemInstance.setOrgEndDay(localDate);
                standardAttItemInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
                standardAttItemInstance.setAttFileVId(qtLineDetail.getAttFileVid());
                QuotaAttItemValue standardAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(standardAttItemInstance)).build();
                standardAttItemValue.setMatchedRule(qtCalRule);
                if (qtLineDetail.getQtDetailAddId() != 0L) {
                    standardAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtLineDetail.getQtDetailAddId(), "wtte_quotadetailadd"));
                }
                quotaDataNodeList.add(attItemValue);
                quotaDataNodeList.add(standardAttItemValue);
            }
        }
    }

    private void setDpConvert(QTDetailAdjustTable qtDetailAdjustTable, QTLineDetail qtLineDetail, boolean oldIsConvert) {
        if (qtDetailAdjustTable.getDetailConvertById() == null) {
            qtLineDetail.setDpConvert(oldIsConvert);
            return;
        }
        Boolean isConvert = qtDetailAdjustTable.getDetailConvertById().get(qtLineDetail.getBid());
        if (isConvert == null) {
            qtLineDetail.setDpConvert(oldIsConvert);
            return;
        }
        qtLineDetail.setDpConvert(isConvert.booleanValue());
    }
}

