/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover.detailadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTMdfyMethodEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailAdjustUtils;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDetailAdjustEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTDetailAdjustEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (WTCCollections.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found dataNodes"));
        }
        List<QuotaAttItemValueStd> quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        List<QuotaAttItemValueStd> enjoyAttStds = quotaAttStds.stream().filter(dt -> this.isEnjoy((QuotaAttItemValueStd)dt)).collect(Collectors.toList());
        List<QuotaAttItemValueStd> starAttStds = quotaAttStds.stream().filter(dt -> QuotaAttItemType.STANDARD == dt.getAttItemInstance().getQuotaAttItemType() && dt.isLeaf()).collect(Collectors.toList());
        if (WTCCollections.isEmpty(enjoyAttStds)) {
            LOG.warn("QTDetailAdjustEvaluator not found enjoy dataNodes");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy dataNodes"));
        }
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        QTDetailAdjustTable qtDetailAdjustTable = context.getInitParamMust("QT_DETAIL_ADJUST", QTDetailAdjustTable.class);
        List<QTDetailAdjust> qtDetailAdjusts = qtDetailAdjustTable.getQtDetailAdjustByBid(attFileModel.getBid());
        if (WTCCollections.isEmpty(qtDetailAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDetailAdjustEvaluator not found QTDetailAdjust");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy QTDetailAdjust"));
        }
        HashMap<Long, List<QTDetailAdjust>> matchQTDetailAdjusts = new HashMap<Long, List<QTDetailAdjust>>();
        QuotaDetailAdjustUtils.matchQtDetailAdjust(matchQTDetailAdjusts, qtDetailAdjusts, enjoyAttStds, starAttStds, qtDetails);
        if (WTCCollections.isEmpty(matchQTDetailAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDetailAdjustEvaluator not found QTDetailAdjust");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy QTDetailAdjust"));
        }
        ArrayList<QuotaDataNode> quotaDataNodeList = new ArrayList<QuotaDataNode>();
        for (QuotaAttItemValueStd enjoyAttStd : enjoyAttStds) {
            this.doAdjustDetail(matchQTDetailAdjusts, quotaDataNodeList, enjoyAttStd, context, quotaAttStds);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void doAdjustDetail(Map<Long, List<QTDetailAdjust>> matchQTDetailAdjusts, List<QuotaDataNode> quotaDataNodeList, QuotaAttItemValueStd enjoyAttStd, QuotaContextStd context, List<QuotaAttItemValueStd> quotaAttStds) {
        Long qtLineDetailId = enjoyAttStd.getAttItemInstance().getQtDetailId();
        List<QTDetailAdjust> qtDetailAdjusts = matchQTDetailAdjusts.get(qtLineDetailId);
        if (WTCCollections.isEmpty(qtDetailAdjusts)) {
            return;
        }
        qtDetailAdjusts = qtDetailAdjusts.stream().sorted(Comparator.comparing(QTDetailAdjust::getCreateTime)).collect(Collectors.toList());
        BigDecimal value = enjoyAttStd.getAttItemInstance().getItemValue();
        for (QTDetailAdjust qtDetailAdjust : qtDetailAdjusts) {
            BigDecimal beforeValue = value;
            BigDecimal afterValue = BigDecimal.ZERO;
            BigDecimal mdfyValue = qtDetailAdjust.getMdfyValue();
            if (QTMdfyMethodEnum.MDFY_METHOD_ADD.type.equals(qtDetailAdjust.getMdfyMethod())) {
                afterValue = value.add(mdfyValue);
            } else if (QTMdfyMethodEnum.MDFY_METHOD_REDUCE.type.equals(qtDetailAdjust.getMdfyMethod())) {
                afterValue = value.subtract(mdfyValue);
            }
            value = afterValue;
        }
        Set<Long> evaluationRuleIds = qtDetailAdjusts.stream().map(QTDetailAdjust::getId).collect(Collectors.toSet());
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)enjoyAttStd.getAttItemInstance().getQttypeId(), (long)enjoyAttStd.getAttItemInstance().getPeriodcircleId(), (long)enjoyAttStd.getAttItemInstance().getPeriodNum().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        for (QTLineDetail qt : qtDetails) {
            if (qt.getBid() != enjoyAttStd.getAttItemInstance().getQtDetailId().longValue()) continue;
            if (CheckUtils.isNegative((BigDecimal)value) && CheckUtils.isNonZero((BigDecimal)qt.getOwnOdValue())) {
                BigDecimal flowValue = BigDecimal.ZERO.subtract(value);
                if (CheckUtils.isLargeEqual((BigDecimal)qt.getOwnOdValue(), (BigDecimal)flowValue)) {
                    value = BigDecimal.ZERO;
                    qt.setOwnOdValue(qt.getOwnValue().subtract(flowValue));
                    qt.setCanBeOdValue(qt.getOwnValue());
                } else {
                    flowValue = flowValue.subtract(qt.getOwnOdValue());
                    value = BigDecimal.ZERO.subtract(flowValue);
                    qt.setOwnOdValue(BigDecimal.ZERO);
                    qt.setCanBeOdValue(BigDecimal.ZERO);
                }
                List linePreDtList = quotaAttStds.stream().filter(dt -> dt.getAttItemInstance().getQtDetailId().longValue() == qt.getBid()).collect(Collectors.toList());
                linePreDtList.stream().filter(this::isOwnOd).forEach(dt -> this.buildItem((QuotaAttItemValueStd)dt, qt.getOwnValue(), quotaDataNodeList, evaluationRuleIds));
                linePreDtList.stream().filter(this::isCanBeOd).forEach(dt -> this.buildItem((QuotaAttItemValueStd)dt, qt.getCanBeOdValue(), quotaDataNodeList, evaluationRuleIds));
            }
            qt.setOwnValue(value);
        }
        this.buildItem(enjoyAttStd, value, quotaDataNodeList, evaluationRuleIds);
    }

    private boolean isEnjoy(QuotaAttItemValueStd dt) {
        boolean enjoyItem = QuotaAttItemType.DURATION_ENJOYMENT == dt.getAttItemInstance().getQuotaAttItemType();
        boolean sysAndManualItem = QuotaDetailType.CUR_PERIOD_GEN == dt.getAttItemInstance().getSource() || QuotaDetailType.MANUAL_GIVE == dt.getAttItemInstance().getSource() || QuotaDetailType.BO_SETTLEMENT == dt.getAttItemInstance().getSource();
        return enjoyItem && sysAndManualItem && dt.isLeaf();
    }

    private boolean isOwnOd(QuotaAttItemValueStd dt) {
        boolean enjoyItem = QuotaAttItemType.ENJOY_OVERDRAFT == dt.getAttItemInstance().getQuotaAttItemType();
        boolean sysAndManualItem = QuotaDetailType.CUR_PERIOD_GEN == dt.getAttItemInstance().getSource() || QuotaDetailType.MANUAL_GIVE == dt.getAttItemInstance().getSource() || QuotaDetailType.BO_SETTLEMENT == dt.getAttItemInstance().getSource();
        return enjoyItem && sysAndManualItem && dt.isLeaf();
    }

    private boolean isCanBeOd(QuotaAttItemValueStd dt) {
        boolean enjoyItem = QuotaAttItemType.OVERDRAW_AVAILABLE == dt.getAttItemInstance().getQuotaAttItemType();
        boolean sysAndManualItem = QuotaDetailType.CUR_PERIOD_GEN == dt.getAttItemInstance().getSource() || QuotaDetailType.MANUAL_GIVE == dt.getAttItemInstance().getSource() || QuotaDetailType.BO_SETTLEMENT == dt.getAttItemInstance().getSource();
        return enjoyItem && sysAndManualItem && dt.isLeaf();
    }

    private void buildItem(QuotaAttItemValueStd enjoyAttStd, BigDecimal value, List<QuotaDataNode> quotaDataNodeList, Set<Long> evaluationRuleIds) {
        QuotaAttItemInstance attItemInstance = enjoyAttStd.getAttItemInstance();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), value, attItemInstance.getUntil(), attItemInstance.getQuotaAttItemType(), attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion(), attItemInstance.getGenStartDate(), attItemInstance.getGenEndDate(), attItemInstance.getUseStartDate(), attItemInstance.getUseEndDate(), attItemInstance.getChangeSatrt(), attItemInstance.getChangeEnd());
        quotaAttItemInstance.setStatus(attItemInstance.getStatus());
        quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).appendParentDataNode(enjoyAttStd)).matchedRule(enjoyAttStd.getMatchedRule())).build();
        for (Long id : evaluationRuleIds) {
            attItemValue.setEvaluationRule(EvaluationRuleModel.of(id, "wtte_quotadetailmdfy"));
        }
        quotaDataNodeList.add(attItemValue);
    }
}

