/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover.detailadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTTurnOverConvert;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertMethodEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTDepartUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDetailDepartEvaluator
implements QuotaEvaluatorStd {
    private static final String OUT_PRE_KEY = "out_";
    private static final Log LOG = LogFactory.getLog(QTDetailDepartEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (WTCCollections.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailDepartEvaluator not found dataNodes"));
        }
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        List enjoyAttStds = quotaAttStds.stream().filter(dt -> dt.isLeaf()).filter(dt -> QuotaAttItemType.DURATION_ENJOYMENT == dt.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        ArrayList<QuotaDataNode> quotaDataNodeList = new ArrayList<QuotaDataNode>();
        HashMap<String, BigDecimal> convertMap = new HashMap<String, BigDecimal>();
        HashMap<String, Boolean> isConvertMap = new HashMap<String, Boolean>();
        for (QuotaAttItemValueStd enjoyAttStd : enjoyAttStds) {
            this.doDpConvert(enjoyAttStd, quotaDataNodeList, context, convertMap, isConvertMap);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void doDpConvert(QuotaAttItemValueStd enjoyAttStd, List<QuotaDataNode> quotaDataNodeList, QuotaContextStd context, Map<String, BigDecimal> convertMap, Map<String, Boolean> isConvertMap) {
        QTCalRule qtCalRule = (QTCalRule)enjoyAttStd.getMatchedRule();
        QuotaAttItemInstance attItemInstance = enjoyAttStd.getAttItemInstance();
        if (qtCalRule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTOnAndOffDutyEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)enjoyAttStd.getAttItemInstance().getQttypeId(), (long)enjoyAttStd.getAttItemInstance().getPeriodcircleId(), (long)enjoyAttStd.getAttItemInstance().getPeriodNum().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == attItemInstance.getQtDetailId().longValue()).findFirst().get();
        if (qtLineDetail == null) {
            LOG.warn("QTDetailDepartEvaluator qtLineDetail not found {}", (Object)attItemInstance.getQtDetailId());
            return;
        }
        if (!qtLineDetail.isDpConvert()) {
            return;
        }
        BigDecimal itemValue = attItemInstance.getItemValue();
        QTTurnOverConvert qtTurnOverConvet = qtCalRule.getTurnOverConversion();
        String outKey = OUT_PRE_KEY + qtCalRule.getId();
        if (!isConvertMap.containsKey(outKey)) {
            QTDepartUtils.getQTThurnOverConvert(qtCalRule, context, qtTurnOverConvet, convertMap, isConvertMap);
        }
        BigDecimal thurnFactor = convertMap.get(outKey);
        if (isConvertMap.get(outKey).booleanValue() && thurnFactor != null) {
            itemValue = itemValue.multiply(thurnFactor);
            if (BigDecimal.ZERO.compareTo(qtTurnOverConvet.getSafActor()) > 0 && QTConvertMethodEnum.CONVERT_LEAVE_DAY != qtTurnOverConvet.getConvertMethod()) {
                itemValue = itemValue.multiply(qtTurnOverConvet.getSafActor());
            }
            qtLineDetail.setOwnValue(itemValue);
            this.buildItem(enjoyAttStd, itemValue, quotaDataNodeList, qtTurnOverConvet.getId());
        }
    }

    private void buildItem(QuotaAttItemValueStd enjoyAttStd, BigDecimal value, List<QuotaDataNode> quotaDataNodeList, Long evaluationRuleId) {
        QuotaAttItemInstance attItemInstance = enjoyAttStd.getAttItemInstance();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), value, attItemInstance.getUntil(), attItemInstance.getQuotaAttItemType(), attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion(), attItemInstance.getGenStartDate(), attItemInstance.getGenEndDate(), attItemInstance.getUseStartDate(), attItemInstance.getUseEndDate(), attItemInstance.getChangeSatrt(), attItemInstance.getChangeEnd());
        quotaAttItemInstance.setStatus(attItemInstance.getStatus());
        quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).appendParentDataNode(enjoyAttStd)).matchedRule(enjoyAttStd.getMatchedRule())).build();
        attItemValue.setEvaluationRule(EvaluationRuleModel.of(evaluationRuleId, "wtp_qtturnoverconver"));
        quotaDataNodeList.add(attItemValue);
    }
}

