/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.deduction;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.executor.deduction.QTDeductEvaluatorHelper;
import kd.wtc.wtes.business.quota.model.DeductEnv;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaRuleConfigUtils;
import kd.wtc.wtp.business.cumulate.calculate.model.result.MBApplyRes;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.QTBillOuterService;
import kd.wtc.wtp.business.cumulate.trading.QTDeductService;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;

public class QTDurationDeductionEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTDurationDeductionEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    private Map<Long, QTCalRule> matchQTCalRule(List<QTLineDetail> lineList, QuotaContextStd context) {
        Map line2QTCalRuleMap = WTCCollections.modifiableEmptyMap();
        for (QTLineDetail line : lineList) {
            QTScheme qtScheme;
            LocalDate endDate = WTCDateUtils.toLocalDate((Date)line.getGenEndDate());
            AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context, endDate);
            if (attFileModel == null) {
                attFileModel = QuotaContextUtil.getAttFileModle(context);
                endDate = WTCDateUtils.toLocalDate((Date)context.getAttSubjectEntry().getCurrentChainAttFileInfo().getEndDate());
            }
            if ((qtScheme = attFileModel.getAttQtPackage(endDate)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u5b9a\u989d\u660e\u7ec6[\u7f16\u7801=%1$s]\u7684\u751f\u6210\u7ed3\u675f\u65e5\u671f[%2$s]\u627e\u5230\u5b9a\u989d\u65b9\u6848\u3002", (String)"QTDurationDeductionEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[]{QTLineDetailNumHelper.convertNum((Long)line.getBid()), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)endDate)}));
            }
            QTRule qtRule = QuotaRuleConfigUtils.getRuleConfig(context, qtScheme, endDate);
            if (qtRule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u5b9a\u989d\u660e\u7ec6[\u7f16\u7801=%1$s]\u7684\u751f\u6210\u7ed3\u675f\u65e5\u671f[%2$s]\u627e\u5230\u5b9a\u989d\u89c4\u5219\u3002", (String)"QTDurationDeductionEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[]{QTLineDetailNumHelper.convertNum((Long)line.getBid()), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)endDate)}));
            }
            boolean notFindRuleEntry = true;
            for (QTCalRule rule : qtRule.getQtRules()) {
                QTGenConfig qtGenConfig;
                if (rule.getGenConfig() == null || rule.getGenConfig().getVersionByDate(endDate) == null || (qtGenConfig = (QTGenConfig)rule.getGenConfig().getVersionByDate(endDate)).getQtType().getId() != line.getQtTypeId()) continue;
                notFindRuleEntry = false;
                if (rule.getUseConfig() == null || rule.getUseConfig().getVersionByDate(endDate) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u5b9a\u989d\u660e\u7ec6[\u7f16\u7801=%1$s]\u7684\u751f\u6210\u7ed3\u675f\u65e5\u671f[%2$s]\u627e\u5230\u5b9a\u989d\u89c4\u5219-\u8ba1\u7b97\u89c4\u5219-\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u3002", (String)"QTDurationDeductionEvaluator_7", (String)"wtc-wtes-business", (Object[])new Object[]{QTLineDetailNumHelper.convertNum((Long)line.getBid()), endDate}));
                }
                if (CheckUtils.isNonZeroNullAble((BigDecimal)line.getOwnOdValue()) && (rule.getOverDraw() == null || rule.getOverDraw().getVersionByDate(endDate) == null)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u5b9a\u989d\u660e\u7ec6[\u7f16\u7801=%1$s]\u7684\u751f\u6210\u7ed3\u675f\u65e5\u671f[%2$s]\u627e\u5230\u5b9a\u989d\u89c4\u5219-\u8ba1\u7b97\u89c4\u5219-\u5b9a\u989d\u900f\u652f\u914d\u7f6e\u3002", (String)"QTDurationDeductionEvaluator_8", (String)"wtc-wtes-business", (Object[])new Object[]{QTLineDetailNumHelper.convertNum((Long)line.getBid()), endDate}));
                }
                line2QTCalRuleMap.put(line.getBid(), rule);
            }
            if (!notFindRuleEntry) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u5b9a\u989d\u660e\u7ec6[\u7f16\u7801=%1$s]\u7684\u751f\u6210\u7ed3\u675f\u65e5\u671f[%2$s]\u627e\u5230\u5b9a\u989d\u89c4\u5219-\u8ba1\u7b97\u89c4\u5219\u3002", (String)"QTDurationDeductionEvaluator_9", (String)"wtc-wtes-business", (Object[])new Object[]{QTLineDetailNumHelper.convertNum((Long)line.getBid()), endDate}));
        }
        return line2QTCalRuleMap;
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (QTAccountModeHelper.isDeductChain((String)context.getRequest().getAccountMode())) {
            AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
            long attFileBoId = attFileModel.getBid();
            QuotaRunTimeCache quotaRunTimeCache = (QuotaRunTimeCache)context.getInitParam("QT_RUN_TIME_CACHE");
            QTRuntime runtime = quotaRunTimeCache.getRunTimeByAttFileBoId(attFileBoId);
            try {
                DeductEnv deductEnv = (DeductEnv)context.getInitParam("QT_DEDUCT_CHAIN_EVN");
                List<BillApply> useBillList = deductEnv.handOverBillsByFileBoId(attFileBoId);
                List<QTLineDetail> allLine = deductEnv.getLineDetailByFileBoId(attFileBoId);
                List<QTBillDeal> allBillDeal = deductEnv.handOverBillDealListByFileBoId(attFileBoId);
                runtime.plusPoolAndMarkDirty(allLine);
                runtime.plusDeductRuleMap(deductEnv.getDeductRuleMap());
                this.repairRepeatBillDeal(runtime, deductEnv, allLine, allBillDeal);
                runtime.setPreQueryBD(allBillDeal);
                QTDeductService.coverApplyDate(useBillList, (Map)runtime.getPreQueryBDMap());
                useBillList.sort(Comparator.comparing(BillApply::getApplyTime));
                MBApplyRes errRes = QTDeductService.batchRefundAndDeductWithQTRuntime((QTRuntime)runtime, useBillList);
                if (errRes != null) {
                    String errCode = errRes.getErrCode();
                    BillApply errorBill = this.getErrorBill(errRes.getId(), useBillList);
                    String humanErrMsg = errorBill.getBillNo() + ":" + errCode;
                    if ("UN_COVER".equals(errCode)) {
                        Map errEntryRetData = errRes.getErrEntryRetData();
                        humanErrMsg = ResManager.loadKDString((String)"\u5355\u636e[\u7f16\u7801=%1$s]\u6240\u7533\u8bf7\u7684\u65e5\u671f[%2$s]\u65e0\u53ef\u7528\u989d\u5ea6\u3002", (String)"QTDurationDeductionEvaluator_11", (String)"wtc-wtes-business", (Object[])new Object[]{errorBill.getBillNo(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)errEntryRetData.get("unCoverDate")))});
                    } else if ("ENTRY_APPLY_NEGATIVE".equals(errCode)) {
                        humanErrMsg = ResManager.loadKDString((String)"%1$s\u65f6\u957f\u4e3a\u8d1f\u503c\uff0c\u65e0\u6cd5\u8fdb\u884c\u65f6\u957f\u6263\u51cf\u3002", (String)"QTDurationDeductionEvaluator_12", (String)"wtc-wtes-business", (Object[])new Object[]{errorBill.getBillNo()});
                    }
                    throw new KDBizException(humanErrMsg);
                }
                runtime.addDirtyBillApplyPackage(useBillList);
                Map<Long, QTCalRule> line2CalRuleMap = this.matchQTCalRule(allLine, context);
                deductEnv.putLineRuleMap(attFileBoId, line2CalRuleMap);
                AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
                List res = WTCCollections.modifiableEmptyList();
                for (QTLineDetail line : allLine) {
                    LocalDate lineEndDate = WTCDateUtils.toLocalDate((Date)line.getGenEndDate());
                    QTCalRule matchedRule = line2CalRuleMap.get(line.getBid());
                    this.genUsableItem(deductEnv, attItemSpecData, line, lineEndDate, matchedRule, res);
                    this.genFreezeItem(attItemSpecData, line, lineEndDate, matchedRule, res);
                    this.genUseDataNode(attItemSpecData, line, lineEndDate, matchedRule, res);
                    this.genInvalidItem(attItemSpecData, line, lineEndDate, matchedRule, res);
                }
                return QuotaDataResultStd.success(res);
            }
            catch (Exception exp) {
                runtime.discard();
                throw exp;
            }
        }
        if (!context.getRequest().isRealTimeComputingBills()) {
            return QTDeductEvaluatorHelper.evacuation(context, dataNodes);
        }
        return QTDeductEvaluatorHelper.deduct(context, dataNodes);
    }

    private void genInvalidItem(AttItemSpecData attItemSpecData, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, List<QuotaAttItemValue> res) {
        if (CheckUtils.isNonZero((BigDecimal)line.getInvalidValue())) {
            QTUseConfig useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(lineEndDate);
            AttItemSpec invalidItemSpec = attItemSpecData.getByBidAndDate(useConfig.getUseDuration(), lineEndDate);
            QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), invalidItemSpec, line.getInvalidValue(), AttitemUnitEnum.of((String)invalidItemSpec.getUnit()), QuotaAttItemType.INVALID_VALUE_ITEM, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
            attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
            attItemInstance.setAttFileVId(line.getAttFileVid());
            attItemInstance.setAttFileBoId(line.getAttFileBoId());
            QuotaAttItemValue temp = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(useConfig.getId(), "wtp_qtuseconfig"))).build();
            res.add(temp);
        }
    }

    private void genUseDataNode(AttItemSpecData attItemSpecData, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, List<QuotaAttItemValue> res) {
        if (CheckUtils.isNonZero((BigDecimal)line.getUsedValue())) {
            QTUseConfig useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(lineEndDate);
            AttItemSpec usedItemSpec = attItemSpecData.getByBidAndDate(useConfig.getUseDuration(), lineEndDate);
            QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), usedItemSpec, line.getUsedValue(), AttitemUnitEnum.of((String)usedItemSpec.getUnit()), QuotaAttItemType.USING, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
            attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
            attItemInstance.setAttFileVId(line.getAttFileVid());
            attItemInstance.setAttFileBoId(line.getAttFileBoId());
            QuotaAttItemValue temp = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(useConfig.getId(), "wtp_qtuseconfig"))).build();
            res.add(temp);
        }
    }

    private void genFreezeItem(AttItemSpecData attItemSpecData, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, List<QuotaAttItemValue> res) {
        if (CheckUtils.isNonZero((BigDecimal)line.getFreezeValue())) {
            QTUseConfig useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(lineEndDate);
            AttItemSpec freeItemSpec = attItemSpecData.getByBidAndDate(useConfig.getFreeze(), lineEndDate);
            QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), freeItemSpec, line.getFreezeValue(), AttitemUnitEnum.of((String)freeItemSpec.getUnit()), QuotaAttItemType.FREEZE, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
            attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
            attItemInstance.setAttFileVId(line.getAttFileVid());
            attItemInstance.setAttFileBoId(line.getAttFileBoId());
            QuotaAttItemValue temp = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(useConfig.getId(), "wtp_qtuseconfig"))).build();
            res.add(temp);
        }
    }

    private void genUsableItem(DeductEnv deductEnv, AttItemSpecData attItemSpecData, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, List<QuotaAttItemValue> res) {
        QTGenConfig genConfig = (QTGenConfig)matchedRule.getGenConfig().getVersionByDate(lineEndDate);
        long itemBoIdByVid = deductEnv.getItemBoIdByVid(line.getUsableValueAttItemVid());
        if (itemBoIdByVid == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6\u53ef\u7528\u9879\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6263\u51cf\u3002", (String)"QTDurationDeductionEvaluator_13", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        AttItemSpec usableItemSpec = attItemSpecData.getByBidAndDate(itemBoIdByVid, lineEndDate);
        if (usableItemSpec == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6\u53ef\u7528\u9879\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6263\u51cf\u3002", (String)"QTDurationDeductionEvaluator_13", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), usableItemSpec, line.getUsableValue(), AttitemUnitEnum.of((String)usableItemSpec.getUnit()), QuotaAttItemType.AVAILABLE, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
        attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
        attItemInstance.setAttFileVId(line.getAttFileVid());
        attItemInstance.setAttFileBoId(line.getAttFileBoId());
        QuotaAttItemValue usableDataNode = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(genConfig.getId(), "wtp_qtgenconfig"))).build();
        res.add(usableDataNode);
    }

    private BillApply getErrorBill(long id, List<BillApply> useBillList) {
        for (BillApply billApply : useBillList) {
            if (id != billApply.getId()) continue;
            return billApply;
        }
        throw new KDBizException("can not get bill by id:" + id);
    }

    private void repairRepeatBillDeal(QTRuntime runtime, DeductEnv deductEnv, List<QTLineDetail> sameBoLine, List<QTBillDeal> sameBoBillDeal) {
        if (WTCCollections.isEmpty(deductEnv.getBillSetExistRepeatBillDeal())) {
            return;
        }
        Map repeatBDChainSize = WTCCollections.modifiableEmptyMap();
        Map repeatBillDealIdMap = WTCCollections.modifiableEmptyMap();
        Set needRepairLineIdSet = WTCCollections.modifiableEmptySet();
        for (QTBillDeal qTBillDeal : sameBoBillDeal) {
            if (!deductEnv.existRepeatBillDeal(qTBillDeal.getBillId())) continue;
            repeatBDChainSize.put(qTBillDeal.getChainID(), 0);
            repeatBillDealIdMap.computeIfAbsent(qTBillDeal.getBillId(), key -> WTCCollections.modifiableEmptyList()).add(qTBillDeal.getId());
            Set occurRepeatBDLine = qTBillDeal.getEntryDealList().stream().flatMap(ele -> ele.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).filter(ele -> ele != 0L).collect(Collectors.toSet());
            needRepairLineIdSet.addAll(occurRepeatBDLine);
        }
        if (WTCCollections.isEmpty((Map)repeatBillDealIdMap)) {
            return;
        }
        LOG.warn("QTDurationDeductionEvaluator detected repeatBillDeal:%s", (Object)repeatBillDealIdMap);
        for (QTBillDeal qTBillDeal : sameBoBillDeal) {
            Integer chainSize = (Integer)repeatBDChainSize.get(qTBillDeal.getChainID());
            if (chainSize == null) continue;
            if (chainSize > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u636e[\u7f16\u53f7=%s]\u91cd\u590d\u7684\u6263\u51cf\u8bb0\u5f55\u3002", (String)"QTDurationDeductionEvaluator_10", (String)"wtc-wtes-business", (Object[])new Object[]{qTBillDeal.getBillNumber()}));
            }
            chainSize = chainSize + 1;
            repeatBDChainSize.put(qTBillDeal.getChainID(), chainSize);
        }
        Set needRemoveBillDealIdSet = WTCCollections.modifiableEmptySet();
        for (Object billDealIdList : repeatBillDealIdMap.values()) {
            for (int i = 1; i < billDealIdList.size(); ++i) {
                needRemoveBillDealIdSet.add(billDealIdList.get(i));
            }
        }
        sameBoBillDeal.removeIf(billDeal -> needRemoveBillDealIdSet.contains(billDeal.getId()));
        Map map = WTCCollections.modifiableEmptyMap();
        for (QTLineDetail line : sameBoLine) {
            if (!needRepairLineIdSet.contains(line.getBid())) continue;
            map.put(line.getBid(), line);
        }
        List<QTBillDeal> repairLineBDList = deductEnv.getRepairLineBDByFileBoId(runtime.getAttFileBoId());
        repairLineBDList.removeIf(billDeal -> needRemoveBillDealIdSet.contains(billDeal.getId()));
        for (QTLineDetail line : map.values()) {
            line.setUsableValue(BigDecimal.ZERO);
            line.setFreezeValue(BigDecimal.ZERO);
            line.setUsedValue(BigDecimal.ZERO);
            line.setInvalidValue(BigDecimal.ZERO);
            line.setCanBeOdValue(BigDecimal.ZERO);
            line.setFrozenOdValue(BigDecimal.ZERO);
            line.setUseOdValue(BigDecimal.ZERO);
            line.setInvalidOdValue(BigDecimal.ZERO);
        }
        QTBillOuterService.doEvacuationForEmptyLine(repairLineBDList, (Map)map);
        runtime.getWaitDelBillDealPk().addAll(needRemoveBillDealIdSet);
    }
}

