/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.quota.model.QuotaInspectrangEnum;
import kd.wtc.wtes.business.quota.model.QuotaLimitMethodEnums;
import kd.wtc.wtes.business.quota.model.QuotaQualityTypeEnums;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.AttRcordSummaryUtils;
import kd.wtc.wtes.business.quota.util.QTConditionsUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.VarConditionUtils;

public class QTQualificationsEvaluator {
    private static final Log logger = LogFactory.getLog(QTQualificationsEvaluator.class);

    public boolean checkCondition(QTQualification qtQualification, QuotaContextStd context) {
        CircleRestVo circleRestVo = context.getCircleRestVo();
        Date startDay = context.getCircleRestVo().getStartDate();
        Date startDate = QuotaContextUtil.getBoStartDay(context);
        startDate = startDate.compareTo(startDay) >= 0 ? startDate : startDay;
        Date endDate = WTCDateUtils.toDate((LocalDate)context.getChainDate());
        String inspectRang = qtQualification.getInspectRang();
        Map<Object, Object> map = Maps.newHashMap();
        block0 : switch (QuotaInspectrangEnum.of(inspectRang)) {
            case CURRENT_PERIOD: {
                map = this.getPeriodValue(qtQualification, context, startDate, endDate);
                break;
            }
            case LAST_PERIOD: {
                List list = (List)context.getVariable("circleRestVoList", VScope.LINE);
                Integer index = circleRestVo.getIndex();
                if (index <= 1) {
                    logger.debug("this is first period");
                    break;
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
                for (CircleRestVo vo : list) {
                    if (!vo.getIndex().equals(index)) continue;
                    startDate = vo.getStartDate();
                    endDate = vo.getEndDate();
                    map = this.getPeriodValue(qtQualification, context, startDate, endDate);
                    break block0;
                }
                break;
            }
        }
        return QTConditionsUtils.checkLimitConditions(qtQualification.getRuleConditionInfo(), map);
    }

    public BigDecimal convertedValue(QuotaContextStd contextstd, Long detatilId, QTGenConfig genConfig, QTQualification qtQualification, BigDecimal value) {
        QTGenConfigEntry qtGenConfigEntry = genConfig.getQtGenCfEntryByDetail(detatilId);
        String limitMethod = qtQualification.getLimitMethod();
        switch (QuotaLimitMethodEnums.of(limitMethod)) {
            case FIXED_VALE: {
                if (value.compareTo(qtQualification.getLimitQuatity()) <= 0) break;
                value = qtQualification.getLimitQuatity();
                break;
            }
            case PERCENTAGE: {
                value = value.multiply(qtQualification.getLimitPercent()).divide(BigDecimal.valueOf(100L));
            }
        }
        value = QuotaContextUtil.roundValue(contextstd, qtGenConfigEntry.getRoundRule(), value);
        return value;
    }

    private Map<String, Object> getPeriodValue(QTQualification qtQualification, QuotaContextStd context, Date startDay, Date endDay) {
        String qualityType = qtQualification.getQualityType();
        Map<Object, Object> map = Maps.newHashMap();
        RuleConditionInfo ruleConditionInfo = qtQualification.getRuleConditionInfo();
        if (ruleConditionInfo == null) {
            return map;
        }
        Set<String> params = ruleConditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toSet());
        switch (QuotaQualityTypeEnums.of(qualityType)) {
            case LIMIT_PROJECT: {
                map = AttRcordSummaryUtils.getAttRcordSummaryList(context, params, startDay, endDay);
                break;
            }
            case LIMIT_CONDITION: {
                AttendPersonData attendPersonData = (AttendPersonData)((Object)context.getInitParam("ATT_PERINFO"));
                AttendPerson attendPerson = attendPersonData.getBid2AttendPersonMap().get(context.getAttPersonId());
                AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
                AttendPersonModel attendPersonModel = QuotaContextUtil.getAttendPersonData(context);
                EmployeeDateRecorder dateRecorder = null;
                if (attendPersonModel != null && attendPersonModel.getEmployee() != null) {
                    long bid = attendPersonModel.getEmployee().getBid();
                    dateRecorder = attendPersonData.getEmployeeDateRecorder(bid, context.getChainDate());
                }
                map = VarConditionUtils.getVarConditionValue(attendPerson, attFileModel, context.getAttPersonId(), params, context.getChainDate(), context.getInitParams(), startDay, endDay, dateRecorder);
            }
        }
        return map;
    }
}

