/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailStandard;
import kd.sdk.wtc.wtes.business.qte.init.model.QuotaGenConditionExt;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonData;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonInfo;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConverTimeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTGenTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTRoundPriorityEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaChageDay;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.AttRcordSummaryUtils;
import kd.wtc.wtes.business.quota.util.QTConditionsUtils;
import kd.wtc.wtes.business.quota.util.QTGenDateUtils;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaCrossManageOrgUtils;
import kd.wtc.wtes.business.quota.util.QuotaDetailClearUtils;
import kd.wtc.wtes.business.quota.util.QuotaRuleConfigUtils;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTStandardDurationEvaluator
implements QuotaEvaluatorStd {
    private static final Log logger = LogFactory.getLog(QTStandardDurationEvaluator.class);
    private static final String PRE_KEY = "pre";
    private static final String CURR_KEY = "curr";
    private static final String WORK_AGE = "workage";
    private static final String COMPANY_AGE = "companyage";
    private static final String WTP_QTGENCONFIG = "wtp_qtgenconfig";
    private static final String ORG_CHANG_DATE = "orgChangDate";
    private static final String ORG_AFTER_CONVERT = "afterconvert";

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, null);
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextstd, List<QuotaDataNodeStd> dataNodes) {
        CircleRestVo circleRestVo;
        Boolean isCompletePer;
        LocalDate endDate = contextstd.getChainDate();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd);
        QTScheme qtScheme = attFileModel.getAttQtPackage(endDate);
        if (qtScheme == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"{}\u672a\u627e\u5230\u6709\u6548\u5b9a\u989d\u65b9\u6848\u3002", (String)"QTStandardDurationEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.format((LocalDate)endDate)})));
        }
        QTRule qtRule = QuotaRuleConfigUtils.getRuleConfig(contextstd, qtScheme, endDate);
        if (qtRule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u89c4\u5219\u3002", (String)"QTStandardDurationEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        String ruleKey = "matchRuleLineVar" + attFileModel.getId();
        contextstd.setVariable(ruleKey, qtRule, VScope.LINE);
        List<QTCalRule> qtCalRules = qtRule.getQtRules();
        QTCalRule qtCalRule = this.getQTCalRule(qtCalRules, contextstd, endDate);
        if (qtCalRule == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u672a\u5339\u914d\u201c\u5b9a\u989d\u89c4\u5219\u201d\u4e0b\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u89c4\u5219\u201d\u7684\u914d\u7f6e\u9879\u3002", (String)"QTStandardDurationEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(endDate);
        ArrayList<QuotaAttItemValue> attItemValues = new ArrayList<QuotaAttItemValue>(16);
        BigDecimal crossBoConversion = BigDecimal.ONE;
        if (QuotaCrossManageOrgUtils.isCrossBo(contextstd)) {
            crossBoConversion = QuotaCrossManageOrgUtils.crossBoConVersion(contextstd, genConfig, qtCalRule, attItemValues);
        }
        if ((isCompletePer = Boolean.valueOf((circleRestVo = contextstd.getCircleRestVo()).getPreCycSetId() != null && circleRestVo.getPreCycSetId().equals(circleRestVo.getCycSetId()) && !circleRestVo.getPreIndex().equals(circleRestVo.getIndex()))).booleanValue() && crossBoConversion == null) {
            crossBoConversion = BigDecimal.ONE;
        }
        if (crossBoConversion != null) {
            this.genByQuotaAttItem(qtCalRule, genConfig, contextstd, attItemValues, crossBoConversion);
        }
        this.setCalculatePeriod(contextstd, attFileModel.getBid());
        QteGenExtPluginUtils.afterDoEvalua(contextstd, attItemValues, "standardgen", QTStandardDurationEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(attItemValues);
    }

    private void setCalculatePeriod(QuotaContextStd contextstd, Long attFileBid) {
        List<Integer> periodNums;
        String calculatePeriodKey = QuotaContextUtil.getCalculatePeriodNums(attFileBid, contextstd.getQuotaTypeId());
        if (!contextstd.containsVariable(calculatePeriodKey, VScope.LINE)) {
            periodNums = new ArrayList();
            contextstd.setVariable(calculatePeriodKey, periodNums, VScope.LINE);
        }
        periodNums = (List)contextstd.getVariable(calculatePeriodKey, VScope.LINE);
        periodNums.add(contextstd.getCircleRestVo().getIndex());
    }

    private QTCalRule getQTCalRule(List<QTCalRule> qtCalRules, QuotaContextStd contextstd, LocalDate endDate) {
        if (CollectionUtils.isEmpty(qtCalRules)) {
            return null;
        }
        for (QTCalRule qtCalRule : qtCalRules) {
            QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(endDate);
            if (!contextstd.getQuotaTypeId().equals(genConfig.getQtType().getId())) continue;
            return qtCalRule;
        }
        return null;
    }

    private String convertTypeKey(String type) {
        if (type.equals(WORK_AGE)) {
            return "socialWork";
        }
        if (type.equals(COMPANY_AGE)) {
            return "companyWork";
        }
        return type;
    }

    private List<QuotaChageDay> getQuotaChangeDay(EmployeeDateRecorder dateRecorder, String type, Date start, Date end) {
        if (dateRecorder == null) {
            return new ArrayList<QuotaChageDay>(16);
        }
        String newType = this.convertTypeKey(type);
        List<QuotaChageDay> quotaChageDays = dateRecorder.computeChangeDay(newType, start, end);
        if (!WTCCollections.isEmpty(quotaChageDays)) {
            quotaChageDays.forEach(quotaChageDay -> quotaChageDay.setType(type));
        }
        return quotaChageDays;
    }

    private int computeTypeAge(EmployeeDateRecorder dateRecorder, String type, Date date) {
        if (dateRecorder == null) {
            return 0;
        }
        type = this.convertTypeKey(type);
        return (int)dateRecorder.getTypeAgeInDate(type, date);
    }

    private void genByQuotaAttItem(QTCalRule qtCalRule, QTGenConfig genConfig, QuotaContextStd contextstd, List<QuotaAttItemValue> attItemValues, BigDecimal crossBoConversion) {
        Date periodstartDay;
        Date startDate = QuotaContextUtil.getBoStartDay(contextstd);
        startDate = startDate.compareTo(periodstartDay = contextstd.getCircleRestVo().getStartDate()) >= 0 ? startDate : periodstartDay;
        Date endDate = WTCDateUtils.toDate((LocalDate)contextstd.getChainDate());
        List<QTGenConfigEntry> entries = genConfig.getQtGenConfigEntries();
        if (CollectionUtils.isEmpty(entries)) {
            return;
        }
        QTConvertEnum qtConvertEnumOrg = genConfig.getConvertByOrg();
        Boolean transferOrgTag = genConfig.getTransferOrg();
        BigDecimal afterOrg = BigDecimal.ONE;
        Date orgChangDate = null;
        AttFileCabinet attFileCabinet = contextstd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        ArrayList<QuotaAttItemValue> orgAttItemValues = new ArrayList<QuotaAttItemValue>(16);
        if (QTGenTypeEnum.GEN_FIX == genConfig.getQtType().getqTGenTypeEnum()) {
            Map<String, Object> map = this.preOrgChangeAttItem(attFileCabinet, contextstd, qtConvertEnumOrg, genConfig, orgAttItemValues, crossBoConversion);
            afterOrg = (BigDecimal)map.get(ORG_AFTER_CONVERT);
            orgChangDate = (Date)map.get(ORG_CHANG_DATE);
        }
        if (CollectionUtils.isNotEmpty(orgAttItemValues)) {
            attItemValues.addAll(orgAttItemValues);
        }
        if (QTGenTypeEnum.GEN_FIX == genConfig.getQtType().getqTGenTypeEnum() && !transferOrgTag.booleanValue() && CollectionUtils.isNotEmpty(orgAttItemValues)) {
            return;
        }
        Date startDay = orgChangDate != null && startDate.before(orgChangDate) ? orgChangDate : startDate;
        this.genAttItem(contextstd, genConfig, attItemValues, startDay, afterOrg, qtCalRule, endDate, genConfig, crossBoConversion);
    }

    private void genAttItem(QuotaContextStd contextstd, QTGenConfig genConfig, List<QuotaAttItemValue> attItemValues, Date startDay, BigDecimal orgConvert, QTCalRule qtCalRule, Date endDay, QTGenConfig lastGenConfig, BigDecimal crossBoConversion) {
        PerNonTsProp perNonTsProp;
        QTConvertEnum qtConvertEnum = genConfig.getConvertByCondition();
        List<QTGenConfigEntry> entries = genConfig.getQtGenConfigEntries();
        AttendPersonData attendPersonData = (AttendPersonData)((Object)contextstd.getInitParam("ATT_PERINFO"));
        AttItemSpecData attItemSpecData = contextstd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttendPerson attendPerson = attendPersonData.getBid2AttendPersonMap().get(contextstd.getAttPersonId());
        Date startDate = contextstd.getCircleRestVo().getStartDate();
        Date endDate = contextstd.getCircleRestVo().getEndDate();
        EmployeeDateRecorder dateRecorder = null;
        AttendPersonModel attendPersonModel = QuotaContextUtil.getAttendPersonData(contextstd);
        if (attendPersonModel != null && attendPersonModel.getEmployee() != null) {
            long bid = attendPersonModel.getEmployee().getBid();
            dateRecorder = attendPersonData.getEmployeeDateRecorder(bid, contextstd.getChainDate());
        }
        Date birthDay = (perNonTsProp = attendPerson.getPerNonTsProp()) != null ? perNonTsProp.getBirthDay() : null;
        ArrayList<QuotaChageDay> chageDays = new ArrayList<QuotaChageDay>(16);
        List<QuotaChageDay> chageAgeDates = QTConditionsUtils.calculateChangeAge(birthDay, startDay, endDay, "age");
        if (!CollectionUtils.isEmpty(chageAgeDates)) {
            chageDays.addAll(chageAgeDates);
        }
        int startAge = QTConditionsUtils.calculateAge(birthDay, startDay);
        List<QuotaChageDay> chageWorkDates = this.getQuotaChangeDay(dateRecorder, WORK_AGE, startDay, endDay);
        if (!CollectionUtils.isEmpty(chageWorkDates)) {
            chageDays.addAll(chageWorkDates);
        }
        int startWorkAge = this.computeTypeAge(dateRecorder, WORK_AGE, startDay);
        Date employDay = null;
        if (attendPersonModel != null && attendPersonModel.getEmployee() != null) {
            employDay = attendPersonModel.getEmployee().getStartDate();
            if (logger.isDebugEnabled()) {
                logger.debug("\u7528\u5de5\u65e5\u671f" + WTCDateUtils.date2Str((Date)employDay, (String)"yyyy-MM-dd"));
            }
        }
        if (employDay == null) {
            return;
        }
        List<QuotaChageDay> chageEmployDates = this.getQuotaChangeDay(dateRecorder, COMPANY_AGE, startDay, endDay);
        if (!CollectionUtils.isEmpty(chageEmployDates)) {
            chageDays.addAll(chageEmployDates);
        }
        int startCmpAge = this.computeTypeAge(dateRecorder, COMPANY_AGE, startDay);
        chageDays = chageDays.stream().sorted(Comparator.comparing(QuotaChageDay::getChangeDate)).collect(Collectors.toList());
        Long workPlace = this.getWorkpalce(contextstd);
        Map<String, Object> paramMp = this.buidStartParamMp(startAge, startWorkAge, startCmpAge, workPlace);
        Map<String, Object> extParamMp = this.buidParamExtMp(contextstd);
        if (extParamMp != null) {
            paramMp.putAll(extParamMp);
        }
        QTConditionsUtils.getGenConfigConditionParam(contextstd, genConfig, paramMp);
        LinkedHashMap<String, List<QTGenConfigEntry>> curConditionMap = new LinkedHashMap<String, List<QTGenConfigEntry>>(2);
        LinkedHashMap<String, List<QTGenConfigEntry>> preConditionMap = new LinkedHashMap<String, List<QTGenConfigEntry>>(2);
        HashSet<String> paramSet = new HashSet<String>();
        List<QTGenConfigEntry> entriesConditions = this.getConditionEntry(chageDays, genConfig, paramMp, curConditionMap, preConditionMap, paramSet);
        List<String> changNames = chageDays.stream().filter(chageDay -> !"age".equals(chageDay.getType())).map(QuotaChageDay::getType).collect(Collectors.toList());
        String paramName = this.getCrossName(changNames, preConditionMap, curConditionMap);
        Date chageDate = this.getChangeDate(paramName, chageEmployDates, chageWorkDates);
        if (paramSet.contains(WORK_AGE) && (null == dateRecorder || CollectionUtils.isEmpty(dateRecorder.getSocialWorkDPListAsc()))) {
            String qtTypeName = genConfig.getQtType().getName();
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u751f\u6210\u5931\u8d25\uff0c\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"QTStandardDurationEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[]{qtTypeName}));
        }
        AtomicReference<Object> firstEntry = new AtomicReference<Object>();
        if (!CollectionUtils.isEmpty(curConditionMap)) {
            for (Map.Entry entry : curConditionMap.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
                firstEntry.set(((List)entry.getValue()).get(0));
                break;
            }
        } else if (!CollectionUtils.isEmpty(entriesConditions)) {
            firstEntry.set(entriesConditions.get(0));
        }
        HashMap<String, BigDecimal> map = new HashMap(2);
        if (genConfig.getGenCondition().booleanValue() && chageDate != null) {
            map = this.genPercent(qtConvertEnum, chageDate, startDate, endDate);
        }
        BigDecimal finalAfterOrg = orgConvert;
        Date finalChageDate = chageDate;
        QTGenConfigEntry preFirstEntry = null;
        QTGenConfigEntry curFirstEntry = null;
        if (!CollectionUtils.isEmpty(preConditionMap) && !StringUtils.isEmpty((String)paramName)) {
            preFirstEntry = this.getFirstEntry(preConditionMap, paramName);
        }
        if (!CollectionUtils.isEmpty(curConditionMap) && !StringUtils.isEmpty((String)paramName)) {
            curFirstEntry = this.getFirstEntry(curConditionMap, paramName);
        }
        boolean crossTag = false;
        if (preFirstEntry != null && curFirstEntry != null) {
            crossTag = preFirstEntry.getValue().compareTo(curFirstEntry.getValue()) != 0;
        }
        HashMap<String, BigDecimal> finalMap = map;
        AtomicBoolean isAllNoCondition = new AtomicBoolean(true);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd);
        List<QTLineDetail> qtLineDetails = this.getCurperiodLineDetail(contextstd, genConfig, attFileModel);
        ArrayList<QuotaAttItemValue> quotaAttItemValues = new ArrayList<QuotaAttItemValue>();
        for (int index = 0; index < entries.size(); ++index) {
            QTGenConfigEntry entry = entries.get(index);
            QTGenConfigEntry qtEntry = (QTGenConfigEntry)firstEntry.get();
            boolean conditionTag = this.isMultCondition(genConfig) ? this.checkMultCondition(entry, entriesConditions) : this.checkCondition(entry, qtEntry, preFirstEntry, curFirstEntry);
            QTGenConfigEntry qTGenConfigEntry = entry = !conditionTag && index + 1 == entries.size() ? entries.get(0) : entry;
            if (!conditionTag && index < entries.size() - 1 || !isAllNoCondition.get() && index == entries.size() - 1 && !conditionTag) continue;
            isAllNoCondition.set(false);
            Date changStartDate = null;
            Date changEndDate = null;
            if (QTGenTypeEnum.GEN_FIX == genConfig.getQtType().getqTGenTypeEnum()) {
                boolean isCross;
                BigDecimal value;
                BigDecimal bigDecimal = value = conditionTag ? entry.getValue() : BigDecimal.ZERO;
                if (genConfig.getGenCondition().booleanValue() && preFirstEntry != null && curFirstEntry != null) {
                    if (entry.equals(preFirstEntry)) {
                        if (!crossTag) continue;
                        changStartDate = startDay;
                        if (finalChageDate != null) {
                            changEndDate = WTCDateUtils.addDays((Date)finalChageDate, (int)-1);
                        }
                        if ((value = this.getPreCrossValue(genConfig, value, preFirstEntry, finalMap)) == null) {
                            continue;
                        }
                    } else if (crossTag && entry.equals(curFirstEntry)) {
                        changStartDate = finalChageDate;
                        changEndDate = endDay;
                        value = this.getCurCrossValue(genConfig, value, preFirstEntry, finalMap);
                    }
                }
                List<QuotaAttItemValue> curAttItemValues = this.genByFix(entry, qtCalRule, attItemSpecData, contextstd, genConfig, value, qtLineDetails, crossTag, endDay);
                quotaAttItemValues.addAll(curAttItemValues);
                if (CollectionUtils.isEmpty(curAttItemValues)) continue;
                boolean bl = isCross = crossTag && entry.equals(curFirstEntry) && genConfig.getGenCondition() != false;
                if (changEndDate != null) {
                    changEndDate = WTCDateUtils.getZeroDate((Date)changEndDate);
                }
                this.updateGenStartday(curAttItemValues, changStartDate, changEndDate, genConfig, isCross);
                attItemValues.addAll(curAttItemValues);
                continue;
            }
            List<QuotaAttItemValue> dyQuotaAttItemValues = this.genByDy(entry, qtCalRule, attItemSpecData, contextstd, genConfig, conditionTag, qtLineDetails, crossBoConversion);
            if (CollectionUtils.isEmpty(dyQuotaAttItemValues)) continue;
            dyQuotaAttItemValues.forEach(qt -> qt.getAttItemInstance().setOrgEndDay(contextstd.getChainDate()));
            attItemValues.addAll(dyQuotaAttItemValues);
        }
        if (!CollectionUtils.isEmpty(quotaAttItemValues)) {
            if (BigDecimal.ONE.compareTo(finalAfterOrg) != 0 || BigDecimal.ONE.compareTo(crossBoConversion) != 0) {
                this.upateVaule(lastGenConfig, genConfig, chageDate, quotaAttItemValues, startDay, endDay);
            }
            int periodNum = contextstd.getCircleRestVo().getIndex();
            String qtLineKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)genConfig.getQtType().getId(), (long)genConfig.getCycSet(), (long)periodNum);
            List qtUpdateLineDetails = (List)contextstd.getVariable(qtLineKey, VScope.LINE);
            quotaAttItemValues.forEach(qt -> {
                BigDecimal value = qt.getAttItemInstance().getItemValue();
                value = BigDecimal.ONE.compareTo(finalAfterOrg) != 0 ? value.multiply(finalAfterOrg) : value.multiply(crossBoConversion);
                QTGenConfigEntry entry = genConfig.getQtGenCfEntryByDetail(qt.getAttItemInstance().getQtDetailId());
                value = QuotaContextUtil.roundValue(contextstd, entry.getRoundRule(), value);
                this.upateLineDetail((QuotaAttItemValue)qt, value, startDay, endDay, startDate, endDate, qtUpdateLineDetails);
            });
        }
    }

    private void upateLineDetail(QuotaAttItemValue qt, BigDecimal value, Date startDay, Date endDay, Date startDate, Date endDate, List<QTLineDetail> qtUpdateLineDetails) {
        Date startBeginDay = WTCDateUtils.getDayBegin((Date)startDay);
        Date endBeginDay = WTCDateUtils.getDayBegin((Date)endDay);
        Date startBeginDayVo = WTCDateUtils.getDayBegin((Date)startDate);
        Date endBeginDayVo = WTCDateUtils.getDayBegin((Date)endDate);
        qt.getAttItemInstance().setItemValue(value);
        if ((startBeginDayVo.compareTo(startBeginDay) != 0 || endBeginDayVo.compareTo(endBeginDay) != 0) && qt.getAttItemInstance().getChangeEnd() == null) {
            qt.getAttItemInstance().setChangeSatrt(startDay);
            qt.getAttItemInstance().setChangeEnd(endDay);
        }
        if (CollectionUtils.isNotEmpty(qtUpdateLineDetails)) {
            for (int index = 0; index < qtUpdateLineDetails.size(); ++index) {
                QTLineDetail qtLineDetail = qtUpdateLineDetails.get(index);
                if (qtLineDetail.getBid() != qt.getAttItemInstance().getQtDetailId().longValue()) continue;
                qtLineDetail.setOwnValue(value);
                qtLineDetail.setGenValue(value);
                qtLineDetail.setGenStartDate(qt.getAttItemInstance().getGenStartDate());
            }
        }
    }

    private void upateVaule(QTGenConfig lastGenConfig, QTGenConfig genConfig, Date chageDate, List<QuotaAttItemValue> quotaAttItemValues, Date startDay, Date endDay) {
        QTConvertEnum convertByCondition = genConfig.getConvertByCondition();
        Boolean genCondition = lastGenConfig.getGenCondition();
        if (quotaAttItemValues.size() < 2) {
            return;
        }
        if (genCondition.booleanValue() && QTConvertEnum.CONVERT_NONE != convertByCondition) {
            BigDecimal sum = BigDecimal.ZERO;
            quotaAttItemValues.sort(Comparator.comparing(qt -> qt.getAttItemInstance().getChangeEnd()));
            for (QuotaAttItemValue qt2 : quotaAttItemValues) {
                sum = sum.add(qt2.getAttItemInstance().getItemValue());
            }
            Map<String, BigDecimal> map = this.genPercent(convertByCondition, chageDate, startDay, endDay);
            if (quotaAttItemValues.size() == 2) {
                quotaAttItemValues.get(0).getAttItemInstance().setItemValue(sum.multiply(map.get(PRE_KEY)));
                quotaAttItemValues.get(1).getAttItemInstance().setItemValue(sum.multiply(map.get(CURR_KEY)));
            }
        }
    }

    private String getCrossName(List<String> changNames, Map<String, List<QTGenConfigEntry>> preConditionMap, Map<String, List<QTGenConfigEntry>> curConditionMap) {
        block4: {
            block3: {
                if (CollectionUtils.isEmpty(changNames)) {
                    return "";
                }
                if (!CollectionUtils.isNotEmpty(curConditionMap) || !CollectionUtils.isNotEmpty(preConditionMap)) break block3;
                Set<String> curCrossName = curConditionMap.keySet();
                Set<String> preCrossName = preConditionMap.keySet();
                curCrossName.retainAll(preCrossName);
                for (String name : changNames) {
                    if (!curCrossName.contains(name)) continue;
                    return name;
                }
                break block4;
            }
            if (!CollectionUtils.isNotEmpty(curConditionMap)) break block4;
            for (String name : changNames) {
                if (!curConditionMap.containsKey(name)) continue;
                return name;
            }
        }
        return changNames.get(0);
    }

    private Date getChangeDate(String name, List<QuotaChageDay> chageEmployDates, List<QuotaChageDay> chageWorkDates) {
        if (COMPANY_AGE.equals(name) && !CollectionUtils.isEmpty(chageEmployDates)) {
            return chageEmployDates.get(0).getChangeDate();
        }
        if (WORK_AGE.equals(name) && !CollectionUtils.isEmpty(chageWorkDates)) {
            return chageWorkDates.get(0).getChangeDate();
        }
        return null;
    }

    private BigDecimal getPreCrossValue(QTGenConfig genConfig, BigDecimal value, QTGenConfigEntry preFirstEntry, Map<String, BigDecimal> finalMap) {
        if (genConfig.getConvertByCondition() == QTConvertEnum.CONVERT_NONE && genConfig.getConverTime() == QTConverTimeEnum.CONVERT_CHANGEDATE) {
            value = preFirstEntry.getValue();
        } else if (genConfig.getConvertByCondition() == QTConvertEnum.CONVERT_NONE && genConfig.getConverTime() == QTConverTimeEnum.CONVERT_GENDATE) {
            value = null;
        } else {
            BigDecimal conditionPrecent = finalMap.get(PRE_KEY);
            value = value.multiply(conditionPrecent);
        }
        return value;
    }

    private BigDecimal getCurCrossValue(QTGenConfig genConfig, BigDecimal value, QTGenConfigEntry preFirstEntry, Map<String, BigDecimal> finalMap) {
        if (genConfig.getConvertByCondition() == QTConvertEnum.CONVERT_NONE && genConfig.getConverTime() == QTConverTimeEnum.CONVERT_CHANGEDATE) {
            BigDecimal preValue = preFirstEntry.getValue();
            value = value.compareTo(preValue) <= 0 ? BigDecimal.ZERO : value.subtract(preValue);
        } else if (genConfig.getConvertByCondition() != QTConvertEnum.CONVERT_NONE || genConfig.getConverTime() != QTConverTimeEnum.CONVERT_GENDATE) {
            BigDecimal conditionPrecent = finalMap.get(CURR_KEY);
            value = value.multiply(conditionPrecent);
        }
        return value;
    }

    private void updateGenStartday(List<QuotaAttItemValue> quotaAttItemValues, Date changStartDate, Date changEndDate, QTGenConfig genConfig, boolean isCross) {
        for (QuotaAttItemValue quotaAttItemValue : quotaAttItemValues) {
            if (genConfig.getConverTime() == QTConverTimeEnum.CONVERT_CHANGEDATE && isCross) {
                quotaAttItemValue.getAttItemInstance().setGenStartDate(changStartDate);
            }
            quotaAttItemValue.getAttItemInstance().setChangeSatrt(changStartDate);
            quotaAttItemValue.getAttItemInstance().setChangeEnd(changEndDate);
        }
    }

    private Long getWorkpalce(QuotaContextStd contextstd) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd);
        AttendPersonModel attendPersonModel = QuotaContextUtil.getAttendPersonData(contextstd);
        EmpPosOrgRel empPosOrgRel = attendPersonModel.getEmpPosOrgRel();
        if (empPosOrgRel != null) {
            return empPosOrgRel.getWorkplace();
        }
        return 0L;
    }

    private boolean checkCondition(QTGenConfigEntry entry, QTGenConfigEntry qtEntry, QTGenConfigEntry finalPreFirstEntry, QTGenConfigEntry finalCurFirstEntry) {
        if (finalCurFirstEntry != null || finalPreFirstEntry != null) {
            return entry.equals(finalPreFirstEntry) || entry.equals(finalCurFirstEntry);
        }
        return entry.equals(qtEntry);
    }

    private boolean isMultCondition(QTGenConfig genConfig) {
        return QTGenTypeEnum.GEN_DYNAMIC == genConfig.getQtType().getqTGenTypeEnum() && genConfig.isGenDetails();
    }

    private boolean checkMultCondition(QTGenConfigEntry entry, List<QTGenConfigEntry> entriesConditions) {
        return entriesConditions.contains(entry);
    }

    private BigDecimal getPercent(QTConvertEnum qtConvertEnumOrg, Date orgStart, Date orgEnd, Date startDate, Date endDate) {
        BigDecimal percent = BigDecimal.ZERO;
        switch (qtConvertEnumOrg) {
            case CONVERT_DAY: {
                int days = WTCDateUtils.daysBetween((Date)startDate, (Date)endDate);
                int orgDays = WTCDateUtils.daysBetween((Date)orgStart, (Date)orgEnd);
                percent = BigDecimal.valueOf(++orgDays).divide(BigDecimal.valueOf(++days), 6, RoundingMode.HALF_UP);
                break;
            }
            case CONVERT_MONTH: {
                BigDecimal chageProMonth;
                BigDecimal periodProMonth;
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(endDate);
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(startDate);
                Calendar startOrgCalendar = Calendar.getInstance();
                startOrgCalendar.setTime(orgStart);
                Calendar endOrgCalendar = Calendar.getInstance();
                endOrgCalendar.setTime(orgEnd);
                int periodYear = endCalendar.get(1) - startCalendar.get(1);
                int periodMonth = periodYear * 12 + endCalendar.get(2) - startCalendar.get(2);
                int startDay = startCalendar.get(5);
                int startLastDay = startCalendar.getActualMaximum(5);
                int endDay = endCalendar.get(5);
                int endLastDay = endCalendar.getActualMaximum(5);
                if (periodMonth == 0) {
                    periodProMonth = BigDecimal.valueOf(endDay - startDay + 1).divide(BigDecimal.valueOf(endLastDay), 6, RoundingMode.HALF_UP);
                } else {
                    BigDecimal startProportion = BigDecimal.valueOf(startLastDay - startDay + 1).divide(BigDecimal.valueOf(startLastDay), 6, RoundingMode.HALF_UP);
                    BigDecimal endProportion = BigDecimal.valueOf(endDay).divide(BigDecimal.valueOf(endLastDay), 6, RoundingMode.HALF_UP);
                    periodProMonth = BigDecimal.valueOf(periodMonth - 1).add(startProportion).add(endProportion);
                }
                int chageYear = endOrgCalendar.get(1) - startOrgCalendar.get(1);
                int chageMonth = chageYear * 12 + endOrgCalendar.get(2) - startOrgCalendar.get(2);
                int startOrgDay = startOrgCalendar.get(5);
                int startOrgLastDay = startOrgCalendar.getActualMaximum(5);
                int endOrgDay = endOrgCalendar.get(5);
                int endOrgLastDay = endOrgCalendar.getActualMaximum(5);
                if (chageMonth == 0) {
                    chageProMonth = BigDecimal.valueOf(endOrgDay - startOrgDay + 1).divide(BigDecimal.valueOf(endOrgLastDay), 6, RoundingMode.HALF_UP);
                } else {
                    BigDecimal startOrgPro = BigDecimal.valueOf(startOrgLastDay - startOrgDay + 1).divide(BigDecimal.valueOf(startOrgLastDay), 6, RoundingMode.HALF_UP);
                    BigDecimal endOrgPro = BigDecimal.valueOf(endOrgDay).divide(BigDecimal.valueOf(endOrgLastDay), 6, RoundingMode.HALF_UP);
                    chageProMonth = BigDecimal.valueOf(chageMonth - 1).add(startOrgPro).add(endOrgPro);
                }
                percent = chageProMonth.divide(periodProMonth, 6, RoundingMode.HALF_UP);
                break;
            }
        }
        return percent;
    }

    private Map<String, BigDecimal> genPercent(QTConvertEnum qtConvertEnumOrg, Date chageDate, Date startDate, Date endDate) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(2);
        BigDecimal prePercent = BigDecimal.ZERO;
        BigDecimal afterPercent = BigDecimal.ONE;
        switch (qtConvertEnumOrg) {
            case CONVERT_DAY: 
            case CONVERT_MONTH: {
                prePercent = this.getPercent(qtConvertEnumOrg, startDate, WTCDateUtils.addDays((Date)chageDate, (int)-1), startDate, endDate);
                afterPercent = BigDecimal.ONE.subtract(prePercent);
                map.put(PRE_KEY, prePercent);
                map.put(CURR_KEY, afterPercent);
                break;
            }
            case CONVERT_NONE: {
                map.put(PRE_KEY, prePercent);
                map.put(CURR_KEY, afterPercent);
                break;
            }
        }
        return map;
    }

    private List<QuotaAttItemValue> genByFix(QTGenConfigEntry entry, QTCalRule qtCalRule, AttItemSpecData attItemSpecData, QuotaContextStd contextstd, QTGenConfig genConfig, BigDecimal value, List<QTLineDetail> qtLineDetailPols, boolean crosTag, Date endDay) {
        LocalDate endLocal;
        Date startDate = contextstd.getCircleRestVo().getStartDate();
        Date endDate = contextstd.getCircleRestVo().getEndDate();
        AttFileCabinet attFileCabinet = contextstd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        LocalDate chainDate = contextstd.getChainDate();
        endLocal = chainDate.isAfter(endLocal = WTCDateUtils.toLocalDate((Date)endDay)) ? endLocal : chainDate;
        Long curBoId = null;
        if (contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo() != null) {
            curBoId = contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId();
        }
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(contextstd.getAttPersonId(), endLocal, curBoId);
        Date noGenDate = this.getNoGenDate(contextstd, genConfig, attFileModel);
        List effectLists = qtLineDetailPols.stream().filter(qt -> qt.isEffect()).collect(Collectors.toList());
        boolean isNoGenDetails = false;
        if (noGenDate != null && startDate.compareTo(noGenDate) <= 0) {
            isNoGenDetails = true;
        }
        int periodNum = contextstd.getCircleRestVo().getIndex();
        if (WTCCollections.isEmpty(effectLists) && isNoGenDetails) {
            this.setGenCache(attFileModel, contextstd, qtCalRule, entry, genConfig, periodNum);
            return Collections.emptyList();
        }
        ArrayList<QuotaAttItemValue> list = new ArrayList<QuotaAttItemValue>(16);
        String periodAttribtion = contextstd.getCircleRestVo().getAssignDate();
        Long attItemId = entry.getResultAttItem();
        AttItemSpec starAttItemSpec = attItemSpecData.getByBidAndDate(attItemId, contextstd.getChainDate());
        String qtLineKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)genConfig.getQtType().getId(), (long)genConfig.getCycSet(), (long)periodNum);
        ArrayList<QTLineDetail> qtLineDetails = (ArrayList<QTLineDetail>)contextstd.getVariable(qtLineKey, VScope.LINE);
        QTLineDetail qtDetail = this.getQTLineDetail(qtLineDetailPols, genConfig, crosTag, (List<QTLineDetail>)qtLineDetails);
        qtDetail.setAttFileBoId(attFileModel.getBid());
        qtDetail.setOrgId(attFileModel.getOrgId().longValue());
        qtDetail.setAttFileVid(attFileModel.getId());
        qtDetail.setQtTypeId(genConfig.getQtType().getId());
        qtDetail.setpCycleId(genConfig.getCycSet());
        qtDetail.setPeriodNum(periodNum);
        qtDetail.setSource(QuotaDetailType.CUR_PERIOD_GEN.getCode());
        qtDetail.setGenStartDate(startDate);
        qtDetail.setGenEndDate(endDate);
        qtDetail.setGenValue(value);
        qtDetail.setOwnValue(value);
        QuotaAttItemInstance starQuotaAttItemInstance = new QuotaAttItemInstance(qtDetail.getBid(), starAttItemSpec, value, AttitemUnitEnum.of((String)starAttItemSpec.getUnit()), QuotaAttItemType.STANDARD, QuotaDetailType.CUR_PERIOD_GEN, genConfig.getQtType().getId(), genConfig.getCycSet(), periodNum, periodAttribtion);
        starQuotaAttItemInstance.setGenEndDate(endDate);
        starQuotaAttItemInstance.setGenStartDate(startDate);
        starQuotaAttItemInstance.setOrgEndDay(endLocal);
        starQuotaAttItemInstance.setAttFileBoId(attFileModel.getBid());
        starQuotaAttItemInstance.setAttFileVId(attFileModel.getId());
        QuotaAttItemValue starAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(starQuotaAttItemInstance)).build();
        starAttItemValue.setMatchedRule(qtCalRule);
        starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getId(), WTP_QTGENCONFIG));
        starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getCycSet(), "wtbd_cycset"));
        list.add(starAttItemValue);
        genConfig.putQtGenCfEntryByDetail(qtDetail.getBid(), entry);
        if (CollectionUtils.isEmpty((Collection)qtLineDetails)) {
            qtLineDetails = new ArrayList<QTLineDetail>(16);
            contextstd.setVariable(qtLineKey, qtLineDetails, VScope.LINE);
        }
        qtLineDetails.add(qtDetail);
        return list;
    }

    private QTLineDetail getQTLineDetail(List<QTLineDetail> qtLineDetails, QTGenConfig genConfig, boolean crosTag, List<QTLineDetail> curQtLineDetails) {
        List ids;
        long id = IDService.get().genLongId();
        QTLineDetail newQtDetail = new QTLineDetail();
        newQtDetail.setCreateTime(new Date());
        newQtDetail.setId(id);
        if (CollectionUtils.isEmpty(qtLineDetails) || qtLineDetails.size() > 1) {
            return newQtDetail;
        }
        if (crosTag && (genConfig.getConvertByCondition() != QTConvertEnum.CONVERT_NONE || genConfig.getConverTime() != QTConverTimeEnum.CONVERT_GENDATE)) {
            return newQtDetail;
        }
        QTLineDetail qtLineDetail = qtLineDetails.get(0);
        if (!CollectionUtils.isEmpty(curQtLineDetails) && (ids = curQtLineDetails.stream().map(QTLineDetail::getBid).collect(Collectors.toList())).contains(qtLineDetail.getBid())) {
            return newQtDetail;
        }
        qtLineDetail.rememberOriginalId();
        QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtLineDetail);
        qtLineDetail.setId(id);
        return qtLineDetail;
    }

    private List<QTLineDetail> getCurperiodLineDetail(QuotaContextStd context, QTGenConfig qtGenConfig, AttFileModel attFileModel) {
        ArrayList<QTLineDetail> qtLineDetails = new ArrayList<QTLineDetail>();
        int periodNum = context.getCircleRestVo().getIndex();
        Long attFileBoId = attFileModel.getBid();
        QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
        if (qtPoolHolder != null) {
            List<QTLineDetail> allQTLineDetails = qtPoolHolder.getQtPoolByFileBoId(attFileBoId, periodNum, qtGenConfig.getQtType().getId());
            for (QTLineDetail qtLineDetail : allQTLineDetails) {
                if (qtLineDetail.getpCycleId() != qtGenConfig.getCycSet() || !QuotaDetailType.CUR_PERIOD_GEN.getCode().equals(qtLineDetail.getSource())) continue;
                qtLineDetails.add(qtLineDetail);
            }
        }
        return qtLineDetails;
    }

    private List<QuotaAttItemValue> genByDy(QTGenConfigEntry qtGenConfigEntry, QTCalRule qtCalRule, AttItemSpecData attItemSpecData, QuotaContextStd contextstd, QTGenConfig genConfig, boolean conditionTag, List<QTLineDetail> qtLineDetailPools, BigDecimal crossBoConversion) {
        QTLineDetail qtDetail;
        Date createTime;
        List effectLists;
        ArrayList<QuotaAttItemValue> list = new ArrayList<QuotaAttItemValue>(16);
        Date startDate = contextstd.getCircleRestVo().getStartDate();
        Date endDate = contextstd.getCircleRestVo().getEndDate();
        int periodNum = contextstd.getCircleRestVo().getIndex();
        String periodAttribtion = contextstd.getCircleRestVo().getAssignDate();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd);
        Date noGenDate = this.getNoGenDate(contextstd, genConfig, attFileModel);
        boolean isNoGenDetails = false;
        if (noGenDate != null && startDate.compareTo(noGenDate) <= 0) {
            isNoGenDetails = true;
        }
        if (WTCCollections.isEmpty(effectLists = qtLineDetailPools.stream().filter(qt -> qt.isEffect()).collect(Collectors.toList())) && isNoGenDetails) {
            this.setGenCache(attFileModel, contextstd, qtCalRule, qtGenConfigEntry, genConfig, periodNum);
            return Collections.emptyList();
        }
        QTRoundPriorityEnum qtRoundPriorityEnum = qtGenConfigEntry.getRoundPriority();
        BigDecimal value = BigDecimal.ZERO;
        if (conditionTag) {
            value = AttRcordSummaryUtils.getAttRcordSummary(contextstd, qtGenConfigEntry.getAttItem(), startDate, endDate);
        }
        if ((createTime = (qtDetail = this.matchDyDetail(qtLineDetailPools, qtGenConfigEntry, genConfig)).getCreateTime()) == null && value.compareTo(BigDecimal.ZERO) == 0) {
            this.setGenCache(attFileModel, contextstd, qtCalRule, qtGenConfigEntry, genConfig, periodNum);
            return Collections.emptyList();
        }
        if (createTime == null) {
            qtDetail.setCreateTime(new Date());
        }
        qtDetail.rememberOriginalId();
        QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtDetail);
        qtDetail.setId(IDService.get().genLongId());
        qtDetail.setAttFileBoId(attFileModel.getBid());
        qtDetail.setOrgId(attFileModel.getOrgId().longValue());
        qtDetail.setAttFileVid(attFileModel.getId());
        qtDetail.setQtTypeId(genConfig.getQtType().getId());
        qtDetail.setpCycleId(genConfig.getCycSet());
        qtDetail.setPeriodNum(periodNum);
        qtDetail.setSource(QuotaDetailType.CUR_PERIOD_GEN.getCode());
        qtDetail.setGenStartDate(startDate);
        qtDetail.setGenEndDate(endDate);
        BigDecimal percent = qtGenConfigEntry.getPercent();
        Long attItemId = qtGenConfigEntry.getResultAttItem();
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attItemId, contextstd.getChainDate());
        if (QTRoundPriorityEnum.ROUND_BEFORE == qtRoundPriorityEnum) {
            value = QuotaContextUtil.roundValue(contextstd, qtGenConfigEntry.getRoundRule(), value);
            value = value.multiply(percent).multiply(crossBoConversion);
            value = value.divide(BigDecimal.valueOf(100L));
        } else {
            value = value.multiply(percent).multiply(crossBoConversion);
            value = value.divide(BigDecimal.valueOf(100L));
            value = QuotaContextUtil.roundValue(contextstd, qtGenConfigEntry.getRoundRule(), value);
        }
        BigDecimal maxValue = qtGenConfigEntry.getValue();
        genConfig.putQtGenCfEntryByDetail(qtDetail.getBid(), qtGenConfigEntry);
        BigDecimal outValue = BigDecimal.ZERO;
        if (value.compareTo(maxValue) > 0) {
            outValue = value.subtract(maxValue);
            QuotaAttItemInstance outQuotaAttItemInstance = new QuotaAttItemInstance(qtDetail.getBid(), attItemSpec, outValue, AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.EXCEEDING, QuotaDetailType.CUR_PERIOD_GEN, genConfig.getQtType().getId(), genConfig.getCycSet(), periodNum, periodAttribtion);
            outQuotaAttItemInstance.setGenEndDate(endDate);
            outQuotaAttItemInstance.setGenStartDate(startDate);
            outQuotaAttItemInstance.setStatus(QuotaAttItemStatus.LOSE_EFFECT);
            outQuotaAttItemInstance.setOrgEndDay(contextstd.getChainDate());
            outQuotaAttItemInstance.setAttFileVId(attFileModel.getId());
            outQuotaAttItemInstance.setAttFileBoId(attFileModel.getBid());
            QuotaAttItemValue outAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(outQuotaAttItemInstance)).build();
            outAttItemValue.setMatchedRule(qtCalRule);
            outAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getId(), WTP_QTGENCONFIG));
            value = maxValue;
            list.add(outAttItemValue);
        }
        QuotaAttItemInstance starQuotaAttItemInstance = new QuotaAttItemInstance(qtDetail.getBid(), attItemSpec, value, AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.STANDARD, QuotaDetailType.CUR_PERIOD_GEN, genConfig.getQtType().getId(), genConfig.getCycSet(), periodNum, periodAttribtion);
        starQuotaAttItemInstance.setGenEndDate(endDate);
        starQuotaAttItemInstance.setGenStartDate(startDate);
        starQuotaAttItemInstance.setAttFileVId(attFileModel.getId());
        starQuotaAttItemInstance.setAttFileBoId(attFileModel.getBid());
        starQuotaAttItemInstance.setOrgEndDay(contextstd.getChainDate());
        QuotaAttItemValue starAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(starQuotaAttItemInstance)).build();
        starAttItemValue.setMatchedRule(qtCalRule);
        starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getId(), WTP_QTGENCONFIG));
        starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getCycSet(), "wtbd_cycset"));
        list.add(starAttItemValue);
        String qtLineKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)genConfig.getQtType().getId(), (long)genConfig.getCycSet(), (long)periodNum);
        ArrayList<QTLineDetail> qtLineDetails = (ArrayList<QTLineDetail>)contextstd.getVariable(qtLineKey, VScope.LINE);
        if (CollectionUtils.isEmpty((Collection)qtLineDetails)) {
            qtLineDetails = new ArrayList<QTLineDetail>(16);
            contextstd.setVariable(qtLineKey, qtLineDetails, VScope.LINE);
        }
        qtDetail.setGenValue(value);
        qtDetail.setOwnValue(value);
        qtDetail.setNoUseGenValue(outValue);
        qtLineDetails.add(qtDetail);
        return list;
    }

    private void setGenCache(AttFileModel attFileModel, QuotaContextStd contextstd, QTCalRule qtCalRule, QTGenConfigEntry qtGenConfigEntry, QTGenConfig genConfig, long periodNum) {
        String qtLineKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)genConfig.getQtType().getId(), (long)genConfig.getCycSet(), (long)periodNum);
        String rule = "rule" + qtLineKey;
        String configEntry = "configEntry" + qtLineKey;
        if (contextstd.getVariable(rule, VScope.LINE) == null) {
            contextstd.setVariable(rule, qtCalRule, VScope.LINE);
            contextstd.setVariable(configEntry, qtGenConfigEntry, VScope.LINE);
        }
    }

    private Date getNoGenDate(QuotaContextStd contextstd, QTGenConfig genConfig, AttFileModel attFileModel) {
        EffectAttendPersonData effectAttendPersonData = contextstd.getInitParamMust("EFF_ATT_PERINFO", EffectAttendPersonData.class);
        Map<Long, EffectAttendPersonInfo> effectAttendPersonInfoMap = effectAttendPersonData.getEffectAttendPersonInfoMap();
        EffectAttendPersonInfo effectAttendPersonInfo = null;
        if (effectAttendPersonInfoMap != null) {
            effectAttendPersonInfo = effectAttendPersonInfoMap.get(contextstd.getAttPersonId());
        }
        return QTGenDateUtils.getNoGenBeforeDate(effectAttendPersonInfo, genConfig.getNoGenBeforeDate(), attFileModel, contextstd.getAttPersonId(), contextstd.getChainDate(), contextstd.getInitParams());
    }

    private QTLineDetail matchDyDetail(List<QTLineDetail> qtLineDetailPools, QTGenConfigEntry qtGenConfigEntry, QTGenConfig genConfig) {
        Long entryId = qtGenConfigEntry.getEntryBoId();
        Long attItem = qtGenConfigEntry.getAttItem();
        String conditionKey = entryId + ":" + attItem;
        if (!this.isMultCondition(genConfig)) {
            QTLineDetail qtDetail = new QTLineDetail();
            if (WTCCollections.isNotEmpty(qtLineDetailPools)) {
                List matchList = qtLineDetailPools.stream().filter(qt -> conditionKey.equals(qt.getGenConditionStr())).collect(Collectors.toList());
                qtDetail = WTCCollections.isNotEmpty(matchList) ? (QTLineDetail)matchList.get(0) : qtLineDetailPools.get(0);
            }
            return qtDetail;
        }
        if (CollectionUtils.isEmpty(qtLineDetailPools)) {
            QTLineDetail detail = new QTLineDetail();
            detail.setGenConditionStr(conditionKey);
            return detail;
        }
        List matchList = qtLineDetailPools.stream().filter(qt -> conditionKey.equals(qt.getGenConditionStr())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchList)) {
            QTLineDetail qtLineDetail = qtLineDetailPools.get(0);
            if (StringUtils.isEmpty((String)qtLineDetail.getGenConditionStr())) {
                qtLineDetail.setGenConditionStr(conditionKey);
                return qtLineDetail;
            }
            QTLineDetail detail = new QTLineDetail();
            detail.setGenConditionStr(conditionKey);
            return detail;
        }
        return (QTLineDetail)matchList.get(0);
    }

    private Map<String, Object> preOrgChangeAttItem(AttFileCabinet attFileCabinet, QuotaContextStd contextstd, QTConvertEnum qtConvertEnumOrg, QTGenConfig genConfig, List<QuotaAttItemValue> quotaAttItemValues, BigDecimal crossBoConversion) {
        Date periodStartDay;
        BigDecimal afterOrg = BigDecimal.ONE;
        HashMap<String, Object> orgMap = new HashMap<String, Object>(2);
        Date endDate = WTCDateUtils.toDate((LocalDate)contextstd.getChainDate());
        Date startDate = QuotaContextUtil.getBoStartDay(contextstd);
        startDate = startDate.compareTo(periodStartDay = contextstd.getCircleRestVo().getStartDate()) >= 0 ? startDate : periodStartDay;
        Boolean transferOrgTag = genConfig.getTransferOrg();
        Long curBoId = null;
        if (contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo() != null) {
            curBoId = contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId();
        }
        long lastCycSet = genConfig.getCycSet();
        List<TimeSeqBo<AttFileModel>> attFileModelList = attFileCabinet.getByAttPersonId(contextstd.getAttPersonId());
        if (transferOrgTag.booleanValue() && QTConvertEnum.CONVERT_NONE == qtConvertEnumOrg) {
            orgMap.put(ORG_AFTER_CONVERT, BigDecimal.ONE);
            return orgMap;
        }
        Set<LocalDate> localDates = this.orgChageDates(attFileModelList, WTCDateUtils.toLocalDate((Date)startDate), WTCDateUtils.toLocalDate((Date)endDate), curBoId);
        BigDecimal preOrgPercentSum = BigDecimal.ZERO;
        Date orgChangeDate = new Date();
        Date periodEndDay = contextstd.getCircleRestVo().getEndDate();
        boolean needGenAttItem = true;
        if (CollectionUtils.isNotEmpty(localDates)) {
            Date orgStartDay = startDate;
            List localDateList = localDates.stream().sorted().collect(Collectors.toList());
            for (int index = 0; index < localDateList.size(); ++index) {
                QTGenConfig genConfigOrg;
                List<QTCalRule> qtCalRules;
                QTCalRule qtCalRuleOrg;
                QTRule qtRule;
                AttFileModel attFileModelVersion;
                QTScheme qtScheme;
                Date nextOrgStart;
                LocalDate localDate = (LocalDate)localDateList.get(index);
                orgChangeDate = nextOrgStart = WTCDateUtils.toDate((LocalDate)localDate);
                Date orgEndDay = WTCDateUtils.addDays((Date)nextOrgStart, (int)-1);
                LocalDate orgCurEndLocal = WTCDateUtils.toLocalDate((Date)orgEndDay);
                if (index > 0) {
                    LocalDate preLocalDate = (LocalDate)localDateList.get(index - 1);
                    orgStartDay = WTCDateUtils.toDate((LocalDate)preLocalDate);
                }
                BigDecimal orgPercent = BigDecimal.ONE;
                if (transferOrgTag.booleanValue()) {
                    orgPercent = this.getPercent(qtConvertEnumOrg, orgStartDay, orgEndDay, periodStartDay, periodEndDay);
                    preOrgPercentSum = preOrgPercentSum.add(orgPercent);
                }
                if ((qtScheme = (attFileModelVersion = attFileCabinet.getByAttPersonIdAndDate(contextstd.getAttPersonId(), orgCurEndLocal, curBoId)).getAttQtPackage(orgCurEndLocal)) == null || (qtRule = QuotaRuleConfigUtils.getRuleConfig(contextstd, qtScheme, orgCurEndLocal)) == null || (qtCalRuleOrg = this.getQTCalRule(qtCalRules = qtRule.getQtRules(), contextstd, orgCurEndLocal)) == null || (genConfigOrg = (QTGenConfig)qtCalRuleOrg.getGenConfig().getVersionByDate(orgCurEndLocal)).getCycSet() != lastCycSet) continue;
                AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(contextstd.getAttPersonId(), orgCurEndLocal, curBoId);
                String ruleKey = "matchRuleLineVar" + attFileModel.getId();
                contextstd.setVariable(ruleKey, qtRule, VScope.LINE);
                if (needGenAttItem) {
                    this.genAttItem(contextstd, genConfigOrg, quotaAttItemValues, orgStartDay, orgPercent, qtCalRuleOrg, orgEndDay, genConfig, crossBoConversion);
                }
                if (transferOrgTag.booleanValue()) continue;
                needGenAttItem = false;
            }
            orgMap.put(ORG_CHANG_DATE, orgChangeDate);
            afterOrg = BigDecimal.ONE.compareTo(preOrgPercentSum) == 0 ? BigDecimal.ZERO : this.getPercent(qtConvertEnumOrg, orgChangeDate, endDate, periodStartDay, periodEndDay);
        }
        orgMap.put(ORG_AFTER_CONVERT, afterOrg);
        return orgMap;
    }

    private List<QTGenConfigEntry> getConditionEntry(List<QuotaChageDay> chageDays, QTGenConfig genConfig, Map<String, Object> paramMp, Map<String, List<QTGenConfigEntry>> curConditionMap, Map<String, List<QTGenConfigEntry>> preConditionMap, Set<String> paramSet) {
        ArrayList<QTGenConfigEntry> entriesConditions = new ArrayList<QTGenConfigEntry>(16);
        List<QTGenConfigEntry> entries = genConfig.getQtGenConfigEntries();
        entries.forEach(entry -> {
            Boolean curTag;
            RuleConditionInfo checkLimitConditions = entry.getReplaceConditionInfo();
            if (checkLimitConditions != null) {
                paramSet.addAll(checkLimitConditions.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toSet()));
            }
            if ((curTag = Boolean.valueOf(QTConditionsUtils.checkLimitConditions(checkLimitConditions, paramMp))).booleanValue()) {
                entriesConditions.add((QTGenConfigEntry)entry);
            }
        });
        if (!CollectionUtils.isEmpty(chageDays)) {
            for (QuotaChageDay chageDay : chageDays) {
                paramMp.put(chageDay.getType(), chageDay.getChangeValue());
                if (logger.isDebugEnabled()) {
                    logger.debug("condition param{}", (Object)JSON.toJSONString(paramMp));
                }
                entries.forEach(entry -> {
                    RuleConditionInfo ruleConditionInfo = entry.getReplaceConditionInfo();
                    Boolean curTag = QTConditionsUtils.checkLimitConditions(ruleConditionInfo, paramMp);
                    if (curTag.booleanValue() && !entriesConditions.contains(entry)) {
                        entriesConditions.add((QTGenConfigEntry)entry);
                    }
                    if (this.isChangeDay(genConfig, chageDay)) {
                        List<QTGenConfigEntry> qtGenConfigEntries;
                        paramMp.put(chageDay.getType(), chageDay.getChangeValue() - 1);
                        Boolean preTag = QTConditionsUtils.checkLimitConditions(ruleConditionInfo, paramMp);
                        paramMp.put(chageDay.getType(), chageDay.getChangeValue());
                        if (curTag.booleanValue() && !preTag.booleanValue()) {
                            qtGenConfigEntries = (ArrayList<QTGenConfigEntry>)curConditionMap.get(chageDay.getType());
                            if (CollectionUtils.isEmpty((Collection)qtGenConfigEntries)) {
                                qtGenConfigEntries = new ArrayList<QTGenConfigEntry>(entries.size());
                                curConditionMap.put(chageDay.getType(), qtGenConfigEntries);
                            }
                            qtGenConfigEntries.add((QTGenConfigEntry)entry);
                        }
                        if (preTag.booleanValue() && !curTag.booleanValue()) {
                            qtGenConfigEntries = (List)preConditionMap.get(chageDay.getType());
                            if (CollectionUtils.isEmpty((Collection)qtGenConfigEntries)) {
                                qtGenConfigEntries = new ArrayList(entries.size());
                                preConditionMap.put(chageDay.getType(), qtGenConfigEntries);
                            }
                            qtGenConfigEntries.add((QTGenConfigEntry)entry);
                        }
                    }
                });
            }
        }
        return entriesConditions;
    }

    private boolean isChangeDay(QTGenConfig genConfig, QuotaChageDay chageDay) {
        boolean isCanGenCondition;
        boolean genConditionTag = genConfig.getGenCondition();
        boolean bl = isCanGenCondition = QTGenTypeEnum.GEN_FIX == genConfig.getQtType().getqTGenTypeEnum() && genConditionTag;
        if (isCanGenCondition) {
            isCanGenCondition = COMPANY_AGE.equals(chageDay.getType()) || WORK_AGE.equals(chageDay.getType());
        }
        return isCanGenCondition;
    }

    private QTGenConfigEntry getFirstEntry(Map<String, List<QTGenConfigEntry>> conditionMap, String paramName) {
        QTGenConfigEntry qtGenConfigEntry = null;
        if (!CollectionUtils.isEmpty(conditionMap)) {
            if (!StringUtils.isEmpty((String)paramName)) {
                List<QTGenConfigEntry> entryList = conditionMap.get(paramName);
                if (!CollectionUtils.isEmpty(entryList)) {
                    qtGenConfigEntry = entryList.get(0);
                }
            } else {
                for (Map.Entry<String, List<QTGenConfigEntry>> entry : conditionMap.entrySet()) {
                    qtGenConfigEntry = entry.getValue().get(0);
                }
            }
        }
        return qtGenConfigEntry;
    }

    private Map<String, Object> buidStartParamMp(int startAge, int startWorkAge, int startCmpAge, Long workPlace) {
        HashMap paramMp = Maps.newHashMapWithExpectedSize((int)4);
        paramMp.put(COMPANY_AGE, startCmpAge);
        paramMp.put(WORK_AGE, startWorkAge);
        paramMp.put("age", startAge);
        paramMp.put("workplace.hbss_workplace.id", workPlace);
        return paramMp;
    }

    private Map<String, Object> buidParamExtMp(QuotaContextStd contextstd) {
        Map conditionInitMap;
        Object conditionObject;
        Long boId;
        if (contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo() != null) {
            boId = contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId();
        } else {
            AttFileCabinet attFileCabinet = contextstd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
            LocalDate chainDate = contextstd.getChainDate();
            AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(contextstd.getAttPersonId(), chainDate);
            boId = attFileModel.getBid();
        }
        Map<String, Object> map = new HashMap<String, Object>();
        Object object = contextstd.getInitParam("QT_EXT_PARAM");
        if (object instanceof Map && (conditionObject = (conditionInitMap = (Map)object).get("gen_condition_init")) instanceof QuotaGenConditionExt) {
            QuotaGenConditionExt conditionExtObject = (QuotaGenConditionExt)conditionObject;
            map = conditionExtObject.getConditionValue(boId, WTCDateUtils.toDate((LocalDate)contextstd.getChainDate()));
        }
        return map;
    }

    private Set<LocalDate> orgChageDates(List<TimeSeqBo<AttFileModel>> attFileModelList, LocalDate startdDate, LocalDate endDeta, Long curBoId) {
        HashSet<LocalDate> localDates = new HashSet<LocalDate>();
        ArrayList attFileModels = new ArrayList(16);
        attFileModelList.forEach(att -> {
            List models = att.getVersionsBetweenDate(startdDate, endDeta);
            if (curBoId != null && models != null) {
                models = models.stream().filter(attFileModel -> attFileModel.getBid() == curBoId.longValue()).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)models)) {
                attFileModels.addAll(models);
            }
        });
        logger.debug("orgChageDate attFileModels size{} ", (Object)attFileModels.size());
        for (int index = 1; index < attFileModels.size(); ++index) {
            Long orgId;
            Long preOrgId = ((AttFileModel)((Object)attFileModels.get(index - 1))).getAffiliateAdminOrgBid();
            if (preOrgId.equals(orgId = ((AttFileModel)((Object)attFileModels.get(index))).getAffiliateAdminOrgBid())) continue;
            LocalDate changeLocalDate = ((AttFileModel)((Object)attFileModels.get(index))).getTimeSeqInfo().getBsed();
            localDates.add(changeLocalDate);
        }
        return localDates;
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        return new QuotaDetailStandard(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
    }
}

