/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.overdraft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailOverdraw;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOverDrawTypeEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTOverdraftDurationEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTOverdraftDurationEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd, List<QuotaDataNodeStd> dataNodes) {
        LOG.debug("QTOverdraftDurationEvaluator doEvaluate start");
        if (CollectionUtils.isEmpty(dataNodes)) {
            LOG.debug("QTOverdraftDurationEvaluator not found dataNodes");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTOverdraftDurationEvaluator not found dataNodes"));
        }
        LinkedList<QuotaAttItemValue> quotaDataNodeList = new LinkedList<QuotaAttItemValue>();
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        ArrayList<QuotaAttItemValueStd> enjoyStds = new ArrayList<QuotaAttItemValueStd>(4);
        for (QuotaAttItemValueStd node : quotaAttStds) {
            QuotaAttItemInstance instance = node.getAttItemInstance();
            if (null == instance || !instance.getQuotaAttItemType().code.equals(QuotaAttItemType.DURATION_ENJOYMENT.code) || !node.isLeaf()) continue;
            enjoyStds.add(node);
        }
        if (CollectionUtils.isEmpty(enjoyStds)) {
            LOG.debug("QTOverdraftDurationEvaluator not found enjoy QuotaAttItemInstance");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTOverdraftDurationEvaluator not found enjoy QuotaAttItemInstance"));
        }
        for (QuotaAttItemValueStd enjoy : enjoyStds) {
            this.processOverdraftDuration(enjoy, quotaDataNodeList, contextStd);
        }
        QteGenExtPluginUtils.afterDoEvalua(contextStd, quotaDataNodeList, "over", QTOverdraftDurationEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void processOverdraftDuration(QuotaAttItemValueStd enjoy, List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd contextStd) {
        QuotaAttItemInstance enjoyInstance = enjoy.getAttItemInstance();
        QTCalRule qtCalRule = (QTCalRule)enjoy.getMatchedRule();
        AttFileCabinet attFileCabinet = contextStd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)enjoyInstance.getQttypeId(), (long)enjoyInstance.getPeriodcircleId(), (long)enjoyInstance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        if (qtCalRule == null || qtCalRule.getOverDraw() == null) {
            LOG.debug("QTOverdraftDurationEvaluator not found qtCalRule");
            return;
        }
        QTOverDraw qtOverConfig = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(enjoyInstance.getOrgEndDay());
        if (qtOverConfig == null) {
            LOG.debug("QTOverdraftDurationEvaluator not found OverDraw");
            return;
        }
        long roundRuleId = qtOverConfig.getRoundRule();
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec availableAttItemSpec = attItemSpecData.getByBidAndDate(qtOverConfig.getCanOdValue(), contextStd.getChainDate());
        AttItemSpec stdAttItemSpec = attItemSpecData.getByBidAndDate(qtOverConfig.getOriOverAttItem(), contextStd.getChainDate());
        long qtDetailId = enjoyInstance.getQtDetailId();
        BigDecimal roundResult = QuotaDetailType.BO_SETTLEMENT == enjoyInstance.getSource() ? this.inherit(qtOverConfig, enjoyInstance, qtDetails, qtCalRule, availableAttItemSpec, quotaDataNodeList) : this.curGeng(qtOverConfig, enjoyInstance, contextStd, qtCalRule, availableAttItemSpec, quotaDataNodeList);
        if (roundResult == null) {
            return;
        }
        BigDecimal finalItemValue = roundResult;
        if (CollectionUtils.isEmpty((Collection)qtDetails)) {
            LOG.warn("QTOverdraftDurationEvaluator qtlineDetail is Null");
            return;
        }
        qtDetails.forEach(qtLineDetail -> {
            if (qtLineDetail.getBid() == enjoyInstance.getQtDetailId().longValue()) {
                qtLineDetail.setCanBeOdValue(finalItemValue);
            }
        });
        if (!WTCCollections.isEmpty(quotaDataNodeList)) {
            QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, stdAttItemSpec, roundResult, AttitemUnitEnum.of((String)stdAttItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_STANDARD, enjoyInstance.getSource(), enjoyInstance.getQttypeId(), enjoyInstance.getPeriodcircleId(), enjoyInstance.getPeriodNum(), enjoyInstance.getPeriodAttribtion());
            stdInstance.setGenStartDate(enjoyInstance.getGenStartDate());
            stdInstance.setGenEndDate(enjoyInstance.getGenEndDate());
            stdInstance.setUseStartDate(enjoyInstance.getUseStartDate());
            stdInstance.setUseEndDate(enjoyInstance.getUseEndDate());
            stdInstance.setChangeSatrt(enjoyInstance.getChangeSatrt());
            stdInstance.setChangeEnd(enjoyInstance.getChangeEnd());
            stdInstance.setOrgEndDay(enjoyInstance.getOrgEndDay());
            stdInstance.setAttFileVId(enjoyInstance.getAttFileVId());
            stdInstance.setAttFileBoId(enjoyInstance.getAttFileBoId());
            QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(enjoy.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(qtOverConfig.getId(), "wtp_qtoverdraw"))).build();
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == enjoyInstance.getQtDetailId().longValue()) {
                    qtLineDetail.setOwnOdValue(finalItemValue);
                }
            });
            quotaDataNodeList.add(quotaSdtAttItemValue);
        }
    }

    private BigDecimal inherit(QTOverDraw qtOverConfig, QuotaAttItemInstance enjoyInstance, List<QTLineDetail> qtDetails, QTCalRule qtCalRule, AttItemSpec availableAttItemSpec, List<QuotaAttItemValue> quotaDataNodeList) {
        BigDecimal roundResult = null;
        long qtDetailId = enjoyInstance.getQtDetailId();
        for (QTLineDetail qtLineDetail : qtDetails) {
            if (qtLineDetail.getBid() != qtDetailId || BigDecimal.ZERO.compareTo(qtLineDetail.getCanBeOdValue()) >= 0) continue;
            roundResult = qtLineDetail.getCanBeOdValue();
        }
        if (roundResult == null) {
            return roundResult;
        }
        QuotaAttItemInstance instance = new QuotaAttItemInstance(qtDetailId, availableAttItemSpec, roundResult, AttitemUnitEnum.of((String)availableAttItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, enjoyInstance.getSource(), enjoyInstance.getQttypeId(), enjoyInstance.getPeriodcircleId(), enjoyInstance.getPeriodNum(), enjoyInstance.getPeriodAttribtion());
        instance.setChangeSatrt(enjoyInstance.getChangeSatrt());
        instance.setChangeEnd(enjoyInstance.getChangeEnd());
        instance.setOrgEndDay(enjoyInstance.getOrgEndDay());
        instance.setAttFileBoId(enjoyInstance.getAttFileBoId());
        instance.setAttFileVId(enjoyInstance.getAttFileVId());
        QuotaAttItemValue quotaAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(instance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(qtOverConfig.getId(), "wtp_qtoverdraw"))).build();
        if (null != quotaAttItemValue) {
            quotaAttItemValue.getAttItemInstance().setGenStartDate(enjoyInstance.getGenStartDate());
            quotaAttItemValue.getAttItemInstance().setGenEndDate(enjoyInstance.getGenEndDate());
            quotaAttItemValue.getAttItemInstance().setUseStartDate(enjoyInstance.getUseStartDate());
            quotaAttItemValue.getAttItemInstance().setUseEndDate(enjoyInstance.getUseEndDate());
            quotaDataNodeList.add(quotaAttItemValue);
        }
        return roundResult;
    }

    private BigDecimal curGeng(QTOverDraw qtOverConfig, QuotaAttItemInstance enjoyInstance, QuotaContextStd contextStd, QTCalRule qtCalRule, AttItemSpec availableAttItemSpec, List<QuotaAttItemValue> quotaDataNodeList) {
        BigDecimal roundResult;
        long qtDetailId = enjoyInstance.getQtDetailId();
        long roundRuleId = qtOverConfig.getRoundRule();
        QuotaAttItemValue quotaAttItemValue = null;
        if (QTOverDrawTypeEnum.OVER_FIX == qtOverConfig.getOverDrawType()) {
            roundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, qtOverConfig.getFixValue());
            QuotaAttItemInstance instance = new QuotaAttItemInstance(qtDetailId, availableAttItemSpec, roundResult, AttitemUnitEnum.of((String)availableAttItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, enjoyInstance.getSource(), enjoyInstance.getQttypeId(), enjoyInstance.getPeriodcircleId(), enjoyInstance.getPeriodNum(), enjoyInstance.getPeriodAttribtion());
            instance.setChangeSatrt(enjoyInstance.getChangeSatrt());
            instance.setChangeEnd(enjoyInstance.getChangeEnd());
            instance.setOrgEndDay(enjoyInstance.getOrgEndDay());
            instance.setAttFileVId(enjoyInstance.getAttFileVId());
            instance.setAttFileBoId(enjoyInstance.getAttFileBoId());
            quotaAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(instance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(qtOverConfig.getId(), "wtp_qtoverdraw"))).build();
        } else {
            if (qtOverConfig.getPercentValue().compareTo(BigDecimal.ZERO) <= 0) {
                LOG.debug("QTOverdraftDurationEvaluator illegal overdraw value");
                return null;
            }
            BigDecimal amount = enjoyInstance.getItemValue().multiply(qtOverConfig.getPercentValue()).multiply(BigDecimal.valueOf(0.01));
            roundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, amount);
            QuotaAttItemInstance instance = new QuotaAttItemInstance(qtDetailId, availableAttItemSpec, roundResult, AttitemUnitEnum.of((String)availableAttItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, enjoyInstance.getSource(), enjoyInstance.getQttypeId(), enjoyInstance.getPeriodcircleId(), enjoyInstance.getPeriodNum(), enjoyInstance.getPeriodAttribtion());
            instance.setChangeSatrt(enjoyInstance.getChangeSatrt());
            instance.setChangeEnd(enjoyInstance.getChangeEnd());
            instance.setOrgEndDay(enjoyInstance.getOrgEndDay());
            instance.setAttFileBoId(enjoyInstance.getAttFileBoId());
            instance.setAttFileVId(enjoyInstance.getAttFileVId());
            quotaAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(instance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(qtOverConfig.getId(), "wtp_qtoverdraw"))).build();
        }
        if (null != quotaAttItemValue) {
            quotaAttItemValue.getAttItemInstance().setGenStartDate(enjoyInstance.getGenStartDate());
            quotaAttItemValue.getAttItemInstance().setGenEndDate(enjoyInstance.getGenEndDate());
            quotaAttItemValue.getAttItemInstance().setUseStartDate(enjoyInstance.getUseStartDate());
            quotaAttItemValue.getAttItemInstance().setUseEndDate(enjoyInstance.getUseEndDate());
            quotaDataNodeList.add(quotaAttItemValue);
        }
        return roundResult;
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailOverdraw detailStandardGen = new QuotaDetailOverdraw(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        return detailStandardGen;
    }
}

