/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.overdraft;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.DeductEnv;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTOverdraftHandleEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTOverdraftHandleEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        Long qtTypeId;
        if (QTAccountModeHelper.isDeductChain((String)context.getRequest().getAccountMode())) {
            AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
            long attFileBoId = attFileModel.getBid();
            AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
            DeductEnv deductEnv = (DeductEnv)context.getInitParam("QT_DEDUCT_CHAIN_EVN");
            List<QTLineDetail> allLine = deductEnv.getLineDetailByFileBoId(attFileBoId);
            Map<Long, QTCalRule> line2CalRuleMap = deductEnv.handOverLineRuleMap(attFileBoId);
            List res = WTCCollections.modifiableEmptyList();
            for (QTLineDetail line : allLine) {
                if (!CheckUtils.isNonZeroNullAble((BigDecimal)line.getOwnOdValue())) continue;
                LocalDate lineEndDate = WTCDateUtils.toLocalDate((Date)line.getGenEndDate());
                QTCalRule matchedRule = line2CalRuleMap.get(line.getBid());
                QTOverDraw overConfig = (QTOverDraw)matchedRule.getOverDraw().getVersionByDate(lineEndDate);
                this.genCanBeOdItem(attItemSpecData, res, line, lineEndDate, matchedRule, overConfig);
                this.genUsedOdItem(attItemSpecData, res, line, lineEndDate, matchedRule, overConfig);
            }
            return QuotaDataResultStd.success(res);
        }
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDurationDeductionEvaluator not found dataNodes"));
        }
        List allAttStd = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        CircleRestVo circleRestVo = context.getCircleRestVo();
        LocalDate chainDate = context.getChainDate();
        AttFileCabinet attFileCabinet = (AttFileCabinet)context.getInitParam("ATT_FILE");
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        long attFileBoId = attFileModel.getBid();
        List qtLineDetails = (List)context.getVariable(DetailLogicKey.getIndexKey((long)attFileBoId, (long)(qtTypeId = context.getQuotaTypeId()), (long)circleRestVo.getCycSetId(), (long)circleRestVo.getIndex().intValue()), VScope.LINE);
        if (WTCCollections.isEmpty((Collection)qtLineDetails)) {
            LOG.warn("QTOverdraftHandleEvaluator not found qtLineDetails");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDurationDeductionEvaluator not found qtLineDetails"));
        }
        List overDraftAvailableStd = allAttStd.stream().filter(dataNode -> dataNode.isLeaf() && QuotaAttItemType.OVERDRAW_AVAILABLE == dataNode.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        ArrayList resItemValue = Lists.newArrayListWithCapacity((int)10);
        for (QTLineDetail applyRe : qtLineDetails) {
            if (this.isZero(applyRe.getUseOdValue())) continue;
            List overDraftAvailableParent = overDraftAvailableStd.stream().filter(std -> applyRe.getBid() == std.getAttItemInstance().getQtDetailId().longValue()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(overDraftAvailableParent)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u900f\u652f\u9879\u76ee\uff0c\u4e0d\u80fd\u53d1\u751f\u5df2\u900f\u3002", (String)"QTOverdraftHandleEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            QuotaAttItemValue canOdAttItemValue = ((QuotaAttItemValueStd)overDraftAvailableParent.get(0)).unwrapAndCopy();
            QuotaAttItemInstance attItemInstance = canOdAttItemValue.getAttItemInstance();
            QTCalRule qtCalRule = (QTCalRule)canOdAttItemValue.getMatchedRule();
            QTOverDraw overDraw = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(attItemInstance.getOrgEndDay());
            long canOdValue = overDraw.getCanOdValue();
            AttItemSpec canOdItemSpec = attItemSpecData.getByBidAndDate(canOdValue, chainDate);
            attItemInstance.setItemValue(applyRe.getCanBeOdValue());
            attItemInstance.setAttItemSpec(canOdItemSpec);
            attItemInstance.setUntil(AttitemUnitEnum.of((String)canOdItemSpec.getUnit()));
            attItemInstance.setQuotaAttItemType(QuotaAttItemType.OVERDRAW_AVAILABLE);
            canOdAttItemValue.setParentDataNodes(overDraftAvailableParent.stream().map(QuotaDataNodeStd.class::cast).collect(Collectors.toList()));
            resItemValue.add(canOdAttItemValue);
            long overOdValue = overDraw.getOverTimeAttItem();
            QuotaAttItemValue overOdAttItemValue = ((QuotaAttItemValueStd)overDraftAvailableParent.get(0)).unwrapAndCopy();
            QuotaAttItemInstance overAttItemInstance = overOdAttItemValue.getAttItemInstance();
            AttItemSpec overItemSpec = attItemSpecData.getByBidAndDate(overOdValue, chainDate);
            overAttItemInstance.setItemValue(applyRe.getUseOdValue());
            overAttItemInstance.setAttItemSpec(overItemSpec);
            overAttItemInstance.setUntil(AttitemUnitEnum.of((String)overItemSpec.getUnit()));
            overAttItemInstance.setQuotaAttItemType(QuotaAttItemType.OVERDRAWN);
            resItemValue.add(overOdAttItemValue);
        }
        return QuotaDataResultStd.success(resItemValue);
    }

    private void genUsedOdItem(AttItemSpecData attItemSpecData, List<QuotaAttItemValue> res, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, QTOverDraw overConfig) {
        if (CheckUtils.isNonZeroNullAble((BigDecimal)line.getUseOdValue())) {
            AttItemSpec useOdItemSpec = attItemSpecData.getByBidAndDate(overConfig.getOverTimeAttItem(), lineEndDate);
            QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), useOdItemSpec, line.getUseOdValue(), AttitemUnitEnum.of((String)useOdItemSpec.getUnit()), QuotaAttItemType.OVERDRAWN, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
            attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
            attItemInstance.setAttFileVId(line.getAttFileVid());
            attItemInstance.setAttFileBoId(line.getAttFileBoId());
            QuotaAttItemValue useOdDataNode = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(overConfig.getId(), "wtp_qtoverdraw"))).build();
            res.add(useOdDataNode);
        }
    }

    private void genCanBeOdItem(AttItemSpecData attItemSpecData, List<QuotaAttItemValue> res, QTLineDetail line, LocalDate lineEndDate, QTCalRule matchedRule, QTOverDraw overConfig) {
        if (CheckUtils.isNonZeroNullAble((BigDecimal)line.getCanBeOdValue())) {
            AttItemSpec canOdItemSpec = attItemSpecData.getByBidAndDate(overConfig.getCanOdValue(), lineEndDate);
            QuotaAttItemInstance attItemInstance = new QuotaAttItemInstance(line.getBid(), canOdItemSpec, line.getCanBeOdValue(), AttitemUnitEnum.of((String)canOdItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, QuotaDetailType.of(line.getSource()), line.getQtTypeId(), line.getpCycleId(), line.getPeriodNum(), " ", line.getGenStartDate(), line.getGenEndDate(), line.getUseStartDate(), line.getUseEndDate(), line.getCrossStartdate(), line.getCrossEnddate());
            attItemInstance.setStatus(QuotaAttItemStatus.of(line.getBusstatus()));
            attItemInstance.setAttFileVId(line.getAttFileVid());
            attItemInstance.setAttFileBoId(line.getAttFileBoId());
            QuotaAttItemValue canOdDataNode = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(attItemInstance)).matchedRule(matchedRule)).evaluationRule(EvaluationRuleModel.of(overConfig.getId(), "wtp_qtoverdraw"))).build();
            res.add(canOdDataNode);
        }
    }

    public boolean isZero(BigDecimal o1) {
        return null == o1 || BigDecimal.ZERO.compareTo(o1) == 0;
    }
}

