/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.exporter;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.tie.TieCalTaskDetail;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.model.QuotaEngineState;
import kd.wtc.wtes.business.quota.model.QuotaLineState;
import kd.wtc.wtes.business.quota.service.IQuotaLineExporter;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.std.AbstractQuotaExporter;
import kd.wtc.wtes.business.quota.std.QuotaLineExporterStdImpl;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaExporterStdImpl
extends AbstractQuotaExporter {
    private static final Log LOGGER = LogFactory.getLog(QuotaExporterStdImpl.class);
    private final QuotaEngineState engineState = new QuotaEngineState();
    private final AtomicInteger succeedAttSubjectCount = new AtomicInteger(0);
    private final AtomicInteger failAttSubjectCount = new AtomicInteger(0);
    private LocalDate requstStartDate;
    private LocalDate requstendDate;
    private List<AttPersonRange> attSubjects;
    private List<AttPersonRange> excludeBoList;
    private int excludeAttSubjectCount;
    private final AtomicInteger waitRunAttSubjectCount = new AtomicInteger(0);
    private final AtomicInteger succeedAttFileBoCount = new AtomicInteger(0);
    private final AtomicInteger failAttFileBoCount = new AtomicInteger(0);
    private int excludeAttFileBoCount;
    private final AtomicInteger waitRunAttFileBoCount = new AtomicInteger(0);
    private final Map<Long, String> personErrorMsg = new ConcurrentHashMap<Long, String>(16);
    private final StringBuffer alarmsBuffer = new StringBuffer();
    private boolean isStop = false;
    private final Map<Long, List<WTCCalTaskDetailEntity>> detailAccumulator = new ConcurrentHashMap<Long, List<WTCCalTaskDetailEntity>>(16);
    private QuotaMsgLevel level = QuotaMsgLevel.INFO;
    private static final int MAX_EXPORT_SIZE = 200;
    private Map<String, Object> initParams;
    private Set<Long> epRelDiscardAttFileBoIds;

    private WTCCalTaskDetailEntity newTaskDetail() {
        return new TieCalTaskDetail();
    }

    @Override
    public boolean loadInitParamsBeforeErrorOnLine() {
        return true;
    }

    @Override
    public void setInitParams(Map<String, Object> params) {
        this.initParams = params;
        this.epRelDiscardAttFileBoIds = this.initDiscardEpRelBoIds();
    }

    @Override
    public void setQuotaRequest(QuotaRequest request) {
        this.engineState.setTaskid(request.getTaskId());
        this.engineState.setSubTaskId(request.getSubTaskId());
        this.engineState.setVersion(request.getVersion());
        this.requstStartDate = request.getStartDate();
        this.requstendDate = request.getEndDate();
    }

    @Override
    public void setAttPersonRanges(List<AttPersonRange> attSubjects) {
        this.attSubjects = attSubjects;
        this.tryInitStaticsInfo();
    }

    @Override
    public void setAttExcludeSubjects(List<AttPersonRange> attExcludeSubjects) {
        this.excludeBoList = attExcludeSubjects;
        this.tryInitStaticsInfo();
    }

    @Override
    public IQuotaLineExporter newLineExporter(AttPersonRange attSubject) {
        return new QuotaLineExporterStdImpl(this, attSubject);
    }

    @Override
    public Map<Long, LocalDate> getLastQuotaDateMap() {
        return null;
    }

    @Override
    public Map<Long, LocalDate> getErrorDateMap() {
        return null;
    }

    @Override
    public List<WTCCalTaskDetailEntity> getResult() {
        return this.detailAccumulator.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    public void updateSubErrorResult(Set<Long> personIds, String errorMsg) {
        for (Long personId : personIds) {
            List<WTCCalTaskDetailEntity> wtcCalTaskDetailEntities = this.detailAccumulator.get(personId);
            if (null == wtcCalTaskDetailEntities) continue;
            this.failAttSubjectCount.incrementAndGet();
            this.succeedAttSubjectCount.decrementAndGet();
            for (WTCCalTaskDetailEntity entity : wtcCalTaskDetailEntities) {
                this.failAttFileBoCount.incrementAndGet();
                this.succeedAttFileBoCount.decrementAndGet();
                entity.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                entity.setExInfo(errorMsg);
            }
        }
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.alarmsBuffer.append((Object)msgLevel).append(':').append(msg).append(';');
        if (QuotaMsgLevel.ERROR == msgLevel) {
            this.level = msgLevel;
        }
        if (QuotaMsgLevel.WARNING == msgLevel && QuotaMsgLevel.INFO == this.level) {
            this.level = msgLevel;
        }
    }

    @Override
    protected void finishOneSubject(AttPersonRange attSubject) {
        LOGGER.debug(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u7684\u6d41\u6c34\u7ebf\u6267\u884c\u6210\u529f\uff0cattSubject={}\u3002", (String)"TieExporterStdImpl_3", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attSubject);
        this.succeedAttSubjectCount.incrementAndGet();
        this.waitRunAttSubjectCount.decrementAndGet();
        long attPersonId = attSubject.getPersonId();
        List detailList = this.detailAccumulator.computeIfAbsent(attPersonId, key -> new ArrayList(16));
        for (AttFileInfo attFileInfo : attSubject.getAttFileInfoList()) {
            WTCCalTaskDetailEntity detail = this.newTaskDetail();
            detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
            detail.setAttFileBoId(attFileInfo.getAttFileBaseBoId().longValue());
            WTCTaskDetailStatus taskDetailState = Boolean.FALSE.equals(attFileInfo.getLegal()) ? WTCTaskDetailStatus.FAIL : WTCTaskDetailStatus.SUCCESS;
            detail.setTaskDetailState(taskDetailState);
            if (Boolean.FALSE.equals(attFileInfo.getLegal())) {
                detail.setExInfo(attFileInfo.getMessage());
            }
            detail.setRealCalStartDate(attFileInfo.getStartDate());
            detail.setRealCalEndDate(attFileInfo.getEndDate());
            if (Boolean.TRUE.equals(attFileInfo.getLegal()) && this.getEpRelDiscardAttFileBoIds().contains(attFileInfo.getAttFileBaseBoId())) {
                detail.setExInfo((null != detail.getExInfo() ? detail.getExInfo() : "") + this.getRpRelDiscardMessage());
            }
            detailList.add(detail);
        }
        this.waitRunAttFileBoCount.decrementAndGet();
        this.succeedAttFileBoCount.incrementAndGet();
    }

    private String getRpRelDiscardMessage() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u6210\u529f\uff0c\u4f46\u662f\u8003\u52e4\u6863\u6848\u5bf9\u5e94\u7684\u6838\u5fc3\u4eba\u529b\u7684\u4efb\u804c\u7ecf\u5386\u5df2\u5220\u9664\uff0c\u8003\u52e4\u6863\u6848\u5173\u8054\u7684\u5c97\u4f4d\u4fe1\u606f\u4e0d\u51c6\u786e\uff0c\u5efa\u8bae\u8c03\u6574\u8003\u52e4\u6863\u6848\u7684\u5c97\u4f4d\u4fe1\u606f\u3002", (String)"QuotaExporterStdImpl_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
    }

    @Override
    protected void errorOneSubject(AttPersonRange attSubject) {
        this.failAttSubjectCount.incrementAndGet();
        this.waitRunAttSubjectCount.decrementAndGet();
        long attPersonId = attSubject.getPersonId();
        List detailList = this.detailAccumulator.computeIfAbsent(attPersonId, key -> new ArrayList(16));
        for (AttFileInfo attFileInfo : attSubject.getAttFileInfoList()) {
            WTCCalTaskDetailEntity detail = this.newTaskDetail();
            detail.setAttPersonId(attPersonId);
            detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
            detail.setAttFileBoId(attFileInfo.getAttFileBaseBoId().longValue());
            detail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
            detail.setRealCalStartDate(null);
            detail.setRealCalEndDate(null);
            detail.setExCode(null);
            String exInfo = this.personErrorMsg.get(attFileInfo.getPersonId());
            detail.setExInfo(exInfo);
            if (exInfo == null) {
                detail.setExInfo(ResManager.loadKDString((String)"\u8ba1\u7b97\u51fa\u9519\u3002\u3002", (String)"QuotaExporterStdImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            detailList.add(detail);
        }
        this.failAttFileBoCount.incrementAndGet();
        this.waitRunAttFileBoCount.decrementAndGet();
    }

    @Override
    protected void afterStateChanged(QuotaState oldState, QuotaState newState) {
        if (newState == QuotaState.SUCCESS || newState == QuotaState.ERROR || newState == QuotaState.TERMINATED) {
            List<WTCCalTaskDetailEntity> engineCauseFailDetailList;
            this.pushAllExcludeDetail2Accumulator();
            List<WTCCalTaskDetailEntity> detailList = this.getResult();
            WTCSubTaskStatus subTaskStatus = null;
            if (newState == QuotaState.SUCCESS) {
                subTaskStatus = WTCSubTaskStatus.FINISHED;
            } else if (newState == QuotaState.ERROR) {
                subTaskStatus = WTCSubTaskStatus.ERROR;
                this.failAttFileBoCount.addAndGet(this.waitRunAttFileBoCount.get());
                this.waitRunAttFileBoCount.set(0);
                this.failAttSubjectCount.addAndGet(this.waitRunAttSubjectCount.get());
                this.waitRunAttSubjectCount.set(0);
                engineCauseFailDetailList = this.getEngineCauseFailDetailList();
                detailList.addAll(engineCauseFailDetailList);
                LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u63a8\u8fdb\u5230\u9519\u8bef\u72b6\u6001\uff0c\u7531\u4e8e\u5f15\u64ce\u9519\u8bef\u5bfc\u81f4\u7b49\u5f85\u8ba1\u7b97\u5931\u8d25\u7684\u660e\u7ec6\uff1a{}\u3002", (String)"TieExporterStdImpl_6", (String)"wtc-wtes-business", (Object[])new Object[0]), engineCauseFailDetailList);
            } else if (newState == QuotaState.TERMINATED) {
                subTaskStatus = WTCSubTaskStatus.TERMINATED;
                this.failAttFileBoCount.addAndGet(this.waitRunAttFileBoCount.get());
                this.waitRunAttFileBoCount.set(0);
                this.failAttSubjectCount.addAndGet(this.waitRunAttSubjectCount.get());
                this.waitRunAttSubjectCount.set(0);
                engineCauseFailDetailList = this.getEngineCauseFailDetailList();
                detailList.addAll(engineCauseFailDetailList);
                LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u63a8\u8fdb\u5230\u7ec8\u6b62\u72b6\u6001\uff0c\u7531\u4e8e\u5f15\u64ce\u9519\u8bef\u5bfc\u81f4\u7b49\u5f85\u8ba1\u7b97\u5931\u8d25\u7684\u660e\u7ec6\uff1a{}\u3002", (String)"TieExporterStdImpl_7", (String)"wtc-wtes-business", (Object[])new Object[0]), engineCauseFailDetailList);
            }
            WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(detailList, (String)"wtte_qttie");
            QFilter countingStatus = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.ACCOUNTING.code);
            List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_qttie", (long)this.engineState.getTaskid(), (long)this.engineState.getSubTaskId(), (QFilter)countingStatus);
            wtcCalTaskDetailEntities.forEach(detail -> detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT));
            WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId((List)wtcCalTaskDetailEntities, (String)"wtte_qttie");
            Map stateMap = WTCTaskServiceHelper.taskDetailStateCount((String)"wtte_qttie", (long)0L, (long)this.engineState.getSubTaskId());
            WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
            subTask.setId(this.engineState.getSubTaskId().longValue());
            subTask.setTaskId(this.engineState.getTaskid());
            subTask.setSubTaskStatus(subTaskStatus);
            subTask.setStartDate(this.engineState.getBeginTime());
            subTask.setEndDate(this.engineState.getEndTime());
            subTask.setRefreshTime(this.engineState.getTaskStatusRefreshTime());
            subTask.setSucceedAttFile(((Integer)stateMap.get("succeedattfile")).intValue());
            subTask.setFailedAttFile(((Integer)stateMap.get("failedattfile")).intValue());
            subTask.setRunAttFile(subTask.getSucceedAttFile() + subTask.getFailedAttFile());
            subTask.setNotRunAttFile(((Integer)stateMap.get("notrunattfile")).intValue());
            subTask.setSucceedAttPerson(((Integer)stateMap.get("succeedattperson")).intValue());
            subTask.setFailedAttPerson(((Integer)stateMap.get("failedattperson")).intValue());
            subTask.setRunAttPerson(subTask.getSucceedAttPerson() + subTask.getFailedAttPerson());
            subTask.setNotRunAttPerson(((Integer)stateMap.get("notrunattperson")).intValue());
            boolean success = WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtte_qttie");
            if (!success) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\u3002", (String)"TieExporterStdImpl_8", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u5237\u65b0\u5b50\u4efb\u52a1\u4e0e\u660e\u7ec6\u5b8c\u6210\u3002", (String)"TieExporterStdImpl_9", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
    }

    public QuotaEngineState getEngineState() {
        return this.engineState;
    }

    public void pushQuotaSubjectErrorMsg(Long attPersonId, String msg) {
        if (msg.charAt(msg.length() - 1) == ';') {
            msg = msg.substring(0, msg.length() - 1);
        }
        this.personErrorMsg.put(attPersonId, msg);
    }

    public void addCacheLine(QuotaLineState tieLineState, QuotaState lineState) {
        if (QuotaMsgLevel.ERROR.name().equals(tieLineState.getMessageLevel())) {
            this.alarmsBuffer.append("pserson:").append(tieLineState.getAttPersonId()).append(' ');
            this.alarmsBuffer.append(tieLineState.getMessage());
        }
        if (lineState == QuotaState.TERMINATING || lineState == QuotaState.TERMINATED || this.isStop) {
            this.isStop = true;
            return;
        }
    }

    private void tryInitStaticsInfo() {
        if (this.excludeBoList == null || this.attSubjects == null) {
            return;
        }
        Map<Long, List<AttPersonRange>> excludeSubjectMap = this.excludeBoList.stream().collect(Collectors.groupingBy(AttPersonRange::getPersonId));
        Map<Long, AttPersonRange> allSubjectMap = this.attSubjects.stream().collect(Collectors.toMap(AttPersonRange::getPersonId, ele -> ele));
        HashSet<Long> excludeSubjectId = new HashSet<Long>(16);
        for (Map.Entry<Long, List<AttPersonRange>> entry : excludeSubjectMap.entrySet()) {
            Long attPersonId = entry.getKey();
            if (allSubjectMap.containsKey(attPersonId)) continue;
            excludeSubjectId.add(attPersonId);
            ++this.excludeAttSubjectCount;
        }
        this.waitRunAttSubjectCount.addAndGet(this.attSubjects.size());
        this.excludeAttFileBoCount = this.excludeBoList.size();
        this.waitRunAttFileBoCount.addAndGet(this.attSubjects.size());
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684BO\u6570\u91cf={}\uff1b", (String)"TieExporterStdImpl_14", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.excludeAttFileBoCount);
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53\u6570\u91cf={}\uff1b\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53ID\u96c6\u5408excludeSubjectId={}\u3002", (String)"TieExporterStdImpl_1", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.excludeAttSubjectCount, excludeSubjectId);
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53\u6570\u91cf={}\uff1b", (String)"TieExporterStdImpl_15", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.waitRunAttSubjectCount.get());
    }

    private List<WTCCalTaskDetailEntity> getEngineCauseFailDetailList() {
        if (this.attSubjects == null) {
            LOGGER.debug(ResManager.loadKDString((String)"\u4e0a\u62a5\u5668\u4e2d\u7684\u8003\u52e4\u4e3b\u4f53\u672a\u88ab\u521d\u59cb\u5316\uff0c\u5f15\u64ce\u53ef\u80fd\u5728\u521d\u59cb\u5316\u524d\u51fa\u73b0\u9519\u8bef\u3002", (String)"TieExporterStdImpl_10", (String)"wtc-wtes-business", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        ArrayList<WTCCalTaskDetailEntity> engineCauseFailDetailList = new ArrayList<WTCCalTaskDetailEntity>(this.attSubjects.size());
        for (AttPersonRange attSubject : this.attSubjects) {
            for (AttFileInfo attFileInfo : attSubject.getAttFileInfoList()) {
                WTCCalTaskDetailEntity detail = this.newTaskDetail();
                detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
                detail.setAttFileBoId(attFileInfo.getAttFileBaseBoId().longValue());
                detail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                detail.setRealCalStartDate(null);
                detail.setRealCalEndDate(null);
                detail.setExCode(null);
                if (this.alarmsBuffer.length() > 200) {
                    detail.setExInfo(this.alarmsBuffer.substring(0, 200) + "...");
                } else {
                    String exInfo = this.alarmsBuffer.toString();
                    if (exInfo.charAt(exInfo.length() - 1) == ';') {
                        exInfo = exInfo.substring(0, exInfo.length() - 1);
                    }
                    detail.setExInfo(exInfo);
                }
                if (detail.getExInfo() == null) {
                    detail.setExInfo(ResManager.loadKDString((String)"\u5f15\u64ce\u51fa\u9519\u3002", (String)"TieExporterStdImpl_11", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                engineCauseFailDetailList.add(detail);
            }
        }
        return engineCauseFailDetailList;
    }

    private void pushAllExcludeDetail2Accumulator() {
        if (null != this.excludeBoList) {
            for (AttPersonRange exBo : this.excludeBoList) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("AttPersonRange.getAttFileInfoList{}", (Object)JSON.toJSONString(exBo.getAttFileInfoList()));
                }
                if (CollectionUtils.isEmpty(exBo.getAttFileInfoList())) continue;
                for (AttFileInfo attFileInfo : exBo.getAttFileInfoList()) {
                    List detailList = this.detailAccumulator.computeIfAbsent(attFileInfo.getPersonId(), key -> new ArrayList(16));
                    WTCCalTaskDetailEntity detail = this.newTaskDetail();
                    detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
                    detail.setAttFileBoId(attFileInfo.getAttFileBaseBoId().longValue());
                    detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
                    if (!attFileInfo.getLegal().booleanValue()) {
                        detail.setExInfo(attFileInfo.getMessage());
                    }
                    detailList.add(detail);
                }
            }
        }
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    private Set<Long> initDiscardEpRelBoIds() {
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)10);
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap = attFileCabinet.getAttFileTimeSeqBoMap();
        for (List<TimeSeqBo<AttFileModel>> value : attFileTimeSeqBoMap.values()) {
            for (TimeSeqBo<AttFileModel> attFileSeq : value) {
                List attFileModels = attFileSeq.getVersionsBetweenDate(this.requstStartDate, this.requstendDate);
                for (AttFileModel attFileModel : attFileModels) {
                    if (!attFileModel.epRelStatusDiscard()) continue;
                    attFileBoIds.add(attFileModel.getTimeSeqInfo().getBid());
                }
            }
        }
        return attFileBoIds;
    }

    protected Set<Long> getEpRelDiscardAttFileBoIds() {
        return this.epRelDiscardAttFileBoIds;
    }
}

