/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTType;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.init.TieInitializerAttRecordDetailForQuota;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.model.QuotaCycSetData;
import kd.wtc.wtes.business.quota.model.QuotaQualityTypeEnums;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;

public class TieInitCycleSetForQuota
implements QuotaParamInitializer {
    private static final Log log = LogFactory.getLog(TieInitCycleSetForQuota.class);
    private boolean loadBill = true;
    private static final String ENTRY_PROP = String.join((CharSequence)",entryentity.", "entryentity.entrystartdate", "entryvatimeday", "entryvatimehour", "entrystartmethod", "entryenddate", "owndate", "entryvacationtype");
    private static final String VABILL_PROPERTIES = String.join((CharSequence)",", "parentid", "personid", "billno", "attfile", "attfilebasef7", ENTRY_PROP);
    private final HRBaseServiceHelper vaBaseServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");

    public void setLoadBill(boolean loadBill) {
        this.loadBill = loadBill;
    }

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        List<Long> regQtTypeIds;
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(new AttRecordDetailHolder());
        }
        log.debug("TieInitCycleSetForQuota_init_version\uff3f{}", (Object)initRequest.getRequest().getVersion());
        AttFileCabinet attFileCabinet = (AttFileCabinet)initRequest.getInitParams().get("ATT_FILE");
        RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)initRequest.getInitParams().get("RULE_ENGINE");
        ArrayList qtTypeIds = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        if (!CollectionUtils.isEmpty(dyQtTypeIds)) {
            qtTypeIds.addAll(dyQtTypeIds);
        }
        if (!CollectionUtils.isEmpty(regQtTypeIds = initRequest.getRequest().getRegQtTypeIds())) {
            qtTypeIds.addAll(regQtTypeIds);
        }
        if (attFileCabinet == null) {
            return null;
        }
        Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap = attFileCabinet.getAttFileTimeSeqBoMap();
        if (attFileTimeSeqBoMap == null) {
            return null;
        }
        HashSet<Long> cycleSet = new HashSet<Long>(16);
        HashSet<Long> cycDateSet = new HashSet<Long>(16);
        HashSet<Long> attItems = new HashSet<Long>(16);
        List<QTRule> rules = ruleEngineMetaData.getBusinessRuleMap().values().stream().filter(obj -> obj instanceof TimeSeqAvailableBo).map(obj -> ((TimeSeqAvailableBo)obj).getVersions()).flatMap(Collection::stream).filter(obj -> obj instanceof QTRule).map(obj -> (QTRule)obj).collect(Collectors.toList());
        this.buildCycSetParam(cycleSet, cycDateSet, attItems, rules, qtTypeIds);
        for (List<TimeSeqBo<AttFileModel>> value : attFileTimeSeqBoMap.values()) {
            value.forEach(timeSeqBo -> timeSeqBo.getVersions().stream().filter(Objects::nonNull).forEach(attFileModel -> attFileModel.getAttQtPackageList().stream().filter(Objects::nonNull).map(AttFileScheduleEntity::getEntity).filter(Objects::nonNull).map(TimeSeqBo::getVersions).filter(Objects::nonNull).flatMap(Collection::stream).forEach(qtScheme -> {
                TimeSeqAvailableBo<QTRule> rule = qtScheme.getQtRule();
                if (rule == null) {
                    return;
                }
                List qtRules = rule.getVersions();
                this.buildCycSetParam(cycleSet, cycDateSet, attItems, qtRules, qtTypeIds);
            })));
        }
        DynamicObject[] cycleArr = new HRBaseServiceHelper("wtbd_cycset").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", cycleSet)});
        HashMap<Long, DynamicObject> cycleMap = new HashMap<Long, DynamicObject>(cycleArr.length);
        for (DynamicObject dynamicObject : cycleArr) {
            cycleMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        DynamicObject[] cycleDateArr = new HRBaseServiceHelper("wtbd_cycdateset").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", cycDateSet)});
        HashMap<Long, DynamicObject> cycleDateMap = new HashMap<Long, DynamicObject>(cycleDateArr.length);
        for (DynamicObject dynamicObject : cycleDateArr) {
            cycleDateMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        QuotaCycSetData quotaCycSetData = QuotaCycSetData.of(initRequest, cycleMap, cycleDateMap);
        Map<String, QuotaCycInfo> cycSetData = quotaCycSetData.getCycSetDataNew();
        AttRecordDetailHolder detailHolder = new AttRecordDetailHolder();
        detailHolder.setCycSetMap(cycSetData);
        TieInitializerAttRecordDetailForQuota initAttRecord = TieInitializerAttRecordDetailForQuota.of(attItems, detailHolder, initRequest);
        detailHolder.setAttRecordDetailTable(initAttRecord.doInit());
        if (cycSetData != null && this.loadBill) {
            ArrayList<DetailLogicKey> detailLogicKeys = new ArrayList<DetailLogicKey>(cycSetData.size());
            HashMap<String, DetailLogicKey> indexMap = new HashMap<String, DetailLogicKey>(cycSetData.size());
            HashMap attSubjectEndDateMap = Maps.newHashMapWithExpectedSize((int)initRequest.getAttSubjects().size());
            HashMap fileBoWithPersonIdMap = Maps.newHashMapWithExpectedSize((int)16);
            for (AttPersonRange attPersonRange : initRequest.getAttSubjects()) {
                attPersonRange.getAttFileInfoList().forEach(attFileInfo -> {
                    attSubjectEndDateMap.put(attFileInfo.getAttFileBaseBoId(), attFileInfo.getEndDate());
                    fileBoWithPersonIdMap.put(attFileInfo.getAttFileBaseBoId(), attFileInfo.getPersonId());
                });
                if (attPersonRange.getPreAttFileInfo() == null) continue;
                attSubjectEndDateMap.put(attPersonRange.getPreAttFileInfo().getAttFileBaseBoId(), attPersonRange.getPreAttFileInfo().getEndDate());
                fileBoWithPersonIdMap.put(attPersonRange.getPreAttFileInfo().getAttFileBaseBoId(), attPersonRange.getPreAttFileInfo().getPersonId());
            }
            for (Map.Entry entry : cycSetData.entrySet()) {
                QuotaCycInfo quotaCycInfo = (QuotaCycInfo)entry.getValue();
                if (!quotaCycInfo.isSuccessFlag()) continue;
                Date date = (Date)attSubjectEndDateMap.get(QuotaCycSetData.getPersonId((String)entry.getKey()));
                for (CircleRestVo restVo : quotaCycInfo.getRestVos()) {
                    AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate((long)((Long)fileBoWithPersonIdMap.get(QuotaCycSetData.getPersonId((String)entry.getKey()))), date.before(restVo.getEndDate()) ? WTCDateUtils.toLocalDate((Date)date) : WTCDateUtils.toLocalDate((Date)restVo.getEndDate()));
                    if (null == attFileModel) continue;
                    DetailLogicKey detailLogicKey = new DetailLogicKey(attFileModel.getBid(), QuotaCycSetData.getQtTypeId((String)entry.getKey()), restVo.getCycSetId().longValue(), restVo.getIndex().intValue());
                    detailLogicKeys.add(detailLogicKey);
                    indexMap.put(detailLogicKey.getIndexKey(), detailLogicKey);
                }
            }
            Map detailLogicKeyListMap = QTDealRecordDBService.loadBillInfo(detailLogicKeys);
            ConcurrentHashMap<Long, Map<DetailLogicKey, List<QTBillDeal>>> concurrentHashMap = new ConcurrentHashMap<Long, Map<DetailLogicKey, List<QTBillDeal>>>(16);
            for (Map.Entry entry : detailLogicKeyListMap.entrySet()) {
                DetailLogicKey logicKey = (DetailLogicKey)entry.getKey();
                Map detailMap = concurrentHashMap.computeIfAbsent(logicKey.getAttFileBoId(), key -> new HashMap(16));
                detailMap.put(logicKey, entry.getValue());
            }
            detailHolder.setDetailLogicKeyListMap(concurrentHashMap);
            detailHolder.setIndexMap(indexMap);
            if (WTCCollections.isNotEmpty((Map)detailLogicKeyListMap)) {
                ArrayList billIds = Lists.newArrayListWithExpectedSize((int)detailLogicKeyListMap.size());
                detailLogicKeyListMap.values().forEach(qtBills -> qtBills.forEach(qtBill -> billIds.add(qtBill.getBillId())));
                List<BillApply> list = this.queryBillApplies(billIds);
                Map<Long, BillApply> billApplyMap = list.stream().collect(Collectors.toMap(BillApply::getId, Function.identity()));
                detailHolder.setBillApplyMap(billApplyMap);
            }
        }
        return QuotaInitParamResult.success(detailHolder);
    }

    private void buildCycSetParam(Set<Long> cycleSet, Set<Long> cycDateSet, Set<Long> attItems, List<QTRule> qtRules, List<Long> qtTypeIds) {
        for (QTRule version : qtRules) {
            for (QTCalRule qtRule : version.getQtRules()) {
                if (null == qtRule.getGenConfig()) continue;
                boolean calculateItem = false;
                for (QTGenConfig qtGenConfig : qtRule.getGenConfig().getVersions()) {
                    QTType qtType = qtGenConfig.getQtType();
                    if (!qtTypeIds.contains(qtType.getId())) continue;
                    calculateItem = true;
                    cycleSet.add(qtGenConfig.getCycSet());
                    cycDateSet.add(qtGenConfig.getCycDateSet());
                    if (CollectionUtils.isEmpty(qtGenConfig.getQtGenConfigEntries())) continue;
                    attItems.addAll(qtGenConfig.getQtGenConfigEntries().stream().map(QTGenConfigEntry::getAttItem).collect(Collectors.toSet()));
                    attItems.addAll(this.getGenEntryQlfAttItem(qtGenConfig));
                }
                if (null != qtRule.getGenQualification() && calculateItem) {
                    for (QTQualification qualification : qtRule.getGenQualification().getVersions()) {
                        attItems.addAll(this.getAttItems(qualification).stream().filter(info -> 0L != info).collect(Collectors.toSet()));
                    }
                }
                if (null != qtRule.getUseQualification() && calculateItem) {
                    for (QTQualification qualification : qtRule.getUseQualification().getVersions()) {
                        attItems.addAll(this.getAttItems(qualification).stream().filter(info -> 0L != info).collect(Collectors.toSet()));
                    }
                }
                if (null != qtRule.getOverQualification() && calculateItem) {
                    for (QTQualification qualification : qtRule.getOverQualification().getVersions()) {
                        attItems.addAll(this.getAttItems(qualification).stream().filter(info -> 0L != info).collect(Collectors.toSet()));
                    }
                }
                if (null == qtRule.getCarryQualification() || !calculateItem) continue;
                for (QTQualification qualification : qtRule.getCarryQualification().getVersions()) {
                    attItems.addAll(this.getAttItems(qualification).stream().filter(info -> 0L != info).collect(Collectors.toSet()));
                }
            }
        }
    }

    private Set<Long> getGenEntryQlfAttItem(QTGenConfig qtGenConfig) {
        HashSet<Long> attItems = new HashSet<Long>();
        Set sets = qtGenConfig.getQtGenConfigEntries().stream().map(QTGenConfigEntry::getQtQualification).collect(Collectors.toSet());
        ArrayList qtQualifications = new ArrayList();
        sets.stream().filter(qtqualification -> qtqualification != null).forEach(qtqualification -> qtQualifications.addAll(qtqualification.getVersions()));
        for (QTQualification qtQualification : qtQualifications) {
            attItems.addAll(this.getAttItems(qtQualification));
        }
        return attItems;
    }

    private Set<Long> getAttItems(QTQualification qualification) {
        String qualityType = qualification.getQualityType();
        HashSet attitems = Sets.newHashSet();
        if (QuotaQualityTypeEnums.LIMIT_PROJECT.getCode().equals(qualityType)) {
            RuleConditionInfo ruleConditionInfo = qualification.getRuleConditionInfo();
            if (ruleConditionInfo == null) {
                return attitems;
            }
            List conditionInfos = ruleConditionInfo.getConditionList();
            conditionInfos.forEach(conditionInfo -> {
                String param = conditionInfo.getParam();
                try {
                    attitems.add(Long.valueOf(param));
                }
                catch (Exception ex) {
                    log.warn("{} String to Log  error ", (Object)param);
                }
            });
        }
        return attitems;
    }

    @Override
    public String category() {
        return "QT_ATT_RECORD_DETAIL";
    }

    public List<BillApply> queryBillApplies(List<Long> billIds) {
        ArrayList billApplies = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(billIds)) {
            QFilter idFilter = new QFilter("id", "in", (Object)billIds.toArray());
            QFilter statusFilter = new QFilter("billstatus", "in", Arrays.asList("B", "D"));
            DynamicObject[] billApplyDyns = this.vaBaseServiceHelper.query(VABILL_PROPERTIES + "," + "isdisposable", new QFilter[]{idFilter, statusFilter});
            Arrays.stream(billApplyDyns).forEach(billDyn -> billApplies.add(TieInitCycleSetForQuota.generateBillApply(billDyn)));
        }
        return billApplies;
    }

    public static BillApply generateBillApply(DynamicObject billDy) {
        BillApply billApply = TieInitCycleSetForQuota.getBillApply(billDy);
        DynamicObjectCollection entryEntities = billDy.getDynamicObjectCollection("entryentity");
        ArrayList billApplyEntries = Lists.newArrayListWithCapacity((int)entryEntities.size());
        for (DynamicObject dyObject : entryEntities) {
            BigDecimal valDay = dyObject.getBigDecimal("entryvatimeday");
            BigDecimal valHour = dyObject.getBigDecimal("entryvatimehour");
            String startMethod = dyObject.getString("entrystartmethod");
            Date startDate = dyObject.getDate("entrystartdate");
            Date endDate = dyObject.getDate("entryenddate");
            Date ownDate = dyObject.getDate("owndate");
            String vacationType = dyObject.getString("entryvacationtype.name");
            BillApplyEntry billApplyEntry = new BillApplyEntry();
            if (WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(startMethod)) {
                billApplyEntry.setStartDate(ownDate);
                billApplyEntry.setEndDate(ownDate);
            } else {
                billApplyEntry.setStartDate(startDate);
                billApplyEntry.setEndDate(endDate);
            }
            billApplyEntry.setVaTimeDay(valDay);
            billApplyEntry.setVaTimeHour(valHour);
            billApplyEntry.setVacationType(vacationType);
            billApplyEntry.setEntryId(dyObject.getLong("id"));
            billApplyEntry.setDisposable(dyObject.getBoolean("isdisposable"));
            billApplyEntries.add(billApplyEntry);
        }
        billApply.setEntryEntities((List)billApplyEntries);
        return billApply;
    }

    private static BillApply getBillApply(DynamicObject billDy) {
        BillApply billApply = new BillApply();
        long billId = billDy.getLong("id");
        long parentBillId = billDy.getLong("parentid");
        long personId = billDy.getLong("personid.id");
        String billNo = billDy.getString("billno");
        long attFileBoId = billDy.getLong("attfile.boid");
        long attFileVid = billDy.getLong("attfilebasef7.id");
        billApply.setBillNo(billNo);
        billApply.setId(billId);
        billApply.setAttFileBoId(attFileBoId);
        billApply.setAttFileVId(attFileVid);
        billApply.setPersonId(personId);
        billApply.setParentId(parentBillId);
        return billApply;
    }
}

