/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.deduction.BillCalResult;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.billcal.IBillCalService;
import kd.wtc.wtes.business.billcal.va.VaBillCalService;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.quotacal.va.QuotaCalBatchReq;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.init.TieInitCycleSetForQuota;
import kd.wtc.wtes.business.quota.model.DeductEnv;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.calculate.model.QTType;
import kd.wtc.wtp.business.cumulate.trading.DateRange;
import kd.wtc.wtp.business.cumulate.trading.QTBillOuterService;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTDeductService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class TieInitDeductChainEvnForQuota
implements QuotaParamInitializer {
    private static final Log log = LogFactory.getLog(TieInitDeductChainEvnForQuota.class);
    private static final String ENTRY_PROP = String.join((CharSequence)",entryentity.", "entryentity.entrystartdate", "entryvatimeday", "entryvatimehour", "entrystartmethod", "entryenddate", "owndate", "entryvacationtype");
    private static final String VABILL_PROPERTIES = String.join((CharSequence)",", "parentid", "personid", "billno", "attfile", "attfilebasef7", ENTRY_PROP);

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        if (!QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(new DeductEnv());
        }
        return this.doInit(initRequest);
    }

    private QuotaInitParamResult doInit(QuotaInitParamRequest initRequest) {
        long existedBills;
        long billId = initRequest.getRequest().getComputingBillId();
        BillApply tarBill = null;
        if (billId != 0L) {
            HRBaseServiceHelper vaBaseServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");
            QFilter idFilter = new QFilter("id", "=", (Object)billId);
            QFilter statusFilter = new QFilter("billstatus", "in", (Object)WTCCollections.modifiableList((Object[])new String[]{"C"}));
            DynamicObject[] billApplyDyns = vaBaseServiceHelper.query(VABILL_PROPERTIES + "," + "isdisposable", new QFilter[]{idFilter, statusFilter});
            if (billApplyDyns.length != 0) {
                tarBill = TieInitCycleSetForQuota.generateBillApply(billApplyDyns[0]);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u636e[id=%s]\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u7ec8\u6b62\u672c\u6b21\u5355\u636e\u6838\u7b97\u3002", (String)"TieInitDeductChainEvnForQuota_1", (String)"wtc-wtes-business", (Object[])new Object[]{billId}));
            }
        }
        LocalDate allSubjectMinStartDate = initRequest.getStartDate();
        LocalDate allSubjectMaxEndDate = initRequest.getEndDate();
        LinkedHashMap personInfo = Maps.newLinkedHashMapWithExpectedSize((int)16);
        initRequest.getAttSubjects().forEach(item -> item.getAttFileInfoList().forEach(attFileInfo -> personInfo.put(attFileInfo.getAttFileBaseBoId(), attFileInfo.getPersonId())));
        IBillCalService vaBillCalService = (IBillCalService)WTCAppContextHelper.getBean(VaBillCalService.class);
        QuotaCalBatchReq quotaReq = new QuotaCalBatchReq().setBillIds(Collections.emptyList()).setLoggingProcess(false).setPersonInfos(personInfo).setStartDate(allSubjectMinStartDate).setEndDate(allSubjectMaxEndDate);
        quotaReq.setTiePlanId(initRequest.getRequest().getTiePlanId());
        quotaReq.setInitParams(null);
        BillCalResult billCalResult = vaBillCalService.calBillDeductionBatch(quotaReq);
        List calBillList = billCalResult.getCalcBillApplies();
        log.info("TieInitDeductChainEvnForQuota calBill:{}", calBillList.stream().map(BillApply::getBillNo).collect(Collectors.toList()));
        calBillList.addAll(this.initChangeIllegalBillAndNotCountAuditBill(initRequest, allSubjectMinStartDate, allSubjectMaxEndDate, calBillList));
        Map failAttFileMap = WTCCollections.isEmpty((Map)billCalResult.getFailAttFileMap()) ? WTCCollections.modifiableEmptyMap() : billCalResult.getFailAttFileMap();
        Map<Long, List<BillApply>> fileBo2billMap = calBillList.stream().collect(Collectors.groupingBy(BillApply::getAttFileBoId));
        if (tarBill != null && !failAttFileMap.containsKey(tarBill.getAttFileBoId()) && (existedBills = fileBo2billMap.values().stream().flatMap(Collection::stream).filter(ele -> ele.getId() == billId).count()) == 0L) {
            fileBo2billMap.computeIfAbsent(tarBill.getAttFileBoId(), key -> WTCCollections.modifiableEmptyList()).add(tarBill);
        }
        this.repairBillAndDetectLegalBill(failAttFileMap, fileBo2billMap);
        this.excludeOutRangeBill(fileBo2billMap, failAttFileMap, initRequest.getAttSubjects());
        this.excludeExtraBill(fileBo2billMap, initRequest.getAttSubjects());
        this.excludeRepeatBill(fileBo2billMap);
        Map<Long, List<QTBillDeal>> fileBo2BillDealMap = this.initQTBillDeal(fileBo2billMap);
        boolean excludeTarBill = this.excludeNotLeafBill(fileBo2BillDealMap, fileBo2billMap, tarBill);
        if (excludeTarBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u636e[id=%s]\u6b63\u5728\u53d1\u751f\u53d8\u66f4\uff0c\u7ec8\u6b62\u672c\u6b21\u5355\u636e\u6838\u7b97\u3002", (String)"TieInitDeductChainEvnForQuota_3", (String)"wtc-wtes-business", (Object[])new Object[]{billId}));
        }
        Map<Long, QTDeductRule> deductRuleMap = this.initDeductRule(fileBo2billMap);
        Set<Long> billIdExistRepeatBD = this.detectedRepeatBillDeal(fileBo2BillDealMap);
        Map<Long, List<QTLineDetail>> fileBo2Line = this.initQTLine(fileBo2billMap, deductRuleMap, fileBo2BillDealMap, initRequest);
        Map useToRepairLineBDMap = WTCCollections.modifiableEmptyMap();
        if (WTCCollections.isNotEmpty(billIdExistRepeatBD)) {
            log.warn("TieInitDeductChainEvnForQuota detected exist repeat BillDeal, billIdSet:{}", billIdExistRepeatBD);
            Set needRepairLineIds = fileBo2BillDealMap.values().stream().flatMap(Collection::stream).filter(ele -> billIdExistRepeatBD.contains(ele.getBillId())).flatMap(ele -> ele.getEntryDealList().stream()).flatMap(ele -> ele.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).filter(ele -> ele != 0L).collect(Collectors.toSet());
            Map billDealMap = QTDealRecordDBService.loadBillDealByLineId(needRepairLineIds);
            for (QTBillDeal billDeal : billDealMap.values()) {
                useToRepairLineBDMap.computeIfAbsent(billDeal.getAttFileBoId(), key -> WTCCollections.modifiableEmptyList()).add(billDeal);
            }
        }
        Map<Long, Long> itemVid2ItemBoIdMap = this.initItemVid2BoIdMap(fileBo2Line);
        DeductEnv deductEnv = new DeductEnv();
        deductEnv.setItemVid2ItemBoIdMap(itemVid2ItemBoIdMap);
        deductEnv.setFailAttFileBoMap(failAttFileMap);
        deductEnv.setFileBo2BillMap(fileBo2billMap);
        deductEnv.setDeductRuleMap(deductRuleMap);
        deductEnv.setFileBo2BillDealMap(fileBo2BillDealMap);
        deductEnv.setBillSetExistRepeatBillDeal(billIdExistRepeatBD);
        deductEnv.setUseToRepairLineBDMap(useToRepairLineBDMap);
        deductEnv.setFileBo2LineMap(fileBo2Line);
        deductEnv.initLineUseDateRange();
        return QuotaInitParamResult.success(deductEnv);
    }

    private List<BillApply> initChangeIllegalBillAndNotCountAuditBill(QuotaInitParamRequest initRequest, LocalDate allSubjectMinStartDate, LocalDate allSubjectMaxEndDate, List<BillApply> calBillList) {
        Set boIdSet = initRequest.getAttSubjects().stream().flatMap(ele -> ele.getAttFileInfoList().stream()).map(AttFileInfo::getAttFileBaseBoId).collect(Collectors.toSet());
        Set excludeBillIdSet = calBillList.stream().map(BillApply::getId).collect(Collectors.toSet());
        DateRange dateRange = DateRange.range((Date)WTCDateUtils.toDate((LocalDate)allSubjectMinStartDate), (Date)WTCDateUtils.toDate((LocalDate)allSubjectMaxEndDate));
        QFilter filter = new QFilter("attfile", "in", boIdSet).and("id", "not in", excludeBillIdSet).and(dateRange.getFilterIntersectionLCRC("startdate", "enddate")).and("billstatus", "=", (Object)"C");
        HRBaseServiceHelper vaBillDao = new HRBaseServiceHelper("wtabm_vaapply");
        DynamicObject[] billArr = vaBillDao.query(VABILL_PROPERTIES + "," + "isdisposable" + "," + "ishavechange", filter.toArray());
        Set beAlteredBillIdSet = Arrays.stream(billArr).filter(ele -> ele.getBoolean("ishavechange")).map(ele -> ele.getLong("id")).collect(Collectors.toSet());
        List effectAlterBillStatus = WTCCollections.modifiableList((Object[])new String[]{"C", "B", "D"});
        QFilter effectAlterBillStatusFilter = new QFilter("parentid", "in", beAlteredBillIdSet).and("billstatus", "in", (Object)effectAlterBillStatus);
        DynamicObject[] alterBillArr = vaBillDao.query("parentid", effectAlterBillStatusFilter.toArray());
        Set effectBeAlteredBillId = Arrays.stream(alterBillArr).map(ele -> ele.getLong("parentid")).collect(Collectors.toSet());
        List<BillApply> extraBills = Arrays.stream(billArr).filter(ele -> !effectBeAlteredBillId.contains(ele.getLong("id"))).map(TieInitCycleSetForQuota::generateBillApply).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(extraBills)) {
            log.info("TieInitDeductChainEvnForQuota initChangeIllegalBillAndNotCountAuditBill:{}", extraBills.stream().map(BillApply::getBillNo).collect(Collectors.toList()));
        }
        return extraBills;
    }

    private boolean excludeNotLeafBill(Map<Long, List<QTBillDeal>> fileBo2BillDealMap, Map<Long, List<BillApply>> fileBo2billMap, BillApply tarBill) {
        Set parentBillIdSet = WTCCollections.modifiableEmptySet();
        for (List<QTBillDeal> bdList : fileBo2BillDealMap.values()) {
            for (QTBillDeal billDeal : bdList) {
                parentBillIdSet.add(billDeal.getParentBillId());
            }
        }
        parentBillIdSet.remove(0L);
        Set removeBills = WTCCollections.modifiableEmptySet();
        for (List<BillApply> billList : fileBo2billMap.values()) {
            Iterator<BillApply> iterator = billList.iterator();
            while (iterator.hasNext()) {
                BillApply bill = iterator.next();
                if (!parentBillIdSet.contains(bill.getId())) continue;
                removeBills.add(bill.getId());
                iterator.remove();
            }
        }
        if (WTCCollections.isNotEmpty((Collection)removeBills)) {
            log.warn("TieInitDeductChainEvnForQuota detected billCal return data contain not leaf bill:{}", (Object)removeBills);
        }
        return tarBill != null && removeBills.contains(tarBill.getId());
    }

    private Set<Long> detectedRepeatBillDeal(Map<Long, List<QTBillDeal>> fileBo2BillDealMap) {
        HashSet<Long> repeatBillID = new HashSet<Long>(16);
        HashSet<Long> billIdSet = new HashSet<Long>(fileBo2BillDealMap.size());
        for (List<QTBillDeal> sameBoBD : fileBo2BillDealMap.values()) {
            for (QTBillDeal billDeal : sameBoBD) {
                if (billIdSet.add(billDeal.getBillId())) continue;
                repeatBillID.add(billDeal.getBillId());
            }
        }
        return repeatBillID;
    }

    private Map<Long, Long> initItemVid2BoIdMap(Map<Long, List<QTLineDetail>> fileBo2Line) {
        Set itemVidSet = fileBo2Line.values().stream().flatMap(Collection::stream).map(QTLineDetail::getUsableValueAttItemVid).collect(Collectors.toSet());
        HRBaseServiceHelper itemDao = new HRBaseServiceHelper("wtbd_attitem");
        DynamicObject[] itemArr = itemDao.query("id,boid", new QFilter("id", "in", itemVidSet).toArray());
        HashMap<Long, Long> res = new HashMap<Long, Long>(itemArr.length);
        for (DynamicObject item : itemArr) {
            res.put(item.getLong("id"), item.getLong("boid"));
        }
        return res;
    }

    private void excludeRepeatBill(Map<Long, List<BillApply>> fileBo2billMap) {
        HashSet billIdSet = new HashSet(16);
        for (Map.Entry<Long, List<BillApply>> entry : fileBo2billMap.entrySet()) {
            entry.getValue().removeIf(next -> !billIdSet.add(next.getId()));
            billIdSet.clear();
        }
    }

    private Map<Long, QTDeductRule> initDeductRule(Map<Long, List<BillApply>> fileBo2billMap) {
        List allBills = fileBo2billMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return QTDeductService.initDeductRule(allBills);
    }

    private Map<Long, List<QTBillDeal>> initQTBillDeal(Map<Long, List<BillApply>> fileBo2billMap) {
        List allBills = fileBo2billMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Set chainId = QTDealRecordDBService.queryChainId((Collection)allBills.stream().map(BillApply::getId).collect(Collectors.toSet()));
        Map allBDChain = QTDealRecordDBService.loadBDByChainId((Collection)chainId, (boolean)true);
        HashMap<Long, List<QTBillDeal>> res = new HashMap<Long, List<QTBillDeal>>(fileBo2billMap.size());
        for (List bdChain : allBDChain.values()) {
            if (bdChain == null || bdChain.size() <= 0) continue;
            long attFileBoId = ((QTBillDeal)bdChain.get(0)).getAttFileBoId();
            res.computeIfAbsent(attFileBoId, key -> new ArrayList(16)).addAll(bdChain);
        }
        HashSet bdIdSet = new HashSet(16);
        for (List samBoBD : res.values()) {
            samBoBD.removeIf(bd -> !bdIdSet.add(bd.getId()));
            bdIdSet.clear();
        }
        return res;
    }

    private Map<Long, List<QTLineDetail>> initQTLine(Map<Long, List<BillApply>> fileBo2billMap, Map<Long, QTDeductRule> deductRuleMap, Map<Long, List<QTBillDeal>> fileBo2BillDealMap, QuotaInitParamRequest initRequest) {
        HashSet<Long> allNeedQueryQTTypeId = new HashSet<Long>(16);
        allNeedQueryQTTypeId.addAll(deductRuleMap.values().stream().flatMap(ele -> ele.getDeductOrder().stream()).map(QTType::getId).collect(Collectors.toSet()));
        allNeedQueryQTTypeId.addAll(initRequest.getRequest().getRegQtTypeIds());
        allNeedQueryQTTypeId.addAll(initRequest.getRequest().getDyQtTypeIds());
        Set allBillDealUsedQTLineIdSet = fileBo2BillDealMap.values().stream().flatMap(Collection::stream).flatMap(ele -> ele.getEntryDealList().stream()).flatMap(ele -> ele.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).filter(ele -> ele != 0L).collect(Collectors.toSet());
        Date initMinStartDate = WTCDateUtils.toDate((LocalDate)initRequest.getStartDate());
        Date initMaxEndDate = WTCDateUtils.toDate((LocalDate)initRequest.getEndDate());
        for (List<BillApply> sameBoBills : fileBo2billMap.values()) {
            for (BillApply bill : sameBoBills) {
                for (BillApplyEntry billEntry : bill.getEntryEntities()) {
                    if (billEntry.getStartDate().before(initMinStartDate)) {
                        initMinStartDate = billEntry.getStartDate();
                    }
                    if (!billEntry.getEndDate().after(initMaxEndDate)) continue;
                    initMaxEndDate = billEntry.getEndDate();
                }
            }
        }
        Set allNeedQueryFileBoId = initRequest.getAttSubjects().stream().flatMap(ele -> ele.getAttFileInfoList().stream()).filter(ele -> ele.getLegal() != null && ele.getLegal() != false).map(AttFileInfo::getAttFileBaseBoId).collect(Collectors.toSet());
        QFilter dateFilter = DateRange.range((Date)initMinStartDate, (Date)initMaxEndDate).getFilterIntersectionLCRC("usestartdate", "useenddate");
        QFilter extraLineFilter = new QFilter("id", "in", allBillDealUsedQTLineIdSet);
        List allNeedUsedLine = QTLineDetailDBService.loadLineBatch(allNeedQueryFileBoId, allNeedQueryQTTypeId, (QFilter)dateFilter, (QFilter)extraLineFilter);
        HashSet<Long> deWeightSet = new HashSet<Long>(16);
        HashMap<Long, List<QTLineDetail>> res = new HashMap<Long, List<QTLineDetail>>(allNeedQueryFileBoId.size());
        for (QTLineDetail line : allNeedUsedLine) {
            if (!deWeightSet.add(line.getBid())) continue;
            List details = res.computeIfAbsent(line.getAttFileBoId(), key -> new ArrayList(4));
            details.add(line);
        }
        return res;
    }

    private void repairBillAndDetectLegalBill(Map<Long, String> failAttFileMap, Map<Long, List<BillApply>> fileBo2billMap) {
        List allBillId = fileBo2billMap.values().stream().flatMap(Collection::stream).map(BillApply::getId).collect(Collectors.toList());
        Map oldBillInfo = QTDealRecordDBService.queryBillApplyPackage(allBillId);
        HashSet<Long> detectedFailFileBo = new HashSet<Long>(4);
        block0: for (Map.Entry<Long, List<BillApply>> entry : fileBo2billMap.entrySet()) {
            Long fileBoId = entry.getKey();
            List<BillApply> sameBoBills = entry.getValue();
            for (BillApply bill : sameBoBills) {
                long billId = bill.getId();
                BillApply oldBill = (BillApply)oldBillInfo.get(billId);
                if (oldBill != null) {
                    QTBillOuterService.amendOldBillApply((BillApply)bill, (BillApply)oldBill);
                }
                if (!WTCCollections.isEmpty((Collection)bill.getEntryEntities())) continue;
                log.warn("TieInitDeductChainEvnForQuota occur illegal bill:{}", (Object)bill);
                failAttFileMap.put(fileBoId, ResManager.loadKDString((String)"\u5355\u636e\u6838\u7b97\u4e2d\u51fa\u73b0\u975e\u6cd5\u7684\u65e0\u5206\u5f55\u6570\u636e\uff0c\u5355\u636e\u7f16\u7801=%s\u3002", (String)"TieInitDeductChainEvnForQuota_2", (String)"wtc-wtes-business", (Object[])new Object[]{bill.getBillNo()}));
                detectedFailFileBo.add(fileBoId);
                continue block0;
            }
        }
        if (!detectedFailFileBo.isEmpty()) {
            log.warn("TieInitDeductChainEvnForQuota remove bill for fail fileBo:{}", detectedFailFileBo);
            for (Long failFileBoId : detectedFailFileBo) {
                fileBo2billMap.remove(failFileBoId);
            }
        }
    }

    private void excludeOutRangeBill(Map<Long, List<BillApply>> fileBo2billMap, Map<Long, String> failAttFileMap, List<AttPersonRange> attSubjects) {
        for (AttPersonRange subject : attSubjects) {
            for (AttFileInfo fileBoRepresent : subject.getAttFileInfoList()) {
                Long fileBoId = fileBoRepresent.getAttFileBaseBoId();
                if (failAttFileMap.containsKey(fileBoId)) continue;
                Date subjectStartDate = fileBoRepresent.getStartDate();
                Date subjectEndDate = fileBoRepresent.getEndDate();
                List<BillApply> sameBoBills = fileBo2billMap.get(fileBoId);
                if (sameBoBills == null) {
                    log.warn("TieInitDeductChainEvnForQuota detected fileBo:{} in attSubjects, but not occur on fileBo2billMap and fileBoRepresent. now give it empty value.", (Object)fileBoId);
                    fileBo2billMap.put(fileBoId, WTCCollections.modifiableEmptyList());
                    continue;
                }
                if (fileBoRepresent.getLegal() == null || !fileBoRepresent.getLegal().booleanValue()) {
                    log.warn("TieInitDeductChainEvnForQuota remove bills for subject[boId={}, legal={}, subjectStartDate={}, subjectEndDate={}], removeBillIds={}", new Object[]{fileBoId, fileBoRepresent.getLegal(), subjectStartDate, subjectEndDate, sameBoBills.stream().map(BillApply::getId).collect(Collectors.toList())});
                    sameBoBills.clear();
                    continue;
                }
                Iterator<BillApply> iterator = sameBoBills.iterator();
                List currentBoRemoveBills = WTCCollections.modifiableEmptyList();
                while (iterator.hasNext()) {
                    BillApply bill = iterator.next();
                    Date billMinStart = null;
                    Date billMaxEnd = null;
                    for (BillApplyEntry billEntry : bill.getEntryEntities()) {
                        if (billMinStart == null || billEntry.getStartDate().before(billMinStart)) {
                            billMinStart = billEntry.getStartDate();
                        }
                        if (billMaxEnd != null && !billEntry.getEndDate().after(billMaxEnd)) continue;
                        billMaxEnd = billEntry.getEndDate();
                    }
                    if (billMinStart != null && billMaxEnd != null && WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate(billMinStart), (Date)WTCDateUtils.getDayLastDate(billMaxEnd), (Date)WTCDateUtils.getZeroDate((Date)subjectStartDate), (Date)WTCDateUtils.getDayLastDate((Date)subjectEndDate))) continue;
                    currentBoRemoveBills.add(bill);
                    iterator.remove();
                }
                if (!WTCCollections.isNotEmpty((Collection)currentBoRemoveBills)) continue;
                log.info("TieInitDeductChainEvnForQuota remove bills for subject[boId={}, subjectStartDate={}, subjectEndDate={}], removeBills={}", new Object[]{fileBoId, subjectStartDate, subjectEndDate, currentBoRemoveBills});
                currentBoRemoveBills.clear();
            }
        }
    }

    private void excludeExtraBill(Map<Long, List<BillApply>> fileBo2billMap, List<AttPersonRange> attSubjects) {
        Set allLegalFileBo = attSubjects.stream().flatMap(ele -> ele.getAttFileInfoList().stream()).filter(ele -> ele.getLegal() != null && ele.getLegal() != false).map(AttFileInfo::getAttFileBaseBoId).collect(Collectors.toSet());
        HashSet<Long> occurFileBo = new HashSet<Long>(fileBo2billMap.keySet());
        occurFileBo.removeAll(allLegalFileBo);
        if (!occurFileBo.isEmpty()) {
            log.warn("TieInitDeductChainEvnForQuota remove bills that occur in fileBo2billMap, but it's fileBo not in attSubjects or in attSubjects but not legal. fileBoList:{}", occurFileBo);
            for (Long fileBo : occurFileBo) {
                fileBo2billMap.remove(fileBo);
            }
        }
    }

    @Override
    public String category() {
        return "QT_DEDUCT_CHAIN_EVN";
    }
}

