/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaEmployeeData;

public class TieInitEmployeeForQuota
implements QuotaParamInitializer {
    private static final List<String> EMPLOYEE_FIELDS = new ArrayList<String>(){
        {
            this.add("id");
            this.add("person");
            this.add("boid");
            this.add("mid");
            this.add("iscurrentversion");
            this.add("enddate");
            this.add("startdate");
        }
    };

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        AttFileCabinet attFileCabinet = (AttFileCabinet)initRequest.getInitParams().get("ATT_FILE");
        AttendPersonData attendPersonData = (AttendPersonData)((Object)initRequest.getInitParams().get("ATT_PERINFO"));
        List<Long> personIdList = initRequest.getAttPersonIds();
        Map<Long, AttendPerson> map = attendPersonData.getBid2AttendPersonMap();
        HashMap<Long, Date> employeeFirstStartDate = new HashMap<Long, Date>();
        HashMap<Long, Long> employeeFirstId = new HashMap<Long, Long>();
        HashMap<Long, List<Long>> personBidMap = new HashMap<Long, List<Long>>();
        HashSet<Long> employeeSet = new HashSet<Long>();
        HashMap<Long, Date> employeeEndDate = new HashMap<Long, Date>();
        HashSet<Long> employeeEndDateSet = new HashSet<Long>();
        for (Long personId : personIdList) {
            List<TimeSeqBo<AttFileModel>> timeSeqBoList = attFileCabinet.getByAttPersonId(personId);
            ArrayList boIds = Lists.newArrayListWithExpectedSize((int)timeSeqBoList.size());
            for (TimeSeqBo<AttFileModel> timeSeqBo : timeSeqBoList) {
                Employee employeeBo;
                TimeSeqBo employeeTimeSeqBo;
                Map employeeMap;
                List attFileModels = timeSeqBo.getVersions();
                if (!WTCCollections.isNotEmpty((Collection)attFileModels)) continue;
                AttFileModel attFileModel = (AttFileModel)((Object)attFileModels.get(0));
                Long employId = attFileModel.getEmployeeId();
                boIds.add(attFileModel.getBid());
                employeeFirstId.put(attFileModel.getBid(), employId);
                employeeSet.add(employId);
                AttendPerson attendPerson = map.get(attFileModel.getAttPersonId());
                personBidMap.put(personId, boIds);
                if (attendPerson == null || !WTCCollections.isNotEmpty((Map)(employeeMap = attendPerson.getEmployeeMap())) || (employeeTimeSeqBo = (TimeSeqBo)employeeMap.get(employId)) == null) continue;
                List employeeList = employeeTimeSeqBo.getVersions();
                if (WTCCollections.isNotEmpty((Collection)employeeList)) {
                    Long employyeeId = ((Employee)employeeList.get(0)).getFirstEmployeeBid();
                    employeeSet.add(employyeeId);
                }
                if ((employeeBo = (Employee)employeeTimeSeqBo.getBoVersion()) == null) {
                    employeeEndDateSet.add(employId);
                    continue;
                }
                Date endDate = employeeBo.getEndDate();
                employeeEndDate.put(employId, endDate);
            }
        }
        employeeSet.addAll(employeeEndDateSet);
        if (WTCCollections.isNotEmpty(employeeSet)) {
            QFilter empPosOrgRelIdQFilter = new QFilter("boid", "in", employeeSet);
            empPosOrgRelIdQFilter.and(new QFilter("person", "in", initRequest.getAttPersonIds()));
            DynamicObject[] employeeDyListAll = HRPIMServiceImpl.getInstance().listFieldsFilterInfo(StringUtils.join(EMPLOYEE_FIELDS, (String)","), empPosOrgRelIdQFilter, "hrpi_employee");
            if (employeeDyListAll != null) {
                Map<Long, List<DynamicObject>> dyMap = Arrays.stream(employeeDyListAll).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
                this.updateStartDate(personIdList, personBidMap, employeeFirstId, employeeFirstStartDate, dyMap);
                Map<Long, List<DynamicObject>> dyEndDateMap = Arrays.stream(employeeDyListAll).filter(dy -> employeeEndDateSet.contains(dy.getLong("boid"))).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
                this.updateEndDate(employeeEndDate, dyEndDateMap);
            }
        }
        QuotaEmployeeData quotaEmployeeData = QuotaEmployeeData.of(employeeFirstStartDate, employeeEndDate);
        return QuotaInitParamResult.success((Object)quotaEmployeeData);
    }

    private void updateStartDate(List<Long> personIdList, Map<Long, List<Long>> personBidMap, Map<Long, Long> employeeFirstId, Map<Long, Date> employeeFirstStartDate, Map<Long, List<DynamicObject>> dyMap) {
        if (WTCCollections.isEmpty(dyMap)) {
            return;
        }
        for (Long personId : personIdList) {
            List<Long> fileBoIds = personBidMap.get(personId);
            if (fileBoIds == null) continue;
            for (Long fileBoId : fileBoIds) {
                List<DynamicObject> dynamicObjects;
                Long employessId = employeeFirstId.get(fileBoId);
                if (employessId == null || !WTCCollections.isNotEmpty(dynamicObjects = dyMap.get(employessId))) continue;
                dynamicObjects.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
                employeeFirstStartDate.put(fileBoId, dynamicObjects.get(0).getDate("startdate"));
            }
        }
    }

    private void updateEndDate(Map<Long, Date> employeeEndDate, Map<Long, List<DynamicObject>> dyEndDateMap) {
        if (WTCCollections.isEmpty(dyEndDateMap)) {
            return;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : dyEndDateMap.entrySet()) {
            Long employId = entry.getKey();
            List<DynamicObject> employDys = entry.getValue();
            for (DynamicObject dy : employDys) {
                boolean isCurrentversion = dy.getBoolean("iscurrentversion");
                if (!isCurrentversion) continue;
                Date endDate = dy.getDate("enddate");
                employeeEndDate.put(employId, endDate);
            }
        }
    }

    @Override
    public String category() {
        return "FIRST_EMPLOYEE_STARTDAY";
    }
}

