/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.init.DateRecorderInitializer;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.calculate.model.result.QTPool;
import kd.wtc.wtp.business.cumulate.trading.DateRange;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;

public class TieInitQTPoolForQuota
implements QuotaParamInitializer {
    private static final Log log = LogFactory.getLog(TieInitQTPoolForQuota.class);

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        AttRecordDetailHolder detailHolder;
        Date cycMinDate;
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success((Object)QTPoolHolder.of(null));
        }
        List<Long> regQtTypeIds = initRequest.getRequest().getRegQtTypeIds();
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        ArrayList qtTypes = Lists.newArrayListWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(regQtTypeIds)) {
            qtTypes.addAll(regQtTypeIds);
        }
        if (WTCCollections.isNotEmpty(dyQtTypeIds)) {
            qtTypes.addAll(dyQtTypeIds);
        }
        if (null == (cycMinDate = (detailHolder = (AttRecordDetailHolder)initRequest.getInitParams().get("QT_ATT_RECORD_DETAIL")).getCycMinDate())) {
            cycMinDate = WTCDateUtils.toDate((LocalDate)initRequest.getStartDate());
        }
        QFilter filter = DateRange.range((Date)cycMinDate, (Date)WTCDateUtils.toDate((LocalDate)initRequest.getEndDate())).getFilterIntersectionLCRC("genstartdate", "genenddate");
        List<AttPersonRange> attPersonRanges = initRequest.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        filter.and(new QFilter("initstatus", "=", (Object)"2"));
        List qtPools = QTLineDetailDBService.loadPoolBatch(attFileBoIds, (Collection)qtTypes, (QFilter)filter);
        AttFileCabinet attFileCabinet = (AttFileCabinet)initRequest.getInitParams().get("ATT_FILE");
        List<Long> personIdList = initRequest.getAttPersonIds();
        Date earliestDate = null;
        HashSet attFilleBids = new HashSet();
        for (Long personId : personIdList) {
            List<TimeSeqBo<AttFileModel>> timeSeqBoList = attFileCabinet.getByAttPersonId(personId);
            List attFileModels = timeSeqBoList.stream().map(seqBo -> (AttFileModel)((Object)((Object)seqBo.getVersions().get(0)))).collect(Collectors.toList());
            Map<Long, List<AttFileModel>> map = attFileModels.stream().collect(Collectors.groupingBy(AttFileModel::getEmployeeId));
            for (Map.Entry<Long, List<AttFileModel>> entrys : map.entrySet()) {
                if (entrys.getValue().size() <= 1) continue;
                entrys.getValue().sort(Comparator.comparing(AttFileModel::getEndDateTime));
                Date endDate = entrys.getValue().get(0).getEndDateTime();
                earliestDate = earliestDate == null || endDate.before(earliestDate) ? endDate : earliestDate;
                List<AttFileModel> attFileModelList = entrys.getValue().subList(0, entrys.getValue().size() - 1);
                Set fileBids = attFileModelList.stream().map(TimeSeqVersion::getBid).collect(Collectors.toSet());
                attFilleBids.addAll(fileBids);
            }
        }
        if (CollectionUtils.isNotEmpty(attFilleBids) && earliestDate != null) {
            QFilter rangFilter = DateRange.range(earliestDate, (Date)WTCDateUtils.toDate((LocalDate)initRequest.getEndDate())).getFilterIntersectionLCRC("genstartdate", "useenddate");
            rangFilter.and(new QFilter("busstatus", "=", (Object)"0"));
            rangFilter.and(new QFilter("initstatus", "=", (Object)"2"));
            rangFilter.and(new QFilter("source", "!=", (Object)"DT-008"));
            List preQtPools = QTLineDetailDBService.loadPoolBatch(attFilleBids, (Collection)qtTypes, (QFilter)rangFilter);
            for (QTPool qtPool : preQtPools) {
                List filterPools = qtPools.stream().filter(qt -> qt.getQtTypeId() == qtPool.getQtTypeId() && qt.getAttFileBoId() == qtPool.getAttFileBoId()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(filterPools)) {
                    List qtLineBids = ((QTPool)filterPools.get(0)).getLineDetailList().stream().map(qtLineDetail -> qtLineDetail.getBid()).collect(Collectors.toList());
                    List qtLineDetails = qtPool.getLineDetailList().stream().filter(qtLineDetail -> !qtLineBids.contains(qtLineDetail.getBid())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(qtLineDetails)) continue;
                    ((QTPool)filterPools.get(0)).getLineDetailList().addAll(qtLineDetails);
                    continue;
                }
                qtPools.add(qtPool);
            }
        }
        AttendPersonData attendPersonData = (AttendPersonData)((Object)initRequest.getInitParams().get("ATT_PERINFO"));
        Set empIdSet = (Set)attendPersonData.getExtAttributes().remove("AllEmployeeIDS");
        Map<Long, EmployeeDateRecorder> dateRecorderMap = new HashMap<Long, EmployeeDateRecorder>(16);
        if (empIdSet != null && !empIdSet.isEmpty()) {
            dateRecorderMap = DateRecorderInitializer.queryEmployeeDateRecorder(empIdSet, WTCDateUtils.toLocalDate((Date)cycMinDate), initRequest.getEndDate());
        }
        attendPersonData.setDateRecorderMap(dateRecorderMap);
        return QuotaInitParamResult.success((Object)QTPoolHolder.of(qtPools));
    }

    @Override
    public String category() {
        return "QT_POOL";
    }
}

