/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.init.TieInitializerAttPeriod;
import kd.wtc.wtes.business.model.AttPeriodModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerAttPeriodForQuota
implements QuotaParamInitializer {
    private final TieInitializerAttPeriod attPeriod = new TieInitializerAttPeriod();

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        QFilter endfilter;
        QFilter startfilter;
        QFilter periodIdQFilter;
        HRBaseServiceHelper hRBaseServiceHelper;
        DynamicObject[] arr;
        InitParamResult init = this.attPeriod.init(initRequest);
        AttPeriodTable attPeriodTable = (AttPeriodTable)init.getInitData();
        LocalDate endDate = initRequest.getEndDate();
        LocalDate startDate = initRequest.getStartDate();
        List<Long> personIds = initRequest.getAttPersonIds();
        HashMap<Long, Date> map = new HashMap<Long, Date>();
        HashMap<Long, Long> personMap = new HashMap<Long, Long>();
        for (AttPersonRange attPersonRange : initRequest.getAttSubjects()) {
            for (AttFileInfo attFileInfo : attPersonRange.getAttFileInfoList()) {
                Date chainDate;
                Date fileEndDate = attFileInfo.getEndDate();
                if (map.containsKey(attFileInfo.getAttFileBaseBoId()) && (chainDate = (Date)map.get(attFileInfo.getAttFileBaseBoId())).after(fileEndDate)) {
                    fileEndDate = chainDate;
                }
                map.put(attFileInfo.getAttFileBaseBoId(), fileEndDate);
                personMap.put(attFileInfo.getAttFileBaseBoId(), attFileInfo.getPersonId());
            }
        }
        HashMap<Long, Long> attPeriod = new HashMap<Long, Long>(personIds.size());
        HashSet<Long> periodIds = new HashSet<Long>(personIds.size());
        for (Map.Entry entry : map.entrySet()) {
            Long attFileBoId = (Long)entry.getKey();
            Long personId = (Long)personMap.get(attFileBoId);
            Optional<PerAttPeriod> perAttPeriodOp = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate((long)personId, (Date)entry.getValue());
            if (!perAttPeriodOp.isPresent()) continue;
            PerAttPeriod perAttPeriod = perAttPeriodOp.get();
            attPeriod.put(attFileBoId, perAttPeriod.getPeriodId());
            periodIds.add(perAttPeriod.getPeriodId());
        }
        HashMap<Long, List<AttPeriodModel>> periodAttFileMap = new HashMap<Long, List<AttPeriodModel>>(attPeriod.size());
        if (!CollectionUtils.isEmpty(periodIds) && (arr = (hRBaseServiceHelper = new HRBaseServiceHelper("wtp_attperiodentry")).loadDynamicObjectArray(new QFilter[]{periodIdQFilter = new QFilter("masterid", "in", periodIds), startfilter = new QFilter("begindate", "<=", (Object)WTCDateUtils.toDate((LocalDate)endDate)), endfilter = new QFilter("enddate", ">=", (Object)WTCDateUtils.toDate((LocalDate)startDate))})) != null && arr.length > 0) {
            Map<Long, List<DynamicObject>> periodMap = Arrays.stream(arr).collect(Collectors.groupingBy(dy -> dy.getLong("masterid.id")));
            attPeriod.forEach((key, value) -> {
                List dys = (List)periodMap.get(value);
                if (!WTCCollections.isEmpty((Collection)dys)) {
                    List attPeriodModels = dys.stream().map(dy -> {
                        AttPeriodModel attPeriodModel = new AttPeriodModel();
                        attPeriodModel.setEndDate(dy.getDate("enddate"));
                        attPeriodModel.setStartDate(dy.getDate("begindate"));
                        attPeriodModel.setId(dy.getLong("id"));
                        return attPeriodModel;
                    }).collect(Collectors.toList());
                    periodAttFileMap.put((Long)key, attPeriodModels);
                }
            });
        }
        attPeriodTable.setAttPeriodMap(periodAttFileMap);
        return QuotaInitParamResult.success(attPeriodTable);
    }

    @Override
    public String category() {
        return this.attPeriod.category();
    }
}

