/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryAdjustTable;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailCarryDown;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCarryDownTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOverDrawTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTVestDayEnum;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerDetailCarryAjForQuota
implements QuotaParamInitializer {
    private static final String[] SELECTS = new String[]{"attfileid.boid", "createtime", "cdmode", "qttypeid", "pastduration.id", "cdstartdate", "cdsdelay", "cdsdelayvalue", "cdsdelayunit", "cdenddate", "cdedelay", "cdedelayvalue", "cdedelayunit", "cdtype", "cdvalue", "cdpercent", "cdvdelay", "cdvestday", "cdvdelayvalue", "cdvdelayunit", "cdduration.id", "cdpastpercent", "cdpastduration_id", "qtdetailcdrecd.crossday", "id", "qtdetailcdrecd.periodcircleid", "qtdetailcdrecd.periodnum", "qtdetailcdrecd.qtdetailid", "qtdetailcdrecd.source"};

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(new QTDetailCarryAdjustTable());
        }
        List<Long> regQtTypeIds = initRequest.getRequest().getRegQtTypeIds();
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        ArrayList qtTypes = Lists.newArrayListWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(regQtTypeIds)) {
            qtTypes.addAll(regQtTypeIds);
        }
        if (WTCCollections.isNotEmpty(dyQtTypeIds)) {
            qtTypes.addAll(dyQtTypeIds);
        }
        List<AttPersonRange> attPersonRanges = initRequest.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("attfileid.boid", "in", attFileBoIds), new QFilter("qttypeid", "in", (Object)qtTypes), new QFilter("status", "=", (Object)"C")};
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtte_qtdetailcarryaj");
        DynamicObject[] baseDys = baseHelper.query(String.join((CharSequence)",", SELECTS), qFilters);
        ArrayList<QTDetailCarryAdjust> qtDetailAdjusts = new ArrayList<QTDetailCarryAdjust>();
        if (baseDys != null && baseDys.length > 0) {
            for (DynamicObject dy : baseDys) {
                QTDetailCarryAdjust qtDetailAdjust = this.buildQTDetailAdjust(dy);
                qtDetailAdjusts.add(qtDetailAdjust);
            }
        }
        Map<Long, List<QTDetailCarryAdjust>> map = qtDetailAdjusts.stream().collect(Collectors.groupingBy(QTDetailCarryAdjust::getAttFileBoId));
        QTDetailCarryAdjustTable qtDetailCarryAdjustTable = new QTDetailCarryAdjustTable();
        qtDetailCarryAdjustTable.setQtDetailCarryAdjustMap(map);
        return QuotaInitParamResult.success(qtDetailCarryAdjustTable);
    }

    @Override
    public String category() {
        return "QT_DETAIL_CARRY_AJ";
    }

    private QTDetailCarryAdjust buildQTDetailAdjust(DynamicObject dynamicObject) {
        QTDetailCarryAdjust qtDetailAdjust = new QTDetailCarryAdjust();
        qtDetailAdjust.setId(dynamicObject.getLong("id"));
        qtDetailAdjust.setAttFileBoId(dynamicObject.getLong("attfileid.boid"));
        qtDetailAdjust.setCreateTime(dynamicObject.getDate("createtime"));
        qtDetailAdjust.setQttype(dynamicObject.getLong("qttypeid.id"));
        QTDetailCarryDown carryDown = this.buidQTDetailCarryDown(dynamicObject);
        qtDetailAdjust.setQtDetailCarryDown(carryDown);
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("qtdetailcdrecd");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            DynamicObject dy = (DynamicObject)dynamicObjects.get(0);
            qtDetailAdjust.setCrossDay(dy.getDate("crossday"));
            qtDetailAdjust.setPeriodCircle(dy.getLong("periodcircleid.id"));
            qtDetailAdjust.setPeriodNum(dy.getLong("periodnum"));
            qtDetailAdjust.setQtDetailId(dy.getLong("qtdetailid.id"));
            qtDetailAdjust.setSource(dy.getString("source"));
        }
        return qtDetailAdjust;
    }

    private QTDetailCarryDown buidQTDetailCarryDown(DynamicObject dynamicObject) {
        QTDetailCarryDown carryDown = new QTDetailCarryDown();
        carryDown.setCarryDownMethod(QTCarryDownTypeEnum.getByType(dynamicObject.getString("cdmode")));
        carryDown.setPassDurationAttItem(dynamicObject.getLong("pastduration.id"));
        carryDown.setCarryStartDate(QTDateConfigTypeEnum.getByType(dynamicObject.getString("cdstartdate")));
        carryDown.setStartDelay(dynamicObject.getBoolean("cdsdelay"));
        carryDown.setsDelay(dynamicObject.getInt("cdsdelayvalue"));
        carryDown.setStartFloatUnit(QTFloatUnitEnum.getByType(dynamicObject.getString("cdsdelayunit")));
        carryDown.setCarryEndDate(QTDateConfigTypeEnum.getByType(dynamicObject.getString("cdenddate")));
        carryDown.setEndDelay(dynamicObject.getBoolean("cdedelay"));
        carryDown.seteDelay(dynamicObject.getInt("cdedelayvalue"));
        carryDown.setEndFloatUnit(QTFloatUnitEnum.getByType(dynamicObject.getString("cdedelayunit")));
        carryDown.setCarryType(QTOverDrawTypeEnum.getByType(dynamicObject.getString("cdtype")));
        carryDown.setFixValue(dynamicObject.getBigDecimal("cdvalue"));
        carryDown.setPercentValue(dynamicObject.getBigDecimal("cdpercent"));
        carryDown.setVDDelay(dynamicObject.getBoolean("cdvdelay"));
        carryDown.setVestDay(QTVestDayEnum.getByType(dynamicObject.getString("cdvestday")));
        carryDown.setVestDayDelay(dynamicObject.getInt("cdvdelayvalue"));
        carryDown.setVestDayFloatUnit(QTFloatUnitEnum.getByType(dynamicObject.getString("cdvdelayunit")));
        carryDown.setCdDuration(dynamicObject.getLong("cdduration.id"));
        carryDown.setCdPastPercent(dynamicObject.getBigDecimal("cdpastpercent"));
        carryDown.setCarryDownAttItem(dynamicObject.getLong("cdpastduration_id"));
        return carryDown;
    }
}

