/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTAdjustDetailInfo;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;

public class TieInitializerDetailExtensionForQuota
implements QuotaParamInitializer {
    private static final String[] SELECTS = new String[]{"attfileid.boid", "crossday", "delaymethod", "delayusedate", "delayvalue", "delayunit", "periodcircleid.id", "periodnum", "qtdetailid", "qttypeid.id", "source", "createtime", "id"};

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(new QTDetailAdjustTable());
        }
        List<Long> regQtTypeIds = initRequest.getRequest().getRegQtTypeIds();
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        ArrayList qtTypes = Lists.newArrayListWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(regQtTypeIds)) {
            qtTypes.addAll(regQtTypeIds);
        }
        if (WTCCollections.isNotEmpty(dyQtTypeIds)) {
            qtTypes.addAll(dyQtTypeIds);
        }
        List<AttPersonRange> attPersonRanges = initRequest.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("attfileid.boid", "in", attFileBoIds), new QFilter("qttypeid", "in", (Object)qtTypes), new QFilter("status", "=", (Object)"C")};
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtte_qtdetailextension");
        DynamicObject[] baseDys = baseHelper.query(String.join((CharSequence)",", SELECTS), qFilters);
        ArrayList<QTDetailAdjust> qtDetailAdjusts = new ArrayList<QTDetailAdjust>();
        if (baseDys != null && baseDys.length > 0) {
            for (DynamicObject dy : baseDys) {
                QTDetailAdjust qtDetailAdjust = this.buildQTDetailAdjust(dy);
                qtDetailAdjusts.add(qtDetailAdjust);
            }
        }
        Map<Long, List<QTDetailAdjust>> map = qtDetailAdjusts.stream().collect(Collectors.groupingBy(QTAdjustDetailInfo::getAttFileBoId));
        QTDetailAdjustTable qtDetailAdjustTable = new QTDetailAdjustTable();
        qtDetailAdjustTable.setQtDetailAdjustMap(map);
        return QuotaInitParamResult.success(qtDetailAdjustTable);
    }

    @Override
    public String category() {
        return "QT_DETAIL_EXTENSION";
    }

    private QTDetailAdjust buildQTDetailAdjust(DynamicObject dynamicObject) {
        QTDetailAdjust qtDetailAdjust = new QTDetailAdjust();
        qtDetailAdjust.setId(dynamicObject.getLong("id"));
        qtDetailAdjust.setAttFileBoId(dynamicObject.getLong("attfileid.boid"));
        qtDetailAdjust.setCrossDay(dynamicObject.getDate("crossday"));
        qtDetailAdjust.setMdfyMethod(dynamicObject.getString("delaymethod"));
        qtDetailAdjust.setMdfyDate(dynamicObject.getString("delayusedate"));
        qtDetailAdjust.setDelayUnit(dynamicObject.getString("delayunit"));
        qtDetailAdjust.setDelayValue(dynamicObject.getBigDecimal("delayvalue"));
        qtDetailAdjust.setPeriodCircle(dynamicObject.getLong("periodcircleid.id"));
        qtDetailAdjust.setPeriodNum(dynamicObject.getLong("periodnum"));
        qtDetailAdjust.setQtDetailId(dynamicObject.getLong("qtdetailid.id"));
        qtDetailAdjust.setQttype(dynamicObject.getLong("qttypeid.id"));
        qtDetailAdjust.setSource(dynamicObject.getString("source"));
        qtDetailAdjust.setCreateTime(dynamicObject.getDate("createtime"));
        return qtDetailAdjust;
    }
}

