/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.wtc.wtbs.business.subject.AttPlainSubject;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.engine.QuotaRangeChecker;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;
import kd.wtc.wtes.common.util.Assert;

public class QuotaRangerBuilder
implements QuotaRangeChecker {
    private static final Log LOGGER = LogFactory.getLog(QuotaRangerBuilder.class);
    private QuotaRequest quotaRequest;
    private String excludeMessage;
    private List<AttPersonRange> attSubjectList;
    private List<AttPersonRange> attExcludeSubjectList;

    @Override
    public void setQuotaRequest(QuotaRequest quotaRequest) {
        Assert.nonNull((Object)quotaRequest, (String)"quotaRequest");
        this.quotaRequest = quotaRequest;
    }

    @Override
    public void check() {
        List<Long> attPersonIds = this.quotaRequest.getAttPersonIds();
        List<Long> attFileBoIds = this.quotaRequest.getAttFileBoids();
        LOGGER.debug("attFileBoIds {}", attFileBoIds);
        Date startDate = null != this.quotaRequest.getStartDate() ? WTCDateUtils.toDate((LocalDate)this.quotaRequest.getStartDate()) : null;
        Date endDate = null != this.quotaRequest.getEndDate() ? WTCDateUtils.toDate((LocalDate)this.quotaRequest.getEndDate()) : null;
        startDate = CollectionUtils.isNotEmpty(this.quotaRequest.getRegQtTypeIds()) ? WTCDateUtils.add((Date)startDate, (int)1, (int)-1) : WTCDateUtils.add((Date)startDate, (int)2, (int)-1);
        List list = null == startDate ? WTCAttFileService.queryAttFilesWithOutAuthCheck(attPersonIds, (Date)endDate) : WTCAttFileService.queryAttFilesWithOutAuthCheck(attPersonIds, (Date)startDate, (Date)endDate);
        List discardAttFiles = WTCAttFileService.queryDiscardAttFilesByAttFileBoIds(attFileBoIds, (Date)endDate);
        List<Long> discardFileIds = discardAttFiles.stream().map(item -> item.getLong("boid")).distinct().collect(Collectors.toList());
        this.attSubjectList = new ArrayList<AttPersonRange>();
        this.attExcludeSubjectList = new ArrayList<AttPersonRange>();
        if (list != null && !list.isEmpty()) {
            list.addAll(discardAttFiles);
            Map<Long, AttPersonRange> exsitedPersonMap = this.dealExistedMapNew(list, startDate, endDate);
            HashMap fileBoIdToPersonIdMap = Maps.newHashMapWithExpectedSize((int)list.size());
            HashMap personToFileBoMap = Maps.newHashMapWithExpectedSize((int)list.size());
            this.dealRelationMap(fileBoIdToPersonIdMap, personToFileBoMap, endDate, discardAttFiles);
            if (exsitedPersonMap.isEmpty()) {
                this.dealExculePerson(fileBoIdToPersonIdMap, discardFileIds);
            } else {
                this.dealCalPersonNew(exsitedPersonMap, personToFileBoMap, startDate, endDate, list, discardFileIds);
            }
        } else if (null != startDate) {
            HashMap fileBoIdToPersonIdMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap personToFileBoMap = Maps.newHashMapWithExpectedSize((int)16);
            this.dealRelationMap(fileBoIdToPersonIdMap, personToFileBoMap, endDate, discardAttFiles);
            this.dealExculePerson(fileBoIdToPersonIdMap, discardFileIds);
        }
        if (this.attSubjectList.isEmpty()) {
            this.excludeMessage = ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u6863\u6848\u5747\u65e0\u6743\u9650\u6216\u88ab\u5176\u4ed6\u64cd\u4f5c\u4eba\u6838\u7b97\u4e2d\u3002", (String)"QuotaRangerBuilder_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
        }
    }

    private static List<DynamicObject> qtQueryAttFiles(Collection<Long> attPersonIds, Date enddate) {
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setAppId("wtte");
        param.setFormId("wtte_qttietaskdetail");
        param.setPermField("attfile");
        param.setOrgAuthCheck(true);
        param.setAttStatus(null);
        param.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        param.setEndDate(enddate);
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
    }

    private static List<DynamicObject> qtQueryAttFiles(Collection<Long> attPersonIds, Date startDate, Date endDate) {
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setAppId("wtte");
        param.setFormId("wtte_qttietaskdetail");
        param.setPermField("attfile");
        param.setOrgAuthCheck(true);
        param.setProperties(AttFileQueryParam.attCalProperties);
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        param.setAttStatus(null);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll((Collection)attFiles);
        return dynamicObjectCollection;
    }

    @Override
    public String getExcludeMessage() {
        return this.excludeMessage;
    }

    @Override
    public List<AttPersonRange> getAttSubjects() {
        return this.attSubjectList;
    }

    @Override
    public List<AttPersonRange> getAttExcludeSubject() {
        return this.attExcludeSubjectList;
    }

    private void dealExculePerson(Map<Long, Long> fileBoIdToPersonIdMap, List<Long> discardFileIds) {
        HashMap excludeExistedPersonMap = Maps.newHashMapWithExpectedSize((int)fileBoIdToPersonIdMap.size());
        for (Long attfileBoid : this.quotaRequest.getAttFileBoids()) {
            Long attPersonId = fileBoIdToPersonIdMap.get(attfileBoid);
            if (null == attPersonId) continue;
            AttPersonRange attPersonRange = (AttPersonRange)excludeExistedPersonMap.get(attPersonId);
            if (null != attPersonRange) {
                attPersonRange.getAttFileBoIdList().add(attfileBoid);
            } else {
                attPersonRange = new AttPersonRange();
                attPersonRange.setPersonId(attPersonId);
                HashSet<Long> attFileBoIdList = new HashSet<Long>(10);
                attFileBoIdList.add(attfileBoid);
                attPersonRange.setAttFileBoIdList(attFileBoIdList);
                AttFileInfo attFileInfo = new AttFileInfo();
                attFileInfo.setPersonId(attPersonId);
                attFileInfo.setLegal(Boolean.FALSE);
                if (WTCCollections.isNotEmpty(discardFileIds) && discardFileIds.contains(attfileBoid)) {
                    attFileInfo.setMessage(ValiteKDStringUtil.discardAttFile());
                } else {
                    attFileInfo.setMessage(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u201c\u8003\u52e4\u6863\u6848\u201d\u65e0\u6743\u9650\u3001\u672a\u751f\u6548\u6216\u975e\u6b63\u5e38\u8003\u52e4\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u6743\u9650\u3001\u751f\u6548\u65e5\u671f\u6216\u8003\u52e4\u72b6\u6001\u3002", (String)"QuotaRangerBuilder_4", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                attFileInfo.setAttFileBaseBoId(attfileBoid);
                ArrayList<AttFileInfo> attFileInfoList = new ArrayList<AttFileInfo>();
                attFileInfoList.add(attFileInfo);
                attPersonRange.setAttFileInfoList(attFileInfoList);
                attPersonRange.setLegal(Boolean.FALSE);
                attPersonRange.setMessage(attFileInfo.getMessage());
            }
            attPersonRange.setAttFileBaseBoId(attfileBoid);
            this.attExcludeSubjectList.add(attPersonRange);
            excludeExistedPersonMap.put(attPersonId, attPersonRange);
        }
    }

    private void dealRelationMap(Map<Long, Long> fileBoIdToPersonIdMap, Map<Long, Set<Long>> personToFileBoMap, Date endDate, List<DynamicObject> discardAttFiles) {
        List toEndlist = WTCAttFileService.queryAttFilesWithOutAuthCheck(this.quotaRequest.getAttPersonIds(), (Date)endDate);
        if (WTCCollections.isNotEmpty(discardAttFiles)) {
            toEndlist.addAll(discardAttFiles);
        }
        for (DynamicObject dy : toEndlist) {
            fileBoIdToPersonIdMap.put(dy.getLong("boid"), dy.getLong("attperson.id"));
            Set<Long> personList = personToFileBoMap.get(dy.getLong("attperson.id"));
            if (personList == null) {
                personList = new HashSet<Long>(16);
            }
            personList.add(dy.getLong("boid"));
            personToFileBoMap.put(dy.getLong("attperson.id"), personList);
        }
    }

    private Map<Long, AttPersonRange> dealExistedMapNew(List<DynamicObject> list, Date startDate, Date endDate) {
        HashMap existedPersonMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, List<DynamicObject>> attPersonGroupByMap = list.stream().sorted(Comparator.comparing(item -> item.getDate("bsed"))).collect(Collectors.groupingBy(dy -> dy.getLong("attperson.id")));
        for (Map.Entry<Long, List<DynamicObject>> attPersonEntry : attPersonGroupByMap.entrySet()) {
            Long personId = attPersonEntry.getKey();
            List<DynamicObject> fileVersionList = attPersonEntry.getValue();
            List boList = fileVersionList.stream().map(item -> item.getLong("boid")).distinct().collect(Collectors.toList());
            HashMap boAndNextBo = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < boList.size(); ++i) {
                if (i < boList.size() - 1) {
                    boAndNextBo.put(boList.get(i), boList.get(i + 1));
                    continue;
                }
                boAndNextBo.put(boList.get(i), null);
            }
            AttPersonRange range = new AttPersonRange();
            range.setPersonId(personId);
            ArrayList attFileInfoList = Lists.newArrayListWithExpectedSize((int)10);
            Map<Long, List<DynamicObject>> fileBoGroupByMap = fileVersionList.stream().collect(Collectors.groupingBy(item -> item.getLong("boid")));
            HashSet fileBoIdSet = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry<Long, List<DynamicObject>> entry : fileBoGroupByMap.entrySet()) {
                boolean attFileStopFlag;
                List<DynamicObject> fileVidList = entry.getValue();
                DynamicObject fileDy = fileVidList.get(0);
                AttFileInfo attFileInfo = new AttFileInfo();
                attFileInfo.setEmployeeId(fileDy.getLong("employee.id"));
                attFileInfo.setPersonId(personId);
                attFileInfo.setAttFileBaseBoId(fileDy.getLong("boid"));
                attFileInfo.setAttFileBaseId(fileDy.getLong("id"));
                attFileInfo.setStartDate(fileDy.getDate("bsed").after(startDate) ? fileDy.getDate("bsed") : startDate);
                attFileInfo.setEndDate(fileDy.getDate("bsled").before(endDate) ? fileDy.getDate("bsled") : endDate);
                boolean bl = attFileStopFlag = HRObjectUtils.isEmpty((Object)fileDy.get("atttag")) || AttStatusEnum.ATT_STOP.getCode().equals(fileDy.getString("atttag.attendstatus"));
                if (attFileStopFlag) {
                    attFileInfo.setLegal(Boolean.FALSE);
                    attFileInfo.setMessage(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u201c\u8003\u52e4\u6863\u6848\u201d\u5df2\u505c\u6b62\u8003\u52e4\u3002", (String)"QuotaRangerBuilder_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                for (int i = 1; i < fileVidList.size(); ++i) {
                    Date effStartDate;
                    DynamicObject dy2 = fileVidList.get(i);
                    boolean bl2 = attFileStopFlag = HRObjectUtils.isEmpty((Object)dy2.get("atttag")) || AttStatusEnum.ATT_STOP.getCode().equals(dy2.getString("atttag.attendstatus"));
                    if (attFileStopFlag) {
                        if (this.needToExclude(dy2.getLong("boid"), dy2.getDate("bsed"), fileBoGroupByMap, boAndNextBo) || i == fileVidList.size() - 1) break;
                        attFileInfo.setLegal(Boolean.FALSE);
                        attFileInfo.setMessage(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u201c\u8003\u52e4\u6863\u6848\u201d\u5df2\u505c\u6b62\u8003\u52e4\u3002", (String)"QuotaRangerBuilder_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
                    }
                    if (!(effStartDate = dy2.getDate("bsed")).after(attFileInfo.getStartDate())) continue;
                    attFileInfo.setAttFileBaseId(dy2.getLong("id"));
                    attFileInfo.setEndDate(dy2.getDate("bsled").before(endDate) ? dy2.getDate("bsled") : endDate);
                }
                fileBoIdSet.add(fileDy.getLong("boid"));
                attFileInfoList.add(attFileInfo);
            }
            range.setAttFileBoIdList(fileBoIdSet);
            attFileInfoList.sort(Comparator.comparing(AttFileInfo::getStartDate));
            range.setAttFileInfoList(attFileInfoList);
            existedPersonMap.put(personId, range);
        }
        return existedPersonMap;
    }

    private boolean needToExclude(Long currentFileBoId, Date currentFileStartDate, Map<Long, List<DynamicObject>> fileBoGroupByMap, Map<Long, Long> boAndNextBo) {
        Long nextFileBoId = boAndNextBo.get(currentFileBoId);
        if (nextFileBoId == null) {
            return false;
        }
        List<DynamicObject> dynamicObjectList = fileBoGroupByMap.get(nextFileBoId);
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return false;
        }
        Date startDate = dynamicObjectList.get(0).getDate("bsed");
        return currentFileStartDate.compareTo(startDate) >= 0;
    }

    private void dealCalPersonNew(Map<Long, AttPersonRange> exsitedPersonMap, Map<Long, Set<Long>> personToFileBoMap, Date startDate, Date endDate, List<DynamicObject> attFilesWithOutAuthCheck, List<Long> discardFileIds) {
        List<Long> attPersonIds = this.quotaRequest.getAttPersonIds();
        List<Long> attFileBoIds = this.quotaRequest.getAttFileBoids();
        List<AttPlainSubject> attPlainSubjects = this.quotaRequest.getAttPlainSubjects();
        Map<Long, List<AttPlainSubject>> map = attPlainSubjects.stream().collect(Collectors.groupingBy(AttPlainSubject::getAttPersonId));
        boolean authCheck = this.quotaRequest.getComputingBillId() == 0L;
        Set concurrencyExcludeBoIdSet = TaskConcurrencyCtrlHelper.getInstance().getRunningKeyList(TaskCategoryEnum.QT_TIE.getCode(), attFileBoIds, Long.valueOf(this.quotaRequest.getTaskId()), Long.valueOf(this.quotaRequest.getSubTaskId()));
        List<DynamicObject> haveAuthList = attFilesWithOutAuthCheck;
        if (authCheck) {
            haveAuthList = HRObjectUtils.isEmpty((Object)startDate) ? QuotaRangerBuilder.qtQueryAttFiles(attPersonIds, endDate) : QuotaRangerBuilder.qtQueryAttFiles(attPersonIds, startDate, endDate);
        }
        Set authCheckSet = haveAuthList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        for (Map.Entry<Long, AttPersonRange> entry : exsitedPersonMap.entrySet()) {
            AttPersonRange value = entry.getValue();
            ArrayList excludeFileList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList includeFileList = Lists.newArrayListWithExpectedSize((int)10);
            AttPersonRange excludeSubject = new AttPersonRange();
            AttPersonRange includeSubject = new AttPersonRange();
            Iterator<AttFileInfo> iterator = entry.getValue().getAttFileInfoList().iterator();
            List attFileBoIdList = value.getAttFileInfoList().stream().map(AttFileInfo::getAttFileBaseBoId).collect(Collectors.toList());
            if (attFileBoIds.stream().noneMatch(attFileBoIdList::contains)) {
                Set<Long> personSet = personToFileBoMap.get(value.getPersonId());
                attFileBoIds.forEach(item -> {
                    if (personSet.contains(item)) {
                        AttFileInfo attFileInfo = new AttFileInfo();
                        attFileInfo.setPersonId(value.getPersonId());
                        attFileInfo.setLegal(Boolean.FALSE);
                        if (WTCCollections.isNotEmpty((Collection)discardFileIds) && discardFileIds.contains(item)) {
                            attFileInfo.setMessage(ValiteKDStringUtil.discardAttFile());
                        } else {
                            attFileInfo.setMessage(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u201c\u8003\u52e4\u6863\u6848\u201d\u65e0\u6743\u9650\u6216\u672a\u751f\u6548\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u6743\u9650\u6216\u751f\u6548\u65e5\u671f\u3002", (String)"QuotaRangerBuilder_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                        }
                        attFileInfo.setAttFileBaseBoId((Long)item);
                        attFileInfo.setStartDate(startDate);
                        attFileInfo.setEndDate(endDate);
                        excludeFileList.add(attFileInfo);
                    }
                });
            }
            while (iterator.hasNext()) {
                AttFileInfo attFileInfo = iterator.next();
                if (!attFileInfo.getLegal().booleanValue()) {
                    excludeFileList.add(attFileInfo);
                    continue;
                }
                if (WTCCollections.isNotEmpty(discardFileIds) && discardFileIds.contains(attFileInfo.getAttFileBaseBoId())) {
                    attFileInfo.setLegal(Boolean.FALSE);
                    attFileInfo.setMessage(ValiteKDStringUtil.discardAttFile());
                    excludeFileList.add(attFileInfo);
                    continue;
                }
                if (!authCheckSet.contains(attFileInfo.getAttFileBaseId())) {
                    attFileInfo.setLegal(Boolean.FALSE);
                    attFileInfo.setMessage(ResManager.loadKDString((String)"\u65e0\u8be5\u6863\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8bbe\u7f6e\u6743\u9650\u3002", (String)"AttCalTaskUtils_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                    excludeFileList.add(attFileInfo);
                    continue;
                }
                if (concurrencyExcludeBoIdSet.contains(attFileInfo.getAttFileBaseBoId())) {
                    attFileInfo.setLegal(Boolean.FALSE);
                    attFileInfo.setMessage(ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u64cd\u4f5c\u4eba\u6838\u7b97\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"QuotaRangerBuilder_3", (String)"wtc-wtes-business", (Object[])new Object[0]));
                    excludeFileList.add(attFileInfo);
                    continue;
                }
                includeFileList.add(attFileInfo);
            }
            List<AttPlainSubject> plainSubjects = map.get(value.getPersonId());
            if (CollectionUtils.isNotEmpty(plainSubjects)) {
                List attFileBoids = plainSubjects.stream().map(AttPlainSubject::getAttFileBoid).collect(Collectors.toList());
                attFileBoids.removeAll(attFileBoIdList);
                for (Long attFileBoid : attFileBoids) {
                    AttFileInfo attFileInfo = new AttFileInfo();
                    attFileInfo.setPersonId(value.getPersonId());
                    attFileInfo.setLegal(Boolean.FALSE);
                    if (WTCCollections.isNotEmpty(discardFileIds) && discardFileIds.contains(attFileBoid)) {
                        attFileInfo.setMessage(ValiteKDStringUtil.discardAttFile());
                    } else {
                        attFileInfo.setMessage(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\u201c\u8003\u52e4\u6863\u6848\u201d\u65e0\u6743\u9650\u3001\u672a\u751f\u6548\u6216\u975e\u6b63\u5e38\u8003\u52e4\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u6743\u9650\u3001\u751f\u6548\u65e5\u671f\u6216\u8003\u52e4\u72b6\u6001\u3002", (String)"QuotaRangerBuilder_4", (String)"wtc-wtes-business", (Object[])new Object[0]));
                    }
                    attFileInfo.setAttFileBaseBoId(attFileBoid);
                    excludeFileList.add(attFileInfo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)includeFileList)) {
                Tuple<Date, Date> minStartAndMaxEndDate = this.getMinStartAndMaxEndDate(includeFileList);
                includeSubject.setPersonId(value.getPersonId());
                includeSubject.setAttFileInfoList(includeFileList);
                includeSubject.setStartDate((Date)minStartAndMaxEndDate.getKey());
                includeSubject.setEndDate((Date)minStartAndMaxEndDate.getValue());
                this.attSubjectList.add(includeSubject);
            }
            if (!CollectionUtils.isNotEmpty((Collection)excludeFileList)) continue;
            excludeSubject.setAttFileInfoList(excludeFileList);
            excludeSubject.setPersonId(value.getPersonId());
            this.attExcludeSubjectList.add(excludeSubject);
        }
    }

    private Tuple<Date, Date> getMinStartAndMaxEndDate(List<AttFileInfo> attFileInfoList) {
        if (CollectionUtils.isEmpty(attFileInfoList)) {
            return new Tuple(null, null);
        }
        List startDateList = attFileInfoList.stream().map(AttFileInfo::getStartDate).sorted(Date::compareTo).collect(Collectors.toList());
        Date minStartDate = (Date)startDateList.get(0);
        List endDateList = attFileInfoList.stream().map(AttFileInfo::getEndDate).sorted(Comparator.comparing(Date::getTime).reversed()).collect(Collectors.toList());
        Date maxEndDate = (Date)endDateList.get(0);
        return new Tuple((Object)minStartDate, (Object)maxEndDate);
    }
}

