/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.std;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.chain.QuotaContext;
import kd.wtc.wtes.business.quota.chain.QuotaVariable;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;

public class QuotaContextStd
implements QuotaContext<QuotaDataNodeStd> {
    private final QuotaContext<QuotaDataNodeStd> context;

    public QuotaContextStd(QuotaContext<QuotaDataNodeStd> context) {
        this.context = context;
    }

    public long getAttPersonId() {
        return this.context.getAttSubjectEntry().getPersonId();
    }

    public LocalDate getChainDate() {
        return this.context.getDataPackage().getChainDate();
    }

    public LocalDate getStartDate() {
        return WTCDateUtils.toLocalDate((Date)this.context.getAttSubjectEntry().getStartDate());
    }

    public LocalDate getEndDate() {
        return WTCDateUtils.toLocalDate((Date)this.context.getAttSubjectEntry().getEndDate());
    }

    public String getVersion() {
        return this.context.getDataPackage().getVersion();
    }

    @Override
    public AttPersonRange getAttSubjectEntry() {
        return this.context.getAttSubjectEntry();
    }

    @Override
    public QuotaRequest getRequest() {
        return this.context.getRequest();
    }

    @Override
    public QuotaDataPackage<QuotaDataNodeStd> getDataPackage() {
        return this.context.getDataPackage();
    }

    @Override
    public List<QuotaDataNodeStd> getAllDataNodes() {
        return this.context.getAllDataNodes();
    }

    @Override
    public QuotaVariable getQuotaVariable() {
        return this.context.getQuotaVariable();
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.context.getInitParams();
    }

    @Override
    public TieStepIdentity getQuotaStepIdentity() {
        return this.context.getQuotaStepIdentity();
    }

    @Override
    public Long getQuotaTypeId() {
        return this.context.getQuotaTypeId();
    }

    @Override
    public CircleRestVo getCircleRestVo() {
        return this.context.getCircleRestVo();
    }

    public Map<String, QuotaAttItemValue> getAllHandleResultAttItemValueMap(List<QuotaDataNodeStd> dataNodes) {
        return QuotaContextUtil.getAllHandleResultAttItemValue(dataNodes);
    }
}

