/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.std;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.engine.QuotaEngineCallbackEvent;
import kd.wtc.wtes.business.quota.engine.QuotaEngineCompletedCallback;

public class QuotaEngineCallbackExecutor
implements QuotaEngineCompletedCallback {
    private final List<QuotaEngineCompletedCallback> terminatedCallbackList;
    private static final Log log = WTCLogFactory.getLog(QuotaEngineCallbackExecutor.class);

    public QuotaEngineCallbackExecutor(List<QuotaEngineCompletedCallback> terminatedCallbackList) {
        this.terminatedCallbackList = terminatedCallbackList;
    }

    @Override
    public void completedCallback(QuotaEngineCallbackEvent callbackEvent) {
        boolean isCallbackExecuteFlag;
        log.debug("QuotaEngine callback, status={}, traceId={}", (Object)callbackEvent.getState(), (Object)RequestContext.get().getTraceId());
        boolean bl = isCallbackExecuteFlag = callbackEvent.getState() != QuotaState.ERROR;
        if (isCallbackExecuteFlag) {
            log.debug("QuotaEngine callback Lists {}", this.terminatedCallbackList.stream().map(dy -> dy.getClass().getName()).collect(Collectors.toList()));
            if (WTCCollections.isNotEmpty(this.terminatedCallbackList)) {
                try (Span callbackSpan = TaskTracer.newSpan((String)TieReportKDStrings.ENGINE_CALLBACK.loadKDString());){
                    for (QuotaEngineCompletedCallback terminatedCallback : this.terminatedCallbackList) {
                        String callbackTag = terminatedCallback.getClass().getName();
                        log.debug("QuotaEngine callback try to call {}", (Object)callbackTag);
                        try {
                            Span callbackTagSpan = TaskTracer.newSpan((String)callbackTag);
                            Throwable throwable = null;
                            try {
                                terminatedCallback.completedCallback(callbackEvent);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (callbackTagSpan == null) continue;
                                if (throwable != null) {
                                    try {
                                        callbackTagSpan.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                callbackTagSpan.close();
                            }
                        }
                        catch (Exception e) {
                            log.warn("QuotaEngine callback[{}] error", (Object)callbackTag, (Object)e);
                        }
                    }
                }
            }
        }
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(callbackEvent.getSubTaskId()));
    }
}

