/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.std;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.exporter.QuotaExporterStdImpl;
import kd.wtc.wtes.business.quota.model.QuotaLineState;
import kd.wtc.wtes.business.quota.service.IQuotaLineExporter;

public class QuotaLineExporterStdImpl
implements IQuotaLineExporter {
    private static final Log LOGGER = LogFactory.getLog(QuotaLineExporterStdImpl.class);
    private QuotaExporterStdImpl quotaExporter;
    private final QuotaLineState quotaLineState = new QuotaLineState();
    private final StringBuilder stringBuilder = new StringBuilder();
    private QuotaMsgLevel level = QuotaMsgLevel.INFO;
    private final AttPersonRange attSubject;
    private final Map<Long, LocalDate> lastQuotaDateMap;
    private static final int MAX_EXPORT_SIZE = 200;

    public QuotaLineExporterStdImpl(QuotaExporterStdImpl quotaExporter, AttPersonRange attSubject) {
        Date minStartDate = attSubject.getAttFileInfoList().stream().map(AttFileInfo::getStartDate).sorted(Comparator.comparing(Date::getTime)).findFirst().get();
        Date maxEndDate = attSubject.getAttFileInfoList().stream().map(AttFileInfo::getEndDate).sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().get();
        this.quotaExporter = quotaExporter;
        this.quotaLineState.setAttPersonId(attSubject.getPersonId());
        this.quotaLineState.setLineBeginDate(WTCDateUtils.toLocalDate((Date)minStartDate));
        this.quotaLineState.setLineEndDate(WTCDateUtils.toLocalDate((Date)maxEndDate));
        this.attSubject = attSubject;
        this.lastQuotaDateMap = new HashMap<Long, LocalDate>(16);
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.stringBuilder.append((Object)msgLevel).append(':');
        this.stringBuilder.append(msg).append(';');
        if (QuotaMsgLevel.ERROR == msgLevel) {
            this.level = msgLevel;
        }
        if (QuotaMsgLevel.WARNING == msgLevel && QuotaMsgLevel.INFO == this.level) {
            this.level = msgLevel;
        }
        if (QuotaMsgLevel.ERROR == msgLevel) {
            this.quotaExporter.pushQuotaSubjectErrorMsg(this.attSubject.getPersonId(), msg);
        }
    }

    @Override
    public void stateChanged(QuotaState oldState, QuotaState newState) {
        this.quotaLineState.setEngineStateId(this.quotaExporter.getEngineState().getSubTaskId());
        this.quotaLineState.setTaskId(this.quotaExporter.getEngineState().getTaskid());
        this.quotaLineState.setEndTime(LocalDateTime.now());
        this.quotaLineState.setTaskStatusRefreshTime(LocalDateTime.now());
        this.quotaLineState.setMessageLevel(this.level.name());
        if (this.stringBuilder.length() > 200) {
            this.quotaLineState.setMessage(this.stringBuilder.substring(0, 200) + "...");
        } else {
            this.quotaLineState.setMessage(this.stringBuilder.toString());
        }
        this.quotaLineState.setStatus(newState.name());
        if (QuotaState.SUCCESS == newState || QuotaState.ERROR == newState || QuotaState.TERMINATED == newState) {
            this.quotaExporter.addCacheLine(this.quotaLineState, newState);
        }
    }

    @Override
    public Map<Long, LocalDate> getLastQuotaDateMap() {
        return this.lastQuotaDateMap;
    }

    @Override
    public void finishOneChain(AttPersonRange attSubjectEntry) {
        LOGGER.debug("finishOneChain:{}", (Object)attSubjectEntry);
        this.quotaLineState.setChainFinish(this.quotaLineState.getChainFinish() + 1);
    }

    @Override
    public void errorOneChain(AttPersonRange attSubjectEntry) {
        LOGGER.debug(ResManager.loadKDString((String)"\u6d41\u6c34\u7ebf\u51fa\u73b0\u5931\u8d25\uff1aerrorOneChain:{}\u3002", (String)"QuotaLineExporterStdImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attSubjectEntry);
    }
}

