/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.storage;

import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.model.jsondto.QuotaAccountPlanJsonDto;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.quota.model.QuotaDataPackageInfo;
import kd.wtc.wtes.business.quota.service.IQuotaDataPackageStoreService;
import kd.wtc.wtes.business.quota.storage.QuotaRecordAndPackageWrapper;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;

public class QuotaCalculateDetailSaveServiceImpl
implements IQuotaDataPackageStoreService {
    private static final HRBaseServiceHelper dataJsonService = WtesHRBaseTimeWatchUtil.create("wtte_quotadatajson", "wtte_quotadatajson");
    private static final MainEntityType DATA_JSON = MetadataServiceHelper.getDataEntityType((String)"wtte_quotadatajson");

    @Override
    public void storeBatch(List<QuotaRecordAndPackageWrapper> recordAndPackageWrapperList) {
        DynamicObjectCollection dynamicObjects = this.makeData(recordAndPackageWrapperList);
        dataJsonService.save(dynamicObjects);
    }

    private DynamicObjectCollection makeData(List<QuotaRecordAndPackageWrapper> recordAndPackageWrapperList) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (QuotaRecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            QuotaAccountPlanJsonDto accountPlanJsonDto = recordAndPackageWrapper.getAccountPlanJsonDto();
            if (null == accountPlanJsonDto) continue;
            DynamicObject dynamicObject = this.toDataJons(accountPlanJsonDto, recordAndPackageWrapper.getPackageInfo());
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        return dynamicObjectCollection;
    }

    private DynamicObject toDataJons(QuotaAccountPlanJsonDto phaseJsonDto, QuotaDataPackageInfo quotaDataPackageInfo) {
        String jsonString = JsonUtil.encodeToString((Object)phaseJsonDto);
        DynamicObject dataJsonDyn = new DynamicObject((DynamicObjectType)DATA_JSON);
        dataJsonDyn.set("personid", (Object)quotaDataPackageInfo.getAttPersonId());
        dataJsonDyn.set("qttypeid", (Object)quotaDataPackageInfo.getQtTypeId());
        dataJsonDyn.set("periodnum", (Object)quotaDataPackageInfo.getPeriodNum());
        dataJsonDyn.set("attfileid", (Object)quotaDataPackageInfo.getAttFileId());
        dataJsonDyn.set("datajson", (Object)jsonString);
        dataJsonDyn.set("version", (Object)quotaDataPackageInfo.getVersion());
        dataJsonDyn.set("creator", (Object)quotaDataPackageInfo.getCalculatorId());
        dataJsonDyn.set("modifier", (Object)quotaDataPackageInfo.getCalculatorId());
        dataJsonDyn.set("createtime", (Object)quotaDataPackageInfo.getCalculateDate());
        dataJsonDyn.set("modifytime", (Object)quotaDataPackageInfo.getCalculateDate());
        return dataJsonDyn;
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.QUOTA_CALCULATEDETAIL_STORE_TIME;
    }

    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
    }
}

