/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.quota.model.QuotaAttRecordModel;
import kd.wtc.wtes.business.quota.model.QuotaDataPackageInfo;
import kd.wtc.wtes.business.quota.model.QuotaRecordDdEntity;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.service.IQuotaDataPackageStoreService;
import kd.wtc.wtes.business.quota.storage.QuotaRecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.StorageUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaRecordSaveServiceImpl
implements IQuotaDataPackageStoreService {
    private static HRBaseServiceHelper quotaDetailService = WtesHRBaseTimeWatchUtil.create(QuotaRecordSaveServiceImpl.class.getName() + "." + "wtte_quotadetail", "wtte_quotadetail");
    private static HRBaseServiceHelper quotaDetailHisService = WtesHRBaseTimeWatchUtil.create(QuotaRecordSaveServiceImpl.class.getName() + "." + "wtte_quotadetahis", "wtte_quotadetahis");

    public void saveRecored(DynamicObjectCollection quotaDeatilObjList) {
        if (CollectionUtils.isNotEmpty((Collection)quotaDeatilObjList)) {
            quotaDetailService.save(quotaDeatilObjList);
        }
    }

    public void saveRecoredHis(DynamicObjectCollection detailObjHisList) {
        quotaDetailHisService.save(detailObjHisList);
    }

    @Override
    public void storeBatch(List<QuotaRecordAndPackageWrapper> recordAndPackageWrapperList) {
        if (recordAndPackageWrapperList.isEmpty()) {
            return;
        }
        DynamicObjectCollection detailObjList = new DynamicObjectCollection();
        DynamicObjectCollection detailObjHisList = new DynamicObjectCollection();
        for (QuotaRecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            List<DynamicObject> dynamicObjectCollection;
            QuotaRecordDdEntity recordDbEntity = this.getData(recordAndPackageWrapper);
            if (recordDbEntity == null || !CollectionUtils.isNotEmpty(dynamicObjectCollection = recordDbEntity.getDetailObjList())) continue;
            detailObjList.addAll(dynamicObjectCollection);
            detailObjHisList.addAll(recordDbEntity.getDetailObjHisList());
        }
        this.saveRecored(detailObjList);
        this.saveRecoredHis(detailObjHisList);
        QuotaRunTimeCache runTimeCache = (QuotaRunTimeCache)recordAndPackageWrapperList.get(0).getPackageInfo().getExtAttribute("ext_key_qt_runtime_cache");
        if (runTimeCache != null) {
            List<QuotaRunTimeCache.QuotaItemDebris> collect = detailObjList.stream().map(QuotaRunTimeCache.QuotaItemDebris::new).collect(Collectors.toList());
            runTimeCache.cacheType2Id4FileBo(collect);
            Set endBoSet = WTCCollections.modifiableEmptySet();
            Set LineEndAllBoSet = WTCCollections.modifiableEmptySet();
            for (QuotaRecordAndPackageWrapper wrapper : recordAndPackageWrapperList) {
                boolean oneLineEnd;
                boolean oneBoEnd = wrapper.getPackageInfo().hasMark(1);
                if (oneBoEnd) {
                    Long enBo = (Long)wrapper.getPackageInfo().getExtAttribute("ext_key_line_one_bo");
                    endBoSet.add(enBo);
                }
                if (!(oneLineEnd = wrapper.getPackageInfo().hasMark(2))) continue;
                Set lineAllBo = (Set)wrapper.getPackageInfo().getExtAttribute("ext_key_line_all_bo");
                LineEndAllBoSet.addAll(lineAllBo);
            }
            Set flushDBBo = WTCCollections.modifiableEmptySet();
            flushDBBo.addAll(runTimeCache.actPimp(endBoSet));
            flushDBBo.addAll(runTimeCache.actPimp(LineEndAllBoSet));
            runTimeCache.flushDB4FileBoAndRevTmpData(flushDBBo);
        }
    }

    private QuotaRecordDdEntity getData(QuotaRecordAndPackageWrapper recordAndPackageWrapper) {
        List<QuotaAttRecordModel> list = recordAndPackageWrapper.getList();
        QuotaDataPackageInfo packageInfo = recordAndPackageWrapper.getPackageInfo();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.builteRecordDbEntity(list, packageInfo);
    }

    private QuotaRecordDdEntity builteRecordDbEntity(List<QuotaAttRecordModel> attRecordModelList, QuotaDataPackageInfo packageInfo) {
        QuotaRecordDdEntity recordDbEntity = new QuotaRecordDdEntity();
        for (QuotaAttRecordModel quotaAttRecordModel : attRecordModelList) {
            DynamicObject detailObj = BusinessDataServiceHelper.newDynamicObject((String)"wtte_quotadetail");
            detailObj.set("attfileid", (Object)packageInfo.getAttFileId());
            detailObj.set("attfilevid", (Object)quotaAttRecordModel.getAttFileVid());
            detailObj.set("version", (Object)packageInfo.getVersion());
            detailObj.set("createtime", (Object)packageInfo.getCalculateDate());
            detailObj.set("modifytime", (Object)packageInfo.getCalculateDate());
            detailObj.set("creator", (Object)packageInfo.getCalculatorId());
            detailObj.set("modifier", (Object)packageInfo.getCalculatorId());
            detailObj.set("gentime", (Object)packageInfo.getCalculateDate());
            detailObj.set("qttypeid", (Object)quotaAttRecordModel.getQtTypeId());
            detailObj.set("periodcircleid", (Object)quotaAttRecordModel.getPeriodCircleId());
            detailObj.set("periodnum", (Object)quotaAttRecordModel.getPeriodNum());
            detailObj.set("source", (Object)quotaAttRecordModel.getSource());
            detailObj.set("bid", (Object)quotaAttRecordModel.getBoId());
            detailObj.set("type", (Object)quotaAttRecordModel.getType());
            detailObj.set("genstartdate", (Object)quotaAttRecordModel.getGenStartDate());
            detailObj.set("genenddate", (Object)quotaAttRecordModel.getGenEndDate());
            detailObj.set("usestartdate", (Object)quotaAttRecordModel.getUseStartDate());
            detailObj.set("useenddate", (Object)quotaAttRecordModel.getUseEndDate());
            detailObj.set("attitemvalue", (Object)quotaAttRecordModel.getAttitemValue());
            detailObj.set("assigndate", (Object)quotaAttRecordModel.getAssignDate());
            detailObj.set("crossstartdate", (Object)quotaAttRecordModel.getCrossStartDate());
            detailObj.set("crossenddate", (Object)quotaAttRecordModel.getCrossEndDate());
            detailObj.set("attitemvid", (Object)quotaAttRecordModel.getAttitemVid());
            detailObj.set("sourceattitemid", (Object)quotaAttRecordModel.getSourceAttitemId());
            detailObj.set("attitemvaluestr", (Object)quotaAttRecordModel.getAttitemValueStr());
            detailObj.set("vestday", (Object)quotaAttRecordModel.getVestDay());
            detailObj.set("vesttype", (Object)quotaAttRecordModel.getVestType());
            Long timeBuckId = quotaAttRecordModel.getTimeBuckId();
            detailObj.set("sourceattitemids", (Object)timeBuckId);
            recordDbEntity.addDetailObj(detailObj);
            DynamicObject detailObjHis = BusinessDataServiceHelper.newDynamicObject((String)"wtte_quotadetahis");
            HRDynamicObjectUtils.copy((DynamicObject)detailObj, (DynamicObject)detailObjHis);
            recordDbEntity.addDetailObjHis(detailObjHis);
        }
        return recordDbEntity;
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.QUOTA_ATTRECORD_STORE_TIME;
    }

    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        Map<String, Map<String, Tuple<QFilter, List<Long>>>> needClearMapNew = StorageUtil.genNeedClearMapWithAttSubject(attSubjects, "owndate", version);
        List<QFilter> qFilterList = StorageUtil.transferQFilterList(needClearMapNew, "personid", "versionid");
        if (qFilterList != null && !qFilterList.isEmpty()) {
            ArrayList detailIdList = Lists.newArrayListWithExpectedSize((int)16);
            for (QFilter qFilter : qFilterList) {
                List<Object> pkIdList = this.getDeleteObj(qFilter);
                detailIdList.addAll(pkIdList);
            }
            if (CollectionUtils.isNotEmpty((Collection)detailIdList)) {
                quotaDetailService.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)detailIdList)});
            }
        }
    }

    private List<Object> getDeleteObj(QFilter qFilter) {
        DynamicObject[] dynamicObjects = quotaDetailService.query("id", new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return Arrays.asList(dynamicObjects).stream().map(ob -> ob.get("id")).collect(Collectors.toList());
        }
        return new ArrayList<Object>(0);
    }
}

