/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.quota.model.QuotaDataPackageInfo;
import kd.wtc.wtes.business.quota.service.IQuotaDataPackageStoreService;
import kd.wtc.wtes.business.quota.storage.QuotaDataPackageStoreExecutor;
import kd.wtc.wtes.business.quota.storage.QuotaRecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.business.storage.DataPackageStoreResult;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaVersionDataPackageStore {
    private static Log logger = LogFactory.getLog(QuotaVersionDataPackageStore.class);
    private static final int DATAPACKAGE_STORE_THRESHOLD_DEFAULT = 600;
    private List<QuotaRecordAndPackageWrapper> localItemCache = new ArrayList<QuotaRecordAndPackageWrapper>(10);
    private final int threshold;
    private List<IQuotaDataPackageStoreService> serviceList;
    private List<Future<DataPackageStoreResult>> storeResult = new ArrayList<Future<DataPackageStoreResult>>(16);
    private int storeBatchNum;
    private int storeTotalCount;
    private long firstStartTime;

    public QuotaVersionDataPackageStore() {
        this.threshold = WTCAppContextHelper.getProjectParams().getInteger("tie.dataPackage.store.threshold", Integer.valueOf(600));
    }

    public synchronized void store(QuotaRecordAndPackageWrapper recordAndPackageWrapper) {
        logger.debug("size before {}", (Object)this.localItemCache.size());
        this.toLocalChe(recordAndPackageWrapper);
        if (this.localItemCache.size() >= this.threshold) {
            this.storeImmediately();
        }
        logger.debug("size after {}", (Object)this.localItemCache.size());
    }

    private void toLocalChe(QuotaRecordAndPackageWrapper recordAndPackageWrapper) {
        this.localItemCache.add(recordAndPackageWrapper);
    }

    public synchronized void storeImmediately() {
        if (this.isNotEmpty()) {
            if (this.firstStartTime == 0L) {
                this.firstStartTime = System.currentTimeMillis();
            }
            List<IQuotaDataPackageStoreService> storeServices = this.getStoreServices();
            List list = (List)((ArrayList)this.localItemCache).clone();
            QuotaDataPackageInfo packageInfo = ((QuotaRecordAndPackageWrapper)list.get(0)).getPackageInfo();
            ExecutorService executorService = DataPackageStoreManager.getInstance().getExecutorService(packageInfo.getVersion(), packageInfo.getShardingIndex());
            try {
                this.storeTotalCount += this.localItemCache.size();
                if (storeServices != null) {
                    this.storeResult.add(executorService.submit(TaskTracer.wrap((Callable)new QuotaDataPackageStoreExecutor(storeServices, list, RequestContext.get()))));
                }
            }
            catch (Exception ex) {
                logger.warn("storeBatch error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
            }
            finally {
                this.clear();
                ++this.storeBatchNum;
            }
        }
    }

    private void clear() {
        this.localItemCache.clear();
    }

    private List<IQuotaDataPackageStoreService> getStoreServices() {
        Object initialises;
        if (this.serviceList == null && (initialises = WTCAppContextHelper.getProjectParams().get("quota.init.dataPackageStoreList")) != null) {
            List initializerList = (List)initialises;
            this.serviceList = initializerList.stream().map(initializerBeanName -> (IQuotaDataPackageStoreService)WTCAppContextHelper.getBean((String)initializerBeanName, IQuotaDataPackageStoreService.class)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(this.serviceList)) {
            throw new WtesException("count not get store service by param:tie.init.dataPackageStoreList");
        }
        return this.serviceList;
    }

    public synchronized Map<String, Object> getCostData() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        if (this.firstStartTime == 0L) {
            map.put("startTime", System.currentTimeMillis());
        } else {
            map.put("startTime", this.firstStartTime);
        }
        map.put("storeBatchNum", this.storeBatchNum);
        map.put("storeTotalCount", this.storeTotalCount);
        return map;
    }

    private boolean isNotEmpty() {
        return this.localItemCache.size() > 0;
    }

    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        block13: {
            List<IQuotaDataPackageStoreService> storeServices = this.getStoreServices();
            try {
                if (storeServices == null) break block13;
                for (IQuotaDataPackageStoreService service : storeServices) {
                    String callbackTag = service.getClass().getName();
                    Span callbackTagSpan = TaskTracer.newSpan((String)callbackTag);
                    Throwable throwable = null;
                    try {
                        service.doCalDataClean(attSubjects, version);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (callbackTagSpan == null) continue;
                        if (throwable != null) {
                            try {
                                callbackTagSpan.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        callbackTagSpan.close();
                    }
                }
            }
            catch (Exception ex) {
                logger.warn("doCalDataClean error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public List<Future<DataPackageStoreResult>> getStoreResult() {
        return this.storeResult;
    }
}

