/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailSingle;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.QTService;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;

public class AttRcordSummaryUtils {
    public static Map<String, Object> getAttRcordSummaryList(QuotaContextStd quotaContextStd, Set<String> attItemIds, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(attItemIds) || startDate == null || endDate == null) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)attItemIds.size());
        for (String attItemId : attItemIds) {
            BigDecimal value = AttRcordSummaryUtils.getAttRcordSummary(quotaContextStd, Long.valueOf(attItemId), startDate, endDate);
            map.put(attItemId, value);
        }
        return map;
    }

    public static BigDecimal getAttRcordSummary(QuotaContextStd quotaContextStd, Long attItemId, Date startDate, Date endDate) {
        Long boId;
        if (attItemId == null || startDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        AttItemSpecData attItemSpecData = quotaContextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attItemId, WTCDateUtils.toLocalDate((Date)endDate));
        AttitemUnitEnum attitemUnitEnum = AttitemUnitEnum.of((String)attItemSpec.getUnit());
        AttRecordDetailHolder detailHolder = quotaContextStd.getInitParamMust("QT_ATT_RECORD_DETAIL", AttRecordDetailHolder.class);
        AttRecordDetailTable attRecordDetailMap = detailHolder.getAttRecordDetailTable();
        Map<LocalDate, Map<Long, AttRecordDetailSingle>> attRecordDetails = attRecordDetailMap.getByAttFileBoId(boId = quotaContextStd.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId());
        if (CollectionUtils.isEmpty(attRecordDetails)) {
            return BigDecimal.ZERO;
        }
        ArrayList attRecordDetailSingles = new ArrayList(16);
        attRecordDetails.forEach((key, value) -> {
            Date ownDate = WTCDateUtils.toDate((LocalDate)key);
            AttRecordDetailSingle recordDetailSingle = (AttRecordDetailSingle)value.get(attItemId);
            if (startDate.compareTo(ownDate) <= 0 && endDate.compareTo(ownDate) >= 0 && recordDetailSingle != null) {
                attRecordDetailSingles.add(recordDetailSingle);
            }
        });
        BigDecimal countValue = BigDecimal.ZERO;
        for (AttRecordDetailSingle attRecordDetail : attRecordDetailSingles) {
            int precisionTail;
            BigDecimal detailValue = BigDecimal.ZERO;
            if (AttitemUnitEnum.DAY.equals((Object)attitemUnitEnum) || AttitemUnitEnum.TIME.equals((Object)attitemUnitEnum)) {
                detailValue = attRecordDetail.getValue();
            } else if (AttitemUnitEnum.HOUR.equals((Object)attitemUnitEnum)) {
                precisionTail = AttRecordTrimUtil.getPrecisionTail(attItemSpec.getPrecisionTail());
                detailValue = attRecordDetail.getValueSecond();
                detailValue = AttRecordTrimUtil.secondToHour(detailValue, attItemSpec.getDataAccuracy(), precisionTail);
            } else if (AttitemUnitEnum.MINUTE.equals((Object)attitemUnitEnum)) {
                precisionTail = AttRecordTrimUtil.getPrecisionTail(attItemSpec.getPrecisionTail());
                detailValue = attRecordDetail.getValueSecond();
                detailValue = AttRecordTrimUtil.secondToMinute(detailValue, attItemSpec.getDataAccuracy(), precisionTail);
            } else if (AttitemUnitEnum.SECOND.equals((Object)attitemUnitEnum)) {
                detailValue = attRecordDetail.getValueSecond();
            }
            if (CheckUtils.isNegative((BigDecimal)detailValue)) {
                String qtTypeName = String.valueOf(quotaContextStd.getQuotaTypeId());
                List qtType = QTService.queryQtType((List)WTCCollections.modifiableList((Object[])new Long[]{quotaContextStd.getQuotaTypeId()}));
                if (!qtType.isEmpty()) {
                    qtTypeName = ((DynamicObject)qtType.get(0)).getString("name");
                }
                String errMsg = ResManager.loadKDString((String)"%1$s\u65f6\u957f\u4e3a\u8d1f\u503c\uff0c\u65e0\u6cd5\u751f\u6210%2$s\u7684\u989d\u5ea6\u3002", (String)"AttRcordSummaryUtils_1", (String)"wtc-wtes-business", (Object[])new Object[]{attItemSpec.getName(), qtTypeName});
                throw new KDBizException(errMsg);
            }
            countValue = countValue.add(detailValue);
        }
        return countValue;
    }
}

