/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDto;
import kd.wtc.wtes.business.model.quotacal.retrieval.QuotaRetrievalDimensionResult;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.quota.model.QuotaChageDay;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.QTTieRetrievalUtil;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;

public class QTConditionsUtils {
    private static final Log logger = LogFactory.getLog(QTConditionsUtils.class);

    public static List<QuotaChageDay> calculateChangeAge(Date refenceDate, Date startDay, Date endDay, String type) {
        if (startDay == null || startDay.compareTo(endDay) == 0 || refenceDate == null || endDay.before(endDay)) {
            return Collections.emptyList();
        }
        if (endDay.before(refenceDate)) {
            return Collections.emptyList();
        }
        Calendar birthCal = Calendar.getInstance();
        birthCal.setTime(refenceDate);
        int birthYear = birthCal.get(1);
        int birthMonth = birthCal.get(2);
        int birthMonthDay = birthCal.get(5);
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDay);
        int calYear = cal.get(1);
        int size = calYear - birthYear + 1;
        ArrayList<QuotaChageDay> list = new ArrayList<QuotaChageDay>(size);
        Calendar start = Calendar.getInstance();
        start.setTime(startDay);
        int startYear = start.get(1);
        int startMonth = start.get(2);
        int startMonthDay = start.get(5);
        AtomicInteger age = new AtomicInteger(0);
        if (startDay.after(refenceDate)) {
            int ageInt = startYear - birthYear;
            if (startMonth < birthMonth) {
                --ageInt;
            } else if (startMonth == birthMonth && startMonthDay < birthMonthDay) {
                --ageInt;
            }
            birthCal.add(1, age.addAndGet(ageInt));
        }
        while (birthCal.getTime().compareTo(endDay) <= 0) {
            birthCal.add(1, 1);
            int ageTemp = age.getAndIncrement();
            if (birthCal.getTime().compareTo(endDay) > 0) continue;
            QuotaChageDay quotaChageDay = new QuotaChageDay();
            quotaChageDay.setType(type);
            quotaChageDay.setChangeDate(birthCal.getTime());
            quotaChageDay.setChangeValue(ageTemp + 1);
            list.add(quotaChageDay);
        }
        return list;
    }

    public static int calculateAge(Date refenceDate, Date startDay) {
        if (startDay == null || refenceDate == null) {
            return 0;
        }
        Calendar birthCal = Calendar.getInstance();
        birthCal.setTime(refenceDate);
        int birthYear = birthCal.get(1);
        int birthMonth = birthCal.get(2);
        int birthMonthDay = birthCal.get(5);
        Calendar start = Calendar.getInstance();
        start.setTime(startDay);
        int startYear = start.get(1);
        int startMonth = start.get(2);
        int startMonthDay = start.get(5);
        int startValue = 0;
        if (startDay.after(refenceDate)) {
            int ageInt = startYear - birthYear;
            if (startMonth < birthMonth) {
                --ageInt;
            } else if (startMonth == birthMonth && startMonthDay < birthMonthDay) {
                --ageInt;
            }
            startValue = ageInt;
        }
        return startValue;
    }

    public static boolean checkLimitConditions(RuleConditionInfo conditionInfo, Map<String, Object> paramMp) {
        if (conditionInfo == null) {
            return true;
        }
        LinkedHashMap dataMap = Maps.newLinkedHashMap();
        long id = IDService.get().genLongId();
        dataMap.put(id, paramMp);
        JudgeResult judge = JudgeConditionService.judgeOriginalParam((LinkedHashMap)dataMap, (RuleConditionInfo)conditionInfo);
        return judge.isMatched();
    }

    public static void getGenConfigConditionParam(QuotaContextStd contextstd, QTGenConfig genConfig, Map<String, Object> paramMp) {
        List<QTGenConfigEntry> qtGenConfigEntries = genConfig.getQtGenConfigEntries();
        if (WTCCollections.isNotEmpty(qtGenConfigEntries)) {
            AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd, contextstd.getChainDate());
            String ruleKey = "matchRuleLineVar" + attFileModel.getId();
            QTRule qtRule = (QTRule)contextstd.getVariable(ruleKey, VScope.LINE);
            LocalDate endDateLocal = attFileModel.getEndDate();
            Date cycEnd = contextstd.getCircleRestVo().getEndDate();
            Date endDate = WTCDateUtils.toDate((LocalDate)endDateLocal).before(cycEnd) ? WTCDateUtils.toDate((LocalDate)endDateLocal) : cycEnd;
            Set<QuotaRetrievalDimensionResult> quotaRetrievalDimensionResults = QTTieRetrievalUtil.getQTRetrievalResultOfDate(contextstd, qtRule, WTCDateUtils.toLocalDate((Date)endDate));
            List<Object> list = Lists.newArrayListWithExpectedSize((int)16);
            if (WTCCollections.isNotEmpty(quotaRetrievalDimensionResults)) {
                String dimensionKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)contextstd.getQuotaTypeId(), (long)contextstd.getCircleRestVo().getCycSetId(), (long)contextstd.getCircleRestVo().getIndex().intValue());
                list = quotaRetrievalDimensionResults.stream().filter(item -> item.getDimensionKey().equals(dimensionKey)).collect(Collectors.toList());
            }
            for (QTGenConfigEntry qtGenConfigEntry : qtGenConfigEntries) {
                AccessDto accessDto;
                List<ConditionDto> conditionDtos;
                String conditionStr = qtGenConfigEntry.getReplaceCondition();
                if (StringUtils.isEmpty((CharSequence)conditionStr) || WTCCollections.isEmpty(conditionDtos = (accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionStr, AccessDto.class)).getConditionList())) continue;
                for (ConditionDto conditionDto : conditionDtos) {
                    String retrievalWay = conditionDto.getRetrievalWay();
                    if (WTCCollections.isNotEmpty((Collection)list) && HRStringUtils.isNotEmpty((String)retrievalWay) && RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) {
                        for (QuotaRetrievalDimensionResult quotaRetrievalDimensionResult : list) {
                            Object object = quotaRetrievalDimensionResult.getRetrievalDimension().getValue(conditionDto.getUniqueCode());
                            paramMp.put(conditionDto.getParam(), object);
                        }
                        continue;
                    }
                    if (paramMp.containsKey(conditionDto.getParam())) continue;
                    String newkey = conditionDto.getParam();
                    String string = conditionDto.getParam1();
                    if (StringUtils.isEmpty((CharSequence)string)) continue;
                    paramMp.put(newkey, paramMp.get(string));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.info("QTConditionsUtils.getGenConfigConditionParam param:{}", (Object)JSON.toJSONString(paramMp));
            }
        }
    }
}

